/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.content.Context;
import android.graphics.HardwareRenderer;
import android.graphics.RenderNode;
import android.view.Display;
import android.view.IWindowSession;
import android.view.ThreadedRenderer;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewRootImpl;
import android.view.ViewRootImpl_Accessor;
import android.view.WindowManagerImpl;

public class AttachInfo_Accessor {
    public static void setAttachInfo(ViewGroup view2, final HardwareRenderer renderer) {
        Context context = view2.getContext();
        WindowManagerImpl wm = (WindowManagerImpl)context.getSystemService("window");
        wm.setBaseRootView(view2);
        Display display = wm.getDefaultDisplay();
        ViewRootImpl root = new ViewRootImpl(context, display, new IWindowSession.Default());
        root.mAttachInfo.mThreadedRenderer = new ThreadedRenderer(context, false, "delegate-renderer"){

            @Override
            public void registerAnimatingRenderNode(RenderNode animator2) {
                if (renderer != null) {
                    renderer.registerAnimatingRenderNode(animator2);
                } else {
                    super.registerAnimatingRenderNode(animator2);
                }
            }
        };
        View.AttachInfo info = root.mAttachInfo;
        info.mHasWindowFocus = true;
        info.mWindowVisibility = 0;
        info.mInTouchMode = false;
        info.mHardwareAccelerated = true;
        info.mThreadedRenderer = new ThreadedRenderer(context, false, "layoutlib-renderer");
        info.mApplicationScale = 1.0f;
        view2.dispatchAttachedToWindow(info, 0);
    }

    public static void dispatchOnPreDraw(View view2) {
        view2.mAttachInfo.mTreeObserver.dispatchOnPreDraw();
    }

    public static void detachFromWindow(View view2) {
        if (view2 != null) {
            View.AttachInfo attachInfo = view2.mAttachInfo;
            view2.dispatchDetachedFromWindow();
            if (attachInfo != null) {
                ThreadedRenderer rootRenderer;
                ViewRootImpl_Accessor.detachFromWindow(attachInfo.mViewRootImpl);
                ThreadedRenderer threadedRenderer = attachInfo.mThreadedRenderer;
                if (threadedRenderer != null) {
                    threadedRenderer.destroy();
                }
                if ((rootRenderer = attachInfo.mViewRootImpl.mAttachInfo.mThreadedRenderer) != null) {
                    rootRenderer.destroy();
                }
            }
        }
    }

    public static ViewRootImpl getRootView(View view2) {
        return view2.mAttachInfo != null ? view2.mAttachInfo.mViewRootImpl : null;
    }
}

