/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.os.Binder;
import android.os.Handler;
import android.os.Looper;
import android.os.RemoteException;
import android.os.SystemProperties;
import android.util.ArrayMap;
import android.util.Log;
import android.view.ICrossWindowBlurEnabledListener;
import android.view.WindowManagerGlobal;
import com.android.internal.util.Preconditions;
import java.util.concurrent.Executor;
import java.util.function.Consumer;

public class CrossWindowBlurListeners {
    private static final String TAG = "CrossWindowBlurListeners";
    private static final String BLUR_PROPERTY = "ro.surface_flinger.supports_background_blur";
    public static final boolean CROSS_WINDOW_BLUR_SUPPORTED = SystemProperties.getBoolean("ro.surface_flinger.supports_background_blur", false);
    private static volatile CrossWindowBlurListeners sInstance;
    private static final Object sLock;
    private final BlurEnabledListenerInternal mListenerInternal = new BlurEnabledListenerInternal();
    private final ArrayMap<Consumer<Boolean>, Executor> mListeners = new ArrayMap();
    private final Handler mMainHandler = new Handler(Looper.getMainLooper());
    private boolean mInternalListenerAttached = false;
    private boolean mCrossWindowBlurEnabled;

    private CrossWindowBlurListeners() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CrossWindowBlurListeners getInstance() {
        CrossWindowBlurListeners instance2 = sInstance;
        if (instance2 == null) {
            Object object = sLock;
            synchronized (object) {
                instance2 = sInstance;
                if (instance2 == null) {
                    sInstance = instance2 = new CrossWindowBlurListeners();
                }
            }
        }
        return instance2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isCrossWindowBlurEnabled() {
        Object object = sLock;
        synchronized (object) {
            this.attachInternalListenerIfNeededLocked();
            return this.mCrossWindowBlurEnabled;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(Executor executor, Consumer<Boolean> listener2) {
        Preconditions.checkNotNull(listener2, "listener cannot be null");
        Preconditions.checkNotNull(executor, "executor cannot be null");
        Object object = sLock;
        synchronized (object) {
            this.attachInternalListenerIfNeededLocked();
            this.mListeners.put(listener2, executor);
            this.notifyListener(listener2, executor, this.mCrossWindowBlurEnabled);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(Consumer<Boolean> listener2) {
        Preconditions.checkNotNull(listener2, "listener cannot be null");
        Object object = sLock;
        synchronized (object) {
            this.mListeners.remove(listener2);
            if (this.mInternalListenerAttached && this.mListeners.size() == 0) {
                try {
                    WindowManagerGlobal.getWindowManagerService().unregisterCrossWindowBlurEnabledListener(this.mListenerInternal);
                    this.mInternalListenerAttached = false;
                }
                catch (RemoteException e) {
                    Log.d(TAG, "Could not unregister ICrossWindowBlurEnabledListener");
                }
            }
        }
    }

    private void attachInternalListenerIfNeededLocked() {
        if (!this.mInternalListenerAttached) {
            try {
                this.mCrossWindowBlurEnabled = WindowManagerGlobal.getWindowManagerService().registerCrossWindowBlurEnabledListener(this.mListenerInternal);
                this.mInternalListenerAttached = true;
            }
            catch (RemoteException e) {
                Log.d(TAG, "Could not register ICrossWindowBlurEnabledListener");
            }
        }
    }

    private void notifyListener(Consumer<Boolean> listener2, Executor executor, boolean enabled) {
        executor.execute(() -> listener2.accept(enabled));
    }

    static {
        sLock = new Object();
    }

    private class BlurEnabledListenerInternal
    extends ICrossWindowBlurEnabledListener.Stub {
        private BlurEnabledListenerInternal() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onCrossWindowBlurEnabledChanged(boolean enabled) {
            Object object = sLock;
            synchronized (object) {
                CrossWindowBlurListeners.this.mCrossWindowBlurEnabled = enabled;
                long token = Binder.clearCallingIdentity();
                try {
                    for (int i = 0; i < CrossWindowBlurListeners.this.mListeners.size(); ++i) {
                        CrossWindowBlurListeners.this.notifyListener(CrossWindowBlurListeners.this.mListeners.keyAt(i), CrossWindowBlurListeners.this.mListeners.valueAt(i), enabled);
                    }
                }
                finally {
                    Binder.restoreCallingIdentity(token);
                }
            }
        }
    }
}

