/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.graphics.Rect;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewParent;
import android.view.inputmethod.InputMethodManager;
import com.android.internal.annotations.VisibleForTesting;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class HandwritingInitiator {
    private final int mTouchSlop;
    private final long mHandwritingTimeoutInMillis;
    private State mState = new State();
    private final HandwritingAreaTracker mHandwritingAreasTracker = new HandwritingAreaTracker();
    @VisibleForTesting
    public WeakReference<View> mConnectedView = null;
    private int mConnectionCount = 0;
    private final InputMethodManager mImm;

    private void reset() {
        this.mState = new State();
    }

    @VisibleForTesting
    public HandwritingInitiator(ViewConfiguration viewConfiguration, InputMethodManager inputMethodManager) {
        this.mTouchSlop = viewConfiguration.getScaledTouchSlop();
        this.mHandwritingTimeoutInMillis = ViewConfiguration.getLongPressTimeout();
        this.mImm = inputMethodManager;
    }

    @VisibleForTesting
    public void onTouchEvent(MotionEvent motionEvent) {
        int maskedAction = motionEvent.getActionMasked();
        switch (maskedAction) {
            case 0: 
            case 5: {
                int actionIndex = motionEvent.getActionIndex();
                int toolType = motionEvent.getToolType(actionIndex);
                if (toolType != 2 && toolType != 4) {
                    return;
                }
                this.mState.mStylusPointerId = motionEvent.getPointerId(actionIndex);
                this.mState.mStylusDownTimeInMillis = motionEvent.getEventTime();
                this.mState.mStylusDownX = motionEvent.getX(actionIndex);
                this.mState.mStylusDownY = motionEvent.getY(actionIndex);
                this.mState.mShouldInitHandwriting = true;
                this.mState.mExceedTouchSlop = false;
                break;
            }
            case 6: {
                int pointerId = motionEvent.getPointerId(motionEvent.getActionIndex());
                if (pointerId != this.mState.mStylusPointerId) {
                    return;
                }
            }
            case 1: 
            case 3: {
                this.reset();
                break;
            }
            case 2: {
                float y;
                if (!this.mState.mShouldInitHandwriting || this.mState.mExceedTouchSlop) {
                    return;
                }
                long timeElapsed = motionEvent.getEventTime() - this.mState.mStylusDownTimeInMillis;
                if (timeElapsed > this.mHandwritingTimeoutInMillis) {
                    this.reset();
                    return;
                }
                int pointerIndex = motionEvent.findPointerIndex(this.mState.mStylusPointerId);
                float x = motionEvent.getX(pointerIndex);
                if (!this.largerThanTouchSlop(x, y = motionEvent.getY(pointerIndex), this.mState.mStylusDownX, this.mState.mStylusDownY)) break;
                this.mState.mExceedTouchSlop = true;
                View candidateView = this.findBestCandidateView(this.mState.mStylusDownX, this.mState.mStylusDownY);
                if (candidateView == null) break;
                if (candidateView == this.getConnectedView()) {
                    this.startHandwriting(candidateView);
                    break;
                }
                candidateView.requestFocus();
            }
        }
    }

    private View getConnectedView() {
        if (this.mConnectedView == null) {
            return null;
        }
        return (View)this.mConnectedView.get();
    }

    private void clearConnectedView() {
        this.mConnectedView = null;
        this.mConnectionCount = 0;
    }

    public void onInputConnectionCreated(View view2) {
        if (!view2.isAutoHandwritingEnabled()) {
            this.clearConnectedView();
            return;
        }
        View connectedView = this.getConnectedView();
        if (connectedView == view2) {
            ++this.mConnectionCount;
        } else {
            this.mConnectedView = new WeakReference<View>(view2);
            this.mConnectionCount = 1;
            if (this.mState.mShouldInitHandwriting) {
                this.tryStartHandwriting();
            }
        }
    }

    public void onInputConnectionClosed(View view2) {
        View connectedView = this.getConnectedView();
        if (connectedView == null) {
            return;
        }
        if (connectedView == view2) {
            --this.mConnectionCount;
            if (this.mConnectionCount == 0) {
                this.clearConnectedView();
            }
        } else {
            this.clearConnectedView();
        }
    }

    private void tryStartHandwriting() {
        if (!this.mState.mExceedTouchSlop) {
            return;
        }
        View connectedView = this.getConnectedView();
        if (connectedView == null) {
            return;
        }
        if (!connectedView.isAutoHandwritingEnabled()) {
            this.clearConnectedView();
            return;
        }
        Rect handwritingArea = HandwritingInitiator.getViewHandwritingArea(connectedView);
        if (this.contains(handwritingArea, this.mState.mStylusDownX, this.mState.mStylusDownY)) {
            this.startHandwriting(connectedView);
        } else {
            this.reset();
        }
    }

    @VisibleForTesting
    public void startHandwriting(View view2) {
        this.mImm.startStylusHandwriting(view2);
        this.reset();
    }

    public void updateHandwritingAreasForView(View view2) {
        this.mHandwritingAreasTracker.updateHandwritingAreaForView(view2);
    }

    private View findBestCandidateView(float x, float y) {
        Rect handwritingArea;
        View connectedView = this.getConnectedView();
        if (connectedView != null && connectedView.isAutoHandwritingEnabled() && this.contains(handwritingArea = HandwritingInitiator.getViewHandwritingArea(connectedView), x, y)) {
            return connectedView;
        }
        List<HandwritableViewInfo> handwritableViewInfos = this.mHandwritingAreasTracker.computeViewInfos();
        for (HandwritableViewInfo viewInfo : handwritableViewInfos) {
            View view2 = viewInfo.getView();
            if (!view2.isAutoHandwritingEnabled() || !this.contains(viewInfo.getHandwritingArea(), x, y)) continue;
            return viewInfo.getView();
        }
        return null;
    }

    private static Rect getViewHandwritingArea(View view2) {
        ViewParent viewParent = view2.getParent();
        if (viewParent != null && view2.isAttachedToWindow() && view2.isAggregatedVisible()) {
            Rect localHandwritingArea = view2.getHandwritingArea();
            Rect globalHandwritingArea = new Rect();
            if (localHandwritingArea != null) {
                globalHandwritingArea.set(localHandwritingArea);
            } else {
                globalHandwritingArea.set(0, 0, view2.getWidth(), view2.getHeight());
            }
            if (viewParent.getChildVisibleRect(view2, globalHandwritingArea, null)) {
                return globalHandwritingArea;
            }
        }
        return null;
    }

    private boolean contains(Rect rect, float x, float y) {
        if (rect == null) {
            return false;
        }
        return x >= (float)rect.left && x < (float)rect.right && y >= (float)rect.top && y < (float)rect.bottom;
    }

    private boolean largerThanTouchSlop(float x1, float y1, float x2, float y2) {
        float dx = x1 - x2;
        float dy = y1 - y2;
        return dx * dx + dy * dy > (float)(this.mTouchSlop * this.mTouchSlop);
    }

    private static boolean isViewActive(View view2) {
        return view2 != null && view2.isAttachedToWindow() && view2.isAggregatedVisible() && view2.isAutoHandwritingEnabled();
    }

    @VisibleForTesting
    public static class HandwritableViewInfo {
        final WeakReference<View> mViewRef;
        Rect mHandwritingArea = null;
        @VisibleForTesting
        public boolean mIsDirty = true;

        @VisibleForTesting
        public HandwritableViewInfo(View view2) {
            this.mViewRef = new WeakReference<View>(view2);
        }

        public View getView() {
            return (View)this.mViewRef.get();
        }

        public Rect getHandwritingArea() {
            return this.mHandwritingArea;
        }

        public boolean update() {
            View view2 = this.getView();
            if (!HandwritingInitiator.isViewActive(view2)) {
                return false;
            }
            if (!this.mIsDirty) {
                return true;
            }
            Rect handwritingArea = view2.getHandwritingArea();
            if (handwritingArea == null) {
                return false;
            }
            ViewParent parent = view2.getParent();
            if (parent != null) {
                if (this.mHandwritingArea == null) {
                    this.mHandwritingArea = new Rect();
                }
                this.mHandwritingArea.set(handwritingArea);
                if (!parent.getChildVisibleRect(view2, this.mHandwritingArea, null)) {
                    this.mHandwritingArea = null;
                }
            }
            this.mIsDirty = false;
            return true;
        }
    }

    @VisibleForTesting
    public static class HandwritingAreaTracker {
        private final List<HandwritableViewInfo> mHandwritableViewInfos = new ArrayList<HandwritableViewInfo>();

        public void updateHandwritingAreaForView(View view2) {
            Iterator<HandwritableViewInfo> iterator = this.mHandwritableViewInfos.iterator();
            boolean found = false;
            while (iterator.hasNext()) {
                HandwritableViewInfo handwritableViewInfo = iterator.next();
                View curView = handwritableViewInfo.getView();
                if (!HandwritingInitiator.isViewActive(curView)) {
                    iterator.remove();
                }
                if (curView != view2) continue;
                found = true;
                handwritableViewInfo.mIsDirty = true;
            }
            if (!found && HandwritingInitiator.isViewActive(view2)) {
                this.mHandwritableViewInfos.add(new HandwritableViewInfo(view2));
            }
        }

        public List<HandwritableViewInfo> computeViewInfos() {
            this.mHandwritableViewInfos.removeIf(viewInfo -> !viewInfo.update());
            return this.mHandwritableViewInfos;
        }
    }

    private static class State {
        private boolean mShouldInitHandwriting = false;
        private boolean mExceedTouchSlop = false;
        private int mStylusPointerId = -1;
        private long mStylusDownTimeInMillis = -1L;
        private float mStylusDownX = Float.NaN;
        private float mStylusDownY = Float.NaN;

        private State() {
        }
    }
}

