/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.graphics.Rect;
import android.os.Binder;
import android.os.IBinder;
import android.os.ICancellationSignal;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import android.view.IScrollCaptureCallbacks;
import android.view.Surface;

public interface IScrollCaptureConnection
extends IInterface {
    public static final String DESCRIPTOR = "android.view.IScrollCaptureConnection";

    public ICancellationSignal startCapture(Surface var1, IScrollCaptureCallbacks var2) throws RemoteException;

    public ICancellationSignal requestImage(Rect var1) throws RemoteException;

    public ICancellationSignal endCapture() throws RemoteException;

    public void close() throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IScrollCaptureConnection {
        static final int TRANSACTION_startCapture = 1;
        static final int TRANSACTION_requestImage = 2;
        static final int TRANSACTION_endCapture = 3;
        static final int TRANSACTION_close = 4;

        public Stub() {
            this.attachInterface(this, IScrollCaptureConnection.DESCRIPTOR);
        }

        public static IScrollCaptureConnection asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IScrollCaptureConnection.DESCRIPTOR);
            if (iin != null && iin instanceof IScrollCaptureConnection) {
                return (IScrollCaptureConnection)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "startCapture";
                }
                case 2: {
                    return "requestImage";
                }
                case 3: {
                    return "endCapture";
                }
                case 4: {
                    return "close";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IScrollCaptureConnection.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    Surface _arg0 = data.readTypedObject(Surface.CREATOR);
                    IScrollCaptureCallbacks _arg1 = IScrollCaptureCallbacks.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    ICancellationSignal _result = this.startCapture(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeStrongInterface(_result);
                    break;
                }
                case 2: {
                    Rect _arg0 = data.readTypedObject(Rect.CREATOR);
                    data.enforceNoDataAvail();
                    ICancellationSignal _result = this.requestImage(_arg0);
                    reply.writeNoException();
                    reply.writeStrongInterface(_result);
                    break;
                }
                case 3: {
                    ICancellationSignal _result = this.endCapture();
                    reply.writeNoException();
                    reply.writeStrongInterface(_result);
                    break;
                }
                case 4: {
                    this.close();
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 3;
        }

        private static class Proxy
        implements IScrollCaptureConnection {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IScrollCaptureConnection.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ICancellationSignal startCapture(Surface surface2, IScrollCaptureCallbacks callbacks) throws RemoteException {
                ICancellationSignal _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IScrollCaptureConnection.DESCRIPTOR);
                    _data.writeTypedObject(surface2, 0);
                    _data.writeStrongInterface(callbacks);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    _reply.readException();
                    _result = ICancellationSignal.Stub.asInterface(_reply.readStrongBinder());
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ICancellationSignal requestImage(Rect captureArea) throws RemoteException {
                ICancellationSignal _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IScrollCaptureConnection.DESCRIPTOR);
                    _data.writeTypedObject(captureArea, 0);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    _reply.readException();
                    _result = ICancellationSignal.Stub.asInterface(_reply.readStrongBinder());
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ICancellationSignal endCapture() throws RemoteException {
                ICancellationSignal _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IScrollCaptureConnection.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(3, _data, _reply, 0);
                    _reply.readException();
                    _result = ICancellationSignal.Stub.asInterface(_reply.readStrongBinder());
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            @Override
            public void close() throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IScrollCaptureConnection.DESCRIPTOR);
                    boolean bl = this.mRemote.transact(4, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IScrollCaptureConnection {
        @Override
        public ICancellationSignal startCapture(Surface surface2, IScrollCaptureCallbacks callbacks) throws RemoteException {
            return null;
        }

        @Override
        public ICancellationSignal requestImage(Rect captureArea) throws RemoteException {
            return null;
        }

        @Override
        public ICancellationSignal endCapture() throws RemoteException {
            return null;
        }

        @Override
        public void close() throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

