/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.compat.annotation.UnsupportedAppUsage;
import android.content.ClipData;
import android.graphics.Rect;
import android.graphics.Region;
import android.os.Binder;
import android.os.Bundle;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.RemoteCallback;
import android.os.RemoteException;
import android.util.MergedConfiguration;
import android.view.IWindow;
import android.view.IWindowId;
import android.view.InputChannel;
import android.view.InsetsSourceControl;
import android.view.InsetsState;
import android.view.InsetsVisibilities;
import android.view.SurfaceControl;
import android.view.WindowManager;
import android.window.ClientWindowFrames;
import android.window.OnBackInvokedCallbackInfo;
import java.util.ArrayList;
import java.util.List;

public interface IWindowSession
extends IInterface {
    public int addToDisplay(IWindow var1, WindowManager.LayoutParams var2, int var3, int var4, InsetsVisibilities var5, InputChannel var6, InsetsState var7, InsetsSourceControl[] var8) throws RemoteException;

    public int addToDisplayAsUser(IWindow var1, WindowManager.LayoutParams var2, int var3, int var4, int var5, InsetsVisibilities var6, InputChannel var7, InsetsState var8, InsetsSourceControl[] var9) throws RemoteException;

    public int addToDisplayWithoutInputChannel(IWindow var1, WindowManager.LayoutParams var2, int var3, int var4, InsetsState var5) throws RemoteException;

    @UnsupportedAppUsage(overrideSourcePosition="frameworks/base/core/java/android/view/IWindowSession.aidl:60:1:60:25")
    public void remove(IWindow var1) throws RemoteException;

    public int relayout(IWindow var1, WindowManager.LayoutParams var2, int var3, int var4, int var5, int var6, ClientWindowFrames var7, MergedConfiguration var8, SurfaceControl var9, InsetsState var10, InsetsSourceControl[] var11, Bundle var12) throws RemoteException;

    public int updateVisibility(IWindow var1, WindowManager.LayoutParams var2, int var3, MergedConfiguration var4, SurfaceControl var5, InsetsState var6, InsetsSourceControl[] var7) throws RemoteException;

    public void updateLayout(IWindow var1, WindowManager.LayoutParams var2, int var3, ClientWindowFrames var4, int var5, int var6) throws RemoteException;

    public void prepareToReplaceWindows(IBinder var1, boolean var2) throws RemoteException;

    public boolean outOfMemory(IWindow var1) throws RemoteException;

    public void setInsets(IWindow var1, int var2, Rect var3, Rect var4, Region var5) throws RemoteException;

    @UnsupportedAppUsage(overrideSourcePosition="frameworks/base/core/java/android/view/IWindowSession.aidl:180:1:180:25")
    public void finishDrawing(IWindow var1, SurfaceControl.Transaction var2, int var3) throws RemoteException;

    @UnsupportedAppUsage(overrideSourcePosition="frameworks/base/core/java/android/view/IWindowSession.aidl:184:1:184:25")
    public void setInTouchMode(boolean var1) throws RemoteException;

    @UnsupportedAppUsage(overrideSourcePosition="frameworks/base/core/java/android/view/IWindowSession.aidl:186:1:186:25")
    public boolean getInTouchMode() throws RemoteException;

    @UnsupportedAppUsage(overrideSourcePosition="frameworks/base/core/java/android/view/IWindowSession.aidl:189:1:189:25")
    public boolean performHapticFeedback(int var1, boolean var2) throws RemoteException;

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L, overrideSourcePosition="frameworks/base/core/java/android/view/IWindowSession.aidl:208:1:208:69")
    public IBinder performDrag(IWindow var1, int var2, SurfaceControl var3, int var4, float var5, float var6, float var7, float var8, ClipData var9) throws RemoteException;

    public boolean dropForAccessibility(IWindow var1, int var2, int var3) throws RemoteException;

    public void reportDropResult(IWindow var1, boolean var2) throws RemoteException;

    public void cancelDragAndDrop(IBinder var1, boolean var2) throws RemoteException;

    public void dragRecipientEntered(IWindow var1) throws RemoteException;

    public void dragRecipientExited(IWindow var1) throws RemoteException;

    public void setWallpaperPosition(IBinder var1, float var2, float var3, float var4, float var5) throws RemoteException;

    public void setWallpaperZoomOut(IBinder var1, float var2) throws RemoteException;

    public void setShouldZoomOutWallpaper(IBinder var1, boolean var2) throws RemoteException;

    @UnsupportedAppUsage(overrideSourcePosition="frameworks/base/core/java/android/view/IWindowSession.aidl:262:1:262:25")
    public void wallpaperOffsetsComplete(IBinder var1) throws RemoteException;

    public void setWallpaperDisplayOffset(IBinder var1, int var2, int var3) throws RemoteException;

    public Bundle sendWallpaperCommand(IBinder var1, String var2, int var3, int var4, int var5, Bundle var6, boolean var7) throws RemoteException;

    @UnsupportedAppUsage(overrideSourcePosition="frameworks/base/core/java/android/view/IWindowSession.aidl:273:1:273:25")
    public void wallpaperCommandComplete(IBinder var1, Bundle var2) throws RemoteException;

    public void onRectangleOnScreenRequested(IBinder var1, Rect var2) throws RemoteException;

    public IWindowId getWindowId(IBinder var1) throws RemoteException;

    public void pokeDrawLock(IBinder var1) throws RemoteException;

    public boolean startMovingTask(IWindow var1, float var2, float var3) throws RemoteException;

    public void finishMovingTask(IWindow var1) throws RemoteException;

    public void updatePointerIcon(IWindow var1) throws RemoteException;

    public void updateTapExcludeRegion(IWindow var1, Region var2) throws RemoteException;

    public void updateRequestedVisibilities(IWindow var1, InsetsVisibilities var2) throws RemoteException;

    public void reportSystemGestureExclusionChanged(IWindow var1, List<Rect> var2) throws RemoteException;

    public void reportKeepClearAreasChanged(IWindow var1, List<Rect> var2, List<Rect> var3) throws RemoteException;

    public void grantInputChannel(int var1, SurfaceControl var2, IWindow var3, IBinder var4, int var5, int var6, int var7, IBinder var8, String var9, InputChannel var10) throws RemoteException;

    public void updateInputChannel(IBinder var1, int var2, SurfaceControl var3, int var4, int var5, Region var6) throws RemoteException;

    public void grantEmbeddedWindowFocus(IWindow var1, IBinder var2, boolean var3) throws RemoteException;

    public void generateDisplayHash(IWindow var1, Rect var2, String var3, RemoteCallback var4) throws RemoteException;

    public void setOnBackInvokedCallbackInfo(IWindow var1, OnBackInvokedCallbackInfo var2) throws RemoteException;

    public void clearTouchableRegion(IWindow var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IWindowSession {
        public static final String DESCRIPTOR = "android.view.IWindowSession";
        static final int TRANSACTION_addToDisplay = 1;
        static final int TRANSACTION_addToDisplayAsUser = 2;
        static final int TRANSACTION_addToDisplayWithoutInputChannel = 3;
        static final int TRANSACTION_remove = 4;
        static final int TRANSACTION_relayout = 5;
        static final int TRANSACTION_updateVisibility = 6;
        static final int TRANSACTION_updateLayout = 7;
        static final int TRANSACTION_prepareToReplaceWindows = 8;
        static final int TRANSACTION_outOfMemory = 9;
        static final int TRANSACTION_setInsets = 10;
        static final int TRANSACTION_finishDrawing = 11;
        static final int TRANSACTION_setInTouchMode = 12;
        static final int TRANSACTION_getInTouchMode = 13;
        static final int TRANSACTION_performHapticFeedback = 14;
        static final int TRANSACTION_performDrag = 15;
        static final int TRANSACTION_dropForAccessibility = 16;
        static final int TRANSACTION_reportDropResult = 17;
        static final int TRANSACTION_cancelDragAndDrop = 18;
        static final int TRANSACTION_dragRecipientEntered = 19;
        static final int TRANSACTION_dragRecipientExited = 20;
        static final int TRANSACTION_setWallpaperPosition = 21;
        static final int TRANSACTION_setWallpaperZoomOut = 22;
        static final int TRANSACTION_setShouldZoomOutWallpaper = 23;
        static final int TRANSACTION_wallpaperOffsetsComplete = 24;
        static final int TRANSACTION_setWallpaperDisplayOffset = 25;
        static final int TRANSACTION_sendWallpaperCommand = 26;
        static final int TRANSACTION_wallpaperCommandComplete = 27;
        static final int TRANSACTION_onRectangleOnScreenRequested = 28;
        static final int TRANSACTION_getWindowId = 29;
        static final int TRANSACTION_pokeDrawLock = 30;
        static final int TRANSACTION_startMovingTask = 31;
        static final int TRANSACTION_finishMovingTask = 32;
        static final int TRANSACTION_updatePointerIcon = 33;
        static final int TRANSACTION_updateTapExcludeRegion = 34;
        static final int TRANSACTION_updateRequestedVisibilities = 35;
        static final int TRANSACTION_reportSystemGestureExclusionChanged = 36;
        static final int TRANSACTION_reportKeepClearAreasChanged = 37;
        static final int TRANSACTION_grantInputChannel = 38;
        static final int TRANSACTION_updateInputChannel = 39;
        static final int TRANSACTION_grantEmbeddedWindowFocus = 40;
        static final int TRANSACTION_generateDisplayHash = 41;
        static final int TRANSACTION_setOnBackInvokedCallbackInfo = 42;
        static final int TRANSACTION_clearTouchableRegion = 43;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static IWindowSession asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof IWindowSession) {
                return (IWindowSession)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "addToDisplay";
                }
                case 2: {
                    return "addToDisplayAsUser";
                }
                case 3: {
                    return "addToDisplayWithoutInputChannel";
                }
                case 4: {
                    return "remove";
                }
                case 5: {
                    return "relayout";
                }
                case 6: {
                    return "updateVisibility";
                }
                case 7: {
                    return "updateLayout";
                }
                case 8: {
                    return "prepareToReplaceWindows";
                }
                case 9: {
                    return "outOfMemory";
                }
                case 10: {
                    return "setInsets";
                }
                case 11: {
                    return "finishDrawing";
                }
                case 12: {
                    return "setInTouchMode";
                }
                case 13: {
                    return "getInTouchMode";
                }
                case 14: {
                    return "performHapticFeedback";
                }
                case 15: {
                    return "performDrag";
                }
                case 16: {
                    return "dropForAccessibility";
                }
                case 17: {
                    return "reportDropResult";
                }
                case 18: {
                    return "cancelDragAndDrop";
                }
                case 19: {
                    return "dragRecipientEntered";
                }
                case 20: {
                    return "dragRecipientExited";
                }
                case 21: {
                    return "setWallpaperPosition";
                }
                case 22: {
                    return "setWallpaperZoomOut";
                }
                case 23: {
                    return "setShouldZoomOutWallpaper";
                }
                case 24: {
                    return "wallpaperOffsetsComplete";
                }
                case 25: {
                    return "setWallpaperDisplayOffset";
                }
                case 26: {
                    return "sendWallpaperCommand";
                }
                case 27: {
                    return "wallpaperCommandComplete";
                }
                case 28: {
                    return "onRectangleOnScreenRequested";
                }
                case 29: {
                    return "getWindowId";
                }
                case 30: {
                    return "pokeDrawLock";
                }
                case 31: {
                    return "startMovingTask";
                }
                case 32: {
                    return "finishMovingTask";
                }
                case 33: {
                    return "updatePointerIcon";
                }
                case 34: {
                    return "updateTapExcludeRegion";
                }
                case 35: {
                    return "updateRequestedVisibilities";
                }
                case 36: {
                    return "reportSystemGestureExclusionChanged";
                }
                case 37: {
                    return "reportKeepClearAreasChanged";
                }
                case 38: {
                    return "grantInputChannel";
                }
                case 39: {
                    return "updateInputChannel";
                }
                case 40: {
                    return "grantEmbeddedWindowFocus";
                }
                case 41: {
                    return "generateDisplayHash";
                }
                case 42: {
                    return "setOnBackInvokedCallbackInfo";
                }
                case 43: {
                    return "clearTouchableRegion";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    IWindow _arg0 = IWindow.Stub.asInterface(data.readStrongBinder());
                    WindowManager.LayoutParams _arg1 = data.readTypedObject(WindowManager.LayoutParams.CREATOR);
                    int _arg2 = data.readInt();
                    int _arg3 = data.readInt();
                    InsetsVisibilities _arg4 = data.readTypedObject(InsetsVisibilities.CREATOR);
                    InputChannel _arg5 = new InputChannel();
                    InsetsState _arg6 = new InsetsState();
                    int _arg7_length = data.readInt();
                    Parcelable[] _arg7 = _arg7_length < 0 ? null : new InsetsSourceControl[_arg7_length];
                    data.enforceNoDataAvail();
                    int _result = this.addToDisplay(_arg0, _arg1, _arg2, _arg3, _arg4, _arg5, _arg6, (InsetsSourceControl[])_arg7);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    reply.writeTypedObject(_arg5, 1);
                    reply.writeTypedObject(_arg6, 1);
                    reply.writeTypedArray(_arg7, 1);
                    break;
                }
                case 2: {
                    IWindow _arg0 = IWindow.Stub.asInterface(data.readStrongBinder());
                    WindowManager.LayoutParams _arg1 = data.readTypedObject(WindowManager.LayoutParams.CREATOR);
                    int _arg2 = data.readInt();
                    int _arg3 = data.readInt();
                    int _arg4 = data.readInt();
                    InsetsVisibilities _arg5 = data.readTypedObject(InsetsVisibilities.CREATOR);
                    InputChannel _arg6 = new InputChannel();
                    InsetsState _arg7 = new InsetsState();
                    int _arg8_length = data.readInt();
                    Parcelable[] _arg8 = _arg8_length < 0 ? null : new InsetsSourceControl[_arg8_length];
                    data.enforceNoDataAvail();
                    int _result = this.addToDisplayAsUser(_arg0, _arg1, _arg2, _arg3, _arg4, _arg5, _arg6, _arg7, (InsetsSourceControl[])_arg8);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    reply.writeTypedObject(_arg6, 1);
                    reply.writeTypedObject(_arg7, 1);
                    reply.writeTypedArray(_arg8, 1);
                    break;
                }
                case 3: {
                    IWindow _arg0 = IWindow.Stub.asInterface(data.readStrongBinder());
                    WindowManager.LayoutParams _arg1 = data.readTypedObject(WindowManager.LayoutParams.CREATOR);
                    int _arg2 = data.readInt();
                    int _arg3 = data.readInt();
                    InsetsState _arg4 = new InsetsState();
                    data.enforceNoDataAvail();
                    int _result = this.addToDisplayWithoutInputChannel(_arg0, _arg1, _arg2, _arg3, _arg4);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    reply.writeTypedObject(_arg4, 1);
                    break;
                }
                case 4: {
                    IWindow _arg0 = IWindow.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.remove(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 5: {
                    IWindow _arg0 = IWindow.Stub.asInterface(data.readStrongBinder());
                    WindowManager.LayoutParams _arg1 = data.readTypedObject(WindowManager.LayoutParams.CREATOR);
                    int _arg2 = data.readInt();
                    int _arg3 = data.readInt();
                    int _arg4 = data.readInt();
                    int _arg5 = data.readInt();
                    ClientWindowFrames _arg6 = new ClientWindowFrames();
                    MergedConfiguration _arg7 = new MergedConfiguration();
                    SurfaceControl _arg8 = new SurfaceControl();
                    InsetsState _arg9 = new InsetsState();
                    int _arg10_length = data.readInt();
                    Parcelable[] _arg10 = _arg10_length < 0 ? null : new InsetsSourceControl[_arg10_length];
                    Bundle _arg11 = new Bundle();
                    data.enforceNoDataAvail();
                    int _result = this.relayout(_arg0, _arg1, _arg2, _arg3, _arg4, _arg5, _arg6, _arg7, _arg8, _arg9, (InsetsSourceControl[])_arg10, _arg11);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    reply.writeTypedObject(_arg6, 1);
                    reply.writeTypedObject(_arg7, 1);
                    reply.writeTypedObject(_arg8, 1);
                    reply.writeTypedObject(_arg9, 1);
                    reply.writeTypedArray(_arg10, 1);
                    reply.writeTypedObject(_arg11, 1);
                    break;
                }
                case 6: {
                    IWindow _arg0 = IWindow.Stub.asInterface(data.readStrongBinder());
                    WindowManager.LayoutParams _arg1 = data.readTypedObject(WindowManager.LayoutParams.CREATOR);
                    int _arg2 = data.readInt();
                    MergedConfiguration _arg3 = new MergedConfiguration();
                    SurfaceControl _arg4 = new SurfaceControl();
                    InsetsState _arg5 = new InsetsState();
                    int _arg6_length = data.readInt();
                    Parcelable[] _arg6 = _arg6_length < 0 ? null : new InsetsSourceControl[_arg6_length];
                    data.enforceNoDataAvail();
                    int _result = this.updateVisibility(_arg0, _arg1, _arg2, _arg3, _arg4, _arg5, (InsetsSourceControl[])_arg6);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    reply.writeTypedObject(_arg3, 1);
                    reply.writeTypedObject(_arg4, 1);
                    reply.writeTypedObject(_arg5, 1);
                    reply.writeTypedArray(_arg6, 1);
                    break;
                }
                case 7: {
                    IWindow _arg0 = IWindow.Stub.asInterface(data.readStrongBinder());
                    WindowManager.LayoutParams _arg1 = data.readTypedObject(WindowManager.LayoutParams.CREATOR);
                    int _arg2 = data.readInt();
                    ClientWindowFrames _arg3 = data.readTypedObject(ClientWindowFrames.CREATOR);
                    int _arg4 = data.readInt();
                    int _arg5 = data.readInt();
                    data.enforceNoDataAvail();
                    this.updateLayout(_arg0, _arg1, _arg2, _arg3, _arg4, _arg5);
                    break;
                }
                case 8: {
                    IBinder _arg0 = data.readStrongBinder();
                    boolean _arg1 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.prepareToReplaceWindows(_arg0, _arg1);
                    break;
                }
                case 9: {
                    IWindow _arg0 = IWindow.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    boolean _result = this.outOfMemory(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 10: {
                    IWindow _arg0 = IWindow.Stub.asInterface(data.readStrongBinder());
                    int _arg1 = data.readInt();
                    Rect _arg2 = data.readTypedObject(Rect.CREATOR);
                    Rect _arg3 = data.readTypedObject(Rect.CREATOR);
                    Region _arg4 = data.readTypedObject(Region.CREATOR);
                    data.enforceNoDataAvail();
                    this.setInsets(_arg0, _arg1, _arg2, _arg3, _arg4);
                    break;
                }
                case 11: {
                    IWindow _arg0 = IWindow.Stub.asInterface(data.readStrongBinder());
                    SurfaceControl.Transaction _arg1 = data.readTypedObject(SurfaceControl.Transaction.CREATOR);
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    this.finishDrawing(_arg0, _arg1, _arg2);
                    break;
                }
                case 12: {
                    boolean _arg0 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.setInTouchMode(_arg0);
                    break;
                }
                case 13: {
                    boolean _result = this.getInTouchMode();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 14: {
                    int _arg0 = data.readInt();
                    boolean _arg1 = data.readBoolean();
                    data.enforceNoDataAvail();
                    boolean _result = this.performHapticFeedback(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 15: {
                    IWindow _arg0 = IWindow.Stub.asInterface(data.readStrongBinder());
                    int _arg1 = data.readInt();
                    SurfaceControl _arg2 = data.readTypedObject(SurfaceControl.CREATOR);
                    int _arg3 = data.readInt();
                    float _arg4 = data.readFloat();
                    float _arg5 = data.readFloat();
                    float _arg6 = data.readFloat();
                    float _arg7 = data.readFloat();
                    ClipData _arg8 = data.readTypedObject(ClipData.CREATOR);
                    data.enforceNoDataAvail();
                    IBinder _result = this.performDrag(_arg0, _arg1, _arg2, _arg3, _arg4, _arg5, _arg6, _arg7, _arg8);
                    reply.writeNoException();
                    reply.writeStrongBinder(_result);
                    break;
                }
                case 16: {
                    IWindow _arg0 = IWindow.Stub.asInterface(data.readStrongBinder());
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    boolean _result = this.dropForAccessibility(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 17: {
                    IWindow _arg0 = IWindow.Stub.asInterface(data.readStrongBinder());
                    boolean _arg1 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.reportDropResult(_arg0, _arg1);
                    break;
                }
                case 18: {
                    IBinder _arg0 = data.readStrongBinder();
                    boolean _arg1 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.cancelDragAndDrop(_arg0, _arg1);
                    break;
                }
                case 19: {
                    IWindow _arg0 = IWindow.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.dragRecipientEntered(_arg0);
                    break;
                }
                case 20: {
                    IWindow _arg0 = IWindow.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.dragRecipientExited(_arg0);
                    break;
                }
                case 21: {
                    IBinder _arg0 = data.readStrongBinder();
                    float _arg1 = data.readFloat();
                    float _arg2 = data.readFloat();
                    float _arg3 = data.readFloat();
                    float _arg4 = data.readFloat();
                    data.enforceNoDataAvail();
                    this.setWallpaperPosition(_arg0, _arg1, _arg2, _arg3, _arg4);
                    break;
                }
                case 22: {
                    IBinder _arg0 = data.readStrongBinder();
                    float _arg1 = data.readFloat();
                    data.enforceNoDataAvail();
                    this.setWallpaperZoomOut(_arg0, _arg1);
                    break;
                }
                case 23: {
                    IBinder _arg0 = data.readStrongBinder();
                    boolean _arg1 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.setShouldZoomOutWallpaper(_arg0, _arg1);
                    break;
                }
                case 24: {
                    IBinder _arg0 = data.readStrongBinder();
                    data.enforceNoDataAvail();
                    this.wallpaperOffsetsComplete(_arg0);
                    break;
                }
                case 25: {
                    IBinder _arg0 = data.readStrongBinder();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    this.setWallpaperDisplayOffset(_arg0, _arg1, _arg2);
                    break;
                }
                case 26: {
                    IBinder _arg0 = data.readStrongBinder();
                    String _arg1 = data.readString();
                    int _arg2 = data.readInt();
                    int _arg3 = data.readInt();
                    int _arg4 = data.readInt();
                    Bundle _arg5 = data.readTypedObject(Bundle.CREATOR);
                    boolean _arg6 = data.readBoolean();
                    data.enforceNoDataAvail();
                    Bundle _result = this.sendWallpaperCommand(_arg0, _arg1, _arg2, _arg3, _arg4, _arg5, _arg6);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 27: {
                    IBinder _arg0 = data.readStrongBinder();
                    Bundle _arg1 = data.readTypedObject(Bundle.CREATOR);
                    data.enforceNoDataAvail();
                    this.wallpaperCommandComplete(_arg0, _arg1);
                    break;
                }
                case 28: {
                    IBinder _arg0 = data.readStrongBinder();
                    Rect _arg1 = data.readTypedObject(Rect.CREATOR);
                    data.enforceNoDataAvail();
                    this.onRectangleOnScreenRequested(_arg0, _arg1);
                    break;
                }
                case 29: {
                    IBinder _arg0 = data.readStrongBinder();
                    data.enforceNoDataAvail();
                    IWindowId _result = this.getWindowId(_arg0);
                    reply.writeNoException();
                    reply.writeStrongInterface(_result);
                    break;
                }
                case 30: {
                    IBinder _arg0 = data.readStrongBinder();
                    data.enforceNoDataAvail();
                    this.pokeDrawLock(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 31: {
                    IWindow _arg0 = IWindow.Stub.asInterface(data.readStrongBinder());
                    float _arg1 = data.readFloat();
                    float _arg2 = data.readFloat();
                    data.enforceNoDataAvail();
                    boolean _result = this.startMovingTask(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 32: {
                    IWindow _arg0 = IWindow.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.finishMovingTask(_arg0);
                    break;
                }
                case 33: {
                    IWindow _arg0 = IWindow.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.updatePointerIcon(_arg0);
                    break;
                }
                case 34: {
                    IWindow _arg0 = IWindow.Stub.asInterface(data.readStrongBinder());
                    Region _arg1 = data.readTypedObject(Region.CREATOR);
                    data.enforceNoDataAvail();
                    this.updateTapExcludeRegion(_arg0, _arg1);
                    break;
                }
                case 35: {
                    IWindow _arg0 = IWindow.Stub.asInterface(data.readStrongBinder());
                    InsetsVisibilities _arg1 = data.readTypedObject(InsetsVisibilities.CREATOR);
                    data.enforceNoDataAvail();
                    this.updateRequestedVisibilities(_arg0, _arg1);
                    break;
                }
                case 36: {
                    IWindow _arg0 = IWindow.Stub.asInterface(data.readStrongBinder());
                    ArrayList<Rect> _arg1 = data.createTypedArrayList(Rect.CREATOR);
                    data.enforceNoDataAvail();
                    this.reportSystemGestureExclusionChanged(_arg0, _arg1);
                    break;
                }
                case 37: {
                    IWindow _arg0 = IWindow.Stub.asInterface(data.readStrongBinder());
                    ArrayList<Rect> _arg1 = data.createTypedArrayList(Rect.CREATOR);
                    ArrayList<Rect> _arg2 = data.createTypedArrayList(Rect.CREATOR);
                    data.enforceNoDataAvail();
                    this.reportKeepClearAreasChanged(_arg0, _arg1, _arg2);
                    break;
                }
                case 38: {
                    int _arg0 = data.readInt();
                    SurfaceControl _arg1 = data.readTypedObject(SurfaceControl.CREATOR);
                    IWindow _arg2 = IWindow.Stub.asInterface(data.readStrongBinder());
                    IBinder _arg3 = data.readStrongBinder();
                    int _arg4 = data.readInt();
                    int _arg5 = data.readInt();
                    int _arg6 = data.readInt();
                    IBinder _arg7 = data.readStrongBinder();
                    String _arg8 = data.readString();
                    InputChannel _arg9 = new InputChannel();
                    data.enforceNoDataAvail();
                    this.grantInputChannel(_arg0, _arg1, _arg2, _arg3, _arg4, _arg5, _arg6, _arg7, _arg8, _arg9);
                    reply.writeNoException();
                    reply.writeTypedObject(_arg9, 1);
                    break;
                }
                case 39: {
                    IBinder _arg0 = data.readStrongBinder();
                    int _arg1 = data.readInt();
                    SurfaceControl _arg2 = data.readTypedObject(SurfaceControl.CREATOR);
                    int _arg3 = data.readInt();
                    int _arg4 = data.readInt();
                    Region _arg5 = data.readTypedObject(Region.CREATOR);
                    data.enforceNoDataAvail();
                    this.updateInputChannel(_arg0, _arg1, _arg2, _arg3, _arg4, _arg5);
                    break;
                }
                case 40: {
                    IWindow _arg0 = IWindow.Stub.asInterface(data.readStrongBinder());
                    IBinder _arg1 = data.readStrongBinder();
                    boolean _arg2 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.grantEmbeddedWindowFocus(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 41: {
                    IWindow _arg0 = IWindow.Stub.asInterface(data.readStrongBinder());
                    Rect _arg1 = data.readTypedObject(Rect.CREATOR);
                    String _arg2 = data.readString();
                    RemoteCallback _arg3 = data.readTypedObject(RemoteCallback.CREATOR);
                    data.enforceNoDataAvail();
                    this.generateDisplayHash(_arg0, _arg1, _arg2, _arg3);
                    break;
                }
                case 42: {
                    IWindow _arg0 = IWindow.Stub.asInterface(data.readStrongBinder());
                    OnBackInvokedCallbackInfo _arg1 = data.readTypedObject(OnBackInvokedCallbackInfo.CREATOR);
                    data.enforceNoDataAvail();
                    this.setOnBackInvokedCallbackInfo(_arg0, _arg1);
                    break;
                }
                case 43: {
                    IWindow _arg0 = IWindow.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.clearTouchableRegion(_arg0);
                    reply.writeNoException();
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 42;
        }

        private static class Proxy
        implements IWindowSession {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int addToDisplay(IWindow window, WindowManager.LayoutParams attrs, int viewVisibility, int layerStackId, InsetsVisibilities requestedVisibilities, InputChannel outInputChannel, InsetsState insetsState, InsetsSourceControl[] activeControls) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(window);
                    _data.writeTypedObject(attrs, 0);
                    _data.writeInt(viewVisibility);
                    _data.writeInt(layerStackId);
                    _data.writeTypedObject(requestedVisibilities, 0);
                    if (activeControls == null) {
                        _data.writeInt(-1);
                    } else {
                        _data.writeInt(activeControls.length);
                    }
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                    if (0 != _reply.readInt()) {
                        outInputChannel.readFromParcel(_reply);
                    }
                    if (0 != _reply.readInt()) {
                        insetsState.readFromParcel(_reply);
                    }
                    _reply.readTypedArray(activeControls, InsetsSourceControl.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int addToDisplayAsUser(IWindow window, WindowManager.LayoutParams attrs, int viewVisibility, int layerStackId, int userId, InsetsVisibilities requestedVisibilities, InputChannel outInputChannel, InsetsState insetsState, InsetsSourceControl[] activeControls) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(window);
                    _data.writeTypedObject(attrs, 0);
                    _data.writeInt(viewVisibility);
                    _data.writeInt(layerStackId);
                    _data.writeInt(userId);
                    _data.writeTypedObject(requestedVisibilities, 0);
                    if (activeControls == null) {
                        _data.writeInt(-1);
                    } else {
                        _data.writeInt(activeControls.length);
                    }
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                    if (0 != _reply.readInt()) {
                        outInputChannel.readFromParcel(_reply);
                    }
                    if (0 != _reply.readInt()) {
                        insetsState.readFromParcel(_reply);
                    }
                    _reply.readTypedArray(activeControls, InsetsSourceControl.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int addToDisplayWithoutInputChannel(IWindow window, WindowManager.LayoutParams attrs, int viewVisibility, int layerStackId, InsetsState insetsState) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(window);
                    _data.writeTypedObject(attrs, 0);
                    _data.writeInt(viewVisibility);
                    _data.writeInt(layerStackId);
                    boolean _status = this.mRemote.transact(3, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                    if (0 != _reply.readInt()) {
                        insetsState.readFromParcel(_reply);
                    }
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void remove(IWindow window) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(window);
                    boolean _status = this.mRemote.transact(4, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int relayout(IWindow window, WindowManager.LayoutParams attrs, int requestedWidth, int requestedHeight, int viewVisibility, int flags, ClientWindowFrames outFrames, MergedConfiguration outMergedConfiguration, SurfaceControl outSurfaceControl, InsetsState insetsState, InsetsSourceControl[] activeControls, Bundle bundle) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(window);
                    _data.writeTypedObject(attrs, 0);
                    _data.writeInt(requestedWidth);
                    _data.writeInt(requestedHeight);
                    _data.writeInt(viewVisibility);
                    _data.writeInt(flags);
                    if (activeControls == null) {
                        _data.writeInt(-1);
                    } else {
                        _data.writeInt(activeControls.length);
                    }
                    boolean _status = this.mRemote.transact(5, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                    if (0 != _reply.readInt()) {
                        outFrames.readFromParcel(_reply);
                    }
                    if (0 != _reply.readInt()) {
                        outMergedConfiguration.readFromParcel(_reply);
                    }
                    if (0 != _reply.readInt()) {
                        outSurfaceControl.readFromParcel(_reply);
                    }
                    if (0 != _reply.readInt()) {
                        insetsState.readFromParcel(_reply);
                    }
                    _reply.readTypedArray(activeControls, InsetsSourceControl.CREATOR);
                    if (0 != _reply.readInt()) {
                        bundle.readFromParcel(_reply);
                    }
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int updateVisibility(IWindow window, WindowManager.LayoutParams attrs, int viewVisibility, MergedConfiguration outMergedConfiguration, SurfaceControl outSurfaceControl, InsetsState outInsetsState, InsetsSourceControl[] outActiveControls) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(window);
                    _data.writeTypedObject(attrs, 0);
                    _data.writeInt(viewVisibility);
                    if (outActiveControls == null) {
                        _data.writeInt(-1);
                    } else {
                        _data.writeInt(outActiveControls.length);
                    }
                    boolean _status = this.mRemote.transact(6, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                    if (0 != _reply.readInt()) {
                        outMergedConfiguration.readFromParcel(_reply);
                    }
                    if (0 != _reply.readInt()) {
                        outSurfaceControl.readFromParcel(_reply);
                    }
                    if (0 != _reply.readInt()) {
                        outInsetsState.readFromParcel(_reply);
                    }
                    _reply.readTypedArray(outActiveControls, InsetsSourceControl.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void updateLayout(IWindow window, WindowManager.LayoutParams attrs, int flags, ClientWindowFrames clientFrames, int requestedWidth, int requestedHeight) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(window);
                    _data.writeTypedObject(attrs, 0);
                    _data.writeInt(flags);
                    _data.writeTypedObject(clientFrames, 0);
                    _data.writeInt(requestedWidth);
                    _data.writeInt(requestedHeight);
                    boolean bl = this.mRemote.transact(7, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void prepareToReplaceWindows(IBinder appToken, boolean childrenOnly) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(appToken);
                    _data.writeBoolean(childrenOnly);
                    boolean bl = this.mRemote.transact(8, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean outOfMemory(IWindow window) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(window);
                    boolean _status = this.mRemote.transact(9, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setInsets(IWindow window, int touchableInsets, Rect contentInsets, Rect visibleInsets, Region touchableRegion) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(window);
                    _data.writeInt(touchableInsets);
                    _data.writeTypedObject(contentInsets, 0);
                    _data.writeTypedObject(visibleInsets, 0);
                    _data.writeTypedObject(touchableRegion, 0);
                    boolean bl = this.mRemote.transact(10, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void finishDrawing(IWindow window, SurfaceControl.Transaction postDrawTransaction, int seqId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(window);
                    _data.writeTypedObject(postDrawTransaction, 0);
                    _data.writeInt(seqId);
                    boolean bl = this.mRemote.transact(11, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setInTouchMode(boolean showFocus) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(showFocus);
                    boolean bl = this.mRemote.transact(12, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean getInTouchMode() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(13, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean performHapticFeedback(int effectId, boolean always) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(effectId);
                    _data.writeBoolean(always);
                    boolean _status = this.mRemote.transact(14, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public IBinder performDrag(IWindow window, int flags, SurfaceControl surface2, int touchSource, float touchX, float touchY, float thumbCenterX, float thumbCenterY, ClipData data) throws RemoteException {
                IBinder _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(window);
                    _data.writeInt(flags);
                    _data.writeTypedObject(surface2, 0);
                    _data.writeInt(touchSource);
                    _data.writeFloat(touchX);
                    _data.writeFloat(touchY);
                    _data.writeFloat(thumbCenterX);
                    _data.writeFloat(thumbCenterY);
                    _data.writeTypedObject(data, 0);
                    boolean _status = this.mRemote.transact(15, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readStrongBinder();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean dropForAccessibility(IWindow window, int x, int y) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(window);
                    _data.writeInt(x);
                    _data.writeInt(y);
                    boolean _status = this.mRemote.transact(16, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void reportDropResult(IWindow window, boolean consumed) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(window);
                    _data.writeBoolean(consumed);
                    boolean bl = this.mRemote.transact(17, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void cancelDragAndDrop(IBinder dragToken, boolean skipAnimation) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(dragToken);
                    _data.writeBoolean(skipAnimation);
                    boolean bl = this.mRemote.transact(18, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void dragRecipientEntered(IWindow window) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(window);
                    boolean bl = this.mRemote.transact(19, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void dragRecipientExited(IWindow window) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(window);
                    boolean bl = this.mRemote.transact(20, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setWallpaperPosition(IBinder windowToken, float x, float y, float xstep, float ystep) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(windowToken);
                    _data.writeFloat(x);
                    _data.writeFloat(y);
                    _data.writeFloat(xstep);
                    _data.writeFloat(ystep);
                    boolean bl = this.mRemote.transact(21, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setWallpaperZoomOut(IBinder windowToken, float scale) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(windowToken);
                    _data.writeFloat(scale);
                    boolean bl = this.mRemote.transact(22, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setShouldZoomOutWallpaper(IBinder windowToken, boolean shouldZoom) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(windowToken);
                    _data.writeBoolean(shouldZoom);
                    boolean bl = this.mRemote.transact(23, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void wallpaperOffsetsComplete(IBinder window) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(window);
                    boolean bl = this.mRemote.transact(24, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setWallpaperDisplayOffset(IBinder windowToken, int x, int y) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(windowToken);
                    _data.writeInt(x);
                    _data.writeInt(y);
                    boolean bl = this.mRemote.transact(25, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Bundle sendWallpaperCommand(IBinder window, String action2, int x, int y, int z, Bundle extras, boolean sync) throws RemoteException {
                Bundle _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(window);
                    _data.writeString(action2);
                    _data.writeInt(x);
                    _data.writeInt(y);
                    _data.writeInt(z);
                    _data.writeTypedObject(extras, 0);
                    _data.writeBoolean(sync);
                    boolean _status = this.mRemote.transact(26, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(Bundle.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void wallpaperCommandComplete(IBinder window, Bundle result) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(window);
                    _data.writeTypedObject(result, 0);
                    boolean bl = this.mRemote.transact(27, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onRectangleOnScreenRequested(IBinder token, Rect rectangle) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(token);
                    _data.writeTypedObject(rectangle, 0);
                    boolean bl = this.mRemote.transact(28, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public IWindowId getWindowId(IBinder window) throws RemoteException {
                IWindowId _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(window);
                    boolean _status = this.mRemote.transact(29, _data, _reply, 0);
                    _reply.readException();
                    _result = IWindowId.Stub.asInterface(_reply.readStrongBinder());
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void pokeDrawLock(IBinder window) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(window);
                    boolean _status = this.mRemote.transact(30, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean startMovingTask(IWindow window, float startX, float startY) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(window);
                    _data.writeFloat(startX);
                    _data.writeFloat(startY);
                    boolean _status = this.mRemote.transact(31, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void finishMovingTask(IWindow window) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(window);
                    boolean bl = this.mRemote.transact(32, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void updatePointerIcon(IWindow window) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(window);
                    boolean bl = this.mRemote.transact(33, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void updateTapExcludeRegion(IWindow window, Region region) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(window);
                    _data.writeTypedObject(region, 0);
                    boolean bl = this.mRemote.transact(34, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void updateRequestedVisibilities(IWindow window, InsetsVisibilities visibilities) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(window);
                    _data.writeTypedObject(visibilities, 0);
                    boolean bl = this.mRemote.transact(35, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void reportSystemGestureExclusionChanged(IWindow window, List<Rect> exclusionRects) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(window);
                    _data.writeTypedList(exclusionRects);
                    boolean bl = this.mRemote.transact(36, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void reportKeepClearAreasChanged(IWindow window, List<Rect> restricted, List<Rect> unrestricted) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(window);
                    _data.writeTypedList(restricted);
                    _data.writeTypedList(unrestricted);
                    boolean bl = this.mRemote.transact(37, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void grantInputChannel(int displayId, SurfaceControl surface2, IWindow window, IBinder hostInputToken, int flags, int privateFlags, int type, IBinder focusGrantToken, String inputHandleName, InputChannel outInputChannel) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    _data.writeTypedObject(surface2, 0);
                    _data.writeStrongInterface(window);
                    _data.writeStrongBinder(hostInputToken);
                    _data.writeInt(flags);
                    _data.writeInt(privateFlags);
                    _data.writeInt(type);
                    _data.writeStrongBinder(focusGrantToken);
                    _data.writeString(inputHandleName);
                    boolean _status = this.mRemote.transact(38, _data, _reply, 0);
                    _reply.readException();
                    if (0 != _reply.readInt()) {
                        outInputChannel.readFromParcel(_reply);
                    }
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void updateInputChannel(IBinder channelToken, int displayId, SurfaceControl surface2, int flags, int privateFlags, Region region) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(channelToken);
                    _data.writeInt(displayId);
                    _data.writeTypedObject(surface2, 0);
                    _data.writeInt(flags);
                    _data.writeInt(privateFlags);
                    _data.writeTypedObject(region, 0);
                    boolean bl = this.mRemote.transact(39, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void grantEmbeddedWindowFocus(IWindow window, IBinder inputToken, boolean grantFocus) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(window);
                    _data.writeStrongBinder(inputToken);
                    _data.writeBoolean(grantFocus);
                    boolean _status = this.mRemote.transact(40, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void generateDisplayHash(IWindow window, Rect boundsInWindow, String hashAlgorithm, RemoteCallback callback2) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(window);
                    _data.writeTypedObject(boundsInWindow, 0);
                    _data.writeString(hashAlgorithm);
                    _data.writeTypedObject(callback2, 0);
                    boolean bl = this.mRemote.transact(41, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setOnBackInvokedCallbackInfo(IWindow window, OnBackInvokedCallbackInfo callbackInfo) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(window);
                    _data.writeTypedObject(callbackInfo, 0);
                    boolean bl = this.mRemote.transact(42, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void clearTouchableRegion(IWindow window) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(window);
                    boolean _status = this.mRemote.transact(43, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IWindowSession {
        @Override
        public int addToDisplay(IWindow window, WindowManager.LayoutParams attrs, int viewVisibility, int layerStackId, InsetsVisibilities requestedVisibilities, InputChannel outInputChannel, InsetsState insetsState, InsetsSourceControl[] activeControls) throws RemoteException {
            return 0;
        }

        @Override
        public int addToDisplayAsUser(IWindow window, WindowManager.LayoutParams attrs, int viewVisibility, int layerStackId, int userId, InsetsVisibilities requestedVisibilities, InputChannel outInputChannel, InsetsState insetsState, InsetsSourceControl[] activeControls) throws RemoteException {
            return 0;
        }

        @Override
        public int addToDisplayWithoutInputChannel(IWindow window, WindowManager.LayoutParams attrs, int viewVisibility, int layerStackId, InsetsState insetsState) throws RemoteException {
            return 0;
        }

        @Override
        public void remove(IWindow window) throws RemoteException {
        }

        @Override
        public int relayout(IWindow window, WindowManager.LayoutParams attrs, int requestedWidth, int requestedHeight, int viewVisibility, int flags, ClientWindowFrames outFrames, MergedConfiguration outMergedConfiguration, SurfaceControl outSurfaceControl, InsetsState insetsState, InsetsSourceControl[] activeControls, Bundle bundle) throws RemoteException {
            return 0;
        }

        @Override
        public int updateVisibility(IWindow window, WindowManager.LayoutParams attrs, int viewVisibility, MergedConfiguration outMergedConfiguration, SurfaceControl outSurfaceControl, InsetsState outInsetsState, InsetsSourceControl[] outActiveControls) throws RemoteException {
            return 0;
        }

        @Override
        public void updateLayout(IWindow window, WindowManager.LayoutParams attrs, int flags, ClientWindowFrames clientFrames, int requestedWidth, int requestedHeight) throws RemoteException {
        }

        @Override
        public void prepareToReplaceWindows(IBinder appToken, boolean childrenOnly) throws RemoteException {
        }

        @Override
        public boolean outOfMemory(IWindow window) throws RemoteException {
            return false;
        }

        @Override
        public void setInsets(IWindow window, int touchableInsets, Rect contentInsets, Rect visibleInsets, Region touchableRegion) throws RemoteException {
        }

        @Override
        public void finishDrawing(IWindow window, SurfaceControl.Transaction postDrawTransaction, int seqId) throws RemoteException {
        }

        @Override
        public void setInTouchMode(boolean showFocus) throws RemoteException {
        }

        @Override
        public boolean getInTouchMode() throws RemoteException {
            return false;
        }

        @Override
        public boolean performHapticFeedback(int effectId, boolean always) throws RemoteException {
            return false;
        }

        @Override
        public IBinder performDrag(IWindow window, int flags, SurfaceControl surface2, int touchSource, float touchX, float touchY, float thumbCenterX, float thumbCenterY, ClipData data) throws RemoteException {
            return null;
        }

        @Override
        public boolean dropForAccessibility(IWindow window, int x, int y) throws RemoteException {
            return false;
        }

        @Override
        public void reportDropResult(IWindow window, boolean consumed) throws RemoteException {
        }

        @Override
        public void cancelDragAndDrop(IBinder dragToken, boolean skipAnimation) throws RemoteException {
        }

        @Override
        public void dragRecipientEntered(IWindow window) throws RemoteException {
        }

        @Override
        public void dragRecipientExited(IWindow window) throws RemoteException {
        }

        @Override
        public void setWallpaperPosition(IBinder windowToken, float x, float y, float xstep, float ystep) throws RemoteException {
        }

        @Override
        public void setWallpaperZoomOut(IBinder windowToken, float scale) throws RemoteException {
        }

        @Override
        public void setShouldZoomOutWallpaper(IBinder windowToken, boolean shouldZoom) throws RemoteException {
        }

        @Override
        public void wallpaperOffsetsComplete(IBinder window) throws RemoteException {
        }

        @Override
        public void setWallpaperDisplayOffset(IBinder windowToken, int x, int y) throws RemoteException {
        }

        @Override
        public Bundle sendWallpaperCommand(IBinder window, String action2, int x, int y, int z, Bundle extras, boolean sync) throws RemoteException {
            return null;
        }

        @Override
        public void wallpaperCommandComplete(IBinder window, Bundle result) throws RemoteException {
        }

        @Override
        public void onRectangleOnScreenRequested(IBinder token, Rect rectangle) throws RemoteException {
        }

        @Override
        public IWindowId getWindowId(IBinder window) throws RemoteException {
            return null;
        }

        @Override
        public void pokeDrawLock(IBinder window) throws RemoteException {
        }

        @Override
        public boolean startMovingTask(IWindow window, float startX, float startY) throws RemoteException {
            return false;
        }

        @Override
        public void finishMovingTask(IWindow window) throws RemoteException {
        }

        @Override
        public void updatePointerIcon(IWindow window) throws RemoteException {
        }

        @Override
        public void updateTapExcludeRegion(IWindow window, Region region) throws RemoteException {
        }

        @Override
        public void updateRequestedVisibilities(IWindow window, InsetsVisibilities visibilities) throws RemoteException {
        }

        @Override
        public void reportSystemGestureExclusionChanged(IWindow window, List<Rect> exclusionRects) throws RemoteException {
        }

        @Override
        public void reportKeepClearAreasChanged(IWindow window, List<Rect> restricted, List<Rect> unrestricted) throws RemoteException {
        }

        @Override
        public void grantInputChannel(int displayId, SurfaceControl surface2, IWindow window, IBinder hostInputToken, int flags, int privateFlags, int type, IBinder focusGrantToken, String inputHandleName, InputChannel outInputChannel) throws RemoteException {
        }

        @Override
        public void updateInputChannel(IBinder channelToken, int displayId, SurfaceControl surface2, int flags, int privateFlags, Region region) throws RemoteException {
        }

        @Override
        public void grantEmbeddedWindowFocus(IWindow window, IBinder inputToken, boolean grantFocus) throws RemoteException {
        }

        @Override
        public void generateDisplayHash(IWindow window, Rect boundsInWindow, String hashAlgorithm, RemoteCallback callback2) throws RemoteException {
        }

        @Override
        public void setOnBackInvokedCallbackInfo(IWindow window, OnBackInvokedCallbackInfo callbackInfo) throws RemoteException {
        }

        @Override
        public void clearTouchableRegion(IWindow window) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

