/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.content.Context;
import android.view.InputEvent;
import android.view.MotionEvent;
import java.util.ArrayList;
import java.util.List;

public class InputEventCompatProcessor {
    protected Context mContext;
    protected int mTargetSdkVersion;
    private List<InputEvent> mProcessedEvents;

    public InputEventCompatProcessor(Context context) {
        this.mContext = context;
        this.mTargetSdkVersion = context.getApplicationInfo().targetSdkVersion;
        this.mProcessedEvents = new ArrayList<InputEvent>();
    }

    public List<InputEvent> processInputEventForCompatibility(InputEvent e) {
        if (this.mTargetSdkVersion < 23 && e instanceof MotionEvent) {
            this.mProcessedEvents.clear();
            MotionEvent motion = (MotionEvent)e;
            int mask = 96;
            int buttonState = motion.getButtonState();
            int compatButtonState = (buttonState & 0x60) >> 4;
            if (compatButtonState != 0) {
                motion.setButtonState(buttonState | compatButtonState);
            }
            this.mProcessedEvents.add(motion);
            return this.mProcessedEvents;
        }
        return null;
    }

    public InputEvent processInputEventBeforeFinish(InputEvent e) {
        return e;
    }
}

