/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.graphics.Insets;
import android.graphics.Rect;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.proto.ProtoOutputStream;
import android.view.InsetsState;
import java.io.PrintWriter;
import java.util.Objects;

public class InsetsSource
implements Parcelable {
    private final int mType;
    private final Rect mFrame;
    private Rect mVisibleFrame;
    private boolean mVisible;
    private boolean mInsetsRoundedCornerFrame;
    private final Rect mTmpFrame = new Rect();
    public static final Parcelable.Creator<InsetsSource> CREATOR = new Parcelable.Creator<InsetsSource>(){

        @Override
        public InsetsSource createFromParcel(Parcel in) {
            return new InsetsSource(in);
        }

        public InsetsSource[] newArray(int size) {
            return new InsetsSource[size];
        }
    };

    public InsetsSource(int type) {
        this.mType = type;
        this.mFrame = new Rect();
        this.mVisible = InsetsState.getDefaultVisibility(type);
    }

    public InsetsSource(InsetsSource other) {
        this.mType = other.mType;
        this.mFrame = new Rect(other.mFrame);
        this.mVisible = other.mVisible;
        this.mVisibleFrame = other.mVisibleFrame != null ? new Rect(other.mVisibleFrame) : null;
        this.mInsetsRoundedCornerFrame = other.mInsetsRoundedCornerFrame;
    }

    public void set(InsetsSource other) {
        this.mFrame.set(other.mFrame);
        this.mVisible = other.mVisible;
        this.mVisibleFrame = other.mVisibleFrame != null ? new Rect(other.mVisibleFrame) : null;
        this.mInsetsRoundedCornerFrame = other.mInsetsRoundedCornerFrame;
    }

    public void setFrame(int left, int top, int right2, int bottom2) {
        this.mFrame.set(left, top, right2, bottom2);
    }

    public void setFrame(Rect frame) {
        this.mFrame.set(frame);
    }

    public void setVisibleFrame(Rect visibleFrame) {
        this.mVisibleFrame = visibleFrame != null ? new Rect(visibleFrame) : visibleFrame;
    }

    public void setVisible(boolean visible) {
        this.mVisible = visible;
    }

    public int getType() {
        return this.mType;
    }

    public Rect getFrame() {
        return this.mFrame;
    }

    public Rect getVisibleFrame() {
        return this.mVisibleFrame;
    }

    public boolean isVisible() {
        return this.mVisible;
    }

    boolean isUserControllable() {
        return this.mVisibleFrame == null || !this.mVisibleFrame.isEmpty();
    }

    public boolean getInsetsRoundedCornerFrame() {
        return this.mInsetsRoundedCornerFrame;
    }

    public void setInsetsRoundedCornerFrame(boolean insetsRoundedCornerFrame) {
        this.mInsetsRoundedCornerFrame = insetsRoundedCornerFrame;
    }

    public Insets calculateInsets(Rect relativeFrame, boolean ignoreVisibility) {
        return this.calculateInsets(relativeFrame, this.mFrame, ignoreVisibility);
    }

    public Insets calculateVisibleInsets(Rect relativeFrame) {
        return this.calculateInsets(relativeFrame, this.mVisibleFrame != null ? this.mVisibleFrame : this.mFrame, false);
    }

    private Insets calculateInsets(Rect relativeFrame, Rect frame, boolean ignoreVisibility) {
        boolean hasIntersection;
        if (!ignoreVisibility && !this.mVisible) {
            return Insets.NONE;
        }
        if (this.getType() == 2) {
            return Insets.of(0, frame.height(), 0, 0);
        }
        boolean bl = hasIntersection = relativeFrame.isEmpty() ? InsetsSource.getIntersection(frame, relativeFrame, this.mTmpFrame) : this.mTmpFrame.setIntersect(frame, relativeFrame);
        if (!hasIntersection) {
            return Insets.NONE;
        }
        if (this.getType() == 19) {
            return Insets.of(0, 0, 0, this.mTmpFrame.height());
        }
        if (this.mTmpFrame.width() == relativeFrame.width()) {
            if (this.mTmpFrame.top == relativeFrame.top) {
                return Insets.of(0, this.mTmpFrame.height(), 0, 0);
            }
            if (this.mTmpFrame.bottom == relativeFrame.bottom) {
                return Insets.of(0, 0, 0, this.mTmpFrame.height());
            }
            if (this.mTmpFrame.top == 0) {
                return Insets.of(0, this.mTmpFrame.height(), 0, 0);
            }
        } else if (this.mTmpFrame.height() == relativeFrame.height()) {
            if (this.mTmpFrame.left == relativeFrame.left) {
                return Insets.of(this.mTmpFrame.width(), 0, 0, 0);
            }
            if (this.mTmpFrame.right == relativeFrame.right) {
                return Insets.of(0, 0, this.mTmpFrame.width(), 0);
            }
        }
        return Insets.NONE;
    }

    private static boolean getIntersection(Rect a, Rect b, Rect out) {
        if (a.left <= b.right && b.left <= a.right && a.top <= b.bottom && b.top <= a.bottom) {
            out.left = Math.max(a.left, b.left);
            out.top = Math.max(a.top, b.top);
            out.right = Math.min(a.right, b.right);
            out.bottom = Math.min(a.bottom, b.bottom);
            return true;
        }
        out.setEmpty();
        return false;
    }

    public void dumpDebug(ProtoOutputStream proto, long fieldId) {
        long token = proto.start(fieldId);
        proto.write(0x10900000001L, InsetsState.typeToString(this.mType));
        this.mFrame.dumpDebug(proto, 1146756268034L);
        if (this.mVisibleFrame != null) {
            this.mVisibleFrame.dumpDebug(proto, 1146756268035L);
        }
        proto.write(1133871366148L, this.mVisible);
        proto.end(token);
    }

    public void dump(String prefix, PrintWriter pw) {
        pw.print(prefix);
        pw.print("InsetsSource type=");
        pw.print(InsetsState.typeToString(this.mType));
        pw.print(" frame=");
        pw.print(this.mFrame.toShortString());
        if (this.mVisibleFrame != null) {
            pw.print(" visibleFrame=");
            pw.print(this.mVisibleFrame.toShortString());
        }
        pw.print(" visible=");
        pw.print(this.mVisible);
        pw.print(" insetsRoundedCornerFrame=");
        pw.print(this.mInsetsRoundedCornerFrame);
        pw.println();
    }

    public boolean equals(Object o) {
        return this.equals(o, false);
    }

    public boolean equals(Object o, boolean excludeInvisibleImeFrames) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InsetsSource that = (InsetsSource)o;
        if (this.mType != that.mType) {
            return false;
        }
        if (this.mVisible != that.mVisible) {
            return false;
        }
        if (excludeInvisibleImeFrames && !this.mVisible && this.mType == 19) {
            return true;
        }
        if (!Objects.equals(this.mVisibleFrame, that.mVisibleFrame)) {
            return false;
        }
        if (this.mInsetsRoundedCornerFrame != that.mInsetsRoundedCornerFrame) {
            return false;
        }
        return this.mFrame.equals(that.mFrame);
    }

    public int hashCode() {
        int result = this.mType;
        result = 31 * result + this.mFrame.hashCode();
        result = 31 * result + (this.mVisibleFrame != null ? this.mVisibleFrame.hashCode() : 0);
        result = 31 * result + (this.mVisible ? 1 : 0);
        result = 31 * result + (this.mInsetsRoundedCornerFrame ? 1 : 0);
        return result;
    }

    public InsetsSource(Parcel in) {
        this.mType = in.readInt();
        this.mFrame = Rect.CREATOR.createFromParcel(in);
        this.mVisibleFrame = in.readInt() != 0 ? Rect.CREATOR.createFromParcel(in) : null;
        this.mVisible = in.readBoolean();
        this.mInsetsRoundedCornerFrame = in.readBoolean();
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.mType);
        this.mFrame.writeToParcel(dest, 0);
        if (this.mVisibleFrame != null) {
            dest.writeInt(1);
            this.mVisibleFrame.writeToParcel(dest, 0);
        } else {
            dest.writeInt(0);
        }
        dest.writeBoolean(this.mVisible);
        dest.writeBoolean(this.mInsetsRoundedCornerFrame);
    }

    public String toString() {
        return "InsetsSource: {mType=" + InsetsState.typeToString(this.mType) + ", mFrame=" + this.mFrame.toShortString() + ", mVisible=" + this.mVisible + ", mInsetsRoundedCornerFrame=" + this.mInsetsRoundedCornerFrame + "}";
    }
}

