/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.graphics.Insets;
import android.graphics.Rect;
import android.util.ArraySet;
import android.util.proto.ProtoOutputStream;
import android.view.InsetsController;
import android.view.InsetsSource;
import android.view.InsetsSourceControl;
import android.view.InsetsState;
import android.view.SurfaceControl;
import android.view.WindowInsets;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.inputmethod.ImeTracing;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Objects;
import java.util.function.Supplier;

public class InsetsSourceConsumer {
    protected final InsetsController mController;
    protected boolean mRequestedVisible;
    protected final InsetsState mState;
    protected final int mType;
    private static final String TAG = "InsetsSourceConsumer";
    private final Supplier<SurfaceControl.Transaction> mTransactionSupplier;
    private InsetsSourceControl mSourceControl;
    private boolean mHasWindowFocus;
    private boolean mHasViewFocusWhenWindowFocusGain;
    private Rect mPendingFrame;
    private Rect mPendingVisibleFrame;
    private boolean mIsAnimationPending;

    public InsetsSourceConsumer(int type, InsetsState state, Supplier<SurfaceControl.Transaction> transactionSupplier, InsetsController controller) {
        this.mType = type;
        this.mState = state;
        this.mTransactionSupplier = transactionSupplier;
        this.mController = controller;
        this.mRequestedVisible = InsetsState.getDefaultVisibility(type);
    }

    public boolean setControl(InsetsSourceControl control, int[] showTypes, int[] hideTypes) {
        if (this.mType == 19) {
            ImeTracing.getInstance().triggerClientDump("InsetsSourceConsumer#setControl", this.mController.getHost().getInputMethodManager(), null);
        }
        if (Objects.equals(this.mSourceControl, control)) {
            if (this.mSourceControl != null && this.mSourceControl != control) {
                this.mSourceControl.release(SurfaceControl::release);
                this.mSourceControl = control;
            }
            return false;
        }
        SurfaceControl oldLeash = this.mSourceControl != null ? this.mSourceControl.getLeash() : null;
        InsetsSourceControl lastControl = this.mSourceControl;
        this.mSourceControl = control;
        if (control != null) {
            // empty if block
        }
        if (this.mSourceControl == null) {
            this.mController.notifyControlRevoked(this);
            InsetsSource source = this.mState.getSource(this.mType);
            boolean serverVisibility = this.mController.getLastDispatchedState().getSourceOrDefaultVisibility(this.mType);
            if (source.isVisible() != serverVisibility) {
                source.setVisible(serverVisibility);
                this.mController.notifyVisibilityChanged();
            }
            this.applyLocalVisibilityOverride();
        } else {
            boolean needsAnimation;
            boolean requestedVisible = this.isRequestedVisibleAwaitingControl();
            boolean fakeControl = InsetsSourceControl.INVALID_HINTS.equals(control.getInsetsHint());
            boolean bl = needsAnimation = requestedVisible != this.mState.getSource(this.mType).isVisible() && !fakeControl;
            if (control.getLeash() != null && (needsAnimation || this.mIsAnimationPending)) {
                if (requestedVisible) {
                    showTypes[0] = showTypes[0] | InsetsState.toPublicType(this.getType());
                } else {
                    hideTypes[0] = hideTypes[0] | InsetsState.toPublicType(this.getType());
                }
                this.mIsAnimationPending = false;
            } else {
                if (needsAnimation) {
                    this.mIsAnimationPending = true;
                }
                if (this.applyLocalVisibilityOverride()) {
                    this.mController.notifyVisibilityChanged();
                }
                this.applyRequestedVisibilityToControl();
                if (!requestedVisible && !this.mIsAnimationPending && lastControl == null) {
                    this.removeSurface();
                }
            }
        }
        if (lastControl != null) {
            lastControl.release(SurfaceControl::release);
        }
        return true;
    }

    @VisibleForTesting
    public InsetsSourceControl getControl() {
        return this.mSourceControl;
    }

    protected boolean isRequestedVisibleAwaitingControl() {
        return this.isRequestedVisible();
    }

    int getType() {
        return this.mType;
    }

    @VisibleForTesting
    public void show(boolean fromIme) {
        this.setRequestedVisible(true);
    }

    @VisibleForTesting
    public void hide() {
        this.setRequestedVisible(false);
    }

    void hide(boolean animationFinished, int animationType) {
        this.hide();
    }

    public void onWindowFocusGained(boolean hasViewFocus) {
        this.mHasWindowFocus = true;
        this.mHasViewFocusWhenWindowFocusGain = hasViewFocus;
    }

    public void onWindowFocusLost() {
        this.mHasWindowFocus = false;
    }

    boolean hasViewFocusWhenWindowFocusGain() {
        return this.mHasViewFocusWhenWindowFocusGain;
    }

    boolean applyLocalVisibilityOverride() {
        boolean hasControl;
        InsetsSource source = this.mState.peekSource(this.mType);
        boolean isVisible = source != null ? source.isVisible() : InsetsState.getDefaultVisibility(this.mType);
        boolean bl = hasControl = this.mSourceControl != null;
        if (this.mType == 19) {
            ImeTracing.getInstance().triggerClientDump("InsetsSourceConsumer#applyLocalVisibilityOverride", this.mController.getHost().getInputMethodManager(), null);
        }
        this.updateCompatSysUiVisibility(hasControl, source, isVisible);
        if (!hasControl) {
            return false;
        }
        if (isVisible == this.mRequestedVisible) {
            return false;
        }
        this.mState.getSource(this.mType).setVisible(this.mRequestedVisible);
        return true;
    }

    private void updateCompatSysUiVisibility(boolean hasControl, InsetsSource source, boolean visible) {
        boolean compatVisible;
        int publicType = InsetsState.toPublicType(this.mType);
        if (publicType != WindowInsets.Type.statusBars() && publicType != WindowInsets.Type.navigationBars()) {
            return;
        }
        if (hasControl) {
            compatVisible = this.mRequestedVisible;
        } else if (source != null && !source.getFrame().isEmpty()) {
            compatVisible = visible;
        } else {
            ArraySet<Integer> types = InsetsState.toInternalType(publicType);
            for (int i = types.size() - 1; i >= 0; --i) {
                InsetsSource s = this.mState.peekSource(types.valueAt(i));
                if (s == null || s.getFrame().isEmpty()) continue;
                return;
            }
            compatVisible = this.mRequestedVisible;
        }
        this.mController.updateCompatSysUiVisibility(this.mType, compatVisible, hasControl);
    }

    @VisibleForTesting
    public boolean isRequestedVisible() {
        return this.mRequestedVisible;
    }

    @VisibleForTesting
    public int requestShow(boolean fromController) {
        return 0;
    }

    public void onPerceptible(boolean perceptible) {
    }

    void notifyHidden() {
    }

    public void removeSurface() {
    }

    @VisibleForTesting(visibility=VisibleForTesting.Visibility.PACKAGE)
    public void updateSource(InsetsSource newSource, int animationType) {
        InsetsSource source = this.mState.peekSource(this.mType);
        if (source == null || animationType == -1 || source.getFrame().equals(newSource.getFrame())) {
            this.mPendingFrame = null;
            this.mPendingVisibleFrame = null;
            this.mState.addSource(newSource);
            return;
        }
        newSource = new InsetsSource(newSource);
        this.mPendingFrame = new Rect(newSource.getFrame());
        this.mPendingVisibleFrame = newSource.getVisibleFrame() != null ? new Rect(newSource.getVisibleFrame()) : null;
        newSource.setFrame(source.getFrame());
        newSource.setVisibleFrame(source.getVisibleFrame());
        this.mState.addSource(newSource);
    }

    @VisibleForTesting(visibility=VisibleForTesting.Visibility.PACKAGE)
    public boolean notifyAnimationFinished() {
        if (this.mPendingFrame != null) {
            InsetsSource source = this.mState.getSource(this.mType);
            source.setFrame(this.mPendingFrame);
            source.setVisibleFrame(this.mPendingVisibleFrame);
            this.mPendingFrame = null;
            this.mPendingVisibleFrame = null;
            return true;
        }
        return false;
    }

    protected void setRequestedVisible(boolean requestedVisible) {
        if (this.mRequestedVisible != requestedVisible) {
            this.mRequestedVisible = requestedVisible;
            this.mIsAnimationPending = !this.mIsAnimationPending && this.mSourceControl != null && this.mSourceControl.getLeash() == null && !Insets.NONE.equals(this.mSourceControl.getInsetsHint());
            this.mController.onRequestedVisibilityChanged(this);
        }
        if (this.applyLocalVisibilityOverride()) {
            this.mController.notifyVisibilityChanged();
        }
    }

    private void applyRequestedVisibilityToControl() {
        if (this.mSourceControl == null || this.mSourceControl.getLeash() == null) {
            return;
        }
        try (SurfaceControl.Transaction t = this.mTransactionSupplier.get();){
            if (this.mRequestedVisible) {
                t.show(this.mSourceControl.getLeash());
            } else {
                t.hide(this.mSourceControl.getLeash());
            }
            t.setAlpha(this.mSourceControl.getLeash(), this.mRequestedVisible ? 1.0f : 0.0f);
            t.apply();
        }
        this.onPerceptible(this.mRequestedVisible);
    }

    void dumpDebug(ProtoOutputStream proto, long fieldId) {
        long token = proto.start(fieldId);
        proto.write(0x10900000001L, InsetsState.typeToString(this.mType));
        proto.write(1133871366146L, this.mHasWindowFocus);
        proto.write(1133871366147L, this.mRequestedVisible);
        if (this.mSourceControl != null) {
            this.mSourceControl.dumpDebug(proto, 1146756268036L);
        }
        if (this.mPendingFrame != null) {
            this.mPendingFrame.dumpDebug(proto, 1146756268037L);
        }
        if (this.mPendingVisibleFrame != null) {
            this.mPendingVisibleFrame.dumpDebug(proto, 1146756268038L);
        }
        proto.end(token);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    static @interface ShowResult {
        public static final int SHOW_IMMEDIATELY = 0;
        public static final int IME_SHOW_DELAYED = 1;
        public static final int IME_SHOW_FAILED = 2;
    }
}

