/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.os.Parcel;
import android.os.Parcelable;
import android.view.InsetsState;
import java.util.Arrays;
import java.util.StringJoiner;

public class InsetsVisibilities
implements Parcelable {
    private static final int UNSPECIFIED = 0;
    private static final int VISIBLE = 1;
    private static final int INVISIBLE = -1;
    private final int[] mVisibilities = new int[24];
    public static final Parcelable.Creator<InsetsVisibilities> CREATOR = new Parcelable.Creator<InsetsVisibilities>(){

        @Override
        public InsetsVisibilities createFromParcel(Parcel in) {
            return new InsetsVisibilities(in);
        }

        public InsetsVisibilities[] newArray(int size) {
            return new InsetsVisibilities[size];
        }
    };

    public InsetsVisibilities() {
    }

    public InsetsVisibilities(InsetsVisibilities other) {
        this.set(other);
    }

    public InsetsVisibilities(Parcel in) {
        in.readIntArray(this.mVisibilities);
    }

    public void set(InsetsVisibilities other) {
        System.arraycopy(other.mVisibilities, 0, this.mVisibilities, 0, 24);
    }

    public void setVisibility(int type, boolean visible) {
        this.mVisibilities[type] = visible ? 1 : -1;
    }

    public boolean getVisibility(int type) {
        int visibility = this.mVisibilities[type];
        return visibility == 0 ? InsetsState.getDefaultVisibility(type) : visibility == 1;
    }

    public String toString() {
        StringJoiner joiner = new StringJoiner(", ");
        for (int type = 0; type <= 23; ++type) {
            int visibility = this.mVisibilities[type];
            if (visibility == 0) continue;
            joiner.add(InsetsState.typeToString(type) + ": " + (visibility == 1 ? "visible" : "invisible"));
        }
        return joiner.toString();
    }

    public int hashCode() {
        return Arrays.hashCode(this.mVisibilities);
    }

    public boolean equals(Object other) {
        if (!(other instanceof InsetsVisibilities)) {
            return false;
        }
        return Arrays.equals(this.mVisibilities, ((InsetsVisibilities)other).mVisibilities);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeIntArray(this.mVisibilities);
    }

    public void readFromParcel(Parcel in) {
        in.readIntArray(this.mVisibilities);
    }
}

