/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.compat.annotation.UnsupportedAppUsage;
import android.graphics.Matrix;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import android.util.SparseArray;
import android.view.InputEvent;
import android.view.KeyEvent;
import dalvik.annotation.optimization.CriticalNative;
import dalvik.annotation.optimization.FastNative;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public final class MotionEvent
extends InputEvent
implements Parcelable {
    private static final String TAG = "MotionEvent";
    private static final long NS_PER_MS = 1000000L;
    private static final String LABEL_PREFIX = "AXIS_";
    private static final boolean DEBUG_CONCISE_TOSTRING = false;
    public static final int INVALID_POINTER_ID = -1;
    public static final int ACTION_MASK = 255;
    public static final int ACTION_DOWN = 0;
    public static final int ACTION_UP = 1;
    public static final int ACTION_MOVE = 2;
    public static final int ACTION_CANCEL = 3;
    public static final int ACTION_OUTSIDE = 4;
    public static final int ACTION_POINTER_DOWN = 5;
    public static final int ACTION_POINTER_UP = 6;
    public static final int ACTION_HOVER_MOVE = 7;
    public static final int ACTION_SCROLL = 8;
    public static final int ACTION_HOVER_ENTER = 9;
    public static final int ACTION_HOVER_EXIT = 10;
    public static final int ACTION_BUTTON_PRESS = 11;
    public static final int ACTION_BUTTON_RELEASE = 12;
    public static final int ACTION_POINTER_INDEX_MASK = 65280;
    public static final int ACTION_POINTER_INDEX_SHIFT = 8;
    @Deprecated
    public static final int ACTION_POINTER_1_DOWN = 5;
    @Deprecated
    public static final int ACTION_POINTER_2_DOWN = 261;
    @Deprecated
    public static final int ACTION_POINTER_3_DOWN = 517;
    @Deprecated
    public static final int ACTION_POINTER_1_UP = 6;
    @Deprecated
    public static final int ACTION_POINTER_2_UP = 262;
    @Deprecated
    public static final int ACTION_POINTER_3_UP = 518;
    @Deprecated
    public static final int ACTION_POINTER_ID_MASK = 65280;
    @Deprecated
    public static final int ACTION_POINTER_ID_SHIFT = 8;
    public static final int FLAG_WINDOW_IS_OBSCURED = 1;
    public static final int FLAG_WINDOW_IS_PARTIALLY_OBSCURED = 2;
    public static final int FLAG_HOVER_EXIT_PENDING = 4;
    public static final int FLAG_IS_GENERATED_GESTURE = 8;
    public static final int FLAG_CANCELED = 32;
    public static final int FLAG_NO_FOCUS_CHANGE = 64;
    public static final int FLAG_IS_ACCESSIBILITY_EVENT = 2048;
    public static final int FLAG_TAINTED = Integer.MIN_VALUE;
    public static final int FLAG_TARGET_ACCESSIBILITY_FOCUS = 0x40000000;
    public static final int EDGE_TOP = 1;
    public static final int EDGE_BOTTOM = 2;
    public static final int EDGE_LEFT = 4;
    public static final int EDGE_RIGHT = 8;
    public static final int AXIS_X = 0;
    public static final int AXIS_Y = 1;
    public static final int AXIS_PRESSURE = 2;
    public static final int AXIS_SIZE = 3;
    public static final int AXIS_TOUCH_MAJOR = 4;
    public static final int AXIS_TOUCH_MINOR = 5;
    public static final int AXIS_TOOL_MAJOR = 6;
    public static final int AXIS_TOOL_MINOR = 7;
    public static final int AXIS_ORIENTATION = 8;
    public static final int AXIS_VSCROLL = 9;
    public static final int AXIS_HSCROLL = 10;
    public static final int AXIS_Z = 11;
    public static final int AXIS_RX = 12;
    public static final int AXIS_RY = 13;
    public static final int AXIS_RZ = 14;
    public static final int AXIS_HAT_X = 15;
    public static final int AXIS_HAT_Y = 16;
    public static final int AXIS_LTRIGGER = 17;
    public static final int AXIS_RTRIGGER = 18;
    public static final int AXIS_THROTTLE = 19;
    public static final int AXIS_RUDDER = 20;
    public static final int AXIS_WHEEL = 21;
    public static final int AXIS_GAS = 22;
    public static final int AXIS_BRAKE = 23;
    public static final int AXIS_DISTANCE = 24;
    public static final int AXIS_TILT = 25;
    public static final int AXIS_SCROLL = 26;
    public static final int AXIS_RELATIVE_X = 27;
    public static final int AXIS_RELATIVE_Y = 28;
    public static final int AXIS_GENERIC_1 = 32;
    public static final int AXIS_GENERIC_2 = 33;
    public static final int AXIS_GENERIC_3 = 34;
    public static final int AXIS_GENERIC_4 = 35;
    public static final int AXIS_GENERIC_5 = 36;
    public static final int AXIS_GENERIC_6 = 37;
    public static final int AXIS_GENERIC_7 = 38;
    public static final int AXIS_GENERIC_8 = 39;
    public static final int AXIS_GENERIC_9 = 40;
    public static final int AXIS_GENERIC_10 = 41;
    public static final int AXIS_GENERIC_11 = 42;
    public static final int AXIS_GENERIC_12 = 43;
    public static final int AXIS_GENERIC_13 = 44;
    public static final int AXIS_GENERIC_14 = 45;
    public static final int AXIS_GENERIC_15 = 46;
    public static final int AXIS_GENERIC_16 = 47;
    private static final SparseArray<String> AXIS_SYMBOLIC_NAMES;
    public static final int BUTTON_PRIMARY = 1;
    public static final int BUTTON_SECONDARY = 2;
    public static final int BUTTON_TERTIARY = 4;
    public static final int BUTTON_BACK = 8;
    public static final int BUTTON_FORWARD = 16;
    public static final int BUTTON_STYLUS_PRIMARY = 32;
    public static final int BUTTON_STYLUS_SECONDARY = 64;
    private static final String[] BUTTON_SYMBOLIC_NAMES;
    public static final int CLASSIFICATION_NONE = 0;
    public static final int CLASSIFICATION_AMBIGUOUS_GESTURE = 1;
    public static final int CLASSIFICATION_DEEP_PRESS = 2;
    public static final int TOOL_TYPE_UNKNOWN = 0;
    public static final int TOOL_TYPE_FINGER = 1;
    public static final int TOOL_TYPE_STYLUS = 2;
    public static final int TOOL_TYPE_MOUSE = 3;
    public static final int TOOL_TYPE_ERASER = 4;
    public static final int TOOL_TYPE_PALM = 5;
    private static final SparseArray<String> TOOL_TYPE_SYMBOLIC_NAMES;
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    private static final int HISTORY_CURRENT = Integer.MIN_VALUE;
    private static final float INVALID_CURSOR_POSITION = Float.NaN;
    private static final int MAX_RECYCLED = 10;
    private static final Object gRecyclerLock;
    private static int gRecyclerUsed;
    private static MotionEvent gRecyclerTop;
    private static final Object gSharedTempLock;
    private static PointerCoords[] gSharedTempPointerCoords;
    private static PointerProperties[] gSharedTempPointerProperties;
    private static int[] gSharedTempPointerIndexMap;
    @UnsupportedAppUsage(maxTargetSdk=28)
    private long mNativePtr;
    private MotionEvent mNext;
    public static final Parcelable.Creator<MotionEvent> CREATOR;

    private static final void ensureSharedTempPointerCapacity(int desiredCapacity) {
        if (gSharedTempPointerCoords == null || gSharedTempPointerCoords.length < desiredCapacity) {
            int capacity;
            int n = capacity = gSharedTempPointerCoords != null ? gSharedTempPointerCoords.length : 8;
            while (capacity < desiredCapacity) {
                capacity *= 2;
            }
            gSharedTempPointerCoords = PointerCoords.createArray(capacity);
            gSharedTempPointerProperties = PointerProperties.createArray(capacity);
            gSharedTempPointerIndexMap = new int[capacity];
        }
    }

    private static native long nativeInitialize(long var0, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9, int var10, float var11, float var12, float var13, float var14, long var15, long var17, int var19, PointerProperties[] var20, PointerCoords[] var21);

    private static native void nativeDispose(long var0);

    private static native void nativeAddBatch(long var0, long var2, PointerCoords[] var4, int var5);

    private static native void nativeGetPointerCoords(long var0, int var2, int var3, PointerCoords var4);

    private static native void nativeGetPointerProperties(long var0, int var2, PointerProperties var3);

    private static native long nativeReadFromParcel(long var0, Parcel var2);

    private static native void nativeWriteToParcel(long var0, Parcel var2);

    private static native String nativeAxisToString(int var0);

    private static native int nativeAxisFromString(String var0);

    @FastNative
    private static native int nativeGetPointerId(long var0, int var2);

    @FastNative
    private static native int nativeGetToolType(long var0, int var2);

    @FastNative
    private static native long nativeGetEventTimeNanos(long var0, int var2);

    @FastNative
    @UnsupportedAppUsage
    private static native float nativeGetRawAxisValue(long var0, int var2, int var3, int var4);

    @FastNative
    private static native float nativeGetAxisValue(long var0, int var2, int var3, int var4);

    @FastNative
    private static native void nativeTransform(long var0, Matrix var2);

    @FastNative
    private static native void nativeApplyTransform(long var0, Matrix var2);

    @CriticalNative
    private static native long nativeCopy(long var0, long var2, boolean var4);

    @CriticalNative
    private static native int nativeGetId(long var0);

    @CriticalNative
    private static native int nativeGetDeviceId(long var0);

    @CriticalNative
    private static native int nativeGetSource(long var0);

    @CriticalNative
    private static native void nativeSetSource(long var0, int var2);

    @CriticalNative
    private static native int nativeGetDisplayId(long var0);

    @CriticalNative
    private static native void nativeSetDisplayId(long var0, int var2);

    @CriticalNative
    private static native int nativeGetAction(long var0);

    @CriticalNative
    private static native void nativeSetAction(long var0, int var2);

    @CriticalNative
    private static native boolean nativeIsTouchEvent(long var0);

    @CriticalNative
    private static native int nativeGetFlags(long var0);

    @CriticalNative
    private static native void nativeSetFlags(long var0, int var2);

    @CriticalNative
    private static native int nativeGetEdgeFlags(long var0);

    @CriticalNative
    private static native void nativeSetEdgeFlags(long var0, int var2);

    @CriticalNative
    private static native int nativeGetMetaState(long var0);

    @CriticalNative
    private static native int nativeGetButtonState(long var0);

    @CriticalNative
    private static native void nativeSetButtonState(long var0, int var2);

    @CriticalNative
    private static native int nativeGetClassification(long var0);

    @CriticalNative
    private static native int nativeGetActionButton(long var0);

    @CriticalNative
    private static native void nativeSetActionButton(long var0, int var2);

    @CriticalNative
    private static native void nativeOffsetLocation(long var0, float var2, float var3);

    @CriticalNative
    private static native float nativeGetXOffset(long var0);

    @CriticalNative
    private static native float nativeGetYOffset(long var0);

    @CriticalNative
    private static native float nativeGetXPrecision(long var0);

    @CriticalNative
    private static native float nativeGetYPrecision(long var0);

    @CriticalNative
    private static native float nativeGetXCursorPosition(long var0);

    @CriticalNative
    private static native float nativeGetYCursorPosition(long var0);

    @CriticalNative
    private static native void nativeSetCursorPosition(long var0, float var2, float var3);

    @CriticalNative
    private static native long nativeGetDownTimeNanos(long var0);

    @CriticalNative
    private static native void nativeSetDownTimeNanos(long var0, long var2);

    @CriticalNative
    private static native int nativeGetPointerCount(long var0);

    @CriticalNative
    private static native int nativeFindPointerIndex(long var0, int var2);

    @CriticalNative
    private static native int nativeGetHistorySize(long var0);

    @CriticalNative
    private static native void nativeScale(long var0, float var2);

    @CriticalNative
    private static native int nativeGetSurfaceRotation(long var0);

    private MotionEvent() {
    }

    protected void finalize() throws Throwable {
        try {
            if (this.mNativePtr != 0L) {
                MotionEvent.nativeDispose(this.mNativePtr);
                this.mNativePtr = 0L;
            }
        }
        finally {
            super.finalize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UnsupportedAppUsage
    private static MotionEvent obtain() {
        MotionEvent ev;
        Object object = gRecyclerLock;
        synchronized (object) {
            ev = gRecyclerTop;
            if (ev == null) {
                return new MotionEvent();
            }
            gRecyclerTop = ev.mNext;
            --gRecyclerUsed;
        }
        ev.mNext = null;
        ev.prepareForReuse();
        return ev;
    }

    public static MotionEvent obtain(long downTime, long eventTime, int action2, int pointerCount, PointerProperties[] pointerProperties, PointerCoords[] pointerCoords, int metaState, int buttonState, float xPrecision, float yPrecision, int deviceId, int edgeFlags, int source, int displayId, int flags) {
        MotionEvent ev = MotionEvent.obtain();
        boolean success = ev.initialize(deviceId, source, displayId, action2, flags, edgeFlags, metaState, buttonState, 0, 0.0f, 0.0f, xPrecision, yPrecision, downTime * 1000000L, eventTime * 1000000L, pointerCount, pointerProperties, pointerCoords);
        if (!success) {
            Log.e(TAG, "Could not initialize MotionEvent");
            ev.recycle();
            return null;
        }
        return ev;
    }

    public static MotionEvent obtain(long downTime, long eventTime, int action2, int pointerCount, PointerProperties[] pointerProperties, PointerCoords[] pointerCoords, int metaState, int buttonState, float xPrecision, float yPrecision, int deviceId, int edgeFlags, int source, int flags) {
        return MotionEvent.obtain(downTime, eventTime, action2, pointerCount, pointerProperties, pointerCoords, metaState, buttonState, xPrecision, yPrecision, deviceId, edgeFlags, source, 0, flags);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public static MotionEvent obtain(long downTime, long eventTime, int action2, int pointerCount, int[] pointerIds, PointerCoords[] pointerCoords, int metaState, float xPrecision, float yPrecision, int deviceId, int edgeFlags, int source, int flags) {
        Object object = gSharedTempLock;
        synchronized (object) {
            MotionEvent.ensureSharedTempPointerCapacity(pointerCount);
            PointerProperties[] pp = gSharedTempPointerProperties;
            for (int i = 0; i < pointerCount; ++i) {
                pp[i].clear();
                pp[i].id = pointerIds[i];
            }
            return MotionEvent.obtain(downTime, eventTime, action2, pointerCount, pp, pointerCoords, metaState, 0, xPrecision, yPrecision, deviceId, edgeFlags, source, flags);
        }
    }

    public static MotionEvent obtain(long downTime, long eventTime, int action2, float x, float y, float pressure, float size, int metaState, float xPrecision, float yPrecision, int deviceId, int edgeFlags) {
        return MotionEvent.obtain(downTime, eventTime, action2, x, y, pressure, size, metaState, xPrecision, yPrecision, deviceId, edgeFlags, 2, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MotionEvent obtain(long downTime, long eventTime, int action2, float x, float y, float pressure, float size, int metaState, float xPrecision, float yPrecision, int deviceId, int edgeFlags, int source, int displayId) {
        MotionEvent ev = MotionEvent.obtain();
        Object object = gSharedTempLock;
        synchronized (object) {
            MotionEvent.ensureSharedTempPointerCapacity(1);
            PointerProperties[] pp = gSharedTempPointerProperties;
            pp[0].clear();
            pp[0].id = 0;
            PointerCoords[] pc = gSharedTempPointerCoords;
            pc[0].clear();
            pc[0].x = x;
            pc[0].y = y;
            pc[0].pressure = pressure;
            pc[0].size = size;
            ev.initialize(deviceId, source, displayId, action2, 0, edgeFlags, metaState, 0, 0, 0.0f, 0.0f, xPrecision, yPrecision, downTime * 1000000L, eventTime * 1000000L, 1, pp, pc);
            return ev;
        }
    }

    @Deprecated
    public static MotionEvent obtain(long downTime, long eventTime, int action2, int pointerCount, float x, float y, float pressure, float size, int metaState, float xPrecision, float yPrecision, int deviceId, int edgeFlags) {
        return MotionEvent.obtain(downTime, eventTime, action2, x, y, pressure, size, metaState, xPrecision, yPrecision, deviceId, edgeFlags);
    }

    public static MotionEvent obtain(long downTime, long eventTime, int action2, float x, float y, int metaState) {
        return MotionEvent.obtain(downTime, eventTime, action2, x, y, 1.0f, 1.0f, metaState, 1.0f, 1.0f, 0, 0);
    }

    public static MotionEvent obtain(MotionEvent other) {
        if (other == null) {
            throw new IllegalArgumentException("other motion event must not be null");
        }
        MotionEvent ev = MotionEvent.obtain();
        ev.mNativePtr = MotionEvent.nativeCopy(ev.mNativePtr, other.mNativePtr, true);
        return ev;
    }

    public static MotionEvent obtainNoHistory(MotionEvent other) {
        if (other == null) {
            throw new IllegalArgumentException("other motion event must not be null");
        }
        MotionEvent ev = MotionEvent.obtain();
        ev.mNativePtr = MotionEvent.nativeCopy(ev.mNativePtr, other.mNativePtr, false);
        return ev;
    }

    private boolean initialize(int deviceId, int source, int displayId, int action2, int flags, int edgeFlags, int metaState, int buttonState, int classification, float xOffset, float yOffset, float xPrecision, float yPrecision, long downTimeNanos, long eventTimeNanos, int pointerCount, PointerProperties[] pointerIds, PointerCoords[] pointerCoords) {
        this.mNativePtr = MotionEvent.nativeInitialize(this.mNativePtr, deviceId, source, displayId, action2, flags, edgeFlags, metaState, buttonState, classification, xOffset, yOffset, xPrecision, yPrecision, downTimeNanos, eventTimeNanos, pointerCount, pointerIds, pointerCoords);
        if (this.mNativePtr == 0L) {
            return false;
        }
        this.updateCursorPosition();
        return true;
    }

    @Override
    @UnsupportedAppUsage
    public MotionEvent copy() {
        return MotionEvent.obtain(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void recycle() {
        super.recycle();
        Object object = gRecyclerLock;
        synchronized (object) {
            if (gRecyclerUsed < 10) {
                ++gRecyclerUsed;
                this.mNext = gRecyclerTop;
                gRecyclerTop = this;
            }
        }
    }

    @UnsupportedAppUsage
    public final void scale(float scale) {
        if (scale != 1.0f) {
            MotionEvent.nativeScale(this.mNativePtr, scale);
        }
    }

    @Override
    public int getId() {
        return MotionEvent.nativeGetId(this.mNativePtr);
    }

    @Override
    public final int getDeviceId() {
        return MotionEvent.nativeGetDeviceId(this.mNativePtr);
    }

    @Override
    public final int getSource() {
        return MotionEvent.nativeGetSource(this.mNativePtr);
    }

    @Override
    public final void setSource(int source) {
        if (source == this.getSource()) {
            return;
        }
        MotionEvent.nativeSetSource(this.mNativePtr, source);
        this.updateCursorPosition();
    }

    @Override
    public int getDisplayId() {
        return MotionEvent.nativeGetDisplayId(this.mNativePtr);
    }

    @Override
    public void setDisplayId(int displayId) {
        MotionEvent.nativeSetDisplayId(this.mNativePtr, displayId);
    }

    public final int getAction() {
        return MotionEvent.nativeGetAction(this.mNativePtr);
    }

    public final int getActionMasked() {
        return MotionEvent.nativeGetAction(this.mNativePtr) & 0xFF;
    }

    public final int getActionIndex() {
        return (MotionEvent.nativeGetAction(this.mNativePtr) & 0xFF00) >> 8;
    }

    public final boolean isTouchEvent() {
        return MotionEvent.nativeIsTouchEvent(this.mNativePtr);
    }

    public final int getFlags() {
        return MotionEvent.nativeGetFlags(this.mNativePtr);
    }

    @Override
    public final boolean isTainted() {
        int flags = this.getFlags();
        return (flags & Integer.MIN_VALUE) != 0;
    }

    @Override
    public final void setTainted(boolean tainted) {
        int flags = this.getFlags();
        MotionEvent.nativeSetFlags(this.mNativePtr, tainted ? flags | Integer.MIN_VALUE : flags & Integer.MAX_VALUE);
    }

    public boolean isTargetAccessibilityFocus() {
        int flags = this.getFlags();
        return (flags & 0x40000000) != 0;
    }

    public void setTargetAccessibilityFocus(boolean targetsFocus) {
        int flags = this.getFlags();
        MotionEvent.nativeSetFlags(this.mNativePtr, targetsFocus ? flags | 0x40000000 : flags & 0xBFFFFFFF);
    }

    public final boolean isHoverExitPending() {
        int flags = this.getFlags();
        return (flags & 4) != 0;
    }

    public void setHoverExitPending(boolean hoverExitPending) {
        int flags = this.getFlags();
        MotionEvent.nativeSetFlags(this.mNativePtr, hoverExitPending ? flags | 4 : flags & 0xFFFFFFFB);
    }

    public final long getDownTime() {
        return MotionEvent.nativeGetDownTimeNanos(this.mNativePtr) / 1000000L;
    }

    @UnsupportedAppUsage
    public final void setDownTime(long downTime) {
        MotionEvent.nativeSetDownTimeNanos(this.mNativePtr, downTime * 1000000L);
    }

    @Override
    public final long getEventTime() {
        return MotionEvent.nativeGetEventTimeNanos(this.mNativePtr, Integer.MIN_VALUE) / 1000000L;
    }

    @Override
    @UnsupportedAppUsage
    public final long getEventTimeNano() {
        return MotionEvent.nativeGetEventTimeNanos(this.mNativePtr, Integer.MIN_VALUE);
    }

    public final float getX() {
        return MotionEvent.nativeGetAxisValue(this.mNativePtr, 0, 0, Integer.MIN_VALUE);
    }

    public final float getY() {
        return MotionEvent.nativeGetAxisValue(this.mNativePtr, 1, 0, Integer.MIN_VALUE);
    }

    public final float getPressure() {
        return MotionEvent.nativeGetAxisValue(this.mNativePtr, 2, 0, Integer.MIN_VALUE);
    }

    public final float getSize() {
        return MotionEvent.nativeGetAxisValue(this.mNativePtr, 3, 0, Integer.MIN_VALUE);
    }

    public final float getTouchMajor() {
        return MotionEvent.nativeGetAxisValue(this.mNativePtr, 4, 0, Integer.MIN_VALUE);
    }

    public final float getTouchMinor() {
        return MotionEvent.nativeGetAxisValue(this.mNativePtr, 5, 0, Integer.MIN_VALUE);
    }

    public final float getToolMajor() {
        return MotionEvent.nativeGetAxisValue(this.mNativePtr, 6, 0, Integer.MIN_VALUE);
    }

    public final float getToolMinor() {
        return MotionEvent.nativeGetAxisValue(this.mNativePtr, 7, 0, Integer.MIN_VALUE);
    }

    public final float getOrientation() {
        return MotionEvent.nativeGetAxisValue(this.mNativePtr, 8, 0, Integer.MIN_VALUE);
    }

    public final float getAxisValue(int axis) {
        return MotionEvent.nativeGetAxisValue(this.mNativePtr, axis, 0, Integer.MIN_VALUE);
    }

    public final int getPointerCount() {
        return MotionEvent.nativeGetPointerCount(this.mNativePtr);
    }

    public final int getPointerId(int pointerIndex) {
        return MotionEvent.nativeGetPointerId(this.mNativePtr, pointerIndex);
    }

    public final int getToolType(int pointerIndex) {
        return MotionEvent.nativeGetToolType(this.mNativePtr, pointerIndex);
    }

    public final int findPointerIndex(int pointerId) {
        return MotionEvent.nativeFindPointerIndex(this.mNativePtr, pointerId);
    }

    public final float getX(int pointerIndex) {
        return MotionEvent.nativeGetAxisValue(this.mNativePtr, 0, pointerIndex, Integer.MIN_VALUE);
    }

    public final float getY(int pointerIndex) {
        return MotionEvent.nativeGetAxisValue(this.mNativePtr, 1, pointerIndex, Integer.MIN_VALUE);
    }

    public final float getPressure(int pointerIndex) {
        return MotionEvent.nativeGetAxisValue(this.mNativePtr, 2, pointerIndex, Integer.MIN_VALUE);
    }

    public final float getSize(int pointerIndex) {
        return MotionEvent.nativeGetAxisValue(this.mNativePtr, 3, pointerIndex, Integer.MIN_VALUE);
    }

    public final float getTouchMajor(int pointerIndex) {
        return MotionEvent.nativeGetAxisValue(this.mNativePtr, 4, pointerIndex, Integer.MIN_VALUE);
    }

    public final float getTouchMinor(int pointerIndex) {
        return MotionEvent.nativeGetAxisValue(this.mNativePtr, 5, pointerIndex, Integer.MIN_VALUE);
    }

    public final float getToolMajor(int pointerIndex) {
        return MotionEvent.nativeGetAxisValue(this.mNativePtr, 6, pointerIndex, Integer.MIN_VALUE);
    }

    public final float getToolMinor(int pointerIndex) {
        return MotionEvent.nativeGetAxisValue(this.mNativePtr, 7, pointerIndex, Integer.MIN_VALUE);
    }

    public final float getOrientation(int pointerIndex) {
        return MotionEvent.nativeGetAxisValue(this.mNativePtr, 8, pointerIndex, Integer.MIN_VALUE);
    }

    public final float getAxisValue(int axis, int pointerIndex) {
        return MotionEvent.nativeGetAxisValue(this.mNativePtr, axis, pointerIndex, Integer.MIN_VALUE);
    }

    public final void getPointerCoords(int pointerIndex, PointerCoords outPointerCoords) {
        MotionEvent.nativeGetPointerCoords(this.mNativePtr, pointerIndex, Integer.MIN_VALUE, outPointerCoords);
    }

    public final void getPointerProperties(int pointerIndex, PointerProperties outPointerProperties) {
        MotionEvent.nativeGetPointerProperties(this.mNativePtr, pointerIndex, outPointerProperties);
    }

    public final int getMetaState() {
        return MotionEvent.nativeGetMetaState(this.mNativePtr);
    }

    public final int getButtonState() {
        return MotionEvent.nativeGetButtonState(this.mNativePtr);
    }

    public final void setButtonState(int buttonState) {
        MotionEvent.nativeSetButtonState(this.mNativePtr, buttonState);
    }

    public int getClassification() {
        return MotionEvent.nativeGetClassification(this.mNativePtr);
    }

    public final int getActionButton() {
        return MotionEvent.nativeGetActionButton(this.mNativePtr);
    }

    @UnsupportedAppUsage
    public final void setActionButton(int button) {
        MotionEvent.nativeSetActionButton(this.mNativePtr, button);
    }

    public final float getRawX() {
        return MotionEvent.nativeGetRawAxisValue(this.mNativePtr, 0, 0, Integer.MIN_VALUE);
    }

    public final float getRawY() {
        return MotionEvent.nativeGetRawAxisValue(this.mNativePtr, 1, 0, Integer.MIN_VALUE);
    }

    public float getRawX(int pointerIndex) {
        return MotionEvent.nativeGetRawAxisValue(this.mNativePtr, 0, pointerIndex, Integer.MIN_VALUE);
    }

    public float getRawY(int pointerIndex) {
        return MotionEvent.nativeGetRawAxisValue(this.mNativePtr, 1, pointerIndex, Integer.MIN_VALUE);
    }

    public final float getXPrecision() {
        return MotionEvent.nativeGetXPrecision(this.mNativePtr);
    }

    public final float getYPrecision() {
        return MotionEvent.nativeGetYPrecision(this.mNativePtr);
    }

    public float getXCursorPosition() {
        return MotionEvent.nativeGetXCursorPosition(this.mNativePtr);
    }

    public float getYCursorPosition() {
        return MotionEvent.nativeGetYCursorPosition(this.mNativePtr);
    }

    private void setCursorPosition(float x, float y) {
        MotionEvent.nativeSetCursorPosition(this.mNativePtr, x, y);
    }

    public final int getHistorySize() {
        return MotionEvent.nativeGetHistorySize(this.mNativePtr);
    }

    public final long getHistoricalEventTime(int pos) {
        return MotionEvent.nativeGetEventTimeNanos(this.mNativePtr, pos) / 1000000L;
    }

    public final long getHistoricalEventTimeNano(int pos) {
        return MotionEvent.nativeGetEventTimeNanos(this.mNativePtr, pos);
    }

    public final float getHistoricalX(int pos) {
        return MotionEvent.nativeGetAxisValue(this.mNativePtr, 0, 0, pos);
    }

    public final float getHistoricalY(int pos) {
        return MotionEvent.nativeGetAxisValue(this.mNativePtr, 1, 0, pos);
    }

    public final float getHistoricalPressure(int pos) {
        return MotionEvent.nativeGetAxisValue(this.mNativePtr, 2, 0, pos);
    }

    public final float getHistoricalSize(int pos) {
        return MotionEvent.nativeGetAxisValue(this.mNativePtr, 3, 0, pos);
    }

    public final float getHistoricalTouchMajor(int pos) {
        return MotionEvent.nativeGetAxisValue(this.mNativePtr, 4, 0, pos);
    }

    public final float getHistoricalTouchMinor(int pos) {
        return MotionEvent.nativeGetAxisValue(this.mNativePtr, 5, 0, pos);
    }

    public final float getHistoricalToolMajor(int pos) {
        return MotionEvent.nativeGetAxisValue(this.mNativePtr, 6, 0, pos);
    }

    public final float getHistoricalToolMinor(int pos) {
        return MotionEvent.nativeGetAxisValue(this.mNativePtr, 7, 0, pos);
    }

    public final float getHistoricalOrientation(int pos) {
        return MotionEvent.nativeGetAxisValue(this.mNativePtr, 8, 0, pos);
    }

    public final float getHistoricalAxisValue(int axis, int pos) {
        return MotionEvent.nativeGetAxisValue(this.mNativePtr, axis, 0, pos);
    }

    public final float getHistoricalX(int pointerIndex, int pos) {
        return MotionEvent.nativeGetAxisValue(this.mNativePtr, 0, pointerIndex, pos);
    }

    public final float getHistoricalY(int pointerIndex, int pos) {
        return MotionEvent.nativeGetAxisValue(this.mNativePtr, 1, pointerIndex, pos);
    }

    public final float getHistoricalPressure(int pointerIndex, int pos) {
        return MotionEvent.nativeGetAxisValue(this.mNativePtr, 2, pointerIndex, pos);
    }

    public final float getHistoricalSize(int pointerIndex, int pos) {
        return MotionEvent.nativeGetAxisValue(this.mNativePtr, 3, pointerIndex, pos);
    }

    public final float getHistoricalTouchMajor(int pointerIndex, int pos) {
        return MotionEvent.nativeGetAxisValue(this.mNativePtr, 4, pointerIndex, pos);
    }

    public final float getHistoricalTouchMinor(int pointerIndex, int pos) {
        return MotionEvent.nativeGetAxisValue(this.mNativePtr, 5, pointerIndex, pos);
    }

    public final float getHistoricalToolMajor(int pointerIndex, int pos) {
        return MotionEvent.nativeGetAxisValue(this.mNativePtr, 6, pointerIndex, pos);
    }

    public final float getHistoricalToolMinor(int pointerIndex, int pos) {
        return MotionEvent.nativeGetAxisValue(this.mNativePtr, 7, pointerIndex, pos);
    }

    public final float getHistoricalOrientation(int pointerIndex, int pos) {
        return MotionEvent.nativeGetAxisValue(this.mNativePtr, 8, pointerIndex, pos);
    }

    public final float getHistoricalAxisValue(int axis, int pointerIndex, int pos) {
        return MotionEvent.nativeGetAxisValue(this.mNativePtr, axis, pointerIndex, pos);
    }

    public final void getHistoricalPointerCoords(int pointerIndex, int pos, PointerCoords outPointerCoords) {
        MotionEvent.nativeGetPointerCoords(this.mNativePtr, pointerIndex, pos, outPointerCoords);
    }

    public final int getEdgeFlags() {
        return MotionEvent.nativeGetEdgeFlags(this.mNativePtr);
    }

    public final void setEdgeFlags(int flags) {
        MotionEvent.nativeSetEdgeFlags(this.mNativePtr, flags);
    }

    public final void setAction(int action2) {
        MotionEvent.nativeSetAction(this.mNativePtr, action2);
    }

    public final void offsetLocation(float deltaX, float deltaY) {
        if (deltaX != 0.0f || deltaY != 0.0f) {
            MotionEvent.nativeOffsetLocation(this.mNativePtr, deltaX, deltaY);
        }
    }

    public final void setLocation(float x, float y) {
        float oldX = this.getX();
        float oldY = this.getY();
        this.offsetLocation(x - oldX, y - oldY);
    }

    public final void transform(Matrix matrix) {
        if (matrix == null) {
            throw new IllegalArgumentException("matrix must not be null");
        }
        MotionEvent.nativeTransform(this.mNativePtr, matrix);
    }

    public void applyTransform(Matrix matrix) {
        if (matrix == null) {
            throw new IllegalArgumentException("matrix must not be null");
        }
        MotionEvent.nativeApplyTransform(this.mNativePtr, matrix);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addBatch(long eventTime, float x, float y, float pressure, float size, int metaState) {
        Object object = gSharedTempLock;
        synchronized (object) {
            MotionEvent.ensureSharedTempPointerCapacity(1);
            PointerCoords[] pc = gSharedTempPointerCoords;
            pc[0].clear();
            pc[0].x = x;
            pc[0].y = y;
            pc[0].pressure = pressure;
            pc[0].size = size;
            MotionEvent.nativeAddBatch(this.mNativePtr, eventTime * 1000000L, pc, metaState);
        }
    }

    public final void addBatch(long eventTime, PointerCoords[] pointerCoords, int metaState) {
        MotionEvent.nativeAddBatch(this.mNativePtr, eventTime * 1000000L, pointerCoords, metaState);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UnsupportedAppUsage
    public final boolean addBatch(MotionEvent event) {
        int action2 = MotionEvent.nativeGetAction(this.mNativePtr);
        if (action2 != 2 && action2 != 7) {
            return false;
        }
        if (action2 != MotionEvent.nativeGetAction(event.mNativePtr)) {
            return false;
        }
        if (MotionEvent.nativeGetDeviceId(this.mNativePtr) != MotionEvent.nativeGetDeviceId(event.mNativePtr) || MotionEvent.nativeGetSource(this.mNativePtr) != MotionEvent.nativeGetSource(event.mNativePtr) || MotionEvent.nativeGetDisplayId(this.mNativePtr) != MotionEvent.nativeGetDisplayId(event.mNativePtr) || MotionEvent.nativeGetFlags(this.mNativePtr) != MotionEvent.nativeGetFlags(event.mNativePtr) || MotionEvent.nativeGetClassification(this.mNativePtr) != MotionEvent.nativeGetClassification(event.mNativePtr)) {
            return false;
        }
        int pointerCount = MotionEvent.nativeGetPointerCount(this.mNativePtr);
        if (pointerCount != MotionEvent.nativeGetPointerCount(event.mNativePtr)) {
            return false;
        }
        Object object = gSharedTempLock;
        synchronized (object) {
            MotionEvent.ensureSharedTempPointerCapacity(Math.max(pointerCount, 2));
            PointerProperties[] pp = gSharedTempPointerProperties;
            PointerCoords[] pc = gSharedTempPointerCoords;
            for (int i = 0; i < pointerCount; ++i) {
                MotionEvent.nativeGetPointerProperties(this.mNativePtr, i, pp[0]);
                MotionEvent.nativeGetPointerProperties(event.mNativePtr, i, pp[1]);
                if (pp[0].equals(pp[1])) continue;
                return false;
            }
            int metaState = MotionEvent.nativeGetMetaState(event.mNativePtr);
            int historySize = MotionEvent.nativeGetHistorySize(event.mNativePtr);
            for (int h = 0; h <= historySize; ++h) {
                int historyPos = h == historySize ? Integer.MIN_VALUE : h;
                for (int i = 0; i < pointerCount; ++i) {
                    MotionEvent.nativeGetPointerCoords(event.mNativePtr, i, historyPos, pc[i]);
                }
                long eventTimeNanos = MotionEvent.nativeGetEventTimeNanos(event.mNativePtr, historyPos);
                MotionEvent.nativeAddBatch(this.mNativePtr, eventTimeNanos, pc, metaState);
            }
        }
        return true;
    }

    public final boolean isWithinBoundsNoHistory(float left, float top, float right2, float bottom2) {
        int pointerCount = MotionEvent.nativeGetPointerCount(this.mNativePtr);
        for (int i = 0; i < pointerCount; ++i) {
            float x = MotionEvent.nativeGetAxisValue(this.mNativePtr, 0, i, Integer.MIN_VALUE);
            float y = MotionEvent.nativeGetAxisValue(this.mNativePtr, 1, i, Integer.MIN_VALUE);
            if (!(x < left || x > right2 || y < top) && !(y > bottom2)) continue;
            return false;
        }
        return true;
    }

    private static final float clamp(float value2, float low, float high) {
        if (value2 < low) {
            return low;
        }
        if (value2 > high) {
            return high;
        }
        return value2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final MotionEvent clampNoHistory(float left, float top, float right2, float bottom2) {
        MotionEvent ev = MotionEvent.obtain();
        Object object = gSharedTempLock;
        synchronized (object) {
            int pointerCount = MotionEvent.nativeGetPointerCount(this.mNativePtr);
            MotionEvent.ensureSharedTempPointerCapacity(pointerCount);
            PointerProperties[] pp = gSharedTempPointerProperties;
            PointerCoords[] pc = gSharedTempPointerCoords;
            for (int i = 0; i < pointerCount; ++i) {
                MotionEvent.nativeGetPointerProperties(this.mNativePtr, i, pp[i]);
                MotionEvent.nativeGetPointerCoords(this.mNativePtr, i, Integer.MIN_VALUE, pc[i]);
                pc[i].x = MotionEvent.clamp(pc[i].x, left, right2);
                pc[i].y = MotionEvent.clamp(pc[i].y, top, bottom2);
            }
            ev.initialize(MotionEvent.nativeGetDeviceId(this.mNativePtr), MotionEvent.nativeGetSource(this.mNativePtr), MotionEvent.nativeGetDisplayId(this.mNativePtr), MotionEvent.nativeGetAction(this.mNativePtr), MotionEvent.nativeGetFlags(this.mNativePtr), MotionEvent.nativeGetEdgeFlags(this.mNativePtr), MotionEvent.nativeGetMetaState(this.mNativePtr), MotionEvent.nativeGetButtonState(this.mNativePtr), MotionEvent.nativeGetClassification(this.mNativePtr), MotionEvent.nativeGetXOffset(this.mNativePtr), MotionEvent.nativeGetYOffset(this.mNativePtr), MotionEvent.nativeGetXPrecision(this.mNativePtr), MotionEvent.nativeGetYPrecision(this.mNativePtr), MotionEvent.nativeGetDownTimeNanos(this.mNativePtr), MotionEvent.nativeGetEventTimeNanos(this.mNativePtr, Integer.MIN_VALUE), pointerCount, pp, pc);
            return ev;
        }
    }

    @UnsupportedAppUsage
    public final int getPointerIdBits() {
        int idBits = 0;
        int pointerCount = MotionEvent.nativeGetPointerCount(this.mNativePtr);
        for (int i = 0; i < pointerCount; ++i) {
            idBits |= 1 << MotionEvent.nativeGetPointerId(this.mNativePtr, i);
        }
        return idBits;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UnsupportedAppUsage
    public final MotionEvent split(int idBits) {
        MotionEvent ev = MotionEvent.obtain();
        Object object = gSharedTempLock;
        synchronized (object) {
            int oldPointerCount = MotionEvent.nativeGetPointerCount(this.mNativePtr);
            MotionEvent.ensureSharedTempPointerCapacity(oldPointerCount);
            PointerProperties[] pp = gSharedTempPointerProperties;
            PointerCoords[] pc = gSharedTempPointerCoords;
            int[] map2 = gSharedTempPointerIndexMap;
            int oldAction = MotionEvent.nativeGetAction(this.mNativePtr);
            int oldActionMasked = oldAction & 0xFF;
            int oldActionPointerIndex = (oldAction & 0xFF00) >> 8;
            int newActionPointerIndex = -1;
            int newPointerCount = 0;
            for (int i = 0; i < oldPointerCount; ++i) {
                MotionEvent.nativeGetPointerProperties(this.mNativePtr, i, pp[newPointerCount]);
                int idBit = 1 << pp[newPointerCount].id;
                if ((idBit & idBits) == 0) continue;
                if (i == oldActionPointerIndex) {
                    newActionPointerIndex = newPointerCount;
                }
                map2[newPointerCount] = i;
                ++newPointerCount;
            }
            if (newPointerCount == 0) {
                throw new IllegalArgumentException("idBits did not match any ids in the event");
            }
            int newAction = oldActionMasked == 5 || oldActionMasked == 6 ? (newActionPointerIndex < 0 ? 2 : (newPointerCount == 1 ? (oldActionMasked == 5 ? 0 : ((this.getFlags() & 0x20) == 0 ? 1 : 3)) : oldActionMasked | newActionPointerIndex << 8)) : oldAction;
            int historySize = MotionEvent.nativeGetHistorySize(this.mNativePtr);
            for (int h = 0; h <= historySize; ++h) {
                int historyPos = h == historySize ? Integer.MIN_VALUE : h;
                for (int i = 0; i < newPointerCount; ++i) {
                    MotionEvent.nativeGetPointerCoords(this.mNativePtr, map2[i], historyPos, pc[i]);
                }
                long eventTimeNanos = MotionEvent.nativeGetEventTimeNanos(this.mNativePtr, historyPos);
                if (h == 0) {
                    ev.initialize(MotionEvent.nativeGetDeviceId(this.mNativePtr), MotionEvent.nativeGetSource(this.mNativePtr), MotionEvent.nativeGetDisplayId(this.mNativePtr), newAction, MotionEvent.nativeGetFlags(this.mNativePtr), MotionEvent.nativeGetEdgeFlags(this.mNativePtr), MotionEvent.nativeGetMetaState(this.mNativePtr), MotionEvent.nativeGetButtonState(this.mNativePtr), MotionEvent.nativeGetClassification(this.mNativePtr), MotionEvent.nativeGetXOffset(this.mNativePtr), MotionEvent.nativeGetYOffset(this.mNativePtr), MotionEvent.nativeGetXPrecision(this.mNativePtr), MotionEvent.nativeGetYPrecision(this.mNativePtr), MotionEvent.nativeGetDownTimeNanos(this.mNativePtr), eventTimeNanos, newPointerCount, pp, pc);
                    continue;
                }
                MotionEvent.nativeAddBatch(ev.mNativePtr, eventTimeNanos, pc, 0);
            }
            return ev;
        }
    }

    private void updateCursorPosition() {
        if (this.getSource() != 8194) {
            this.setCursorPosition(Float.NaN, Float.NaN);
            return;
        }
        float x = 0.0f;
        float y = 0.0f;
        int pointerCount = this.getPointerCount();
        for (int i = 0; i < pointerCount; ++i) {
            x += this.getX(i);
            y += this.getY(i);
        }
        this.setCursorPosition(x /= (float)pointerCount, y /= (float)pointerCount);
    }

    public String toString() {
        StringBuilder msg = new StringBuilder();
        msg.append("MotionEvent { action=").append(MotionEvent.actionToString(this.getAction()));
        MotionEvent.appendUnless("0", msg, ", actionButton=", MotionEvent.buttonStateToString(this.getActionButton()));
        int pointerCount = this.getPointerCount();
        for (int i = 0; i < pointerCount; ++i) {
            MotionEvent.appendUnless(i, msg, ", id[" + i + "]=", this.getPointerId(i));
            float x = this.getX(i);
            float y = this.getY(i);
            msg.append(", x[").append(i).append("]=").append(x);
            msg.append(", y[").append(i).append("]=").append(y);
            MotionEvent.appendUnless(TOOL_TYPE_SYMBOLIC_NAMES.get(1), msg, ", toolType[" + i + "]=", MotionEvent.toolTypeToString(this.getToolType(i)));
        }
        MotionEvent.appendUnless("0", msg, ", buttonState=", MotionEvent.buttonStateToString(this.getButtonState()));
        MotionEvent.appendUnless(MotionEvent.classificationToString(0), msg, ", classification=", MotionEvent.classificationToString(this.getClassification()));
        MotionEvent.appendUnless("0", msg, ", metaState=", KeyEvent.metaStateToString(this.getMetaState()));
        MotionEvent.appendUnless("0", msg, ", flags=0x", Integer.toHexString(this.getFlags()));
        MotionEvent.appendUnless("0", msg, ", edgeFlags=0x", Integer.toHexString(this.getEdgeFlags()));
        MotionEvent.appendUnless(1, msg, ", pointerCount=", pointerCount);
        MotionEvent.appendUnless(0, msg, ", historySize=", this.getHistorySize());
        msg.append(", eventTime=").append(this.getEventTime());
        msg.append(", downTime=").append(this.getDownTime());
        msg.append(", deviceId=").append(this.getDeviceId());
        msg.append(", source=0x").append(Integer.toHexString(this.getSource()));
        msg.append(", displayId=").append(this.getDisplayId());
        msg.append(", eventId=").append(this.getId());
        msg.append(" }");
        return msg.toString();
    }

    private static <T> void appendUnless(T defValue, StringBuilder sb, String key, T value2) {
        sb.append(key).append(value2);
    }

    public static String actionToString(int action2) {
        switch (action2) {
            case 0: {
                return "ACTION_DOWN";
            }
            case 1: {
                return "ACTION_UP";
            }
            case 3: {
                return "ACTION_CANCEL";
            }
            case 4: {
                return "ACTION_OUTSIDE";
            }
            case 2: {
                return "ACTION_MOVE";
            }
            case 7: {
                return "ACTION_HOVER_MOVE";
            }
            case 8: {
                return "ACTION_SCROLL";
            }
            case 9: {
                return "ACTION_HOVER_ENTER";
            }
            case 10: {
                return "ACTION_HOVER_EXIT";
            }
            case 11: {
                return "ACTION_BUTTON_PRESS";
            }
            case 12: {
                return "ACTION_BUTTON_RELEASE";
            }
        }
        int index = (action2 & 0xFF00) >> 8;
        switch (action2 & 0xFF) {
            case 5: {
                return "ACTION_POINTER_DOWN(" + index + ")";
            }
            case 6: {
                return "ACTION_POINTER_UP(" + index + ")";
            }
        }
        return Integer.toString(action2);
    }

    public static String axisToString(int axis) {
        String symbolicName = MotionEvent.nativeAxisToString(axis);
        return symbolicName != null ? LABEL_PREFIX + symbolicName : Integer.toString(axis);
    }

    public static int axisFromString(String symbolicName) {
        int axis;
        if (symbolicName.startsWith(LABEL_PREFIX) && (axis = MotionEvent.nativeAxisFromString(symbolicName = symbolicName.substring(LABEL_PREFIX.length()))) >= 0) {
            return axis;
        }
        try {
            return Integer.parseInt(symbolicName, 10);
        }
        catch (NumberFormatException ex) {
            return -1;
        }
    }

    public static String buttonStateToString(int buttonState) {
        if (buttonState == 0) {
            return "0";
        }
        StringBuilder result = null;
        int i = 0;
        while (buttonState != 0) {
            boolean isSet = (buttonState & 1) != 0;
            buttonState >>>= 1;
            if (isSet) {
                String name = BUTTON_SYMBOLIC_NAMES[i];
                if (result == null) {
                    if (buttonState == 0) {
                        return name;
                    }
                    result = new StringBuilder(name);
                } else {
                    result.append('|');
                    result.append(name);
                }
            }
            ++i;
        }
        return result.toString();
    }

    public static String classificationToString(int classification) {
        switch (classification) {
            case 0: {
                return "NONE";
            }
            case 1: {
                return "AMBIGUOUS_GESTURE";
            }
            case 2: {
                return "DEEP_PRESS";
            }
        }
        return "NONE";
    }

    public static String toolTypeToString(int toolType) {
        String symbolicName = TOOL_TYPE_SYMBOLIC_NAMES.get(toolType);
        return symbolicName != null ? symbolicName : Integer.toString(toolType);
    }

    public final boolean isButtonPressed(int button) {
        if (button == 0) {
            return false;
        }
        return (this.getButtonState() & button) == button;
    }

    public int getSurfaceRotation() {
        return MotionEvent.nativeGetSurfaceRotation(this.mNativePtr);
    }

    public static Matrix createRotateMatrix(int rotation, int rotatedFrameWidth, int rotatedFrameHeight) {
        if (rotation == 0) {
            return new Matrix(Matrix.IDENTITY_MATRIX);
        }
        float[] values2 = null;
        if (rotation == 1) {
            values2 = new float[]{0.0f, 1.0f, 0.0f, -1.0f, 0.0f, rotatedFrameHeight, 0.0f, 0.0f, 1.0f};
        } else if (rotation == 2) {
            values2 = new float[]{-1.0f, 0.0f, rotatedFrameWidth, 0.0f, -1.0f, rotatedFrameHeight, 0.0f, 0.0f, 1.0f};
        } else if (rotation == 3) {
            values2 = new float[]{0.0f, -1.0f, rotatedFrameWidth, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f};
        }
        Matrix toOrient = new Matrix();
        toOrient.setValues(values2);
        return toOrient;
    }

    public static MotionEvent createFromParcelBody(Parcel in) {
        MotionEvent ev = MotionEvent.obtain();
        ev.mNativePtr = MotionEvent.nativeReadFromParcel(ev.mNativePtr, in);
        return ev;
    }

    @Override
    public final void cancel() {
        this.setAction(3);
    }

    @Override
    public void writeToParcel(Parcel out, int flags) {
        out.writeInt(1);
        MotionEvent.nativeWriteToParcel(this.mNativePtr, out);
    }

    static {
        SparseArray<String> names = AXIS_SYMBOLIC_NAMES = new SparseArray();
        names.append(0, "AXIS_X");
        names.append(1, "AXIS_Y");
        names.append(2, "AXIS_PRESSURE");
        names.append(3, "AXIS_SIZE");
        names.append(4, "AXIS_TOUCH_MAJOR");
        names.append(5, "AXIS_TOUCH_MINOR");
        names.append(6, "AXIS_TOOL_MAJOR");
        names.append(7, "AXIS_TOOL_MINOR");
        names.append(8, "AXIS_ORIENTATION");
        names.append(9, "AXIS_VSCROLL");
        names.append(10, "AXIS_HSCROLL");
        names.append(11, "AXIS_Z");
        names.append(12, "AXIS_RX");
        names.append(13, "AXIS_RY");
        names.append(14, "AXIS_RZ");
        names.append(15, "AXIS_HAT_X");
        names.append(16, "AXIS_HAT_Y");
        names.append(17, "AXIS_LTRIGGER");
        names.append(18, "AXIS_RTRIGGER");
        names.append(19, "AXIS_THROTTLE");
        names.append(20, "AXIS_RUDDER");
        names.append(21, "AXIS_WHEEL");
        names.append(22, "AXIS_GAS");
        names.append(23, "AXIS_BRAKE");
        names.append(24, "AXIS_DISTANCE");
        names.append(25, "AXIS_TILT");
        names.append(26, "AXIS_SCROLL");
        names.append(27, "AXIS_REALTIVE_X");
        names.append(28, "AXIS_REALTIVE_Y");
        names.append(32, "AXIS_GENERIC_1");
        names.append(33, "AXIS_GENERIC_2");
        names.append(34, "AXIS_GENERIC_3");
        names.append(35, "AXIS_GENERIC_4");
        names.append(36, "AXIS_GENERIC_5");
        names.append(37, "AXIS_GENERIC_6");
        names.append(38, "AXIS_GENERIC_7");
        names.append(39, "AXIS_GENERIC_8");
        names.append(40, "AXIS_GENERIC_9");
        names.append(41, "AXIS_GENERIC_10");
        names.append(42, "AXIS_GENERIC_11");
        names.append(43, "AXIS_GENERIC_12");
        names.append(44, "AXIS_GENERIC_13");
        names.append(45, "AXIS_GENERIC_14");
        names.append(46, "AXIS_GENERIC_15");
        names.append(47, "AXIS_GENERIC_16");
        BUTTON_SYMBOLIC_NAMES = new String[]{"BUTTON_PRIMARY", "BUTTON_SECONDARY", "BUTTON_TERTIARY", "BUTTON_BACK", "BUTTON_FORWARD", "BUTTON_STYLUS_PRIMARY", "BUTTON_STYLUS_SECONDARY", "0x00000080", "0x00000100", "0x00000200", "0x00000400", "0x00000800", "0x00001000", "0x00002000", "0x00004000", "0x00008000", "0x00010000", "0x00020000", "0x00040000", "0x00080000", "0x00100000", "0x00200000", "0x00400000", "0x00800000", "0x01000000", "0x02000000", "0x04000000", "0x08000000", "0x10000000", "0x20000000", "0x40000000", "0x80000000"};
        TOOL_TYPE_SYMBOLIC_NAMES = new SparseArray();
        names = TOOL_TYPE_SYMBOLIC_NAMES;
        names.append(0, "TOOL_TYPE_UNKNOWN");
        names.append(1, "TOOL_TYPE_FINGER");
        names.append(2, "TOOL_TYPE_STYLUS");
        names.append(3, "TOOL_TYPE_MOUSE");
        names.append(4, "TOOL_TYPE_ERASER");
        gRecyclerLock = new Object();
        gSharedTempLock = new Object();
        CREATOR = new Parcelable.Creator<MotionEvent>(){

            @Override
            public MotionEvent createFromParcel(Parcel in) {
                in.readInt();
                return MotionEvent.createFromParcelBody(in);
            }

            public MotionEvent[] newArray(int size) {
                return new MotionEvent[size];
            }
        };
    }

    public static class PointerProperties {
        public int id;
        public int toolType;

        public PointerProperties() {
            this.clear();
        }

        public PointerProperties(PointerProperties other) {
            this.copyFrom(other);
        }

        @UnsupportedAppUsage
        public static PointerProperties[] createArray(int size) {
            PointerProperties[] array2 = new PointerProperties[size];
            for (int i = 0; i < size; ++i) {
                array2[i] = new PointerProperties();
            }
            return array2;
        }

        public void clear() {
            this.id = -1;
            this.toolType = 0;
        }

        public void copyFrom(PointerProperties other) {
            this.id = other.id;
            this.toolType = other.toolType;
        }

        public boolean equals(Object other) {
            if (other instanceof PointerProperties) {
                return this.equals((PointerProperties)other);
            }
            return false;
        }

        private boolean equals(PointerProperties other) {
            return other != null && this.id == other.id && this.toolType == other.toolType;
        }

        public int hashCode() {
            return this.id | this.toolType << 8;
        }
    }

    public static class PointerCoords {
        private static final int INITIAL_PACKED_AXIS_VALUES = 8;
        @UnsupportedAppUsage
        private long mPackedAxisBits;
        @UnsupportedAppUsage
        private float[] mPackedAxisValues;
        public float x;
        public float y;
        public float pressure;
        public float size;
        public float touchMajor;
        public float touchMinor;
        public float toolMajor;
        public float toolMinor;
        public float orientation;
        public float relativeX;
        public float relativeY;

        public PointerCoords() {
        }

        public PointerCoords(PointerCoords other) {
            this.copyFrom(other);
        }

        @UnsupportedAppUsage
        public static PointerCoords[] createArray(int size) {
            PointerCoords[] array2 = new PointerCoords[size];
            for (int i = 0; i < size; ++i) {
                array2[i] = new PointerCoords();
            }
            return array2;
        }

        public void clear() {
            this.mPackedAxisBits = 0L;
            this.x = 0.0f;
            this.y = 0.0f;
            this.pressure = 0.0f;
            this.size = 0.0f;
            this.touchMajor = 0.0f;
            this.touchMinor = 0.0f;
            this.toolMajor = 0.0f;
            this.toolMinor = 0.0f;
            this.orientation = 0.0f;
            this.relativeX = 0.0f;
            this.relativeY = 0.0f;
        }

        public void copyFrom(PointerCoords other) {
            long bits;
            this.mPackedAxisBits = bits = other.mPackedAxisBits;
            if (bits != 0L) {
                float[] otherValues = other.mPackedAxisValues;
                int count = Long.bitCount(bits);
                float[] values2 = this.mPackedAxisValues;
                if (values2 == null || count > values2.length) {
                    this.mPackedAxisValues = values2 = new float[otherValues.length];
                }
                System.arraycopy(otherValues, 0, values2, 0, count);
            }
            this.x = other.x;
            this.y = other.y;
            this.pressure = other.pressure;
            this.size = other.size;
            this.touchMajor = other.touchMajor;
            this.touchMinor = other.touchMinor;
            this.toolMajor = other.toolMajor;
            this.toolMinor = other.toolMinor;
            this.orientation = other.orientation;
            this.relativeX = other.relativeX;
            this.relativeY = other.relativeY;
        }

        public float getAxisValue(int axis) {
            switch (axis) {
                case 0: {
                    return this.x;
                }
                case 1: {
                    return this.y;
                }
                case 2: {
                    return this.pressure;
                }
                case 3: {
                    return this.size;
                }
                case 4: {
                    return this.touchMajor;
                }
                case 5: {
                    return this.touchMinor;
                }
                case 6: {
                    return this.toolMajor;
                }
                case 7: {
                    return this.toolMinor;
                }
                case 8: {
                    return this.orientation;
                }
                case 27: {
                    return this.relativeX;
                }
                case 28: {
                    return this.relativeY;
                }
            }
            if (axis < 0 || axis > 63) {
                throw new IllegalArgumentException("Axis out of range.");
            }
            long bits = this.mPackedAxisBits;
            long axisBit = Long.MIN_VALUE >>> axis;
            if ((bits & axisBit) == 0L) {
                return 0.0f;
            }
            int index = Long.bitCount(bits & (-1L >>> axis ^ 0xFFFFFFFFFFFFFFFFL));
            return this.mPackedAxisValues[index];
        }

        public void setAxisValue(int axis, float value2) {
            switch (axis) {
                case 0: {
                    this.x = value2;
                    break;
                }
                case 1: {
                    this.y = value2;
                    break;
                }
                case 2: {
                    this.pressure = value2;
                    break;
                }
                case 3: {
                    this.size = value2;
                    break;
                }
                case 4: {
                    this.touchMajor = value2;
                    break;
                }
                case 5: {
                    this.touchMinor = value2;
                    break;
                }
                case 6: {
                    this.toolMajor = value2;
                    break;
                }
                case 7: {
                    this.toolMinor = value2;
                    break;
                }
                case 8: {
                    this.orientation = value2;
                    break;
                }
                case 27: {
                    this.relativeX = value2;
                    break;
                }
                case 28: {
                    this.relativeY = value2;
                    break;
                }
                default: {
                    if (axis < 0 || axis > 63) {
                        throw new IllegalArgumentException("Axis out of range.");
                    }
                    long bits = this.mPackedAxisBits;
                    long axisBit = Long.MIN_VALUE >>> axis;
                    int index = Long.bitCount(bits & (-1L >>> axis ^ 0xFFFFFFFFFFFFFFFFL));
                    float[] values2 = this.mPackedAxisValues;
                    if ((bits & axisBit) == 0L) {
                        if (values2 == null) {
                            this.mPackedAxisValues = values2 = new float[8];
                        } else {
                            int count = Long.bitCount(bits);
                            if (count < values2.length) {
                                if (index != count) {
                                    System.arraycopy(values2, index, values2, index + 1, count - index);
                                }
                            } else {
                                float[] newValues = new float[count * 2];
                                System.arraycopy(values2, 0, newValues, 0, index);
                                System.arraycopy(values2, index, newValues, index + 1, count - index);
                                this.mPackedAxisValues = values2 = newValues;
                            }
                        }
                        this.mPackedAxisBits = bits | axisBit;
                    }
                    values2[index] = value2;
                }
            }
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Classification {
    }
}

