/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.compat.annotation.UnsupportedAppUsage;
import android.content.res.CompatibilityInfo;
import android.graphics.BLASTBufferQueue;
import android.graphics.Canvas;
import android.graphics.ColorSpace;
import android.graphics.HardwareRenderer;
import android.graphics.Matrix;
import android.graphics.Point;
import android.graphics.RecordingCanvas;
import android.graphics.Rect;
import android.graphics.RenderNode;
import android.graphics.SurfaceTexture;
import android.hardware.HardwareBuffer;
import android.os.Parcel;
import android.os.Parcelable;
import android.system.OsConstants;
import android.util.Log;
import android.view.SurfaceControl;
import com.android.internal.lang.System_Delegate;
import dalvik.system.CloseGuard;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public class Surface
implements Parcelable {
    private static final String TAG = "Surface";
    public static final Parcelable.Creator<Surface> CREATOR = new Parcelable.Creator<Surface>(){

        @Override
        public Surface createFromParcel(Parcel source) {
            try {
                Surface s = new Surface();
                s.readFromParcel(source);
                return s;
            }
            catch (Exception e) {
                Log.e(Surface.TAG, "Exception creating surface from parcel", e);
                return null;
            }
        }

        public Surface[] newArray(int size) {
            return new Surface[size];
        }
    };
    private final CloseGuard mCloseGuard = CloseGuard.get();
    @UnsupportedAppUsage
    final Object mLock = new Object();
    @UnsupportedAppUsage
    private String mName;
    @UnsupportedAppUsage
    long mNativeObject;
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    private long mLockedObject;
    private int mGenerationId;
    private final Canvas mCanvas = new CompatibleCanvas();
    private Matrix mCompatibleMatrix;
    private HwuiContext mHwuiContext;
    private boolean mIsSingleBuffered;
    private boolean mIsSharedBufferModeEnabled;
    private boolean mIsAutoRefreshEnabled;
    public static final int SCALING_MODE_FREEZE = 0;
    public static final int SCALING_MODE_SCALE_TO_WINDOW = 1;
    public static final int SCALING_MODE_SCALE_CROP = 2;
    public static final int SCALING_MODE_NO_SCALE_CROP = 3;
    public static final int ROTATION_0 = 0;
    public static final int ROTATION_90 = 1;
    public static final int ROTATION_180 = 2;
    public static final int ROTATION_270 = 3;
    public static final int FRAME_RATE_COMPATIBILITY_DEFAULT = 0;
    public static final int FRAME_RATE_COMPATIBILITY_FIXED_SOURCE = 1;
    public static final int FRAME_RATE_COMPATIBILITY_EXACT = 100;
    public static final int CHANGE_FRAME_RATE_ONLY_IF_SEAMLESS = 0;
    public static final int CHANGE_FRAME_RATE_ALWAYS = 1;

    private static native long nativeCreateFromSurfaceTexture(SurfaceTexture var0) throws OutOfResourcesException;

    private static native long nativeCreateFromSurfaceControl(long var0);

    private static native long nativeGetFromSurfaceControl(long var0, long var2);

    private static native long nativeGetFromBlastBufferQueue(long var0, long var2);

    private static native long nativeLockCanvas(long var0, Canvas var2, Rect var3) throws OutOfResourcesException;

    private static native void nativeUnlockCanvasAndPost(long var0, Canvas var2);

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    private static native void nativeRelease(long var0);

    private static native boolean nativeIsValid(long var0);

    private static native boolean nativeIsConsumerRunningBehind(long var0);

    private static native long nativeReadFromParcel(long var0, Parcel var2);

    private static native void nativeWriteToParcel(long var0, Parcel var2);

    private static native void nativeAllocateBuffers(long var0);

    private static native int nativeGetWidth(long var0);

    private static native int nativeGetHeight(long var0);

    private static native long nativeGetNextFrameNumber(long var0);

    private static native int nativeSetScalingMode(long var0, int var2);

    private static native int nativeForceScopedDisconnect(long var0);

    private static native int nativeAttachAndQueueBufferWithColorSpace(long var0, HardwareBuffer var2, int var3);

    private static native int nativeSetSharedBufferModeEnabled(long var0, boolean var2);

    private static native int nativeSetAutoRefreshEnabled(long var0, boolean var2);

    private static native int nativeSetFrameRate(long var0, float var2, int var3, int var4);

    private static native void nativeDestroy(long var0);

    @UnsupportedAppUsage
    public Surface() {
    }

    public Surface(SurfaceControl from) {
        this.copyFrom(from);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Surface(SurfaceTexture surfaceTexture) {
        if (surfaceTexture == null) {
            throw new IllegalArgumentException("surfaceTexture must not be null");
        }
        this.mIsSingleBuffered = surfaceTexture.isSingleBuffered();
        Object object = this.mLock;
        synchronized (object) {
            this.mName = surfaceTexture.toString();
            this.setNativeObjectLocked(Surface.nativeCreateFromSurfaceTexture(surfaceTexture));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    private Surface(long nativeObject) {
        Object object = this.mLock;
        synchronized (object) {
            this.setNativeObjectLocked(nativeObject);
        }
    }

    protected void finalize() throws Throwable {
        try {
            if (this.mCloseGuard != null) {
                this.mCloseGuard.warnIfOpen();
            }
            this.release();
        }
        finally {
            super.finalize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mHwuiContext != null) {
                this.mHwuiContext.destroy();
                this.mHwuiContext = null;
            }
            if (this.mNativeObject != 0L) {
                Surface.nativeRelease(this.mNativeObject);
                this.setNativeObjectLocked(0L);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UnsupportedAppUsage
    public void destroy() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mNativeObject != 0L) {
                Surface.nativeDestroy(this.mNativeObject);
            }
            this.release();
        }
    }

    public void hwuiDestroy() {
        if (this.mHwuiContext != null) {
            this.mHwuiContext.destroy();
            this.mHwuiContext = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isValid() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mNativeObject == 0L) {
                return false;
            }
            return Surface.nativeIsValid(this.mNativeObject);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getGenerationId() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mGenerationId;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UnsupportedAppUsage
    public long getNextFrameNumber() {
        Object object = this.mLock;
        synchronized (object) {
            this.checkNotReleasedLocked();
            return Surface.nativeGetNextFrameNumber(this.mNativeObject);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isConsumerRunningBehind() {
        Object object = this.mLock;
        synchronized (object) {
            this.checkNotReleasedLocked();
            return Surface.nativeIsConsumerRunningBehind(this.mNativeObject);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Point getDefaultSize() {
        Object object = this.mLock;
        synchronized (object) {
            this.checkNotReleasedLocked();
            return new Point(Surface.nativeGetWidth(this.mNativeObject), Surface.nativeGetHeight(this.mNativeObject));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Canvas lockCanvas(Rect inOutDirty) throws OutOfResourcesException, IllegalArgumentException {
        Object object = this.mLock;
        synchronized (object) {
            this.checkNotReleasedLocked();
            if (this.mLockedObject != 0L) {
                throw new IllegalArgumentException("Surface was already locked");
            }
            this.mLockedObject = Surface.nativeLockCanvas(this.mNativeObject, this.mCanvas, inOutDirty);
            return this.mCanvas;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlockCanvasAndPost(Canvas canvas) {
        Object object = this.mLock;
        synchronized (object) {
            this.checkNotReleasedLocked();
            if (this.mHwuiContext != null) {
                this.mHwuiContext.unlockAndPost(canvas);
            } else {
                this.unlockSwCanvasAndPost(canvas);
            }
        }
    }

    private void unlockSwCanvasAndPost(Canvas canvas) {
        if (canvas != this.mCanvas) {
            throw new IllegalArgumentException("canvas object must be the same instance that was previously returned by lockCanvas");
        }
        if (this.mNativeObject != this.mLockedObject) {
            Log.w(TAG, "WARNING: Surface's mNativeObject (0x" + Long.toHexString(this.mNativeObject) + ") != mLockedObject (0x" + Long.toHexString(this.mLockedObject) + ")");
        }
        if (this.mLockedObject == 0L) {
            throw new IllegalStateException("Surface was not locked");
        }
        try {
            Surface.nativeUnlockCanvasAndPost(this.mLockedObject, canvas);
        }
        finally {
            Surface.nativeRelease(this.mLockedObject);
            this.mLockedObject = 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Canvas lockHardwareCanvas() {
        Object object = this.mLock;
        synchronized (object) {
            this.checkNotReleasedLocked();
            if (this.mHwuiContext == null) {
                this.mHwuiContext = new HwuiContext(false);
            }
            return this.mHwuiContext.lockCanvas(Surface.nativeGetWidth(this.mNativeObject), Surface.nativeGetHeight(this.mNativeObject));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Canvas lockHardwareWideColorGamutCanvas() {
        Object object = this.mLock;
        synchronized (object) {
            this.checkNotReleasedLocked();
            if (this.mHwuiContext != null && !this.mHwuiContext.isWideColorGamut()) {
                this.mHwuiContext.destroy();
                this.mHwuiContext = null;
            }
            if (this.mHwuiContext == null) {
                this.mHwuiContext = new HwuiContext(true);
            }
            return this.mHwuiContext.lockCanvas(Surface.nativeGetWidth(this.mNativeObject), Surface.nativeGetHeight(this.mNativeObject));
        }
    }

    @Deprecated
    public void unlockCanvas(Canvas canvas) {
        throw new UnsupportedOperationException();
    }

    void setCompatibilityTranslator(CompatibilityInfo.Translator translator) {
        if (translator != null) {
            float appScale = translator.applicationScale;
            this.mCompatibleMatrix = new Matrix();
            this.mCompatibleMatrix.setScale(appScale, appScale);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateNativeObject(long newNativeObject) {
        Object object = this.mLock;
        synchronized (object) {
            if (newNativeObject == this.mNativeObject) {
                return;
            }
            if (this.mNativeObject != 0L) {
                Surface.nativeRelease(this.mNativeObject);
            }
            this.setNativeObjectLocked(newNativeObject);
        }
    }

    @UnsupportedAppUsage
    public void copyFrom(SurfaceControl other) {
        if (other == null) {
            throw new IllegalArgumentException("other must not be null");
        }
        long surfaceControlPtr = other.mNativeObject;
        if (surfaceControlPtr == 0L) {
            throw new NullPointerException("null SurfaceControl native object. Are you using a released SurfaceControl?");
        }
        long newNativeObject = Surface.nativeGetFromSurfaceControl(this.mNativeObject, surfaceControlPtr);
        this.updateNativeObject(newNativeObject);
    }

    public void copyFrom(BLASTBufferQueue queue) {
        if (queue == null) {
            throw new IllegalArgumentException("queue must not be null");
        }
        long blastBufferQueuePtr = queue.mNativeObject;
        if (blastBufferQueuePtr == 0L) {
            throw new NullPointerException("Null BLASTBufferQueue native object");
        }
        long newNativeObject = Surface.nativeGetFromBlastBufferQueue(this.mNativeObject, blastBufferQueuePtr);
        this.updateNativeObject(newNativeObject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createFrom(SurfaceControl other) {
        if (other == null) {
            throw new IllegalArgumentException("other must not be null");
        }
        long surfaceControlPtr = other.mNativeObject;
        if (surfaceControlPtr == 0L) {
            throw new NullPointerException("null SurfaceControl native object. Are you using a released SurfaceControl?");
        }
        long newNativeObject = Surface.nativeCreateFromSurfaceControl(surfaceControlPtr);
        Object object = this.mLock;
        synchronized (object) {
            if (this.mNativeObject != 0L) {
                Surface.nativeRelease(this.mNativeObject);
            }
            this.setNativeObjectLocked(newNativeObject);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    @UnsupportedAppUsage
    public void transferFrom(Surface other) {
        if (other == null) {
            throw new IllegalArgumentException("other must not be null");
        }
        if (other != this) {
            long newPtr;
            Object object = other.mLock;
            synchronized (object) {
                newPtr = other.mNativeObject;
                other.setNativeObjectLocked(0L);
            }
            object = this.mLock;
            synchronized (object) {
                if (this.mNativeObject != 0L) {
                    Surface.nativeRelease(this.mNativeObject);
                }
                this.setNativeObjectLocked(newPtr);
            }
        }
    }

    @Override
    public int describeContents() {
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readFromParcel(Parcel source) {
        if (source == null) {
            throw new IllegalArgumentException("source must not be null");
        }
        Object object = this.mLock;
        synchronized (object) {
            this.mName = source.readString();
            this.mIsSingleBuffered = source.readInt() != 0;
            this.setNativeObjectLocked(Surface.nativeReadFromParcel(this.mNativeObject, source));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeToParcel(Parcel dest, int flags) {
        if (dest == null) {
            throw new IllegalArgumentException("dest must not be null");
        }
        Object object = this.mLock;
        synchronized (object) {
            dest.writeString(this.mName);
            dest.writeInt(this.mIsSingleBuffered ? 1 : 0);
            Surface.nativeWriteToParcel(this.mNativeObject, dest);
        }
        if ((flags & 1) != 0) {
            this.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        Object object = this.mLock;
        synchronized (object) {
            return "Surface(name=" + this.mName + ")/@0x" + Integer.toHexString(System.identityHashCode(this));
        }
    }

    private void setNativeObjectLocked(long ptr) {
        if (this.mNativeObject != ptr) {
            if (this.mNativeObject == 0L && ptr != 0L) {
                this.mCloseGuard.open("Surface.release");
            } else if (this.mNativeObject != 0L && ptr == 0L) {
                this.mCloseGuard.close();
            }
            this.mNativeObject = ptr;
            ++this.mGenerationId;
            if (this.mHwuiContext != null) {
                this.mHwuiContext.updateSurface();
            }
        }
    }

    private void checkNotReleasedLocked() {
        if (this.mNativeObject == 0L) {
            throw new IllegalStateException("Surface has already been released.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void allocateBuffers() {
        Object object = this.mLock;
        synchronized (object) {
            this.checkNotReleasedLocked();
            Surface.nativeAllocateBuffers(this.mNativeObject);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setScalingMode(int scalingMode) {
        Object object = this.mLock;
        synchronized (object) {
            this.checkNotReleasedLocked();
            int err = Surface.nativeSetScalingMode(this.mNativeObject, scalingMode);
            if (err != 0) {
                throw new IllegalArgumentException("Invalid scaling mode: " + scalingMode);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void forceScopedDisconnect() {
        Object object = this.mLock;
        synchronized (object) {
            this.checkNotReleasedLocked();
            int err = Surface.nativeForceScopedDisconnect(this.mNativeObject);
            if (err != 0) {
                throw new RuntimeException("Failed to disconnect Surface instance (bad object?)");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void attachAndQueueBufferWithColorSpace(HardwareBuffer buffer, ColorSpace colorSpace) {
        Object object = this.mLock;
        synchronized (object) {
            int err;
            this.checkNotReleasedLocked();
            if (colorSpace == null) {
                colorSpace = ColorSpace.get(ColorSpace.Named.SRGB);
            }
            if ((err = Surface.nativeAttachAndQueueBufferWithColorSpace(this.mNativeObject, buffer, colorSpace.getId())) != 0) {
                throw new RuntimeException("Failed to attach and queue buffer to Surface (bad object?), native error: " + err);
            }
        }
    }

    public boolean isSingleBuffered() {
        return this.mIsSingleBuffered;
    }

    public void setSharedBufferModeEnabled(boolean enabled) {
        if (this.mIsSharedBufferModeEnabled != enabled) {
            int error = Surface.nativeSetSharedBufferModeEnabled(this.mNativeObject, enabled);
            if (error != 0) {
                throw new RuntimeException("Failed to set shared buffer mode on Surface (bad object?)");
            }
            this.mIsSharedBufferModeEnabled = enabled;
        }
    }

    public boolean isSharedBufferModeEnabled() {
        return this.mIsSharedBufferModeEnabled;
    }

    public void setAutoRefreshEnabled(boolean enabled) {
        if (this.mIsAutoRefreshEnabled != enabled) {
            int error = Surface.nativeSetAutoRefreshEnabled(this.mNativeObject, enabled);
            if (error != 0) {
                throw new RuntimeException("Failed to set auto refresh on Surface (bad object?)");
            }
            this.mIsAutoRefreshEnabled = enabled;
        }
    }

    public boolean isAutoRefreshEnabled() {
        return this.mIsAutoRefreshEnabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFrameRate(float frameRate, int compatibility, int changeFrameRateStrategy) {
        Object object = this.mLock;
        synchronized (object) {
            this.checkNotReleasedLocked();
            int error = Surface.nativeSetFrameRate(this.mNativeObject, frameRate, compatibility, changeFrameRateStrategy);
            if (error == -OsConstants.EINVAL) {
                throw new IllegalArgumentException("Invalid argument to Surface.setFrameRate()");
            }
            if (error != 0) {
                throw new RuntimeException("Failed to set frame rate on Surface");
            }
        }
    }

    public void setFrameRate(float frameRate, int compatibility) {
        this.setFrameRate(frameRate, compatibility, 0);
    }

    public static String rotationToString(int rotation) {
        switch (rotation) {
            case 0: {
                return "ROTATION_0";
            }
            case 1: {
                return "ROTATION_90";
            }
            case 2: {
                return "ROTATION_180";
            }
            case 3: {
                return "ROTATION_270";
            }
        }
        return Integer.toString(rotation);
    }

    private class HwuiContext {
        private final RenderNode mRenderNode = RenderNode.create("HwuiCanvas", null);
        private HardwareRenderer mHardwareRenderer;
        private RecordingCanvas mCanvas;
        private final boolean mIsWideColorGamut;

        HwuiContext(boolean isWideColorGamut) {
            this.mRenderNode.setClipToBounds(false);
            this.mRenderNode.setForceDarkAllowed(false);
            this.mIsWideColorGamut = isWideColorGamut;
            this.mHardwareRenderer = new HardwareRenderer();
            this.mHardwareRenderer.setContentRoot(this.mRenderNode);
            this.mHardwareRenderer.setSurface(Surface.this, true);
            this.mHardwareRenderer.setColorMode(isWideColorGamut ? 1 : 0);
            this.mHardwareRenderer.setLightSourceAlpha(0.0f, 0.0f);
            this.mHardwareRenderer.setLightSourceGeometry(0.0f, 0.0f, 0.0f, 0.0f);
        }

        Canvas lockCanvas(int width2, int height2) {
            if (this.mCanvas != null) {
                throw new IllegalStateException("Surface was already locked!");
            }
            this.mCanvas = this.mRenderNode.beginRecording(width2, height2);
            return this.mCanvas;
        }

        void unlockAndPost(Canvas canvas) {
            if (canvas != this.mCanvas) {
                throw new IllegalArgumentException("canvas object must be the same instance that was previously returned by lockCanvas");
            }
            this.mRenderNode.endRecording();
            this.mCanvas = null;
            this.mHardwareRenderer.createRenderRequest().setVsyncTime(System_Delegate.nanoTime()).syncAndDraw();
        }

        void updateSurface() {
            this.mHardwareRenderer.setSurface(Surface.this, true);
        }

        void destroy() {
            this.mHardwareRenderer.destroy();
        }

        boolean isWideColorGamut() {
            return this.mIsWideColorGamut;
        }
    }

    private class CompatibleCanvas
    extends Canvas {
        private Matrix mOrigMatrix = null;

        private CompatibleCanvas() {
        }

        @Override
        public void setMatrix(Matrix matrix) {
            if (Surface.this.mCompatibleMatrix == null || this.mOrigMatrix == null || this.mOrigMatrix.equals(matrix)) {
                super.setMatrix(matrix);
            } else {
                Matrix m = new Matrix(Surface.this.mCompatibleMatrix);
                m.preConcat(matrix);
                super.setMatrix(m);
            }
        }

        @Override
        public void getMatrix(Matrix m) {
            super.getMatrix(m);
            if (this.mOrigMatrix == null) {
                this.mOrigMatrix = new Matrix();
            }
            this.mOrigMatrix.set(m);
        }
    }

    public static class OutOfResourcesException
    extends RuntimeException {
        public OutOfResourcesException() {
        }

        public OutOfResourcesException(String name) {
            super(name);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ChangeFrameRateStrategy {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface FrameRateCompatibility {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Rotation {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ScalingMode {
    }
}

