/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.compat.annotation.UnsupportedAppUsage;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.HardwareRenderer;
import android.graphics.Picture;
import android.graphics.RecordingCanvas;
import android.graphics.Rect;
import android.graphics.RenderNode;
import android.os.Debug;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.util.DisplayMetrics;
import android.util.Log;
import android.util.TypedValue;
import android.view.ThreadedRenderer;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewHierarchyEncoder;
import android.view.ViewOverlay;
import android.view.ViewRootImpl;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.HashMap;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Function;
import java.util.stream.Stream;
import libcore.util.HexEncoding;

public class ViewDebug {
    @Deprecated
    public static final boolean TRACE_HIERARCHY = false;
    @Deprecated
    public static final boolean TRACE_RECYCLER = false;
    public static final boolean DEBUG_DRAG = false;
    public static final boolean DEBUG_POSITIONING = false;
    private static final int CAPTURE_TIMEOUT = 6000;
    private static final String REMOTE_COMMAND_CAPTURE = "CAPTURE";
    private static final String REMOTE_COMMAND_DUMP = "DUMP";
    private static final String REMOTE_COMMAND_DUMP_THEME = "DUMP_THEME";
    public static final String REMOTE_COMMAND_DUMP_ENCODED = "DUMP_ENCODED";
    private static final String REMOTE_COMMAND_INVALIDATE = "INVALIDATE";
    private static final String REMOTE_COMMAND_REQUEST_LAYOUT = "REQUEST_LAYOUT";
    private static final String REMOTE_PROFILE = "PROFILE";
    private static final String REMOTE_COMMAND_CAPTURE_LAYERS = "CAPTURE_LAYERS";
    private static final String REMOTE_COMMAND_OUTPUT_DISPLAYLIST = "OUTPUT_DISPLAYLIST";
    private static HashMap<Class<?>, PropertyInfo<ExportedProperty, ?>[]> sExportProperties;
    private static HashMap<Class<?>, PropertyInfo<CapturedViewProperty, ?>[]> sCapturedViewProperties;

    @UnsupportedAppUsage
    public static long getViewInstanceCount() {
        return Debug.countInstancesOfClass(View.class);
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public static long getViewRootImplCount() {
        return Debug.countInstancesOfClass(ViewRootImpl.class);
    }

    @Deprecated
    public static void trace(View view2, RecyclerTraceType type, int ... parameters) {
    }

    @Deprecated
    public static void startRecyclerTracing(String prefix, View view2) {
    }

    @Deprecated
    public static void stopRecyclerTracing() {
    }

    @Deprecated
    public static void trace(View view2, HierarchyTraceType type) {
    }

    @Deprecated
    public static void startHierarchyTracing(String prefix, View view2) {
    }

    @Deprecated
    public static void stopHierarchyTracing() {
    }

    @UnsupportedAppUsage
    static void dispatchCommand(View view2, String command, String parameters, OutputStream clientStream) throws IOException {
        view2 = view2.getRootView();
        if (REMOTE_COMMAND_DUMP.equalsIgnoreCase(command)) {
            ViewDebug.dump(view2, false, true, clientStream);
        } else if (REMOTE_COMMAND_DUMP_THEME.equalsIgnoreCase(command)) {
            ViewDebug.dumpTheme(view2, clientStream);
        } else if (REMOTE_COMMAND_DUMP_ENCODED.equalsIgnoreCase(command)) {
            ViewDebug.dumpEncoded(view2, clientStream);
        } else if (REMOTE_COMMAND_CAPTURE_LAYERS.equalsIgnoreCase(command)) {
            ViewDebug.captureLayers(view2, new DataOutputStream(clientStream));
        } else {
            String[] params = parameters.split(" ");
            if (REMOTE_COMMAND_CAPTURE.equalsIgnoreCase(command)) {
                ViewDebug.capture(view2, clientStream, params[0]);
            } else if (REMOTE_COMMAND_OUTPUT_DISPLAYLIST.equalsIgnoreCase(command)) {
                ViewDebug.outputDisplayList(view2, params[0]);
            } else if (REMOTE_COMMAND_INVALIDATE.equalsIgnoreCase(command)) {
                ViewDebug.invalidate(view2, params[0]);
            } else if (REMOTE_COMMAND_REQUEST_LAYOUT.equalsIgnoreCase(command)) {
                ViewDebug.requestLayout(view2, params[0]);
            } else if (REMOTE_PROFILE.equalsIgnoreCase(command)) {
                ViewDebug.profile(view2, clientStream, params[0]);
            }
        }
    }

    public static View findView(View root, String parameter) {
        if (parameter.indexOf(64) != -1) {
            String[] ids = parameter.split("@");
            String className = ids[0];
            int hashCode = (int)Long.parseLong(ids[1], 16);
            View view2 = root.getRootView();
            if (view2 instanceof ViewGroup) {
                return ViewDebug.findView((ViewGroup)view2, className, hashCode);
            }
        } else {
            int id2 = root.getResources().getIdentifier(parameter, null, null);
            return root.getRootView().findViewById(id2);
        }
        return null;
    }

    private static void invalidate(View root, String parameter) {
        View view2 = ViewDebug.findView(root, parameter);
        if (view2 != null) {
            view2.postInvalidate();
        }
    }

    private static void requestLayout(View root, String parameter) {
        final View view2 = ViewDebug.findView(root, parameter);
        if (view2 != null) {
            root.post(new Runnable(){

                @Override
                public void run() {
                    view2.requestLayout();
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void profile(View root, OutputStream clientStream, String parameter) throws IOException {
        View view2 = ViewDebug.findView(root, parameter);
        try (BufferedWriter out = null;){
            out = new BufferedWriter(new OutputStreamWriter(clientStream), 32768);
            if (view2 != null) {
                ViewDebug.profileViewAndChildren(view2, out);
            } else {
                out.write("-1 -1 -1");
                out.newLine();
            }
            out.write("DONE.");
            out.newLine();
        }
    }

    public static void profileViewAndChildren(View view2, BufferedWriter out) throws IOException {
        RenderNode node = RenderNode.create("ViewDebug", null);
        ViewDebug.profileViewAndChildren(view2, node, out, true);
    }

    private static void profileViewAndChildren(View view2, RenderNode node, BufferedWriter out, boolean root) throws IOException {
        long durationMeasure = root || (view2.mPrivateFlags & 0x800) != 0 ? ViewDebug.profileViewMeasure(view2) : 0L;
        long durationLayout = root || (view2.mPrivateFlags & 0x2000) != 0 ? ViewDebug.profileViewLayout(view2) : 0L;
        long durationDraw = root || !view2.willNotDraw() || (view2.mPrivateFlags & 0x20) != 0 ? ViewDebug.profileViewDraw(view2, node) : 0L;
        out.write(String.valueOf(durationMeasure));
        out.write(32);
        out.write(String.valueOf(durationLayout));
        out.write(32);
        out.write(String.valueOf(durationDraw));
        out.newLine();
        if (view2 instanceof ViewGroup) {
            ViewGroup group = (ViewGroup)view2;
            int count = group.getChildCount();
            for (int i = 0; i < count; ++i) {
                ViewDebug.profileViewAndChildren(group.getChildAt(i), node, out, false);
            }
        }
    }

    private static long profileViewMeasure(final View view2) {
        return ViewDebug.profileViewOperation(view2, new ViewOperation(){

            @Override
            public void pre() {
                this.forceLayout(view2);
            }

            private void forceLayout(View view22) {
                view22.forceLayout();
                if (view22 instanceof ViewGroup) {
                    ViewGroup group = (ViewGroup)view22;
                    int count = group.getChildCount();
                    for (int i = 0; i < count; ++i) {
                        this.forceLayout(group.getChildAt(i));
                    }
                }
            }

            @Override
            public void run() {
                view2.measure(view2.mOldWidthMeasureSpec, view2.mOldHeightMeasureSpec);
            }
        });
    }

    private static long profileViewLayout(View view2) {
        return ViewDebug.profileViewOperation(view2, () -> view2.layout(view2.mLeft, view2.mTop, view2.mRight, view2.mBottom));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long profileViewDraw(View view2, RenderNode node) {
        DisplayMetrics dm = view2.getResources().getDisplayMetrics();
        if (dm == null) {
            return 0L;
        }
        if (view2.isHardwareAccelerated()) {
            RecordingCanvas canvas = node.beginRecording(dm.widthPixels, dm.heightPixels);
            try {
                long l = ViewDebug.profileViewOperation(view2, () -> view2.draw(canvas));
                return l;
            }
            finally {
                node.endRecording();
            }
        }
        Bitmap bitmap = Bitmap.createBitmap(dm, dm.widthPixels, dm.heightPixels, Bitmap.Config.RGB_565);
        Canvas canvas = new Canvas(bitmap);
        try {
            long l = ViewDebug.profileViewOperation(view2, () -> view2.draw(canvas));
            return l;
        }
        finally {
            canvas.setBitmap(null);
            bitmap.recycle();
        }
    }

    private static long profileViewOperation(View view2, ViewOperation operation) {
        CountDownLatch latch = new CountDownLatch(1);
        long[] duration = new long[1];
        view2.post(() -> {
            try {
                operation.pre();
                long start = Debug.threadCpuTimeNanos();
                operation.run();
                duration[0] = Debug.threadCpuTimeNanos() - start;
            }
            finally {
                latch.countDown();
            }
        });
        try {
            if (!latch.await(6000L, TimeUnit.MILLISECONDS)) {
                Log.w("View", "Could not complete the profiling of the view " + view2);
                return -1L;
            }
        }
        catch (InterruptedException e) {
            Log.w("View", "Could not complete the profiling of the view " + view2);
            Thread.currentThread().interrupt();
            return -1L;
        }
        return duration[0];
    }

    public static void captureLayers(View root, DataOutputStream clientStream) throws IOException {
        try {
            Rect outRect = new Rect();
            root.mAttachInfo.mViewRootImpl.getDisplayFrame(outRect);
            clientStream.writeInt(outRect.width());
            clientStream.writeInt(outRect.height());
            ViewDebug.captureViewLayer(root, clientStream, true);
            clientStream.write(2);
        }
        finally {
            clientStream.close();
        }
    }

    private static void captureViewLayer(View view2, DataOutputStream clientStream, boolean visible) throws IOException {
        boolean localVisible;
        boolean bl = localVisible = view2.getVisibility() == 0 && visible;
        if ((view2.mPrivateFlags & 0x80) != 128) {
            int id2 = view2.getId();
            String name = view2.getClass().getSimpleName();
            if (id2 != -1) {
                name = ViewDebug.resolveId(view2.getContext(), id2).toString();
            }
            clientStream.write(1);
            clientStream.writeUTF(name);
            clientStream.writeByte(localVisible ? 1 : 0);
            int[] position = new int[2];
            view2.getLocationInWindow(position);
            clientStream.writeInt(position[0]);
            clientStream.writeInt(position[1]);
            clientStream.flush();
            Bitmap b = ViewDebug.performViewCapture(view2, true);
            if (b != null) {
                ByteArrayOutputStream arrayOut = new ByteArrayOutputStream(b.getWidth() * b.getHeight() * 2);
                b.compress(Bitmap.CompressFormat.PNG, 100, arrayOut);
                clientStream.writeInt(arrayOut.size());
                arrayOut.writeTo(clientStream);
            }
            clientStream.flush();
        }
        if (view2 instanceof ViewGroup) {
            ViewGroup group = (ViewGroup)view2;
            int count = group.getChildCount();
            for (int i = 0; i < count; ++i) {
                ViewDebug.captureViewLayer(group.getChildAt(i), clientStream, localVisible);
            }
        }
        if (view2.mOverlay != null) {
            ViewOverlay.OverlayViewGroup overlayContainer = view2.getOverlay().mOverlayViewGroup;
            ViewDebug.captureViewLayer(overlayContainer, clientStream, localVisible);
        }
    }

    private static void outputDisplayList(View root, String parameter) throws IOException {
        View view2 = ViewDebug.findView(root, parameter);
        view2.getViewRootImpl().outputDisplayList(view2);
    }

    public static void outputDisplayList(View root, View target) {
        root.getViewRootImpl().outputDisplayList(target);
    }

    @Deprecated
    public static AutoCloseable startRenderingCommandsCapture(View tree, Executor executor, Function<Picture, Boolean> callback2) {
        View.AttachInfo attachInfo = tree.mAttachInfo;
        if (attachInfo == null) {
            throw new IllegalArgumentException("Given view isn't attached");
        }
        if (attachInfo.mHandler.getLooper() != Looper.myLooper()) {
            throw new IllegalStateException("Called on the wrong thread. Must be called on the thread that owns the given View");
        }
        ThreadedRenderer renderer = attachInfo.mThreadedRenderer;
        if (renderer != null) {
            return new PictureCallbackHandler(renderer, callback2, executor);
        }
        return null;
    }

    @UnsupportedAppUsage
    public static AutoCloseable startRenderingCommandsCapture(View tree, Executor executor, Callable<OutputStream> callback2) {
        View.AttachInfo attachInfo = tree.mAttachInfo;
        if (attachInfo == null) {
            throw new IllegalArgumentException("Given view isn't attached");
        }
        if (attachInfo.mHandler.getLooper() != Looper.myLooper()) {
            throw new IllegalStateException("Called on the wrong thread. Must be called on the thread that owns the given View");
        }
        ThreadedRenderer renderer = attachInfo.mThreadedRenderer;
        if (renderer != null) {
            return new StreamingPictureCallbackHandler(renderer, callback2, executor);
        }
        return null;
    }

    private static void capture(View root, OutputStream clientStream, String parameter) throws IOException {
        View captureView = ViewDebug.findView(root, parameter);
        ViewDebug.capture(root, clientStream, captureView);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void capture(View root, OutputStream clientStream, View captureView) throws IOException {
        Bitmap b = ViewDebug.performViewCapture(captureView, false);
        if (b == null) {
            Log.w("View", "Failed to create capture bitmap!");
            b = Bitmap.createBitmap(root.getResources().getDisplayMetrics(), 1, 1, Bitmap.Config.ARGB_8888);
        }
        BufferedOutputStream out = null;
        try {
            out = new BufferedOutputStream(clientStream, 32768);
            b.compress(Bitmap.CompressFormat.PNG, 100, out);
            out.flush();
        }
        finally {
            if (out != null) {
                out.close();
            }
            b.recycle();
        }
    }

    private static Bitmap performViewCapture(View captureView, boolean skipChildren) {
        if (captureView != null) {
            CountDownLatch latch = new CountDownLatch(1);
            Bitmap[] cache = new Bitmap[1];
            captureView.post(() -> {
                try {
                    CanvasProvider provider2 = captureView.isHardwareAccelerated() ? new HardwareCanvasProvider() : new SoftwareCanvasProvider();
                    cache[0] = captureView.createSnapshot(provider2, skipChildren);
                }
                catch (OutOfMemoryError e) {
                    Log.w("View", "Out of memory for bitmap");
                }
                finally {
                    latch.countDown();
                }
            });
            try {
                latch.await(6000L, TimeUnit.MILLISECONDS);
                return cache[0];
            }
            catch (InterruptedException e) {
                Log.w("View", "Could not complete the capture of the view " + captureView);
                Thread.currentThread().interrupt();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public static void dump(View root, boolean skipChildren, boolean includeProperties, OutputStream clientStream) throws IOException {
        try (BufferedWriter out = null;){
            out = new BufferedWriter(new OutputStreamWriter(clientStream, "utf-8"), 32768);
            View view2 = root.getRootView();
            if (view2 instanceof ViewGroup) {
                ViewGroup group = (ViewGroup)view2;
                ViewDebug.dumpViewHierarchy(group.getContext(), group, out, 0, skipChildren, includeProperties);
            }
            out.write("DONE.");
            out.newLine();
        }
    }

    public static void dumpv2(final View view2, ByteArrayOutputStream out) throws InterruptedException {
        final ViewHierarchyEncoder encoder = new ViewHierarchyEncoder(out);
        final CountDownLatch latch = new CountDownLatch(1);
        view2.post(new Runnable(){

            @Override
            public void run() {
                encoder.addProperty("window:left", view2.mAttachInfo.mWindowLeft);
                encoder.addProperty("window:top", view2.mAttachInfo.mWindowTop);
                view2.encode(encoder);
                latch.countDown();
            }
        });
        latch.await(2L, TimeUnit.SECONDS);
        encoder.endStream();
    }

    private static void dumpEncoded(View view2, OutputStream out) throws IOException {
        ByteArrayOutputStream baOut = new ByteArrayOutputStream();
        ViewHierarchyEncoder encoder = new ViewHierarchyEncoder(baOut);
        encoder.setUserPropertiesEnabled(false);
        encoder.addProperty("window:left", view2.mAttachInfo.mWindowLeft);
        encoder.addProperty("window:top", view2.mAttachInfo.mWindowTop);
        view2.encode(encoder);
        encoder.endStream();
        out.write(baOut.toByteArray());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dumpTheme(View view2, OutputStream clientStream) throws IOException {
        try (BufferedWriter out = null;){
            out = new BufferedWriter(new OutputStreamWriter(clientStream, "utf-8"), 32768);
            String[] attributes = ViewDebug.getStyleAttributesDump(view2.getContext().getResources(), view2.getContext().getTheme());
            if (attributes != null) {
                for (int i = 0; i < attributes.length; i += 2) {
                    if (attributes[i] == null) continue;
                    out.write(attributes[i] + "\n");
                    out.write(attributes[i + 1] + "\n");
                }
            }
            out.write("DONE.");
            out.newLine();
        }
    }

    private static String[] getStyleAttributesDump(Resources resources, Resources.Theme theme) {
        TypedValue outValue = new TypedValue();
        String nullString = "null";
        int i = 0;
        int[] attributes = theme.getAllAttributes();
        String[] data = new String[attributes.length * 2];
        for (int attributeId : attributes) {
            try {
                data[i] = resources.getResourceName(attributeId);
                data[i + 1] = theme.resolveAttribute(attributeId, outValue, true) ? outValue.coerceToString().toString() : nullString;
                i += 2;
                if (outValue.type != 1) continue;
                data[i - 1] = resources.getResourceName(outValue.resourceId);
            }
            catch (Resources.NotFoundException notFoundException) {
                // empty catch block
            }
        }
        return data;
    }

    private static View findView(ViewGroup group, String className, int hashCode) {
        if (ViewDebug.isRequestedView(group, className, hashCode)) {
            return group;
        }
        int count = group.getChildCount();
        for (int i = 0; i < count; ++i) {
            View found;
            View view2 = group.getChildAt(i);
            if (view2 instanceof ViewGroup) {
                found = ViewDebug.findView((ViewGroup)view2, className, hashCode);
                if (found != null) {
                    return found;
                }
            } else if (ViewDebug.isRequestedView(view2, className, hashCode)) {
                return view2;
            }
            if (view2.mOverlay != null && (found = ViewDebug.findView(view2.mOverlay.mOverlayViewGroup, className, hashCode)) != null) {
                return found;
            }
            if (!(view2 instanceof HierarchyHandler) || (found = ((HierarchyHandler)((Object)view2)).findHierarchyView(className, hashCode)) == null) continue;
            return found;
        }
        return null;
    }

    private static boolean isRequestedView(View view2, String className, int hashCode) {
        if (view2.hashCode() == hashCode) {
            String viewClassName = view2.getClass().getName();
            if (className.equals("ViewOverlay")) {
                return viewClassName.equals("android.view.ViewOverlay$OverlayViewGroup");
            }
            return className.equals(viewClassName);
        }
        return false;
    }

    private static void dumpViewHierarchy(Context context, ViewGroup group, BufferedWriter out, int level, boolean skipChildren, boolean includeProperties) {
        Handler handler;
        ViewDebug.cacheExportedProperties(group.getClass());
        if (!skipChildren) {
            ViewDebug.cacheExportedPropertiesForChildren(group);
        }
        if ((handler = group.getHandler()) == null) {
            handler = new Handler(Looper.getMainLooper());
        }
        if (handler.getLooper() != Looper.myLooper()) {
            FutureTask<Object> task2 = new FutureTask<Object>(() -> ViewDebug.dumpViewHierarchyOnUIThread(context, group, out, level, skipChildren, includeProperties), null);
            Message msg = Message.obtain(handler, task2);
            msg.setAsynchronous(true);
            handler.sendMessage(msg);
            while (true) {
                try {
                    task2.get(6000L, TimeUnit.MILLISECONDS);
                    return;
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                catch (ExecutionException | TimeoutException e) {
                    throw new RuntimeException(e);
                }
                break;
            }
        }
        ViewDebug.dumpViewHierarchyOnUIThread(context, group, out, level, skipChildren, includeProperties);
    }

    private static void cacheExportedPropertiesForChildren(ViewGroup group) {
        int count = group.getChildCount();
        for (int i = 0; i < count; ++i) {
            View view2 = group.getChildAt(i);
            ViewDebug.cacheExportedProperties(view2.getClass());
            if (!(view2 instanceof ViewGroup)) continue;
            ViewDebug.cacheExportedPropertiesForChildren((ViewGroup)view2);
        }
    }

    private static void cacheExportedProperties(Class<?> klass) {
        if (sExportProperties != null && sExportProperties.containsKey(klass)) {
            return;
        }
        do {
            for (PropertyInfo<ExportedProperty, ?> info : ViewDebug.getExportedProperties(klass)) {
                if (info.returnType.isPrimitive() || !((ExportedProperty)info.property).deepExport()) continue;
                ViewDebug.cacheExportedProperties(info.returnType);
            }
        } while ((klass = klass.getSuperclass()) != Object.class);
    }

    private static void dumpViewHierarchyOnUIThread(Context context, ViewGroup group, BufferedWriter out, int level, boolean skipChildren, boolean includeProperties) {
        if (!ViewDebug.dumpView(context, group, out, level, includeProperties)) {
            return;
        }
        if (skipChildren) {
            return;
        }
        int count = group.getChildCount();
        for (int i = 0; i < count; ++i) {
            View view2 = group.getChildAt(i);
            if (view2 instanceof ViewGroup) {
                ViewDebug.dumpViewHierarchyOnUIThread(context, (ViewGroup)view2, out, level + 1, skipChildren, includeProperties);
            } else {
                ViewDebug.dumpView(context, view2, out, level + 1, includeProperties);
            }
            if (view2.mOverlay == null) continue;
            ViewOverlay overlay = view2.getOverlay();
            ViewOverlay.OverlayViewGroup overlayContainer = overlay.mOverlayViewGroup;
            ViewDebug.dumpViewHierarchyOnUIThread(context, overlayContainer, out, level + 2, skipChildren, includeProperties);
        }
        if (group instanceof HierarchyHandler) {
            ((HierarchyHandler)((Object)group)).dumpViewHierarchyWithProperties(out, level + 1);
        }
    }

    private static boolean dumpView(Context context, View view2, BufferedWriter out, int level, boolean includeProperties) {
        try {
            for (int i = 0; i < level; ++i) {
                out.write(32);
            }
            String className = view2.getClass().getName();
            if (className.equals("android.view.ViewOverlay$OverlayViewGroup")) {
                className = "ViewOverlay";
            }
            out.write(className);
            out.write(64);
            out.write(Integer.toHexString(view2.hashCode()));
            out.write(32);
            if (includeProperties) {
                ViewDebug.dumpViewProperties(context, view2, out);
            }
            out.newLine();
        }
        catch (IOException e) {
            Log.w("View", "Error while dumping hierarchy tree");
            return false;
        }
        return true;
    }

    private static <T extends Annotation> PropertyInfo<T, ?>[] convertToPropertyInfos(Method[] methods, Field[] fields, Class<T> property) {
        return (PropertyInfo[])Stream.of(Arrays.stream(methods).map(m -> PropertyInfo.forMethod(m, property)), Arrays.stream(fields).map(f -> PropertyInfo.forField(f, property))).flatMap(Function.identity()).filter(i -> i != null).toArray(PropertyInfo[]::new);
    }

    private static PropertyInfo<ExportedProperty, ?>[] getExportedProperties(Class<?> klass) {
        if (sExportProperties == null) {
            sExportProperties = new HashMap();
        }
        HashMap<Class<?>, PropertyInfo<ExportedProperty, ?>[]> map2 = sExportProperties;
        PropertyInfo<ExportedProperty, ?>[] properties2 = sExportProperties.get(klass);
        if (properties2 == null) {
            properties2 = ViewDebug.convertToPropertyInfos(klass.getDeclaredMethods(), klass.getDeclaredFields(), ExportedProperty.class);
            map2.put(klass, properties2);
        }
        return properties2;
    }

    private static void dumpViewProperties(Context context, Object view2, BufferedWriter out) throws IOException {
        ViewDebug.dumpViewProperties(context, view2, out, "");
    }

    private static void dumpViewProperties(Context context, Object view2, BufferedWriter out, String prefix) throws IOException {
        if (view2 == null) {
            out.write(prefix + "=4,null ");
            return;
        }
        Class<?> klass = view2.getClass();
        do {
            ViewDebug.writeExportedProperties(context, view2, out, klass, prefix);
        } while ((klass = klass.getSuperclass()) != Object.class);
    }

    private static String formatIntToHexString(int value2) {
        return "0x" + Integer.toHexString(value2).toUpperCase();
    }

    private static void writeExportedProperties(Context context, Object view2, BufferedWriter out, Class<?> klass, String prefix) throws IOException {
        for (PropertyInfo<ExportedProperty, ?> info : ViewDebug.getExportedProperties(klass)) {
            String categoryPrefix;
            Object value2;
            block11: {
                block9: {
                    IntToString[] mapping;
                    block12: {
                        block13: {
                            block10: {
                                try {
                                    value2 = info.invoke(view2);
                                }
                                catch (Exception e) {
                                    continue;
                                }
                                String string2 = categoryPrefix = ((ExportedProperty)info.property).category().length() != 0 ? ((ExportedProperty)info.property).category() + ":" : "";
                                if (info.returnType != Integer.TYPE && info.returnType != Byte.TYPE) break block9;
                                if (!((ExportedProperty)info.property).resolveId() || context == null) break block10;
                                int id2 = (Integer)value2;
                                value2 = ViewDebug.resolveId(context, id2);
                                break block11;
                            }
                            if (!((ExportedProperty)info.property).formatToHexString()) break block12;
                            if (info.returnType != Integer.TYPE) break block13;
                            value2 = ViewDebug.formatIntToHexString((Integer)value2);
                            break block11;
                        }
                        if (info.returnType != Byte.TYPE) break block11;
                        value2 = "0x" + HexEncoding.encodeToString((Byte)value2, true);
                        break block11;
                    }
                    FlagToString[] flagsMapping = ((ExportedProperty)info.property).flagMapping();
                    if (flagsMapping.length > 0) {
                        int intValue = (Integer)value2;
                        String valuePrefix = categoryPrefix + prefix + info.name + '_';
                        ViewDebug.exportUnrolledFlags(out, flagsMapping, intValue, valuePrefix);
                    }
                    if ((mapping = ((ExportedProperty)info.property).mapping()).length <= 0) break block11;
                    int intValue = (Integer)value2;
                    boolean mapped = false;
                    int mappingCount = mapping.length;
                    for (int j = 0; j < mappingCount; ++j) {
                        IntToString mapper = mapping[j];
                        if (mapper.from() != intValue) continue;
                        value2 = mapper.to();
                        mapped = true;
                        break;
                    }
                    if (mapped) break block11;
                    value2 = intValue;
                    break block11;
                }
                if (info.returnType == int[].class) {
                    int[] array2 = (int[])value2;
                    String valuePrefix = categoryPrefix + prefix + info.name + '_';
                    ViewDebug.exportUnrolledArray(context, out, (ExportedProperty)info.property, array2, valuePrefix, info.entrySuffix);
                    continue;
                }
                if (info.returnType == String[].class) {
                    String[] array3 = (String[])value2;
                    if (!((ExportedProperty)info.property).hasAdjacentMapping() || array3 == null) continue;
                    for (int j = 0; j < array3.length; j += 2) {
                        if (array3[j] == null) continue;
                        ViewDebug.writeEntry(out, categoryPrefix + prefix, array3[j], info.entrySuffix, array3[j + 1] == null ? "null" : array3[j + 1]);
                    }
                    continue;
                }
                if (!info.returnType.isPrimitive() && ((ExportedProperty)info.property).deepExport()) {
                    ViewDebug.dumpViewProperties(context, value2, out, prefix + ((ExportedProperty)info.property).prefix());
                    continue;
                }
            }
            ViewDebug.writeEntry(out, categoryPrefix + prefix, info.name, info.entrySuffix, value2);
        }
    }

    private static void writeEntry(BufferedWriter out, String prefix, String name, String suffix, Object value2) throws IOException {
        out.write(prefix);
        out.write(name);
        out.write(suffix);
        out.write("=");
        ViewDebug.writeValue(out, value2);
        out.write(32);
    }

    private static void exportUnrolledFlags(BufferedWriter out, FlagToString[] mapping, int intValue, String prefix) throws IOException {
        for (FlagToString flagMapping : mapping) {
            boolean test;
            boolean ifTrue = flagMapping.outputIf();
            int maskResult = intValue & flagMapping.mask();
            boolean bl = test = maskResult == flagMapping.equals();
            if ((!test || !ifTrue) && (test || ifTrue)) continue;
            String name = flagMapping.name();
            String value2 = ViewDebug.formatIntToHexString(maskResult);
            ViewDebug.writeEntry(out, prefix, name, "", value2);
        }
    }

    public static String intToString(Class<?> clazz, String field, int integer2) {
        IntToString[] mapping = ViewDebug.getMapping(clazz, field);
        if (mapping == null) {
            return Integer.toString(integer2);
        }
        for (IntToString map2 : mapping) {
            if (map2.from() != integer2) continue;
            return map2.to();
        }
        return Integer.toString(integer2);
    }

    public static String flagsToString(Class<?> clazz, String field, int flags) {
        FlagToString[] mapping = ViewDebug.getFlagMapping(clazz, field);
        if (mapping == null) {
            return Integer.toHexString(flags);
        }
        StringBuilder result = new StringBuilder();
        for (FlagToString flagMapping : mapping) {
            boolean test;
            boolean ifTrue = flagMapping.outputIf();
            int maskResult = flags & flagMapping.mask();
            boolean bl = test = maskResult == flagMapping.equals();
            if (!test || !ifTrue) continue;
            String name = flagMapping.name();
            result.append(name).append(' ');
        }
        if (result.length() > 0) {
            result.deleteCharAt(result.length() - 1);
        }
        return result.toString();
    }

    private static FlagToString[] getFlagMapping(Class<?> clazz, String field) {
        try {
            return clazz.getDeclaredField(field).getAnnotation(ExportedProperty.class).flagMapping();
        }
        catch (NoSuchFieldException e) {
            return null;
        }
    }

    private static IntToString[] getMapping(Class<?> clazz, String field) {
        try {
            return clazz.getDeclaredField(field).getAnnotation(ExportedProperty.class).mapping();
        }
        catch (NoSuchFieldException e) {
            return null;
        }
    }

    private static void exportUnrolledArray(Context context, BufferedWriter out, ExportedProperty property, int[] array2, String prefix, String suffix) throws IOException {
        IntToString[] indexMapping = property.indexMapping();
        boolean hasIndexMapping = indexMapping.length > 0;
        IntToString[] mapping = property.mapping();
        boolean hasMapping = mapping.length > 0;
        boolean resolveId = property.resolveId() && context != null;
        int valuesCount = array2.length;
        for (int j = 0; j < valuesCount; ++j) {
            String value2 = null;
            int intValue = array2[j];
            String name = String.valueOf(j);
            if (hasIndexMapping) {
                for (IntToString mapped : indexMapping) {
                    if (mapped.from() != j) continue;
                    name = mapped.to();
                    break;
                }
            }
            if (hasMapping) {
                for (IntToString mapped : mapping) {
                    if (mapped.from() != intValue) continue;
                    value2 = mapped.to();
                    break;
                }
            }
            if (resolveId) {
                if (value2 == null) {
                    value2 = (String)ViewDebug.resolveId(context, intValue);
                }
            } else {
                value2 = String.valueOf(intValue);
            }
            ViewDebug.writeEntry(out, prefix, name, suffix, value2);
        }
    }

    static Object resolveId(Context context, int id2) {
        String fieldValue;
        Resources resources = context.getResources();
        if (id2 >= 0) {
            try {
                fieldValue = resources.getResourceTypeName(id2) + '/' + resources.getResourceEntryName(id2);
            }
            catch (Resources.NotFoundException e) {
                fieldValue = "id/" + ViewDebug.formatIntToHexString(id2);
            }
        } else {
            fieldValue = "NO_ID";
        }
        return fieldValue;
    }

    private static void writeValue(BufferedWriter out, Object value2) throws IOException {
        if (value2 != null) {
            String output = "[EXCEPTION]";
            try {
                output = value2.toString().replace("\n", "\\n");
            }
            finally {
                out.write(String.valueOf(output.length()));
                out.write(",");
                out.write(output);
            }
        } else {
            out.write("4,null");
        }
    }

    private static PropertyInfo<CapturedViewProperty, ?>[] getCapturedViewProperties(Class<?> klass) {
        HashMap<Class<?>, PropertyInfo<CapturedViewProperty, ?>[]> map2;
        PropertyInfo<CapturedViewProperty, ?>[] infos;
        if (sCapturedViewProperties == null) {
            sCapturedViewProperties = new HashMap();
        }
        if ((infos = (map2 = sCapturedViewProperties).get(klass)) == null) {
            infos = ViewDebug.convertToPropertyInfos(klass.getMethods(), klass.getFields(), CapturedViewProperty.class);
            map2.put(klass, infos);
        }
        return infos;
    }

    private static String exportCapturedViewProperties(Object obj, Class<?> klass, String prefix) {
        if (obj == null) {
            return "null";
        }
        StringBuilder sb = new StringBuilder();
        for (PropertyInfo<CapturedViewProperty, ?> pi : ViewDebug.getCapturedViewProperties(klass)) {
            try {
                Object methodValue = pi.invoke(obj);
                if (((CapturedViewProperty)pi.property).retrieveReturn()) {
                    sb.append(ViewDebug.exportCapturedViewProperties(methodValue, pi.returnType, pi.name + "#"));
                    continue;
                }
                sb.append(prefix).append(pi.name).append(pi.entrySuffix).append("=");
                if (methodValue != null) {
                    String value2 = methodValue.toString().replace("\n", "\\n");
                    sb.append(value2);
                } else {
                    sb.append("null");
                }
                sb.append(pi.valueSuffix).append(" ");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return sb.toString();
    }

    public static void dumpCapturedView(String tag2, Object view2) {
        Class<?> klass = view2.getClass();
        StringBuilder sb = new StringBuilder(klass.getName() + ": ");
        sb.append(ViewDebug.exportCapturedViewProperties(view2, klass, ""));
        Log.d(tag2, sb.toString());
    }

    public static Object invokeViewMethod(final View view2, final Method method, final Object[] args) {
        final CountDownLatch latch = new CountDownLatch(1);
        final AtomicReference result = new AtomicReference();
        final AtomicReference exception = new AtomicReference();
        view2.post(new Runnable(){

            @Override
            public void run() {
                try {
                    result.set(method.invoke((Object)view2, args));
                }
                catch (InvocationTargetException e) {
                    exception.set(e.getCause());
                }
                catch (Exception e) {
                    exception.set(e);
                }
                latch.countDown();
            }
        });
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        if (exception.get() != null) {
            throw new RuntimeException((Throwable)exception.get());
        }
        return result.get();
    }

    public static void setLayoutParameter(final View view2, String param, int value2) throws NoSuchFieldException, IllegalAccessException {
        final ViewGroup.LayoutParams p = view2.getLayoutParams();
        Field f = p.getClass().getField(param);
        if (f.getType() != Integer.TYPE) {
            throw new RuntimeException("Only integer layout parameters can be set. Field " + param + " is of type " + f.getType().getSimpleName());
        }
        f.set(p, value2);
        view2.post(new Runnable(){

            @Override
            public void run() {
                view2.setLayoutParams(p);
            }
        });
    }

    public static interface CanvasProvider {
        public Canvas getCanvas(View var1, int var2, int var3);

        public Bitmap createBitmap();
    }

    public static class HardwareCanvasProvider
    implements CanvasProvider {
        private Picture mPicture;

        @Override
        public Canvas getCanvas(View view2, int width2, int height2) {
            this.mPicture = new Picture();
            return this.mPicture.beginRecording(width2, height2);
        }

        @Override
        public Bitmap createBitmap() {
            this.mPicture.endRecording();
            return Bitmap.createBitmap(this.mPicture);
        }
    }

    public static class SoftwareCanvasProvider
    implements CanvasProvider {
        private Canvas mCanvas;
        private Bitmap mBitmap;
        private boolean mEnabledHwFeaturesInSwMode;

        @Override
        public Canvas getCanvas(View view2, int width2, int height2) {
            this.mBitmap = Bitmap.createBitmap(view2.getResources().getDisplayMetrics(), width2, height2, Bitmap.Config.ARGB_8888);
            if (this.mBitmap == null) {
                throw new OutOfMemoryError();
            }
            this.mBitmap.setDensity(view2.getResources().getDisplayMetrics().densityDpi);
            if (view2.mAttachInfo != null) {
                this.mCanvas = view2.mAttachInfo.mCanvas;
            }
            if (this.mCanvas == null) {
                this.mCanvas = new Canvas();
            }
            this.mEnabledHwFeaturesInSwMode = this.mCanvas.isHwFeaturesInSwModeEnabled();
            this.mCanvas.setBitmap(this.mBitmap);
            return this.mCanvas;
        }

        @Override
        public Bitmap createBitmap() {
            this.mCanvas.setBitmap(null);
            this.mCanvas.setHwFeaturesInSwModeEnabled(this.mEnabledHwFeaturesInSwMode);
            return this.mBitmap;
        }
    }

    private static class StreamingPictureCallbackHandler
    implements AutoCloseable,
    HardwareRenderer.PictureCapturedCallback,
    Runnable {
        private final HardwareRenderer mRenderer;
        private final Callable<OutputStream> mCallback;
        private final Executor mExecutor;
        private final ReentrantLock mLock = new ReentrantLock(false);
        private final ArrayDeque<Picture> mQueue = new ArrayDeque(3);
        private boolean mStopListening;
        private Thread mRenderThread;

        private StreamingPictureCallbackHandler(HardwareRenderer renderer, Callable<OutputStream> callback2, Executor executor) {
            this.mRenderer = renderer;
            this.mCallback = callback2;
            this.mExecutor = executor;
            this.mRenderer.setPictureCaptureCallback(this);
        }

        @Override
        public void close() {
            this.mLock.lock();
            this.mStopListening = true;
            this.mLock.unlock();
            this.mRenderer.setPictureCaptureCallback(null);
        }

        @Override
        public void onPictureCaptured(Picture picture) {
            this.mLock.lock();
            if (this.mStopListening) {
                this.mLock.unlock();
                this.mRenderer.setPictureCaptureCallback(null);
                return;
            }
            if (this.mRenderThread == null) {
                this.mRenderThread = Thread.currentThread();
            }
            boolean needsInvoke = true;
            if (this.mQueue.size() == 3) {
                this.mQueue.removeLast();
                needsInvoke = false;
            }
            this.mQueue.add(picture);
            this.mLock.unlock();
            if (needsInvoke) {
                this.mExecutor.execute(this);
            }
        }

        @Override
        public void run() {
            this.mLock.lock();
            Picture picture = this.mQueue.poll();
            boolean isStopped = this.mStopListening;
            this.mLock.unlock();
            if (Thread.currentThread() == this.mRenderThread) {
                this.close();
                throw new IllegalStateException("ViewDebug#startRenderingCommandsCapture must be given an executor that invokes asynchronously");
            }
            if (isStopped) {
                return;
            }
            OutputStream stream = null;
            try {
                stream = this.mCallback.call();
            }
            catch (Exception ex) {
                Log.w("ViewDebug", "Aborting rendering commands capture because callback threw exception", ex);
            }
            if (stream != null) {
                try {
                    picture.writeToStream(stream);
                    stream.flush();
                }
                catch (IOException ex) {
                    Log.w("ViewDebug", "Aborting rendering commands capture due to IOException writing to output stream", ex);
                }
            } else {
                this.close();
            }
        }
    }

    private static class PictureCallbackHandler
    implements AutoCloseable,
    HardwareRenderer.PictureCapturedCallback,
    Runnable {
        private final HardwareRenderer mRenderer;
        private final Function<Picture, Boolean> mCallback;
        private final Executor mExecutor;
        private final ReentrantLock mLock = new ReentrantLock(false);
        private final ArrayDeque<Picture> mQueue = new ArrayDeque(3);
        private boolean mStopListening;
        private Thread mRenderThread;

        private PictureCallbackHandler(HardwareRenderer renderer, Function<Picture, Boolean> callback2, Executor executor) {
            this.mRenderer = renderer;
            this.mCallback = callback2;
            this.mExecutor = executor;
            this.mRenderer.setPictureCaptureCallback(this);
        }

        @Override
        public void close() {
            this.mLock.lock();
            this.mStopListening = true;
            this.mLock.unlock();
            this.mRenderer.setPictureCaptureCallback(null);
        }

        @Override
        public void onPictureCaptured(Picture picture) {
            this.mLock.lock();
            if (this.mStopListening) {
                this.mLock.unlock();
                this.mRenderer.setPictureCaptureCallback(null);
                return;
            }
            if (this.mRenderThread == null) {
                this.mRenderThread = Thread.currentThread();
            }
            Picture toDestroy = null;
            if (this.mQueue.size() == 3) {
                toDestroy = this.mQueue.removeLast();
            }
            this.mQueue.add(picture);
            this.mLock.unlock();
            if (toDestroy == null) {
                this.mExecutor.execute(this);
            } else {
                toDestroy.close();
            }
        }

        @Override
        public void run() {
            this.mLock.lock();
            Picture picture = this.mQueue.poll();
            boolean isStopped = this.mStopListening;
            this.mLock.unlock();
            if (Thread.currentThread() == this.mRenderThread) {
                this.close();
                throw new IllegalStateException("ViewDebug#startRenderingCommandsCapture must be given an executor that invokes asynchronously");
            }
            if (isStopped) {
                picture.close();
                return;
            }
            boolean keepReceiving = this.mCallback.apply(picture);
            if (!keepReceiving) {
                this.close();
            }
        }
    }

    static interface ViewOperation {
        default public void pre() {
        }

        public void run();
    }

    @Deprecated
    public static enum RecyclerTraceType {
        NEW_VIEW,
        BIND_VIEW,
        RECYCLE_FROM_ACTIVE_HEAP,
        RECYCLE_FROM_SCRAP_HEAP,
        MOVE_TO_SCRAP_HEAP,
        MOVE_FROM_ACTIVE_TO_SCRAP_HEAP;

    }

    @Deprecated
    public static enum HierarchyTraceType {
        INVALIDATE,
        INVALIDATE_CHILD,
        INVALIDATE_CHILD_IN_PARENT,
        REQUEST_LAYOUT,
        ON_LAYOUT,
        ON_MEASURE,
        DRAW,
        BUILD_CACHE;

    }

    private static class FieldPI<T extends Annotation>
    extends PropertyInfo<T, Field> {
        FieldPI(Field field, Class<T> property) {
            super(property, field, field.getType());
        }

        @Override
        public Object invoke(Object target) throws Exception {
            return ((Field)this.member).get(target);
        }
    }

    private static class MethodPI<T extends Annotation>
    extends PropertyInfo<T, Method> {
        MethodPI(Method method, Class<T> property) {
            super(property, method, method.getReturnType());
        }

        @Override
        public Object invoke(Object target) throws Exception {
            return ((Method)this.member).invoke(target, new Object[0]);
        }
    }

    private static abstract class PropertyInfo<T extends Annotation, R extends AccessibleObject> {
        public final R member;
        public final T property;
        public final String name;
        public final Class<?> returnType;
        public String entrySuffix = "";
        public String valueSuffix = "";

        PropertyInfo(Class<T> property, R member, Class<?> returnType) {
            this.member = member;
            this.name = ((Member)member).getName();
            this.property = ((AccessibleObject)member).getAnnotation(property);
            this.returnType = returnType;
        }

        public abstract Object invoke(Object var1) throws Exception;

        static <T extends Annotation> PropertyInfo<T, ?> forMethod(Method method, Class<T> property) {
            try {
                if (method.getReturnType() == Void.class || method.getParameterTypes().length != 0) {
                    return null;
                }
            }
            catch (NoClassDefFoundError e) {
                return null;
            }
            if (!method.isAnnotationPresent(property)) {
                return null;
            }
            method.setAccessible(true);
            MethodPI<T> info = new MethodPI<T>(method, property);
            info.entrySuffix = "()";
            info.valueSuffix = ";";
            return info;
        }

        static <T extends Annotation> PropertyInfo<T, ?> forField(Field field, Class<T> property) {
            if (!field.isAnnotationPresent(property)) {
                return null;
            }
            field.setAccessible(true);
            return new FieldPI<T>(field, property);
        }
    }

    public static interface HierarchyHandler {
        public void dumpViewHierarchyWithProperties(BufferedWriter var1, int var2);

        public View findHierarchyView(String var1, int var2);
    }

    @Target(value={ElementType.FIELD, ElementType.METHOD})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface CapturedViewProperty {
        public boolean retrieveReturn() default false;
    }

    @Target(value={ElementType.TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface FlagToString {
        public int mask();

        public int equals();

        public String name();

        public boolean outputIf() default true;
    }

    @Target(value={ElementType.TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface IntToString {
        public int from();

        public String to();
    }

    @Target(value={ElementType.FIELD, ElementType.METHOD})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface ExportedProperty {
        public boolean resolveId() default false;

        public IntToString[] mapping() default {};

        public IntToString[] indexMapping() default {};

        public FlagToString[] flagMapping() default {};

        public boolean deepExport() default false;

        public String prefix() default "";

        public String category() default "";

        public boolean formatToHexString() default false;

        public boolean hasAdjacentMapping() default false;
    }
}

