/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.graphics.Outline;
import android.graphics.drawable.Drawable;
import android.view.View;

public abstract class ViewOutlineProvider {
    public static final ViewOutlineProvider BACKGROUND = new ViewOutlineProvider(){

        @Override
        public void getOutline(View view2, Outline outline) {
            Drawable background = view2.getBackground();
            if (background != null) {
                background.getOutline(outline);
            } else {
                outline.setRect(0, 0, view2.getWidth(), view2.getHeight());
                outline.setAlpha(0.0f);
            }
        }
    };
    public static final ViewOutlineProvider BOUNDS = new ViewOutlineProvider(){

        @Override
        public void getOutline(View view2, Outline outline) {
            outline.setRect(0, 0, view2.getWidth(), view2.getHeight());
        }
    };
    public static final ViewOutlineProvider PADDED_BOUNDS = new ViewOutlineProvider(){

        @Override
        public void getOutline(View view2, Outline outline) {
            outline.setRect(view2.getPaddingLeft(), view2.getPaddingTop(), view2.getWidth() - view2.getPaddingRight(), view2.getHeight() - view2.getPaddingBottom());
        }
    };

    public abstract void getOutline(View var1, Outline var2);
}

