/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.graphics.Rect;
import android.view.View;
import android.view.ViewParent;
import com.android.internal.util.Preconditions;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;

class ViewRootRectTracker {
    private final Function<View, List<Rect>> mRectCollector;
    private boolean mViewsChanged = false;
    private boolean mRootRectsChanged = false;
    private List<Rect> mRootRects = Collections.emptyList();
    private List<ViewInfo> mViewInfos = new ArrayList<ViewInfo>();
    private List<Rect> mRects = Collections.emptyList();

    ViewRootRectTracker(Function<View, List<Rect>> rectCollector) {
        this.mRectCollector = rectCollector;
    }

    public void updateRectsForView(View view2) {
        boolean found = false;
        Iterator<ViewInfo> i = this.mViewInfos.iterator();
        while (i.hasNext()) {
            ViewInfo info = i.next();
            View v = info.getView();
            if (v == null || !v.isAttachedToWindow() || !v.isAggregatedVisible()) {
                this.mViewsChanged = true;
                i.remove();
                continue;
            }
            if (v != view2) continue;
            found = true;
            info.mDirty = true;
            break;
        }
        if (!found && view2.isAttachedToWindow()) {
            this.mViewInfos.add(new ViewInfo(view2));
            this.mViewsChanged = true;
        }
    }

    public List<Rect> computeChangedRects() {
        if (this.computeChanges()) {
            return this.mRects;
        }
        return null;
    }

    public boolean computeChanges() {
        boolean changed = this.mRootRectsChanged;
        Iterator<ViewInfo> i = this.mViewInfos.iterator();
        ArrayList<Rect> rects = new ArrayList<Rect>(this.mRootRects);
        while (i.hasNext()) {
            ViewInfo info = i.next();
            switch (info.update()) {
                case 0: {
                    changed = true;
                }
                case 1: {
                    rects.addAll(info.mRects);
                    break;
                }
                case 2: {
                    this.mViewsChanged = true;
                    i.remove();
                }
            }
        }
        if (changed || this.mViewsChanged) {
            this.mViewsChanged = false;
            this.mRootRectsChanged = false;
            if (!this.mRects.equals(rects)) {
                this.mRects = rects;
                return true;
            }
        }
        return false;
    }

    public List<Rect> getLastComputedRects() {
        return this.mRects;
    }

    public void setRootRects(List<Rect> rects) {
        Preconditions.checkNotNull(rects, "rects must not be null");
        this.mRootRects = rects;
        this.mRootRectsChanged = true;
    }

    public List<Rect> getRootRects() {
        return this.mRootRects;
    }

    private List<Rect> getTrackedRectsForView(View v) {
        List<Rect> rects = this.mRectCollector.apply(v);
        return rects == null ? Collections.emptyList() : rects;
    }

    private class ViewInfo {
        public static final int CHANGED = 0;
        public static final int UNCHANGED = 1;
        public static final int GONE = 2;
        private final WeakReference<View> mView;
        boolean mDirty = true;
        List<Rect> mRects = Collections.emptyList();

        ViewInfo(View view2) {
            this.mView = new WeakReference<View>(view2);
        }

        public View getView() {
            return (View)this.mView.get();
        }

        public int update() {
            View view2 = this.getView();
            if (view2 == null || !view2.isAttachedToWindow() || !view2.isAggregatedVisible()) {
                return 2;
            }
            List<Rect> localRects = ViewRootRectTracker.this.getTrackedRectsForView(view2);
            ArrayList<Rect> newRects = new ArrayList<Rect>(localRects.size());
            for (Rect src : localRects) {
                Rect mappedRect = new Rect(src);
                ViewParent p = view2.getParent();
                if (p == null || !p.getChildVisibleRect(view2, mappedRect, null)) continue;
                newRects.add(mappedRect);
            }
            if (this.mRects.equals(localRects)) {
                return 1;
            }
            this.mRects = newRects;
            return 0;
        }
    }
}

