/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.RemotableViewMethod;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.widget.RemoteViews;
import com.android.internal.R;
import java.lang.ref.WeakReference;

@RemoteViews.RemoteView
public class ViewStub
extends View {
    private int mInflatedId;
    private int mLayoutResource;
    private WeakReference<View> mInflatedViewRef;
    private LayoutInflater mInflater;
    private OnInflateListener mInflateListener;

    public ViewStub(Context context) {
        this(context, 0);
    }

    public ViewStub(Context context, int layoutResource) {
        this(context, null);
        this.mLayoutResource = layoutResource;
    }

    public ViewStub(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public ViewStub(Context context, AttributeSet attrs, int defStyleAttr) {
        this(context, attrs, defStyleAttr, 0);
    }

    public ViewStub(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.ViewStub, defStyleAttr, defStyleRes);
        this.saveAttributeDataForStyleable(context, R.styleable.ViewStub, attrs, a, defStyleAttr, defStyleRes);
        this.mInflatedId = a.getResourceId(2, -1);
        this.mLayoutResource = a.getResourceId(1, 0);
        this.mID = a.getResourceId(0, -1);
        a.recycle();
        this.setVisibility(8);
        this.setWillNotDraw(true);
    }

    public int getInflatedId() {
        return this.mInflatedId;
    }

    @RemotableViewMethod(asyncImpl="setInflatedIdAsync")
    public void setInflatedId(int inflatedId) {
        this.mInflatedId = inflatedId;
    }

    public Runnable setInflatedIdAsync(int inflatedId) {
        this.mInflatedId = inflatedId;
        return null;
    }

    public int getLayoutResource() {
        return this.mLayoutResource;
    }

    @RemotableViewMethod(asyncImpl="setLayoutResourceAsync")
    public void setLayoutResource(int layoutResource) {
        this.mLayoutResource = layoutResource;
    }

    public Runnable setLayoutResourceAsync(int layoutResource) {
        this.mLayoutResource = layoutResource;
        return null;
    }

    public void setLayoutInflater(LayoutInflater inflater) {
        this.mInflater = inflater;
    }

    public LayoutInflater getLayoutInflater() {
        return this.mInflater;
    }

    @Override
    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        this.setMeasuredDimension(0, 0);
    }

    @Override
    public void draw(Canvas canvas) {
    }

    @Override
    protected void dispatchDraw(Canvas canvas) {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @RemotableViewMethod(asyncImpl="setVisibilityAsync")
    public void setVisibility(int visibility) {
        if (this.mInflatedViewRef != null) {
            View view2 = (View)this.mInflatedViewRef.get();
            if (view2 == null) throw new IllegalStateException("setVisibility called on un-referenced view");
            view2.setVisibility(visibility);
            return;
        } else {
            super.setVisibility(visibility);
            if (visibility != 0 && visibility != 4) return;
            this.inflate();
        }
    }

    public Runnable setVisibilityAsync(int visibility) {
        if (visibility == 0 || visibility == 4) {
            ViewGroup parent = (ViewGroup)this.getParent();
            return new ViewReplaceRunnable(this.inflateViewNoAdd(parent));
        }
        return null;
    }

    private View inflateViewNoAdd(ViewGroup parent) {
        LayoutInflater factory = this.mInflater != null ? this.mInflater : LayoutInflater.from(this.mContext);
        View view2 = factory.inflate(this.mLayoutResource, parent, false);
        if (this.mInflatedId != -1) {
            view2.setId(this.mInflatedId);
        }
        return view2;
    }

    private void replaceSelfWithView(View view2, ViewGroup parent) {
        int index = parent.indexOfChild(this);
        parent.removeViewInLayout(this);
        ViewGroup.LayoutParams layoutParams = this.getLayoutParams();
        if (layoutParams != null) {
            parent.addView(view2, index, layoutParams);
        } else {
            parent.addView(view2, index);
        }
    }

    public View inflate() {
        ViewParent viewParent = this.getParent();
        if (viewParent != null && viewParent instanceof ViewGroup) {
            if (this.mLayoutResource != 0) {
                ViewGroup parent = (ViewGroup)viewParent;
                View view2 = this.inflateViewNoAdd(parent);
                this.replaceSelfWithView(view2, parent);
                this.mInflatedViewRef = new WeakReference<View>(view2);
                if (this.mInflateListener != null) {
                    this.mInflateListener.onInflate(this, view2);
                }
                return view2;
            }
            throw new IllegalArgumentException("ViewStub must have a valid layoutResource");
        }
        throw new IllegalStateException("ViewStub must have a non-null ViewGroup viewParent");
    }

    public void setOnInflateListener(OnInflateListener inflateListener) {
        this.mInflateListener = inflateListener;
    }

    public class ViewReplaceRunnable
    implements Runnable {
        public final View view;

        ViewReplaceRunnable(View view2) {
            this.view = view2;
        }

        @Override
        public void run() {
            ViewStub.this.replaceSelfWithView(this.view, (ViewGroup)ViewStub.this.getParent());
        }
    }

    public static interface OnInflateListener {
        public void onInflate(ViewStub var1, View var2);
    }
}

