/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.app.WindowConfiguration;
import android.graphics.Insets;
import android.graphics.Point;
import android.graphics.Rect;
import android.view.DisplayCutout;
import android.view.Gravity;
import android.view.InsetsSource;
import android.view.InsetsState;
import android.view.InsetsVisibilities;
import android.view.WindowInsets;
import android.view.WindowManager;
import android.window.ClientWindowFrames;

public class WindowLayout {
    private static final String TAG = WindowLayout.class.getSimpleName();
    private static final boolean DEBUG = false;
    public static final int UNSPECIFIED_LENGTH = -1;
    static final int MIN_X = -100000;
    static final int MIN_Y = -100000;
    static final int MAX_X = 100000;
    static final int MAX_Y = 100000;
    private final Rect mTempDisplayCutoutSafeExceptMaybeBarsRect = new Rect();
    private final Rect mTempRect = new Rect();

    public void computeFrames(WindowManager.LayoutParams attrs, InsetsState state, Rect displayCutoutSafe, Rect windowBounds, @WindowConfiguration.WindowingMode int windowingMode, int requestedWidth, int requestedHeight, InsetsVisibilities requestedVisibilities, Rect attachedWindowFrame, float compatScale, ClientWindowFrames outFrames) {
        float y;
        float x;
        int h;
        int w;
        int type = attrs.type;
        int fl = attrs.flags;
        int pfl = attrs.privateFlags;
        boolean layoutInScreen = (fl & 0x100) == 256;
        Rect outDisplayFrame = outFrames.displayFrame;
        Rect outParentFrame = outFrames.parentFrame;
        Rect outFrame = outFrames.frame;
        Insets insets = state.calculateInsets(windowBounds, attrs.getFitInsetsTypes(), attrs.isFitInsetsIgnoringVisibility());
        int sides = attrs.getFitInsetsSides();
        int left = (sides & 1) != 0 ? insets.left : 0;
        int top = (sides & 2) != 0 ? insets.top : 0;
        int right2 = (sides & 4) != 0 ? insets.right : 0;
        int bottom2 = (sides & 8) != 0 ? insets.bottom : 0;
        outDisplayFrame.set(windowBounds.left + left, windowBounds.top + top, windowBounds.right - right2, windowBounds.bottom - bottom2);
        if (attachedWindowFrame == null) {
            InsetsSource source;
            outParentFrame.set(outDisplayFrame);
            if ((pfl & 0x40000000) != 0 && (source = state.peekSource(19)) != null) {
                outParentFrame.inset(source.calculateInsets(outParentFrame, false));
            }
        } else {
            outParentFrame.set(!layoutInScreen ? attachedWindowFrame : outDisplayFrame);
        }
        int cutoutMode = attrs.layoutInDisplayCutoutMode;
        DisplayCutout cutout = state.getDisplayCutout();
        Rect displayCutoutSafeExceptMaybeBars = this.mTempDisplayCutoutSafeExceptMaybeBarsRect;
        displayCutoutSafeExceptMaybeBars.set(displayCutoutSafe);
        outFrames.isParentFrameClippedByDisplayCutout = false;
        if (cutoutMode != 3 && !cutout.isEmpty()) {
            boolean floatingInScreenWindow;
            InsetsSource navSource;
            boolean layoutInsetDecor;
            Rect displayFrame = state.getDisplayFrame();
            InsetsSource statusBarSource = state.peekSource(0);
            if (statusBarSource != null && displayCutoutSafe.top > displayFrame.top) {
                displayCutoutSafeExceptMaybeBars.top = Math.max(statusBarSource.getFrame().bottom, displayCutoutSafe.top);
            }
            if (cutoutMode == 1) {
                if (displayFrame.width() < displayFrame.height()) {
                    displayCutoutSafeExceptMaybeBars.top = Integer.MIN_VALUE;
                    displayCutoutSafeExceptMaybeBars.bottom = Integer.MAX_VALUE;
                } else {
                    displayCutoutSafeExceptMaybeBars.left = Integer.MIN_VALUE;
                    displayCutoutSafeExceptMaybeBars.right = Integer.MAX_VALUE;
                }
            }
            boolean bl = layoutInsetDecor = (attrs.flags & 0x10000) != 0;
            if (layoutInScreen && layoutInsetDecor && (cutoutMode == 0 || cutoutMode == 1)) {
                Insets systemBarsInsets = state.calculateInsets(displayFrame, WindowInsets.Type.systemBars(), requestedVisibilities);
                if (systemBarsInsets.left > 0) {
                    displayCutoutSafeExceptMaybeBars.left = Integer.MIN_VALUE;
                }
                if (systemBarsInsets.top > 0) {
                    displayCutoutSafeExceptMaybeBars.top = Integer.MIN_VALUE;
                }
                if (systemBarsInsets.right > 0) {
                    displayCutoutSafeExceptMaybeBars.right = Integer.MAX_VALUE;
                }
                if (systemBarsInsets.bottom > 0) {
                    displayCutoutSafeExceptMaybeBars.bottom = Integer.MAX_VALUE;
                }
            }
            if (type == 2011 && (navSource = state.peekSource(1)) != null && navSource.calculateInsets((Rect)displayFrame, (boolean)true).bottom > 0) {
                displayCutoutSafeExceptMaybeBars.bottom = Integer.MAX_VALUE;
            }
            boolean attachedInParent = attachedWindowFrame != null && !layoutInScreen;
            boolean bl2 = floatingInScreenWindow = !attrs.isFullscreen() && layoutInScreen && type != 1;
            if (!attachedInParent && !floatingInScreenWindow) {
                this.mTempRect.set(outParentFrame);
                outParentFrame.intersectUnchecked(displayCutoutSafeExceptMaybeBars);
                outFrames.isParentFrameClippedByDisplayCutout = !this.mTempRect.equals(outParentFrame);
            }
            outDisplayFrame.intersectUnchecked(displayCutoutSafeExceptMaybeBars);
        }
        boolean noLimits = (attrs.flags & 0x200) != 0;
        boolean inMultiWindowMode = WindowConfiguration.inMultiWindowMode(windowingMode);
        if (noLimits && type != 2010 && !inMultiWindowMode) {
            outDisplayFrame.left = -100000;
            outDisplayFrame.top = -100000;
            outDisplayFrame.right = 100000;
            outDisplayFrame.bottom = 100000;
        }
        boolean hasCompatScale = compatScale != 1.0f;
        int pw = outParentFrame.width();
        int ph = outParentFrame.height();
        boolean extendedByCutout = (attrs.privateFlags & 0x2000) != 0;
        int rw = requestedWidth;
        int rh = requestedHeight;
        if (rw == -1 || extendedByCutout) {
            int n = rw = attrs.width >= 0 ? attrs.width : pw;
        }
        if (rh == -1 || extendedByCutout) {
            int n = rh = attrs.height >= 0 ? attrs.height : ph;
        }
        if ((attrs.flags & 0x4000) != 0) {
            w = attrs.width < 0 ? pw : (hasCompatScale ? (int)((float)attrs.width * compatScale + 0.5f) : attrs.width);
            h = attrs.height < 0 ? ph : (hasCompatScale ? (int)((float)attrs.height * compatScale + 0.5f) : attrs.height);
        } else {
            w = attrs.width == -1 ? pw : (hasCompatScale ? (int)((float)rw * compatScale + 0.5f) : rw);
            h = attrs.height == -1 ? ph : (hasCompatScale ? (int)((float)rh * compatScale + 0.5f) : rh);
        }
        if (hasCompatScale) {
            x = (float)attrs.x * compatScale;
            y = (float)attrs.y * compatScale;
        } else {
            x = attrs.x;
            y = attrs.y;
        }
        if (inMultiWindowMode && (attrs.privateFlags & 0x10000) == 0) {
            w = Math.min(w, pw);
            h = Math.min(h, ph);
        }
        boolean fitToDisplay = !inMultiWindowMode || attrs.type != 1 && !noLimits;
        Gravity.apply(attrs.gravity, w, h, outParentFrame, (int)(x + attrs.horizontalMargin * (float)pw), (int)(y + attrs.verticalMargin * (float)ph), outFrame);
        if (fitToDisplay) {
            Gravity.applyDisplay(attrs.gravity, outDisplayFrame, outFrame);
        }
        if (extendedByCutout && !displayCutoutSafe.contains(outFrame)) {
            this.mTempRect.set(outFrame);
            int clipFlags = 0x11000000;
            Gravity.applyDisplay(attrs.gravity & 0xEEFFFFFF, displayCutoutSafe, this.mTempRect);
            if (this.mTempRect.intersect(outDisplayFrame)) {
                outFrame.union(this.mTempRect);
            }
        }
    }

    public static void computeSurfaceSize(WindowManager.LayoutParams attrs, Rect maxBounds, int requestedWidth, int requestedHeight, Rect winFrame, boolean dragResizing, Point outSurfaceSize) {
        int height2;
        int width2;
        if ((attrs.flags & 0x4000) != 0) {
            width2 = requestedWidth;
            height2 = requestedHeight;
        } else if (dragResizing) {
            width2 = maxBounds.width();
            height2 = maxBounds.height();
        } else {
            width2 = winFrame.width();
            height2 = winFrame.height();
        }
        if (width2 < 1) {
            width2 = 1;
        }
        if (height2 < 1) {
            height2 = 1;
        }
        Rect surfaceInsets = attrs.surfaceInsets;
        outSurfaceSize.set(width2 += surfaceInsets.left + surfaceInsets.right, height2 += surfaceInsets.top + surfaceInsets.bottom);
    }
}

