/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.app.ResourcesManager;
import android.compat.annotation.UnsupportedAppUsage;
import android.content.Context;
import android.content.res.Configuration;
import android.graphics.Bitmap;
import android.graphics.Rect;
import android.graphics.Region;
import android.os.Bundle;
import android.os.IBinder;
import android.os.RemoteException;
import android.os.StrictMode;
import android.view.CrossWindowBlurListeners;
import android.view.Display;
import android.view.DisplayInfo;
import android.view.InsetsState;
import android.view.KeyboardShortcutGroup;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.view.WindowInsets;
import android.view.WindowManager;
import android.view.WindowManagerGlobal;
import android.view.WindowManagerImpl;
import android.view.WindowMetrics;
import android.window.ITaskFpsCallback;
import android.window.TaskFpsCallback;
import android.window.WindowProvider;
import android.window.WindowProviderService;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.os.IResultReceiver;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.function.Consumer;

public class _Original_WindowManagerImpl
implements WindowManager {
    @UnsupportedAppUsage
    private final WindowManagerGlobal mGlobal = WindowManagerGlobal.getInstance();
    @VisibleForTesting
    public final Context mContext;
    private final Window mParentWindow;
    private IBinder mDefaultToken;
    private final IBinder mWindowContextToken;
    @GuardedBy(value={"mOnFpsCallbackListenerProxies"})
    private final ArrayList<WindowManagerImpl.OnFpsCallbackListenerProxy> mOnFpsCallbackListenerProxies = new ArrayList();

    public _Original_WindowManagerImpl(Context context) {
        this(context, null, null);
    }

    private _Original_WindowManagerImpl(Context context, Window parentWindow, IBinder windowContextToken) {
        this.mContext = context;
        this.mParentWindow = parentWindow;
        this.mWindowContextToken = windowContextToken;
    }

    public _Original_WindowManagerImpl createLocalWindowManager(Window parentWindow) {
        return new _Original_WindowManagerImpl(this.mContext, parentWindow, this.mWindowContextToken);
    }

    public _Original_WindowManagerImpl createPresentationWindowManager(Context displayContext) {
        return new _Original_WindowManagerImpl(displayContext, this.mParentWindow, this.mWindowContextToken);
    }

    public static WindowManager createWindowContextWindowManager(Context context) {
        IBinder clientToken = context.getWindowContextToken();
        return new _Original_WindowManagerImpl(context, null, clientToken);
    }

    public void setDefaultToken(IBinder token) {
        this.mDefaultToken = token;
    }

    @Override
    public void addView(View view2, ViewGroup.LayoutParams params) {
        this.applyTokens(params);
        this.mGlobal.addView(view2, params, this.mContext.getDisplayNoVerify(), this.mParentWindow, this.mContext.getUserId());
    }

    @Override
    public void updateViewLayout(View view2, ViewGroup.LayoutParams params) {
        this.applyTokens(params);
        this.mGlobal.updateViewLayout(view2, params);
    }

    private void applyTokens(ViewGroup.LayoutParams params) {
        if (!(params instanceof WindowManager.LayoutParams)) {
            throw new IllegalArgumentException("Params must be WindowManager.LayoutParams");
        }
        WindowManager.LayoutParams wparams = (WindowManager.LayoutParams)params;
        this.assertWindowContextTypeMatches(wparams.type);
        if (this.mDefaultToken != null && this.mParentWindow == null && wparams.token == null) {
            wparams.token = this.mDefaultToken;
        }
        wparams.mWindowContextToken = this.mWindowContextToken;
    }

    private void assertWindowContextTypeMatches(int windowType) {
        if (!(this.mContext instanceof WindowProvider)) {
            return;
        }
        if (windowType >= 1000 && windowType <= 1999) {
            return;
        }
        WindowProvider windowProvider = (WindowProvider)((Object)this.mContext);
        if (windowProvider.getWindowType() == windowType) {
            return;
        }
        IllegalArgumentException exception = new IllegalArgumentException("Window type mismatch. Window Context's window type is " + windowProvider.getWindowType() + ", while LayoutParams' type is set to " + windowType + ". Please create another Window Context via createWindowContext(getDisplay(), " + windowType + ", null) to add window with type:" + windowType);
        if (!WindowProviderService.isWindowProviderService(windowProvider.getWindowContextOptions())) {
            throw exception;
        }
        StrictMode.onIncorrectContextUsed("WindowContext's window type must match type in WindowManager.LayoutParams", exception);
    }

    @Override
    public void removeView(View view2) {
        this.mGlobal.removeView(view2, false);
    }

    @Override
    public void removeViewImmediate(View view2) {
        this.mGlobal.removeView(view2, true);
    }

    @Override
    public void requestAppKeyboardShortcuts(final WindowManager.KeyboardShortcutsReceiver receiver, int deviceId) {
        IResultReceiver.Stub resultReceiver = new IResultReceiver.Stub(){

            @Override
            public void send(int resultCode, Bundle resultData) throws RemoteException {
                ArrayList<KeyboardShortcutGroup> result = resultData.getParcelableArrayList("shortcuts_array");
                receiver.onKeyboardShortcutsReceived(result);
            }
        };
        try {
            WindowManagerGlobal.getWindowManagerService().requestAppKeyboardShortcuts(resultReceiver, deviceId);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    @Override
    public Display getDefaultDisplay() {
        return this.mContext.getDisplayNoVerify();
    }

    @Override
    public Region getCurrentImeTouchRegion() {
        try {
            return WindowManagerGlobal.getWindowManagerService().getCurrentImeTouchRegion();
        }
        catch (RemoteException remoteException) {
            return null;
        }
    }

    @Override
    public void setShouldShowWithInsecureKeyguard(int displayId, boolean shouldShow) {
        try {
            WindowManagerGlobal.getWindowManagerService().setShouldShowWithInsecureKeyguard(displayId, shouldShow);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    @Override
    public void setShouldShowSystemDecors(int displayId, boolean shouldShow) {
        try {
            WindowManagerGlobal.getWindowManagerService().setShouldShowSystemDecors(displayId, shouldShow);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    @Override
    public boolean shouldShowSystemDecors(int displayId) {
        try {
            return WindowManagerGlobal.getWindowManagerService().shouldShowSystemDecors(displayId);
        }
        catch (RemoteException remoteException) {
            return false;
        }
    }

    @Override
    public void setDisplayImePolicy(int displayId, @WindowManager.DisplayImePolicy int imePolicy) {
        try {
            WindowManagerGlobal.getWindowManagerService().setDisplayImePolicy(displayId, imePolicy);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    @Override
    @WindowManager.DisplayImePolicy
    public int getDisplayImePolicy(int displayId) {
        try {
            return WindowManagerGlobal.getWindowManagerService().getDisplayImePolicy(displayId);
        }
        catch (RemoteException remoteException) {
            return 1;
        }
    }

    @Override
    public WindowMetrics getCurrentWindowMetrics() {
        Context context = this.mParentWindow != null ? this.mParentWindow.getContext() : this.mContext;
        Rect bounds2 = _Original_WindowManagerImpl.getCurrentBounds(context);
        return new WindowMetrics(bounds2, this.computeWindowInsets(bounds2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Rect getCurrentBounds(Context context) {
        ResourcesManager resourcesManager = ResourcesManager.getInstance();
        synchronized (resourcesManager) {
            return context.getResources().getConfiguration().windowConfiguration.getBounds();
        }
    }

    @Override
    public WindowMetrics getMaximumWindowMetrics() {
        Context context = this.mParentWindow != null ? this.mParentWindow.getContext() : this.mContext;
        Rect maxBounds = _Original_WindowManagerImpl.getMaximumBounds(context);
        return new WindowMetrics(maxBounds, this.computeWindowInsets(maxBounds));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Rect getMaximumBounds(Context context) {
        ResourcesManager resourcesManager = ResourcesManager.getInstance();
        synchronized (resourcesManager) {
            return context.getResources().getConfiguration().windowConfiguration.getMaxBounds();
        }
    }

    private WindowInsets computeWindowInsets(Rect bounds2) {
        WindowManager.LayoutParams params = new WindowManager.LayoutParams();
        Context context = this.mParentWindow != null ? this.mParentWindow.getContext() : this.mContext;
        params.token = Context.getToken(context);
        return this.getWindowInsetsFromServerForCurrentDisplay(params, bounds2);
    }

    private WindowInsets getWindowInsetsFromServerForCurrentDisplay(WindowManager.LayoutParams attrs, Rect bounds2) {
        Configuration config = this.mContext.getResources().getConfiguration();
        return _Original_WindowManagerImpl.getWindowInsetsFromServerForDisplay(this.mContext.getDisplayId(), attrs, bounds2, config.isScreenRound(), config.windowConfiguration.getWindowingMode());
    }

    private static WindowInsets getWindowInsetsFromServerForDisplay(int displayId, WindowManager.LayoutParams attrs, Rect bounds2, boolean isScreenRound, int windowingMode) {
        try {
            InsetsState insetsState = new InsetsState();
            boolean alwaysConsumeSystemBars = WindowManagerGlobal.getWindowManagerService().getWindowInsets(attrs, displayId, insetsState);
            return insetsState.calculateInsets(bounds2, null, isScreenRound, alwaysConsumeSystemBars, 48, attrs.flags, 0, attrs.type, windowingMode, null);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Override
    public Set<WindowMetrics> getPossibleMaximumWindowMetrics(int displayId) {
        List<DisplayInfo> possibleDisplayInfos;
        try {
            possibleDisplayInfos = WindowManagerGlobal.getWindowManagerService().getPossibleDisplayInfo(displayId, this.mContext.getPackageName());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        HashSet<WindowMetrics> maxMetrics = new HashSet<WindowMetrics>();
        WindowManager.LayoutParams params = new WindowManager.LayoutParams();
        for (int i = 0; i < possibleDisplayInfos.size(); ++i) {
            DisplayInfo currentDisplayInfo = possibleDisplayInfos.get(i);
            Rect maxBounds = new Rect(0, 0, currentDisplayInfo.logicalWidth, currentDisplayInfo.logicalHeight);
            boolean isScreenRound = (currentDisplayInfo.flags & 0x10) != 0;
            WindowInsets windowInsets = _Original_WindowManagerImpl.getWindowInsetsFromServerForDisplay(currentDisplayInfo.displayId, params, new Rect(0, 0, currentDisplayInfo.getNaturalWidth(), currentDisplayInfo.getNaturalHeight()), isScreenRound, 1);
            windowInsets = new WindowInsets.Builder(windowInsets).setRoundedCorners(currentDisplayInfo.roundedCorners).setDisplayCutout(currentDisplayInfo.displayCutout).build();
            maxMetrics.add(new WindowMetrics(maxBounds, windowInsets));
        }
        return maxMetrics;
    }

    @Override
    public void holdLock(IBinder token, int durationMs) {
        try {
            WindowManagerGlobal.getWindowManagerService().holdLock(token, durationMs);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Override
    public boolean isCrossWindowBlurEnabled() {
        return CrossWindowBlurListeners.getInstance().isCrossWindowBlurEnabled();
    }

    @Override
    public void addCrossWindowBlurEnabledListener(Consumer<Boolean> listener2) {
        this.addCrossWindowBlurEnabledListener(this.mContext.getMainExecutor(), listener2);
    }

    @Override
    public void addCrossWindowBlurEnabledListener(Executor executor, Consumer<Boolean> listener2) {
        CrossWindowBlurListeners.getInstance().addListener(executor, listener2);
    }

    @Override
    public void removeCrossWindowBlurEnabledListener(Consumer<Boolean> listener2) {
        CrossWindowBlurListeners.getInstance().removeListener(listener2);
    }

    @Override
    public boolean isTaskSnapshotSupported() {
        try {
            return WindowManagerGlobal.getWindowManagerService().isTaskSnapshotSupported();
        }
        catch (RemoteException remoteException) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerTaskFpsCallback(int taskId, Executor executor, TaskFpsCallback callback2) {
        OnFpsCallbackListenerProxy onFpsCallbackListenerProxy = new OnFpsCallbackListenerProxy(executor, callback2);
        try {
            WindowManagerGlobal.getWindowManagerService().registerTaskFpsCallback(taskId, onFpsCallbackListenerProxy);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        ArrayList<WindowManagerImpl.OnFpsCallbackListenerProxy> arrayList = this.mOnFpsCallbackListenerProxies;
        synchronized (arrayList) {
            this.mOnFpsCallbackListenerProxies.add((WindowManagerImpl.OnFpsCallbackListenerProxy)onFpsCallbackListenerProxy);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterTaskFpsCallback(TaskFpsCallback callback2) {
        ArrayList<WindowManagerImpl.OnFpsCallbackListenerProxy> arrayList = this.mOnFpsCallbackListenerProxies;
        synchronized (arrayList) {
            Iterator<WindowManagerImpl.OnFpsCallbackListenerProxy> iterator = this.mOnFpsCallbackListenerProxies.iterator();
            while (iterator.hasNext()) {
                OnFpsCallbackListenerProxy proxy = (OnFpsCallbackListenerProxy)iterator.next();
                if (proxy.mCallback != callback2) continue;
                try {
                    WindowManagerGlobal.getWindowManagerService().unregisterTaskFpsCallback(proxy);
                }
                catch (RemoteException e) {
                    throw e.rethrowFromSystemServer();
                }
                iterator.remove();
            }
        }
    }

    @Override
    public Bitmap snapshotTaskForRecents(int taskId) {
        try {
            return WindowManagerGlobal.getWindowManagerService().snapshotTaskForRecents(taskId);
        }
        catch (RemoteException e) {
            e.rethrowAsRuntimeException();
            return null;
        }
    }

    private static class OnFpsCallbackListenerProxy
    extends ITaskFpsCallback.Stub {
        private final Executor mExecutor;
        private final TaskFpsCallback mCallback;

        private OnFpsCallbackListenerProxy(Executor executor, TaskFpsCallback callback2) {
            this.mExecutor = executor;
            this.mCallback = callback2;
        }

        @Override
        public void onFpsReported(float fps) {
            this.mExecutor.execute(() -> ((WindowManagerImpl.OnFpsCallbackListenerProxy)this).lambda$onFpsReported$0((float)fps));
        }

        private /* synthetic */ void lambda$onFpsReported$0(float fps) {
            this.mCallback.onFpsReported(fps);
        }
    }
}

