/*
 * Decompiled with CFR 0.152.
 */
package android.view.accessibility;

import android.compat.annotation.UnsupportedAppUsage;
import android.os.Parcel;
import android.os.Parcelable;
import android.os._Original_Build;
import android.text.TextUtils;
import android.util.Log;
import android.view.accessibility.AccessibilityRecord;
import com.android.internal.util.BitUtils;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;

public class AccessibilityEvent
extends AccessibilityRecord
implements Parcelable {
    private static final String LOG_TAG = "AccessibilityEvent";
    private static final boolean DEBUG = Log.isLoggable("AccessibilityEvent", 3) && _Original_Build.IS_DEBUGGABLE;
    public static final boolean DEBUG_ORIGIN = false;
    public static final int INVALID_POSITION = -1;
    @Deprecated
    public static final int MAX_TEXT_LENGTH = 500;
    public static final int TYPE_VIEW_CLICKED = 1;
    public static final int TYPE_VIEW_LONG_CLICKED = 2;
    public static final int TYPE_VIEW_SELECTED = 4;
    public static final int TYPE_VIEW_FOCUSED = 8;
    public static final int TYPE_VIEW_TEXT_CHANGED = 16;
    public static final int TYPE_WINDOW_STATE_CHANGED = 32;
    public static final int TYPE_NOTIFICATION_STATE_CHANGED = 64;
    public static final int TYPE_VIEW_HOVER_ENTER = 128;
    public static final int TYPE_VIEW_HOVER_EXIT = 256;
    public static final int TYPE_TOUCH_EXPLORATION_GESTURE_START = 512;
    public static final int TYPE_TOUCH_EXPLORATION_GESTURE_END = 1024;
    public static final int TYPE_WINDOW_CONTENT_CHANGED = 2048;
    public static final int TYPE_VIEW_SCROLLED = 4096;
    public static final int TYPE_VIEW_TEXT_SELECTION_CHANGED = 8192;
    public static final int TYPE_ANNOUNCEMENT = 16384;
    public static final int TYPE_VIEW_ACCESSIBILITY_FOCUSED = 32768;
    public static final int TYPE_VIEW_ACCESSIBILITY_FOCUS_CLEARED = 65536;
    public static final int TYPE_VIEW_TEXT_TRAVERSED_AT_MOVEMENT_GRANULARITY = 131072;
    public static final int TYPE_GESTURE_DETECTION_START = 262144;
    public static final int TYPE_GESTURE_DETECTION_END = 524288;
    public static final int TYPE_TOUCH_INTERACTION_START = 0x100000;
    public static final int TYPE_TOUCH_INTERACTION_END = 0x200000;
    public static final int TYPE_WINDOWS_CHANGED = 0x400000;
    public static final int TYPE_VIEW_CONTEXT_CLICKED = 0x800000;
    public static final int TYPE_ASSIST_READING_CONTEXT = 0x1000000;
    public static final int TYPE_SPEECH_STATE_CHANGE = 0x2000000;
    public static final int CONTENT_CHANGE_TYPE_UNDEFINED = 0;
    public static final int CONTENT_CHANGE_TYPE_SUBTREE = 1;
    public static final int CONTENT_CHANGE_TYPE_TEXT = 2;
    public static final int CONTENT_CHANGE_TYPE_CONTENT_DESCRIPTION = 4;
    public static final int CONTENT_CHANGE_TYPE_PANE_TITLE = 8;
    public static final int CONTENT_CHANGE_TYPE_PANE_APPEARED = 16;
    public static final int CONTENT_CHANGE_TYPE_PANE_DISAPPEARED = 32;
    public static final int CONTENT_CHANGE_TYPE_STATE_DESCRIPTION = 64;
    public static final int CONTENT_CHANGE_TYPE_DRAG_STARTED = 128;
    public static final int CONTENT_CHANGE_TYPE_DRAG_DROPPED = 256;
    public static final int CONTENT_CHANGE_TYPE_DRAG_CANCELLED = 512;
    public static final int SPEECH_STATE_SPEAKING_START = 1;
    public static final int SPEECH_STATE_SPEAKING_END = 2;
    public static final int SPEECH_STATE_LISTENING_START = 4;
    public static final int SPEECH_STATE_LISTENING_END = 8;
    public static final int WINDOWS_CHANGE_ADDED = 1;
    public static final int WINDOWS_CHANGE_REMOVED = 2;
    public static final int WINDOWS_CHANGE_TITLE = 4;
    public static final int WINDOWS_CHANGE_BOUNDS = 8;
    public static final int WINDOWS_CHANGE_LAYER = 16;
    public static final int WINDOWS_CHANGE_ACTIVE = 32;
    public static final int WINDOWS_CHANGE_FOCUSED = 64;
    public static final int WINDOWS_CHANGE_ACCESSIBILITY_FOCUSED = 128;
    public static final int WINDOWS_CHANGE_PARENT = 256;
    public static final int WINDOWS_CHANGE_CHILDREN = 512;
    public static final int WINDOWS_CHANGE_PIP = 1024;
    public static final int TYPES_ALL_MASK = -1;
    @UnsupportedAppUsage
    private int mEventType;
    private CharSequence mPackageName;
    private long mEventTime;
    int mMovementGranularity;
    @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=115609023L)
    int mAction;
    int mContentChangeTypes;
    int mWindowChangeTypes;
    int mSpeechStateChangeTypes;
    public StackTraceElement[] originStackTrace = null;
    private ArrayList<AccessibilityRecord> mRecords;
    public static final Parcelable.Creator<AccessibilityEvent> CREATOR = new Parcelable.Creator<AccessibilityEvent>(){

        @Override
        public AccessibilityEvent createFromParcel(Parcel parcel) {
            AccessibilityEvent event = new AccessibilityEvent();
            event.initFromParcel(parcel);
            return event;
        }

        public AccessibilityEvent[] newArray(int size) {
            return new AccessibilityEvent[size];
        }
    };

    public AccessibilityEvent() {
    }

    public AccessibilityEvent(int eventType) {
        this.mEventType = eventType;
    }

    public AccessibilityEvent(AccessibilityEvent event) {
        this.init(event);
    }

    void init(AccessibilityEvent event) {
        super.init(event);
        this.mEventType = event.mEventType;
        this.mMovementGranularity = event.mMovementGranularity;
        this.mAction = event.mAction;
        this.mContentChangeTypes = event.mContentChangeTypes;
        this.mSpeechStateChangeTypes = event.mSpeechStateChangeTypes;
        this.mWindowChangeTypes = event.mWindowChangeTypes;
        this.mEventTime = event.mEventTime;
        this.mPackageName = event.mPackageName;
        if (event.mRecords != null) {
            int recordCount = event.mRecords.size();
            this.mRecords = new ArrayList(recordCount);
            for (int i = 0; i < recordCount; ++i) {
                AccessibilityRecord record = event.mRecords.get(i);
                AccessibilityRecord recordClone = new AccessibilityRecord(record);
                this.mRecords.add(recordClone);
            }
        }
    }

    @Override
    public void setSealed(boolean sealed) {
        super.setSealed(sealed);
        ArrayList<AccessibilityRecord> records = this.mRecords;
        if (records != null) {
            int recordCount = records.size();
            for (int i = 0; i < recordCount; ++i) {
                AccessibilityRecord record = (AccessibilityRecord)records.get(i);
                record.setSealed(sealed);
            }
        }
    }

    public int getRecordCount() {
        return this.mRecords == null ? 0 : this.mRecords.size();
    }

    public void appendRecord(AccessibilityRecord record) {
        this.enforceNotSealed();
        if (this.mRecords == null) {
            this.mRecords = new ArrayList();
        }
        this.mRecords.add(record);
    }

    public AccessibilityRecord getRecord(int index) {
        if (this.mRecords == null) {
            throw new IndexOutOfBoundsException("Invalid index " + index + ", size is 0");
        }
        return this.mRecords.get(index);
    }

    public int getEventType() {
        return this.mEventType;
    }

    public int getContentChangeTypes() {
        return this.mContentChangeTypes;
    }

    private static String contentChangeTypesToString(int types) {
        return BitUtils.flagsToString(types, AccessibilityEvent::singleContentChangeTypeToString);
    }

    private static String singleContentChangeTypeToString(int type) {
        switch (type) {
            case 4: {
                return "CONTENT_CHANGE_TYPE_CONTENT_DESCRIPTION";
            }
            case 64: {
                return "CONTENT_CHANGE_TYPE_STATE_DESCRIPTION";
            }
            case 1: {
                return "CONTENT_CHANGE_TYPE_SUBTREE";
            }
            case 2: {
                return "CONTENT_CHANGE_TYPE_TEXT";
            }
            case 8: {
                return "CONTENT_CHANGE_TYPE_PANE_TITLE";
            }
            case 0: {
                return "CONTENT_CHANGE_TYPE_UNDEFINED";
            }
            case 16: {
                return "CONTENT_CHANGE_TYPE_PANE_APPEARED";
            }
            case 32: {
                return "CONTENT_CHANGE_TYPE_PANE_DISAPPEARED";
            }
            case 128: {
                return "CONTENT_CHANGE_TYPE_DRAG_STARTED";
            }
            case 256: {
                return "CONTENT_CHANGE_TYPE_DRAG_DROPPED";
            }
            case 512: {
                return "CONTENT_CHANGE_TYPE_DRAG_CANCELLED";
            }
        }
        return Integer.toHexString(type);
    }

    public void setContentChangeTypes(int changeTypes) {
        this.enforceNotSealed();
        this.mContentChangeTypes = changeTypes;
    }

    public int getSpeechStateChangeTypes() {
        return this.mSpeechStateChangeTypes;
    }

    private static String speechStateChangeTypesToString(int types) {
        return BitUtils.flagsToString(types, AccessibilityEvent::singleSpeechStateChangeTypeToString);
    }

    private static String singleSpeechStateChangeTypeToString(int type) {
        switch (type) {
            case 1: {
                return "SPEECH_STATE_SPEAKING_START";
            }
            case 4: {
                return "SPEECH_STATE_LISTENING_START";
            }
            case 2: {
                return "SPEECH_STATE_SPEAKING_END";
            }
            case 8: {
                return "SPEECH_STATE_LISTENING_END";
            }
        }
        return Integer.toHexString(type);
    }

    public void setSpeechStateChangeTypes(int state) {
        this.enforceNotSealed();
        this.mSpeechStateChangeTypes = state;
    }

    public int getWindowChanges() {
        return this.mWindowChangeTypes;
    }

    public void setWindowChanges(int changes) {
        this.mWindowChangeTypes = changes;
    }

    private static String windowChangeTypesToString(int types) {
        return BitUtils.flagsToString(types, AccessibilityEvent::singleWindowChangeTypeToString);
    }

    private static String singleWindowChangeTypeToString(int type) {
        switch (type) {
            case 1: {
                return "WINDOWS_CHANGE_ADDED";
            }
            case 2: {
                return "WINDOWS_CHANGE_REMOVED";
            }
            case 4: {
                return "WINDOWS_CHANGE_TITLE";
            }
            case 8: {
                return "WINDOWS_CHANGE_BOUNDS";
            }
            case 16: {
                return "WINDOWS_CHANGE_LAYER";
            }
            case 32: {
                return "WINDOWS_CHANGE_ACTIVE";
            }
            case 64: {
                return "WINDOWS_CHANGE_FOCUSED";
            }
            case 128: {
                return "WINDOWS_CHANGE_ACCESSIBILITY_FOCUSED";
            }
            case 256: {
                return "WINDOWS_CHANGE_PARENT";
            }
            case 512: {
                return "WINDOWS_CHANGE_CHILDREN";
            }
            case 1024: {
                return "WINDOWS_CHANGE_PIP";
            }
        }
        return Integer.toHexString(type);
    }

    public void setEventType(int eventType) {
        this.enforceNotSealed();
        this.mEventType = eventType;
    }

    public long getEventTime() {
        return this.mEventTime;
    }

    public void setEventTime(long eventTime) {
        this.enforceNotSealed();
        this.mEventTime = eventTime;
    }

    public CharSequence getPackageName() {
        return this.mPackageName;
    }

    public void setPackageName(CharSequence packageName) {
        this.enforceNotSealed();
        this.mPackageName = packageName;
    }

    public void setMovementGranularity(int granularity) {
        this.enforceNotSealed();
        this.mMovementGranularity = granularity;
    }

    public int getMovementGranularity() {
        return this.mMovementGranularity;
    }

    public void setAction(int action2) {
        this.enforceNotSealed();
        this.mAction = action2;
    }

    public int getAction() {
        return this.mAction;
    }

    public static AccessibilityEvent obtainWindowsChangedEvent(int windowId, int windowChangeTypes) {
        AccessibilityEvent event = new AccessibilityEvent(0x400000);
        event.setWindowId(windowId);
        event.setWindowChanges(windowChangeTypes);
        event.setImportantForAccessibility(true);
        return event;
    }

    @Deprecated
    public static AccessibilityEvent obtain(int eventType) {
        AccessibilityEvent event = new AccessibilityEvent();
        event.setEventType(eventType);
        return event;
    }

    @Deprecated
    public static AccessibilityEvent obtain(AccessibilityEvent event) {
        AccessibilityEvent eventClone = new AccessibilityEvent();
        eventClone.init(event);
        return eventClone;
    }

    @Deprecated
    public static AccessibilityEvent obtain() {
        return new AccessibilityEvent();
    }

    @Override
    @Deprecated
    public void recycle() {
    }

    @Override
    protected void clear() {
        super.clear();
        this.mEventType = 0;
        this.mMovementGranularity = 0;
        this.mAction = 0;
        this.mContentChangeTypes = 0;
        this.mWindowChangeTypes = 0;
        this.mSpeechStateChangeTypes = 0;
        this.mPackageName = null;
        this.mEventTime = 0L;
        if (this.mRecords != null) {
            while (!this.mRecords.isEmpty()) {
                AccessibilityRecord accessibilityRecord = this.mRecords.remove(0);
            }
        }
    }

    public void initFromParcel(Parcel parcel) {
        this.mSealed = parcel.readInt() == 1;
        this.mEventType = parcel.readInt();
        this.mMovementGranularity = parcel.readInt();
        this.mAction = parcel.readInt();
        this.mContentChangeTypes = parcel.readInt();
        this.mWindowChangeTypes = parcel.readInt();
        this.mSpeechStateChangeTypes = parcel.readInt();
        this.mPackageName = TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(parcel);
        this.mEventTime = parcel.readLong();
        this.mConnectionId = parcel.readInt();
        this.readAccessibilityRecordFromParcel(this, parcel);
        int recordCount = parcel.readInt();
        if (recordCount > 0) {
            this.mRecords = new ArrayList(recordCount);
            for (int i = 0; i < recordCount; ++i) {
                AccessibilityRecord record = new AccessibilityRecord();
                this.readAccessibilityRecordFromParcel(record, parcel);
                record.mConnectionId = this.mConnectionId;
                this.mRecords.add(record);
            }
        }
    }

    private void readAccessibilityRecordFromParcel(AccessibilityRecord record, Parcel parcel) {
        record.mBooleanProperties = parcel.readInt();
        record.mCurrentItemIndex = parcel.readInt();
        record.mItemCount = parcel.readInt();
        record.mFromIndex = parcel.readInt();
        record.mToIndex = parcel.readInt();
        record.mScrollX = parcel.readInt();
        record.mScrollY = parcel.readInt();
        record.mScrollDeltaX = parcel.readInt();
        record.mScrollDeltaY = parcel.readInt();
        record.mMaxScrollX = parcel.readInt();
        record.mMaxScrollY = parcel.readInt();
        record.mAddedCount = parcel.readInt();
        record.mRemovedCount = parcel.readInt();
        record.mClassName = TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(parcel);
        record.mContentDescription = TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(parcel);
        record.mBeforeText = TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(parcel);
        record.mParcelableData = parcel.readParcelable(null);
        parcel.readList(record.mText, null, CharSequence.class);
        record.mSourceWindowId = parcel.readInt();
        record.mSourceNodeId = parcel.readLong();
        record.mSourceDisplayId = parcel.readInt();
        record.mSealed = parcel.readInt() == 1;
    }

    @Override
    public void writeToParcel(Parcel parcel, int flags) {
        parcel.writeInt(this.isSealed() ? 1 : 0);
        parcel.writeInt(this.mEventType);
        parcel.writeInt(this.mMovementGranularity);
        parcel.writeInt(this.mAction);
        parcel.writeInt(this.mContentChangeTypes);
        parcel.writeInt(this.mWindowChangeTypes);
        parcel.writeInt(this.mSpeechStateChangeTypes);
        TextUtils.writeToParcel(this.mPackageName, parcel, 0);
        parcel.writeLong(this.mEventTime);
        parcel.writeInt(this.mConnectionId);
        this.writeAccessibilityRecordToParcel(this, parcel, flags);
        int recordCount = this.getRecordCount();
        parcel.writeInt(recordCount);
        for (int i = 0; i < recordCount; ++i) {
            AccessibilityRecord record = this.mRecords.get(i);
            this.writeAccessibilityRecordToParcel(record, parcel, flags);
        }
    }

    private void writeAccessibilityRecordToParcel(AccessibilityRecord record, Parcel parcel, int flags) {
        parcel.writeInt(record.mBooleanProperties);
        parcel.writeInt(record.mCurrentItemIndex);
        parcel.writeInt(record.mItemCount);
        parcel.writeInt(record.mFromIndex);
        parcel.writeInt(record.mToIndex);
        parcel.writeInt(record.mScrollX);
        parcel.writeInt(record.mScrollY);
        parcel.writeInt(record.mScrollDeltaX);
        parcel.writeInt(record.mScrollDeltaY);
        parcel.writeInt(record.mMaxScrollX);
        parcel.writeInt(record.mMaxScrollY);
        parcel.writeInt(record.mAddedCount);
        parcel.writeInt(record.mRemovedCount);
        TextUtils.writeToParcel(record.mClassName, parcel, flags);
        TextUtils.writeToParcel(record.mContentDescription, parcel, flags);
        TextUtils.writeToParcel(record.mBeforeText, parcel, flags);
        parcel.writeParcelable(record.mParcelableData, flags);
        parcel.writeList(record.mText);
        parcel.writeInt(record.mSourceWindowId);
        parcel.writeLong(record.mSourceNodeId);
        parcel.writeInt(record.mSourceDisplayId);
        parcel.writeInt(record.mSealed ? 1 : 0);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public String toString() {
        StringBuilder builder2 = new StringBuilder();
        builder2.append("EventType: ").append(AccessibilityEvent.eventTypeToString(this.mEventType));
        builder2.append("; EventTime: ").append(this.mEventTime);
        builder2.append("; PackageName: ").append(this.mPackageName);
        builder2.append("; MovementGranularity: ").append(this.mMovementGranularity);
        builder2.append("; Action: ").append(this.mAction);
        builder2.append("; ContentChangeTypes: ").append(AccessibilityEvent.contentChangeTypesToString(this.mContentChangeTypes));
        builder2.append("; WindowChangeTypes: ").append(AccessibilityEvent.windowChangeTypesToString(this.mWindowChangeTypes));
        super.appendTo(builder2);
        if (DEBUG) {
            builder2.append("\n");
            if (DEBUG) {
                builder2.append("; SourceWindowId: 0x").append(Long.toHexString(this.mSourceWindowId));
                builder2.append("; SourceNodeId: 0x").append(Long.toHexString(this.mSourceNodeId));
                builder2.append("; SourceDisplayId: ").append(this.mSourceDisplayId);
            }
            for (int i = 0; i < this.getRecordCount(); ++i) {
                builder2.append("  Record ").append(i).append(":");
                this.getRecord(i).appendTo(builder2).append("\n");
            }
        } else {
            builder2.append("; recordCount: ").append(this.getRecordCount());
        }
        return builder2.toString();
    }

    public static String eventTypeToString(int eventType) {
        if (eventType == -1) {
            return "TYPES_ALL_MASK";
        }
        StringBuilder builder2 = new StringBuilder();
        int eventTypeCount = 0;
        while (eventType != 0) {
            int eventTypeFlag = 1 << Integer.numberOfTrailingZeros(eventType);
            eventType &= ~eventTypeFlag;
            if (eventTypeCount > 0) {
                builder2.append(", ");
            }
            builder2.append(AccessibilityEvent.singleEventTypeToString(eventTypeFlag));
            ++eventTypeCount;
        }
        if (eventTypeCount > 1) {
            builder2.insert(0, '[');
            builder2.append(']');
        }
        return builder2.toString();
    }

    private static String singleEventTypeToString(int eventType) {
        switch (eventType) {
            case 1: {
                return "TYPE_VIEW_CLICKED";
            }
            case 2: {
                return "TYPE_VIEW_LONG_CLICKED";
            }
            case 4: {
                return "TYPE_VIEW_SELECTED";
            }
            case 8: {
                return "TYPE_VIEW_FOCUSED";
            }
            case 16: {
                return "TYPE_VIEW_TEXT_CHANGED";
            }
            case 32: {
                return "TYPE_WINDOW_STATE_CHANGED";
            }
            case 128: {
                return "TYPE_VIEW_HOVER_ENTER";
            }
            case 256: {
                return "TYPE_VIEW_HOVER_EXIT";
            }
            case 64: {
                return "TYPE_NOTIFICATION_STATE_CHANGED";
            }
            case 512: {
                return "TYPE_TOUCH_EXPLORATION_GESTURE_START";
            }
            case 1024: {
                return "TYPE_TOUCH_EXPLORATION_GESTURE_END";
            }
            case 2048: {
                return "TYPE_WINDOW_CONTENT_CHANGED";
            }
            case 8192: {
                return "TYPE_VIEW_TEXT_SELECTION_CHANGED";
            }
            case 4096: {
                return "TYPE_VIEW_SCROLLED";
            }
            case 16384: {
                return "TYPE_ANNOUNCEMENT";
            }
            case 32768: {
                return "TYPE_VIEW_ACCESSIBILITY_FOCUSED";
            }
            case 65536: {
                return "TYPE_VIEW_ACCESSIBILITY_FOCUS_CLEARED";
            }
            case 131072: {
                return "TYPE_VIEW_TEXT_TRAVERSED_AT_MOVEMENT_GRANULARITY";
            }
            case 262144: {
                return "TYPE_GESTURE_DETECTION_START";
            }
            case 524288: {
                return "TYPE_GESTURE_DETECTION_END";
            }
            case 0x100000: {
                return "TYPE_TOUCH_INTERACTION_START";
            }
            case 0x200000: {
                return "TYPE_TOUCH_INTERACTION_END";
            }
            case 0x400000: {
                return "TYPE_WINDOWS_CHANGED";
            }
            case 0x800000: {
                return "TYPE_VIEW_CONTEXT_CLICKED";
            }
            case 0x1000000: {
                return "TYPE_ASSIST_READING_CONTEXT";
            }
            case 0x2000000: {
                return "TYPE_SPEECH_STATE_CHANGE";
            }
        }
        return Integer.toHexString(eventType);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface EventType {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface SpeechStateChangeTypes {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ContentChangeTypes {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface WindowsChangeTypes {
    }
}

