/*
 * Decompiled with CFR 0.152.
 */
package android.view.accessibility;

import android.annotation.RequiresPermission;
import android.annotation.SystemApi;
import android.compat.annotation.UnsupportedAppUsage;
import android.content.ContentResolver;
import android.content.Context;
import android.content.res.Resources;
import android.database.ContentObserver;
import android.graphics.Typeface;
import android.net.Uri;
import android.os.Handler;
import android.provider.Settings;
import android.text.TextUtils;
import android.view.accessibility.AccessibilityManager;
import java.util.ArrayList;
import java.util.Locale;

public class CaptioningManager {
    private static final int DEFAULT_ENABLED = 0;
    private static final boolean SYSTEM_AUDIO_CAPTIONING_DEFAULT_ENABLED = false;
    private static final int DEFAULT_PRESET = 0;
    private static final float DEFAULT_FONT_SCALE = 1.0f;
    private final ArrayList<CaptioningChangeListener> mListeners = new ArrayList();
    private final ContentResolver mContentResolver;
    private final ContentObserver mContentObserver;
    private final Resources mResources;
    private final Context mContext;
    private final AccessibilityManager mAccessibilityManager;
    private final Runnable mStyleChangedRunnable = new Runnable(){

        @Override
        public void run() {
            CaptioningManager.this.notifyUserStyleChanged();
        }
    };

    public CaptioningManager(Context context) {
        this.mContext = context;
        this.mContentResolver = context.getContentResolver();
        this.mAccessibilityManager = this.mContext.getSystemService(AccessibilityManager.class);
        Handler handler = new Handler(context.getMainLooper());
        this.mContentObserver = new MyContentObserver(handler);
        this.mResources = context.getResources();
    }

    public boolean isEnabled() {
        return Settings.Secure.getInt(this.mContentResolver, "accessibility_captioning_enabled", 0) == 1;
    }

    public String getRawLocale() {
        return Settings.Secure.getString(this.mContentResolver, "accessibility_captioning_locale");
    }

    public Locale getLocale() {
        String rawLocale = this.getRawLocale();
        if (!TextUtils.isEmpty(rawLocale)) {
            String[] splitLocale = rawLocale.split("_");
            switch (splitLocale.length) {
                case 3: {
                    return new Locale(splitLocale[0], splitLocale[1], splitLocale[2]);
                }
                case 2: {
                    return new Locale(splitLocale[0], splitLocale[1]);
                }
                case 1: {
                    return new Locale(splitLocale[0]);
                }
            }
        }
        return null;
    }

    public float getFontScale() {
        return Settings.Secure.getFloat(this.mContentResolver, "accessibility_captioning_font_scale", 1.0f);
    }

    public int getRawUserStyle() {
        return Settings.Secure.getInt(this.mContentResolver, "accessibility_captioning_preset", 0);
    }

    public CaptionStyle getUserStyle() {
        int preset = this.getRawUserStyle();
        if (preset == -1) {
            return CaptionStyle.getCustomStyle(this.mContentResolver);
        }
        return CaptionStyle.PRESETS[preset];
    }

    public boolean isSystemAudioCaptioningEnabled() {
        return Settings.Secure.getIntForUser(this.mContentResolver, "odi_captions_enabled", 0, this.mContext.getUserId()) == 1;
    }

    @SystemApi
    @RequiresPermission(value="android.permission.SET_SYSTEM_AUDIO_CAPTION")
    public void setSystemAudioCaptioningEnabled(boolean isEnabled) {
        if (this.mAccessibilityManager != null) {
            this.mAccessibilityManager.setSystemAudioCaptioningEnabled(isEnabled, this.mContext.getUserId());
        }
    }

    public boolean isSystemAudioCaptioningUiEnabled() {
        return this.mAccessibilityManager != null && this.mAccessibilityManager.isSystemAudioCaptioningUiEnabled(this.mContext.getUserId());
    }

    @SystemApi
    @RequiresPermission(value="android.permission.SET_SYSTEM_AUDIO_CAPTION")
    public void setSystemAudioCaptioningUiEnabled(boolean isEnabled) {
        if (this.mAccessibilityManager != null) {
            this.mAccessibilityManager.setSystemAudioCaptioningUiEnabled(isEnabled, this.mContext.getUserId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCaptioningChangeListener(CaptioningChangeListener listener2) {
        ArrayList<CaptioningChangeListener> arrayList = this.mListeners;
        synchronized (arrayList) {
            if (this.mListeners.isEmpty()) {
                this.registerObserver("accessibility_captioning_enabled");
                this.registerObserver("accessibility_captioning_foreground_color");
                this.registerObserver("accessibility_captioning_background_color");
                this.registerObserver("accessibility_captioning_window_color");
                this.registerObserver("accessibility_captioning_edge_type");
                this.registerObserver("accessibility_captioning_edge_color");
                this.registerObserver("accessibility_captioning_typeface");
                this.registerObserver("accessibility_captioning_font_scale");
                this.registerObserver("accessibility_captioning_locale");
                this.registerObserver("accessibility_captioning_preset");
                this.registerObserver("odi_captions_enabled");
                this.registerObserver("odi_captions_volume_ui_enabled");
            }
            this.mListeners.add(listener2);
        }
    }

    private void registerObserver(String key) {
        this.mContentResolver.registerContentObserver(Settings.Secure.getUriFor(key), false, this.mContentObserver);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCaptioningChangeListener(CaptioningChangeListener listener2) {
        ArrayList<CaptioningChangeListener> arrayList = this.mListeners;
        synchronized (arrayList) {
            this.mListeners.remove(listener2);
            if (this.mListeners.isEmpty()) {
                this.mContentResolver.unregisterContentObserver(this.mContentObserver);
            }
        }
    }

    public boolean isCallCaptioningEnabled() {
        try {
            return this.mResources.getBoolean(17891795);
        }
        catch (Resources.NotFoundException e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyEnabledChanged() {
        boolean enabled = this.isEnabled();
        ArrayList<CaptioningChangeListener> arrayList = this.mListeners;
        synchronized (arrayList) {
            for (CaptioningChangeListener listener2 : this.mListeners) {
                listener2.onEnabledChanged(enabled);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyUserStyleChanged() {
        CaptionStyle userStyle = this.getUserStyle();
        ArrayList<CaptioningChangeListener> arrayList = this.mListeners;
        synchronized (arrayList) {
            for (CaptioningChangeListener listener2 : this.mListeners) {
                listener2.onUserStyleChanged(userStyle);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyLocaleChanged() {
        Locale locale = this.getLocale();
        ArrayList<CaptioningChangeListener> arrayList = this.mListeners;
        synchronized (arrayList) {
            for (CaptioningChangeListener listener2 : this.mListeners) {
                listener2.onLocaleChanged(locale);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyFontScaleChanged() {
        float fontScale = this.getFontScale();
        ArrayList<CaptioningChangeListener> arrayList = this.mListeners;
        synchronized (arrayList) {
            for (CaptioningChangeListener listener2 : this.mListeners) {
                listener2.onFontScaleChanged(fontScale);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifySystemAudioCaptionChanged() {
        boolean enabled = this.isSystemAudioCaptioningEnabled();
        ArrayList<CaptioningChangeListener> arrayList = this.mListeners;
        synchronized (arrayList) {
            for (CaptioningChangeListener listener2 : this.mListeners) {
                listener2.onSystemAudioCaptioningChanged(enabled);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifySystemAudioCaptionUiChanged() {
        boolean enabled = this.isSystemAudioCaptioningUiEnabled();
        ArrayList<CaptioningChangeListener> arrayList = this.mListeners;
        synchronized (arrayList) {
            for (CaptioningChangeListener listener2 : this.mListeners) {
                listener2.onSystemAudioCaptioningUiChanged(enabled);
            }
        }
    }

    public static interface SystemAudioCaptioningAccessing {
        public void setSystemAudioCaptioningEnabled(boolean var1, int var2);

        public boolean isSystemAudioCaptioningUiEnabled(int var1);

        public void setSystemAudioCaptioningUiEnabled(boolean var1, int var2);
    }

    public static abstract class CaptioningChangeListener {
        public void onEnabledChanged(boolean enabled) {
        }

        public void onUserStyleChanged(CaptionStyle userStyle) {
        }

        public void onLocaleChanged(Locale locale) {
        }

        public void onFontScaleChanged(float fontScale) {
        }

        public void onSystemAudioCaptioningChanged(boolean enabled) {
        }

        public void onSystemAudioCaptioningUiChanged(boolean enabled) {
        }
    }

    public static class CaptionStyle {
        private static final int COLOR_NONE_OPAQUE = 255;
        public static final int COLOR_UNSPECIFIED = 0xFFFFFF;
        private static final CaptionStyle WHITE_ON_BLACK = new CaptionStyle(-1, -16777216, 0, -16777216, 255, null);
        private static final CaptionStyle BLACK_ON_WHITE = new CaptionStyle(-16777216, -1, 0, -16777216, 255, null);
        private static final CaptionStyle YELLOW_ON_BLACK = new CaptionStyle(-256, -16777216, 0, -16777216, 255, null);
        private static final CaptionStyle YELLOW_ON_BLUE = new CaptionStyle(-256, -16776961, 0, -16777216, 255, null);
        private static final CaptionStyle DEFAULT_CUSTOM;
        private static final CaptionStyle UNSPECIFIED;
        public static final CaptionStyle DEFAULT;
        @UnsupportedAppUsage
        public static final CaptionStyle[] PRESETS;
        public static final int PRESET_CUSTOM = -1;
        public static final int EDGE_TYPE_UNSPECIFIED = -1;
        public static final int EDGE_TYPE_NONE = 0;
        public static final int EDGE_TYPE_OUTLINE = 1;
        public static final int EDGE_TYPE_DROP_SHADOW = 2;
        public static final int EDGE_TYPE_RAISED = 3;
        public static final int EDGE_TYPE_DEPRESSED = 4;
        public final int foregroundColor;
        public final int backgroundColor;
        public final int edgeType;
        public final int edgeColor;
        public final int windowColor;
        public final String mRawTypeface;
        private final boolean mHasForegroundColor;
        private final boolean mHasBackgroundColor;
        private final boolean mHasEdgeType;
        private final boolean mHasEdgeColor;
        private final boolean mHasWindowColor;
        private Typeface mParsedTypeface;

        private CaptionStyle(int foregroundColor, int backgroundColor, int edgeType, int edgeColor, int windowColor, String rawTypeface) {
            this.mHasForegroundColor = CaptionStyle.hasColor(foregroundColor);
            this.mHasBackgroundColor = CaptionStyle.hasColor(backgroundColor);
            this.mHasEdgeType = edgeType != -1;
            this.mHasEdgeColor = CaptionStyle.hasColor(edgeColor);
            this.mHasWindowColor = CaptionStyle.hasColor(windowColor);
            this.foregroundColor = this.mHasForegroundColor ? foregroundColor : -1;
            this.backgroundColor = this.mHasBackgroundColor ? backgroundColor : -16777216;
            this.edgeType = this.mHasEdgeType ? edgeType : 0;
            this.edgeColor = this.mHasEdgeColor ? edgeColor : -16777216;
            this.windowColor = this.mHasWindowColor ? windowColor : 255;
            this.mRawTypeface = rawTypeface;
        }

        public static boolean hasColor(int packedColor) {
            return packedColor >>> 24 != 0 || (packedColor & 0xFFFF00) == 0;
        }

        public CaptionStyle applyStyle(CaptionStyle overlay) {
            int newForegroundColor = overlay.hasForegroundColor() ? overlay.foregroundColor : this.foregroundColor;
            int newBackgroundColor = overlay.hasBackgroundColor() ? overlay.backgroundColor : this.backgroundColor;
            int newEdgeType = overlay.hasEdgeType() ? overlay.edgeType : this.edgeType;
            int newEdgeColor = overlay.hasEdgeColor() ? overlay.edgeColor : this.edgeColor;
            int newWindowColor = overlay.hasWindowColor() ? overlay.windowColor : this.windowColor;
            String newRawTypeface = overlay.mRawTypeface != null ? overlay.mRawTypeface : this.mRawTypeface;
            return new CaptionStyle(newForegroundColor, newBackgroundColor, newEdgeType, newEdgeColor, newWindowColor, newRawTypeface);
        }

        public boolean hasBackgroundColor() {
            return this.mHasBackgroundColor;
        }

        public boolean hasForegroundColor() {
            return this.mHasForegroundColor;
        }

        public boolean hasEdgeType() {
            return this.mHasEdgeType;
        }

        public boolean hasEdgeColor() {
            return this.mHasEdgeColor;
        }

        public boolean hasWindowColor() {
            return this.mHasWindowColor;
        }

        public Typeface getTypeface() {
            if (this.mParsedTypeface == null && !TextUtils.isEmpty(this.mRawTypeface)) {
                this.mParsedTypeface = Typeface.create(this.mRawTypeface, 0);
            }
            return this.mParsedTypeface;
        }

        public static CaptionStyle getCustomStyle(ContentResolver cr) {
            CaptionStyle defStyle = DEFAULT_CUSTOM;
            int foregroundColor = Settings.Secure.getInt(cr, "accessibility_captioning_foreground_color", defStyle.foregroundColor);
            int backgroundColor = Settings.Secure.getInt(cr, "accessibility_captioning_background_color", defStyle.backgroundColor);
            int edgeType = Settings.Secure.getInt(cr, "accessibility_captioning_edge_type", defStyle.edgeType);
            int edgeColor = Settings.Secure.getInt(cr, "accessibility_captioning_edge_color", defStyle.edgeColor);
            int windowColor = Settings.Secure.getInt(cr, "accessibility_captioning_window_color", defStyle.windowColor);
            String rawTypeface = Settings.Secure.getString(cr, "accessibility_captioning_typeface");
            if (rawTypeface == null) {
                rawTypeface = defStyle.mRawTypeface;
            }
            return new CaptionStyle(foregroundColor, backgroundColor, edgeType, edgeColor, windowColor, rawTypeface);
        }

        static {
            UNSPECIFIED = new CaptionStyle(0xFFFFFF, 0xFFFFFF, -1, 0xFFFFFF, 0xFFFFFF, null);
            PRESETS = new CaptionStyle[]{WHITE_ON_BLACK, BLACK_ON_WHITE, YELLOW_ON_BLACK, YELLOW_ON_BLUE, UNSPECIFIED};
            DEFAULT_CUSTOM = WHITE_ON_BLACK;
            DEFAULT = WHITE_ON_BLACK;
        }
    }

    private class MyContentObserver
    extends ContentObserver {
        private final Handler mHandler;

        public MyContentObserver(Handler handler) {
            super(handler);
            this.mHandler = handler;
        }

        @Override
        public void onChange(boolean selfChange, Uri uri) {
            String uriPath = uri.getPath();
            String name = uriPath.substring(uriPath.lastIndexOf(47) + 1);
            if ("accessibility_captioning_enabled".equals(name)) {
                CaptioningManager.this.notifyEnabledChanged();
            } else if ("accessibility_captioning_locale".equals(name)) {
                CaptioningManager.this.notifyLocaleChanged();
            } else if ("accessibility_captioning_font_scale".equals(name)) {
                CaptioningManager.this.notifyFontScaleChanged();
            } else if ("odi_captions_enabled".equals(name)) {
                CaptioningManager.this.notifySystemAudioCaptionChanged();
            } else if ("odi_captions_volume_ui_enabled".equals(name)) {
                CaptioningManager.this.notifySystemAudioCaptionUiChanged();
            } else {
                this.mHandler.removeCallbacks(CaptioningManager.this.mStyleChangedRunnable);
                this.mHandler.post(CaptioningManager.this.mStyleChangedRunnable);
            }
        }
    }
}

