/*
 * Decompiled with CFR 0.152.
 */
package android.view.accessibility;

import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;

public interface IAccessibilityEmbeddedConnection
extends IInterface {
    public static final String DESCRIPTOR = "android.view.accessibility.IAccessibilityEmbeddedConnection";

    public IBinder associateEmbeddedHierarchy(IBinder var1, int var2) throws RemoteException;

    public void disassociateEmbeddedHierarchy() throws RemoteException;

    public void setWindowMatrix(float[] var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IAccessibilityEmbeddedConnection {
        static final int TRANSACTION_associateEmbeddedHierarchy = 1;
        static final int TRANSACTION_disassociateEmbeddedHierarchy = 2;
        static final int TRANSACTION_setWindowMatrix = 3;

        public Stub() {
            this.attachInterface(this, IAccessibilityEmbeddedConnection.DESCRIPTOR);
        }

        public static IAccessibilityEmbeddedConnection asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IAccessibilityEmbeddedConnection.DESCRIPTOR);
            if (iin != null && iin instanceof IAccessibilityEmbeddedConnection) {
                return (IAccessibilityEmbeddedConnection)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "associateEmbeddedHierarchy";
                }
                case 2: {
                    return "disassociateEmbeddedHierarchy";
                }
                case 3: {
                    return "setWindowMatrix";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IAccessibilityEmbeddedConnection.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    IBinder _arg0 = data.readStrongBinder();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    IBinder _result = this.associateEmbeddedHierarchy(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeStrongBinder(_result);
                    break;
                }
                case 2: {
                    this.disassociateEmbeddedHierarchy();
                    reply.writeNoException();
                    break;
                }
                case 3: {
                    float[] _arg0 = data.createFloatArray();
                    data.enforceNoDataAvail();
                    this.setWindowMatrix(_arg0);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 2;
        }

        private static class Proxy
        implements IAccessibilityEmbeddedConnection {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IAccessibilityEmbeddedConnection.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public IBinder associateEmbeddedHierarchy(IBinder hostToken, int sourceId) throws RemoteException {
                IBinder _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IAccessibilityEmbeddedConnection.DESCRIPTOR);
                    _data.writeStrongBinder(hostToken);
                    _data.writeInt(sourceId);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readStrongBinder();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void disassociateEmbeddedHierarchy() throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IAccessibilityEmbeddedConnection.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setWindowMatrix(float[] matrixValues) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IAccessibilityEmbeddedConnection.DESCRIPTOR);
                    _data.writeFloatArray(matrixValues);
                    boolean bl = this.mRemote.transact(3, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IAccessibilityEmbeddedConnection {
        @Override
        public IBinder associateEmbeddedHierarchy(IBinder hostToken, int sourceId) throws RemoteException {
            return null;
        }

        @Override
        public void disassociateEmbeddedHierarchy() throws RemoteException {
        }

        @Override
        public void setWindowMatrix(float[] matrixValues) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

