/*
 * Decompiled with CFR 0.152.
 */
package android.view.accessibility;

import android.accessibilityservice.AccessibilityServiceInfo;
import android.accessibilityservice.IAccessibilityServiceClient;
import android.annotation.RequiresPermission;
import android.app.RemoteAction;
import android.compat.annotation.UnsupportedAppUsage;
import android.content.ComponentName;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import android.view.IWindow;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.IAccessibilityInteractionConnection;
import android.view.accessibility.IAccessibilityManagerClient;
import android.view.accessibility.IWindowMagnificationConnection;
import java.util.ArrayList;
import java.util.List;

public interface IAccessibilityManager
extends IInterface {
    public void interrupt(int var1) throws RemoteException;

    public void sendAccessibilityEvent(AccessibilityEvent var1, int var2) throws RemoteException;

    public long addClient(IAccessibilityManagerClient var1, int var2) throws RemoteException;

    public boolean removeClient(IAccessibilityManagerClient var1, int var2) throws RemoteException;

    public List<AccessibilityServiceInfo> getInstalledAccessibilityServiceList(int var1) throws RemoteException;

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L, overrideSourcePosition="frameworks/base/core/java/android/view/accessibility/IAccessibilityManager.aidl:49:1:49:69")
    public List<AccessibilityServiceInfo> getEnabledAccessibilityServiceList(int var1, int var2) throws RemoteException;

    public int addAccessibilityInteractionConnection(IWindow var1, IBinder var2, IAccessibilityInteractionConnection var3, String var4, int var5) throws RemoteException;

    public void removeAccessibilityInteractionConnection(IWindow var1) throws RemoteException;

    public void setPictureInPictureActionReplacingConnection(IAccessibilityInteractionConnection var1) throws RemoteException;

    public void registerUiTestAutomationService(IBinder var1, IAccessibilityServiceClient var2, AccessibilityServiceInfo var3, int var4) throws RemoteException;

    public void unregisterUiTestAutomationService(IAccessibilityServiceClient var1) throws RemoteException;

    public void temporaryEnableAccessibilityStateUntilKeyguardRemoved(ComponentName var1, boolean var2) throws RemoteException;

    public IBinder getWindowToken(int var1, int var2) throws RemoteException;

    public void notifyAccessibilityButtonClicked(int var1, String var2) throws RemoteException;

    public void notifyAccessibilityButtonVisibilityChanged(boolean var1) throws RemoteException;

    public void performAccessibilityShortcut(String var1) throws RemoteException;

    public List<String> getAccessibilityShortcutTargets(int var1) throws RemoteException;

    public boolean sendFingerprintGesture(int var1) throws RemoteException;

    public int getAccessibilityWindowId(IBinder var1) throws RemoteException;

    public long getRecommendedTimeoutMillis() throws RemoteException;

    public void registerSystemAction(RemoteAction var1, int var2) throws RemoteException;

    public void unregisterSystemAction(int var1) throws RemoteException;

    public void setWindowMagnificationConnection(IWindowMagnificationConnection var1) throws RemoteException;

    public void associateEmbeddedHierarchy(IBinder var1, IBinder var2) throws RemoteException;

    public void disassociateEmbeddedHierarchy(IBinder var1) throws RemoteException;

    public int getFocusStrokeWidth() throws RemoteException;

    public int getFocusColor() throws RemoteException;

    public boolean isAudioDescriptionByDefaultEnabled() throws RemoteException;

    @RequiresPermission(value="android.permission.SET_SYSTEM_AUDIO_CAPTION")
    public void setSystemAudioCaptioningEnabled(boolean var1, int var2) throws RemoteException;

    public boolean isSystemAudioCaptioningUiEnabled(int var1) throws RemoteException;

    @RequiresPermission(value="android.permission.SET_SYSTEM_AUDIO_CAPTION")
    public void setSystemAudioCaptioningUiEnabled(boolean var1, int var2) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IAccessibilityManager {
        public static final String DESCRIPTOR = "android.view.accessibility.IAccessibilityManager";
        static final int TRANSACTION_interrupt = 1;
        static final int TRANSACTION_sendAccessibilityEvent = 2;
        static final int TRANSACTION_addClient = 3;
        static final int TRANSACTION_removeClient = 4;
        static final int TRANSACTION_getInstalledAccessibilityServiceList = 5;
        static final int TRANSACTION_getEnabledAccessibilityServiceList = 6;
        static final int TRANSACTION_addAccessibilityInteractionConnection = 7;
        static final int TRANSACTION_removeAccessibilityInteractionConnection = 8;
        static final int TRANSACTION_setPictureInPictureActionReplacingConnection = 9;
        static final int TRANSACTION_registerUiTestAutomationService = 10;
        static final int TRANSACTION_unregisterUiTestAutomationService = 11;
        static final int TRANSACTION_temporaryEnableAccessibilityStateUntilKeyguardRemoved = 12;
        static final int TRANSACTION_getWindowToken = 13;
        static final int TRANSACTION_notifyAccessibilityButtonClicked = 14;
        static final int TRANSACTION_notifyAccessibilityButtonVisibilityChanged = 15;
        static final int TRANSACTION_performAccessibilityShortcut = 16;
        static final int TRANSACTION_getAccessibilityShortcutTargets = 17;
        static final int TRANSACTION_sendFingerprintGesture = 18;
        static final int TRANSACTION_getAccessibilityWindowId = 19;
        static final int TRANSACTION_getRecommendedTimeoutMillis = 20;
        static final int TRANSACTION_registerSystemAction = 21;
        static final int TRANSACTION_unregisterSystemAction = 22;
        static final int TRANSACTION_setWindowMagnificationConnection = 23;
        static final int TRANSACTION_associateEmbeddedHierarchy = 24;
        static final int TRANSACTION_disassociateEmbeddedHierarchy = 25;
        static final int TRANSACTION_getFocusStrokeWidth = 26;
        static final int TRANSACTION_getFocusColor = 27;
        static final int TRANSACTION_isAudioDescriptionByDefaultEnabled = 28;
        static final int TRANSACTION_setSystemAudioCaptioningEnabled = 29;
        static final int TRANSACTION_isSystemAudioCaptioningUiEnabled = 30;
        static final int TRANSACTION_setSystemAudioCaptioningUiEnabled = 31;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static IAccessibilityManager asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof IAccessibilityManager) {
                return (IAccessibilityManager)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "interrupt";
                }
                case 2: {
                    return "sendAccessibilityEvent";
                }
                case 3: {
                    return "addClient";
                }
                case 4: {
                    return "removeClient";
                }
                case 5: {
                    return "getInstalledAccessibilityServiceList";
                }
                case 6: {
                    return "getEnabledAccessibilityServiceList";
                }
                case 7: {
                    return "addAccessibilityInteractionConnection";
                }
                case 8: {
                    return "removeAccessibilityInteractionConnection";
                }
                case 9: {
                    return "setPictureInPictureActionReplacingConnection";
                }
                case 10: {
                    return "registerUiTestAutomationService";
                }
                case 11: {
                    return "unregisterUiTestAutomationService";
                }
                case 12: {
                    return "temporaryEnableAccessibilityStateUntilKeyguardRemoved";
                }
                case 13: {
                    return "getWindowToken";
                }
                case 14: {
                    return "notifyAccessibilityButtonClicked";
                }
                case 15: {
                    return "notifyAccessibilityButtonVisibilityChanged";
                }
                case 16: {
                    return "performAccessibilityShortcut";
                }
                case 17: {
                    return "getAccessibilityShortcutTargets";
                }
                case 18: {
                    return "sendFingerprintGesture";
                }
                case 19: {
                    return "getAccessibilityWindowId";
                }
                case 20: {
                    return "getRecommendedTimeoutMillis";
                }
                case 21: {
                    return "registerSystemAction";
                }
                case 22: {
                    return "unregisterSystemAction";
                }
                case 23: {
                    return "setWindowMagnificationConnection";
                }
                case 24: {
                    return "associateEmbeddedHierarchy";
                }
                case 25: {
                    return "disassociateEmbeddedHierarchy";
                }
                case 26: {
                    return "getFocusStrokeWidth";
                }
                case 27: {
                    return "getFocusColor";
                }
                case 28: {
                    return "isAudioDescriptionByDefaultEnabled";
                }
                case 29: {
                    return "setSystemAudioCaptioningEnabled";
                }
                case 30: {
                    return "isSystemAudioCaptioningUiEnabled";
                }
                case 31: {
                    return "setSystemAudioCaptioningUiEnabled";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.interrupt(_arg0);
                    break;
                }
                case 2: {
                    AccessibilityEvent _arg0 = data.readTypedObject(AccessibilityEvent.CREATOR);
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.sendAccessibilityEvent(_arg0, _arg1);
                    break;
                }
                case 3: {
                    IAccessibilityManagerClient _arg0 = IAccessibilityManagerClient.Stub.asInterface(data.readStrongBinder());
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    long _result = this.addClient(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeLong(_result);
                    break;
                }
                case 4: {
                    IAccessibilityManagerClient _arg0 = IAccessibilityManagerClient.Stub.asInterface(data.readStrongBinder());
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    boolean _result = this.removeClient(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 5: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    List<AccessibilityServiceInfo> _result = this.getInstalledAccessibilityServiceList(_arg0);
                    reply.writeNoException();
                    reply.writeTypedList(_result);
                    break;
                }
                case 6: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    List<AccessibilityServiceInfo> _result = this.getEnabledAccessibilityServiceList(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeTypedList(_result);
                    break;
                }
                case 7: {
                    IWindow _arg0 = IWindow.Stub.asInterface(data.readStrongBinder());
                    IBinder _arg1 = data.readStrongBinder();
                    IAccessibilityInteractionConnection _arg2 = IAccessibilityInteractionConnection.Stub.asInterface(data.readStrongBinder());
                    String _arg3 = data.readString();
                    int _arg4 = data.readInt();
                    data.enforceNoDataAvail();
                    int _result = this.addAccessibilityInteractionConnection(_arg0, _arg1, _arg2, _arg3, _arg4);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 8: {
                    IWindow _arg0 = IWindow.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.removeAccessibilityInteractionConnection(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 9: {
                    IAccessibilityInteractionConnection _arg0 = IAccessibilityInteractionConnection.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.setPictureInPictureActionReplacingConnection(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 10: {
                    IBinder _arg0 = data.readStrongBinder();
                    IAccessibilityServiceClient _arg1 = IAccessibilityServiceClient.Stub.asInterface(data.readStrongBinder());
                    AccessibilityServiceInfo _arg2 = data.readTypedObject(AccessibilityServiceInfo.CREATOR);
                    int _arg3 = data.readInt();
                    data.enforceNoDataAvail();
                    this.registerUiTestAutomationService(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    break;
                }
                case 11: {
                    IAccessibilityServiceClient _arg0 = IAccessibilityServiceClient.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.unregisterUiTestAutomationService(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 12: {
                    ComponentName _arg0 = data.readTypedObject(ComponentName.CREATOR);
                    boolean _arg1 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.temporaryEnableAccessibilityStateUntilKeyguardRemoved(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 13: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    IBinder _result = this.getWindowToken(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeStrongBinder(_result);
                    break;
                }
                case 14: {
                    int _arg0 = data.readInt();
                    String _arg1 = data.readString();
                    data.enforceNoDataAvail();
                    this.notifyAccessibilityButtonClicked(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 15: {
                    boolean _arg0 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.notifyAccessibilityButtonVisibilityChanged(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 16: {
                    String _arg0 = data.readString();
                    data.enforceNoDataAvail();
                    this.performAccessibilityShortcut(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 17: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    List<String> _result = this.getAccessibilityShortcutTargets(_arg0);
                    reply.writeNoException();
                    reply.writeStringList(_result);
                    break;
                }
                case 18: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    boolean _result = this.sendFingerprintGesture(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 19: {
                    IBinder _arg0 = data.readStrongBinder();
                    data.enforceNoDataAvail();
                    int _result = this.getAccessibilityWindowId(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 20: {
                    long _result = this.getRecommendedTimeoutMillis();
                    reply.writeNoException();
                    reply.writeLong(_result);
                    break;
                }
                case 21: {
                    RemoteAction _arg0 = data.readTypedObject(RemoteAction.CREATOR);
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.registerSystemAction(_arg0, _arg1);
                    break;
                }
                case 22: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.unregisterSystemAction(_arg0);
                    break;
                }
                case 23: {
                    IWindowMagnificationConnection _arg0 = IWindowMagnificationConnection.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.setWindowMagnificationConnection(_arg0);
                    break;
                }
                case 24: {
                    IBinder _arg0 = data.readStrongBinder();
                    IBinder _arg1 = data.readStrongBinder();
                    data.enforceNoDataAvail();
                    this.associateEmbeddedHierarchy(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 25: {
                    IBinder _arg0 = data.readStrongBinder();
                    data.enforceNoDataAvail();
                    this.disassociateEmbeddedHierarchy(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 26: {
                    int _result = this.getFocusStrokeWidth();
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 27: {
                    int _result = this.getFocusColor();
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 28: {
                    boolean _result = this.isAudioDescriptionByDefaultEnabled();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 29: {
                    boolean _arg0 = data.readBoolean();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.setSystemAudioCaptioningEnabled(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 30: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    boolean _result = this.isSystemAudioCaptioningUiEnabled(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 31: {
                    boolean _arg0 = data.readBoolean();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.setSystemAudioCaptioningUiEnabled(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 30;
        }

        private static class Proxy
        implements IAccessibilityManager {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void interrupt(int userId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(userId);
                    boolean bl = this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void sendAccessibilityEvent(AccessibilityEvent uiEvent, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(uiEvent, 0);
                    _data.writeInt(userId);
                    boolean bl = this.mRemote.transact(2, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public long addClient(IAccessibilityManagerClient client, int userId) throws RemoteException {
                long _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(client);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(3, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readLong();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean removeClient(IAccessibilityManagerClient client, int userId) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(client);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(4, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<AccessibilityServiceInfo> getInstalledAccessibilityServiceList(int userId) throws RemoteException {
                ArrayList<AccessibilityServiceInfo> _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(5, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createTypedArrayList(AccessibilityServiceInfo.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<AccessibilityServiceInfo> getEnabledAccessibilityServiceList(int feedbackType, int userId) throws RemoteException {
                ArrayList<AccessibilityServiceInfo> _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(feedbackType);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(6, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createTypedArrayList(AccessibilityServiceInfo.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int addAccessibilityInteractionConnection(IWindow windowToken, IBinder leashToken, IAccessibilityInteractionConnection connection, String packageName, int userId) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(windowToken);
                    _data.writeStrongBinder(leashToken);
                    _data.writeStrongInterface(connection);
                    _data.writeString(packageName);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(7, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void removeAccessibilityInteractionConnection(IWindow windowToken) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(windowToken);
                    boolean _status = this.mRemote.transact(8, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setPictureInPictureActionReplacingConnection(IAccessibilityInteractionConnection connection) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(connection);
                    boolean _status = this.mRemote.transact(9, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerUiTestAutomationService(IBinder owner, IAccessibilityServiceClient client, AccessibilityServiceInfo info, int flags) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(owner);
                    _data.writeStrongInterface(client);
                    _data.writeTypedObject(info, 0);
                    _data.writeInt(flags);
                    boolean _status = this.mRemote.transact(10, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unregisterUiTestAutomationService(IAccessibilityServiceClient client) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(client);
                    boolean _status = this.mRemote.transact(11, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void temporaryEnableAccessibilityStateUntilKeyguardRemoved(ComponentName service, boolean touchExplorationEnabled) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(service, 0);
                    _data.writeBoolean(touchExplorationEnabled);
                    boolean _status = this.mRemote.transact(12, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public IBinder getWindowToken(int windowId, int userId) throws RemoteException {
                IBinder _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(windowId);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(13, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readStrongBinder();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void notifyAccessibilityButtonClicked(int displayId, String targetName) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    _data.writeString(targetName);
                    boolean _status = this.mRemote.transact(14, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void notifyAccessibilityButtonVisibilityChanged(boolean available) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(available);
                    boolean _status = this.mRemote.transact(15, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void performAccessibilityShortcut(String targetName) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(targetName);
                    boolean _status = this.mRemote.transact(16, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<String> getAccessibilityShortcutTargets(int shortcutType) throws RemoteException {
                ArrayList<String> _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(shortcutType);
                    boolean _status = this.mRemote.transact(17, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createStringArrayList();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean sendFingerprintGesture(int gestureKeyCode) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(gestureKeyCode);
                    boolean _status = this.mRemote.transact(18, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getAccessibilityWindowId(IBinder windowToken) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(windowToken);
                    boolean _status = this.mRemote.transact(19, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public long getRecommendedTimeoutMillis() throws RemoteException {
                long _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(20, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readLong();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerSystemAction(RemoteAction action2, int actionId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(action2, 0);
                    _data.writeInt(actionId);
                    boolean bl = this.mRemote.transact(21, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unregisterSystemAction(int actionId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(actionId);
                    boolean bl = this.mRemote.transact(22, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setWindowMagnificationConnection(IWindowMagnificationConnection connection) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(connection);
                    boolean bl = this.mRemote.transact(23, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void associateEmbeddedHierarchy(IBinder host, IBinder embedded) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(host);
                    _data.writeStrongBinder(embedded);
                    boolean _status = this.mRemote.transact(24, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void disassociateEmbeddedHierarchy(IBinder token) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(token);
                    boolean _status = this.mRemote.transact(25, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getFocusStrokeWidth() throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(26, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getFocusColor() throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(27, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isAudioDescriptionByDefaultEnabled() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(28, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setSystemAudioCaptioningEnabled(boolean isEnabled, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(isEnabled);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(29, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isSystemAudioCaptioningUiEnabled(int userId) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(30, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setSystemAudioCaptioningUiEnabled(boolean isEnabled, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(isEnabled);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(31, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IAccessibilityManager {
        @Override
        public void interrupt(int userId) throws RemoteException {
        }

        @Override
        public void sendAccessibilityEvent(AccessibilityEvent uiEvent, int userId) throws RemoteException {
        }

        @Override
        public long addClient(IAccessibilityManagerClient client, int userId) throws RemoteException {
            return 0L;
        }

        @Override
        public boolean removeClient(IAccessibilityManagerClient client, int userId) throws RemoteException {
            return false;
        }

        @Override
        public List<AccessibilityServiceInfo> getInstalledAccessibilityServiceList(int userId) throws RemoteException {
            return null;
        }

        @Override
        public List<AccessibilityServiceInfo> getEnabledAccessibilityServiceList(int feedbackType, int userId) throws RemoteException {
            return null;
        }

        @Override
        public int addAccessibilityInteractionConnection(IWindow windowToken, IBinder leashToken, IAccessibilityInteractionConnection connection, String packageName, int userId) throws RemoteException {
            return 0;
        }

        @Override
        public void removeAccessibilityInteractionConnection(IWindow windowToken) throws RemoteException {
        }

        @Override
        public void setPictureInPictureActionReplacingConnection(IAccessibilityInteractionConnection connection) throws RemoteException {
        }

        @Override
        public void registerUiTestAutomationService(IBinder owner, IAccessibilityServiceClient client, AccessibilityServiceInfo info, int flags) throws RemoteException {
        }

        @Override
        public void unregisterUiTestAutomationService(IAccessibilityServiceClient client) throws RemoteException {
        }

        @Override
        public void temporaryEnableAccessibilityStateUntilKeyguardRemoved(ComponentName service, boolean touchExplorationEnabled) throws RemoteException {
        }

        @Override
        public IBinder getWindowToken(int windowId, int userId) throws RemoteException {
            return null;
        }

        @Override
        public void notifyAccessibilityButtonClicked(int displayId, String targetName) throws RemoteException {
        }

        @Override
        public void notifyAccessibilityButtonVisibilityChanged(boolean available) throws RemoteException {
        }

        @Override
        public void performAccessibilityShortcut(String targetName) throws RemoteException {
        }

        @Override
        public List<String> getAccessibilityShortcutTargets(int shortcutType) throws RemoteException {
            return null;
        }

        @Override
        public boolean sendFingerprintGesture(int gestureKeyCode) throws RemoteException {
            return false;
        }

        @Override
        public int getAccessibilityWindowId(IBinder windowToken) throws RemoteException {
            return 0;
        }

        @Override
        public long getRecommendedTimeoutMillis() throws RemoteException {
            return 0L;
        }

        @Override
        public void registerSystemAction(RemoteAction action2, int actionId) throws RemoteException {
        }

        @Override
        public void unregisterSystemAction(int actionId) throws RemoteException {
        }

        @Override
        public void setWindowMagnificationConnection(IWindowMagnificationConnection connection) throws RemoteException {
        }

        @Override
        public void associateEmbeddedHierarchy(IBinder host, IBinder embedded) throws RemoteException {
        }

        @Override
        public void disassociateEmbeddedHierarchy(IBinder token) throws RemoteException {
        }

        @Override
        public int getFocusStrokeWidth() throws RemoteException {
            return 0;
        }

        @Override
        public int getFocusColor() throws RemoteException {
            return 0;
        }

        @Override
        public boolean isAudioDescriptionByDefaultEnabled() throws RemoteException {
            return false;
        }

        @Override
        public void setSystemAudioCaptioningEnabled(boolean isEnabled, int userId) throws RemoteException {
        }

        @Override
        public boolean isSystemAudioCaptioningUiEnabled(int userId) throws RemoteException {
            return false;
        }

        @Override
        public void setSystemAudioCaptioningUiEnabled(boolean isEnabled, int userId) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

