/*
 * Decompiled with CFR 0.152.
 */
package android.view.accessibility;

import android.graphics.Rect;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;

public interface IWindowMagnificationConnectionCallback
extends IInterface {
    public static final String DESCRIPTOR = "android.view.accessibility.IWindowMagnificationConnectionCallback";

    public void onWindowMagnifierBoundsChanged(int var1, Rect var2) throws RemoteException;

    public void onChangeMagnificationMode(int var1, int var2) throws RemoteException;

    public void onSourceBoundsChanged(int var1, Rect var2) throws RemoteException;

    public void onPerformScaleAction(int var1, float var2) throws RemoteException;

    public void onAccessibilityActionPerformed(int var1) throws RemoteException;

    public void onMove(int var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IWindowMagnificationConnectionCallback {
        static final int TRANSACTION_onWindowMagnifierBoundsChanged = 1;
        static final int TRANSACTION_onChangeMagnificationMode = 2;
        static final int TRANSACTION_onSourceBoundsChanged = 3;
        static final int TRANSACTION_onPerformScaleAction = 4;
        static final int TRANSACTION_onAccessibilityActionPerformed = 5;
        static final int TRANSACTION_onMove = 6;

        public Stub() {
            this.attachInterface(this, IWindowMagnificationConnectionCallback.DESCRIPTOR);
        }

        public static IWindowMagnificationConnectionCallback asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IWindowMagnificationConnectionCallback.DESCRIPTOR);
            if (iin != null && iin instanceof IWindowMagnificationConnectionCallback) {
                return (IWindowMagnificationConnectionCallback)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "onWindowMagnifierBoundsChanged";
                }
                case 2: {
                    return "onChangeMagnificationMode";
                }
                case 3: {
                    return "onSourceBoundsChanged";
                }
                case 4: {
                    return "onPerformScaleAction";
                }
                case 5: {
                    return "onAccessibilityActionPerformed";
                }
                case 6: {
                    return "onMove";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IWindowMagnificationConnectionCallback.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    int _arg0 = data.readInt();
                    Rect _arg1 = data.readTypedObject(Rect.CREATOR);
                    data.enforceNoDataAvail();
                    this.onWindowMagnifierBoundsChanged(_arg0, _arg1);
                    break;
                }
                case 2: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onChangeMagnificationMode(_arg0, _arg1);
                    break;
                }
                case 3: {
                    int _arg0 = data.readInt();
                    Rect _arg1 = data.readTypedObject(Rect.CREATOR);
                    data.enforceNoDataAvail();
                    this.onSourceBoundsChanged(_arg0, _arg1);
                    break;
                }
                case 4: {
                    int _arg0 = data.readInt();
                    float _arg1 = data.readFloat();
                    data.enforceNoDataAvail();
                    this.onPerformScaleAction(_arg0, _arg1);
                    break;
                }
                case 5: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onAccessibilityActionPerformed(_arg0);
                    break;
                }
                case 6: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onMove(_arg0);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 5;
        }

        private static class Proxy
        implements IWindowMagnificationConnectionCallback {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IWindowMagnificationConnectionCallback.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onWindowMagnifierBoundsChanged(int displayId, Rect bounds2) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IWindowMagnificationConnectionCallback.DESCRIPTOR);
                    _data.writeInt(displayId);
                    _data.writeTypedObject(bounds2, 0);
                    boolean bl = this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onChangeMagnificationMode(int displayId, int magnificationMode) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IWindowMagnificationConnectionCallback.DESCRIPTOR);
                    _data.writeInt(displayId);
                    _data.writeInt(magnificationMode);
                    boolean bl = this.mRemote.transact(2, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onSourceBoundsChanged(int displayId, Rect sourceBounds) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IWindowMagnificationConnectionCallback.DESCRIPTOR);
                    _data.writeInt(displayId);
                    _data.writeTypedObject(sourceBounds, 0);
                    boolean bl = this.mRemote.transact(3, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onPerformScaleAction(int displayId, float scale) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IWindowMagnificationConnectionCallback.DESCRIPTOR);
                    _data.writeInt(displayId);
                    _data.writeFloat(scale);
                    boolean bl = this.mRemote.transact(4, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onAccessibilityActionPerformed(int displayId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IWindowMagnificationConnectionCallback.DESCRIPTOR);
                    _data.writeInt(displayId);
                    boolean bl = this.mRemote.transact(5, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onMove(int displayId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IWindowMagnificationConnectionCallback.DESCRIPTOR);
                    _data.writeInt(displayId);
                    boolean bl = this.mRemote.transact(6, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IWindowMagnificationConnectionCallback {
        @Override
        public void onWindowMagnifierBoundsChanged(int displayId, Rect bounds2) throws RemoteException {
        }

        @Override
        public void onChangeMagnificationMode(int displayId, int magnificationMode) throws RemoteException {
        }

        @Override
        public void onSourceBoundsChanged(int displayId, Rect sourceBounds) throws RemoteException {
        }

        @Override
        public void onPerformScaleAction(int displayId, float scale) throws RemoteException {
        }

        @Override
        public void onAccessibilityActionPerformed(int displayId) throws RemoteException {
        }

        @Override
        public void onMove(int displayId) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

