/*
 * Decompiled with CFR 0.152.
 */
package android.view.animation;

import android.compat.annotation.UnsupportedAppUsage;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.RectF;
import android.os.Handler;
import android.os.SystemProperties;
import android.util.AttributeSet;
import android.util.TypedValue;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.view.animation.AnimationUtils;
import android.view.animation.Interpolator;
import android.view.animation.Transformation;
import com.android.internal.R;
import dalvik.system.CloseGuard;

public abstract class Animation
implements Cloneable {
    public static final int INFINITE = -1;
    public static final int RESTART = 1;
    public static final int REVERSE = 2;
    public static final int START_ON_FIRST_FRAME = -1;
    public static final int ABSOLUTE = 0;
    public static final int RELATIVE_TO_SELF = 1;
    public static final int RELATIVE_TO_PARENT = 2;
    public static final int ZORDER_NORMAL = 0;
    public static final int ZORDER_TOP = 1;
    public static final int ZORDER_BOTTOM = -1;
    boolean mEnded = false;
    boolean mStarted = false;
    boolean mCycleFlip = false;
    boolean mInitialized = false;
    boolean mFillBefore = true;
    boolean mFillAfter = false;
    boolean mFillEnabled = false;
    long mStartTime = -1L;
    long mStartOffset;
    long mDuration;
    int mRepeatCount = 0;
    int mRepeated = 0;
    int mRepeatMode = 1;
    Interpolator mInterpolator;
    @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=117519981L)
    private AnimationListener mListener;
    private int mZAdjustment;
    private int mBackdropColor;
    private float mScaleFactor = 1.0f;
    private boolean mShowWallpaper;
    private boolean mHasRoundedCorners;
    private boolean mShowBackdrop;
    private boolean mMore = true;
    private boolean mOneMoreTime = true;
    @UnsupportedAppUsage
    RectF mPreviousRegion = new RectF();
    @UnsupportedAppUsage
    RectF mRegion = new RectF();
    @UnsupportedAppUsage
    Transformation mTransformation = new Transformation();
    @UnsupportedAppUsage
    Transformation mPreviousTransformation = new Transformation();
    private final CloseGuard guard = CloseGuard.get();
    private Handler mListenerHandler;
    private Runnable mOnStart;
    private Runnable mOnRepeat;
    private Runnable mOnEnd;

    public Animation() {
        this.ensureInterpolator();
    }

    public Animation(Context context, AttributeSet attrs) {
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.Animation);
        this.setDuration(a.getInt(2, 0));
        this.setStartOffset(a.getInt(5, 0));
        this.setFillEnabled(a.getBoolean(9, this.mFillEnabled));
        this.setFillBefore(a.getBoolean(3, this.mFillBefore));
        this.setFillAfter(a.getBoolean(4, this.mFillAfter));
        this.setRepeatCount(a.getInt(6, this.mRepeatCount));
        this.setRepeatMode(a.getInt(7, 1));
        this.setZAdjustment(a.getInt(8, 0));
        this.setBackdropColor(a.getInt(12, 0));
        this.setDetachWallpaper(a.getBoolean(10, false));
        this.setShowWallpaper(a.getBoolean(14, false));
        this.setHasRoundedCorners(a.getBoolean(13, false));
        this.setShowBackdrop(a.getBoolean(11, false));
        int resID = a.getResourceId(1, 0);
        a.recycle();
        if (resID > 0) {
            this.setInterpolator(context, resID);
        }
        this.ensureInterpolator();
    }

    protected Animation clone() throws CloneNotSupportedException {
        Animation animation = (Animation)super.clone();
        animation.mPreviousRegion = new RectF();
        animation.mRegion = new RectF();
        animation.mTransformation = new Transformation();
        animation.mPreviousTransformation = new Transformation();
        return animation;
    }

    public void reset() {
        this.mPreviousRegion.setEmpty();
        this.mPreviousTransformation.clear();
        this.mInitialized = false;
        this.mCycleFlip = false;
        this.mRepeated = 0;
        this.mMore = true;
        this.mOneMoreTime = true;
        this.mListenerHandler = null;
    }

    public void cancel() {
        if (this.mStarted && !this.mEnded) {
            this.fireAnimationEnd();
            this.mEnded = true;
            this.guard.close();
        }
        this.mStartTime = Long.MIN_VALUE;
        this.mOneMoreTime = false;
        this.mMore = false;
    }

    @UnsupportedAppUsage
    public void detach() {
        if (this.mStarted && !this.mEnded) {
            this.mEnded = true;
            this.guard.close();
            this.fireAnimationEnd();
        }
    }

    public boolean isInitialized() {
        return this.mInitialized;
    }

    public void initialize(int width2, int height2, int parentWidth, int parentHeight) {
        this.reset();
        this.mInitialized = true;
    }

    public void setListenerHandler(Handler handler) {
        if (this.mListenerHandler == null) {
            this.mOnStart = new Runnable(){

                @Override
                public void run() {
                    Animation.this.dispatchAnimationStart();
                }
            };
            this.mOnRepeat = new Runnable(){

                @Override
                public void run() {
                    Animation.this.dispatchAnimationRepeat();
                }
            };
            this.mOnEnd = new Runnable(){

                @Override
                public void run() {
                    Animation.this.dispatchAnimationEnd();
                }
            };
        }
        this.mListenerHandler = handler;
    }

    public void setInterpolator(Context context, int resID) {
        this.setInterpolator(AnimationUtils.loadInterpolator(context, resID));
    }

    public void setInterpolator(Interpolator i) {
        this.mInterpolator = i;
    }

    public void setStartOffset(long startOffset) {
        this.mStartOffset = startOffset;
    }

    public void setDuration(long durationMillis) {
        if (durationMillis < 0L) {
            throw new IllegalArgumentException("Animation duration cannot be negative");
        }
        this.mDuration = durationMillis;
    }

    public void restrictDuration(long durationMillis) {
        if (this.mStartOffset > durationMillis) {
            this.mStartOffset = durationMillis;
            this.mDuration = 0L;
            this.mRepeatCount = 0;
            return;
        }
        long dur = this.mDuration + this.mStartOffset;
        if (dur > durationMillis) {
            this.mDuration = durationMillis - this.mStartOffset;
            dur = durationMillis;
        }
        if (this.mDuration <= 0L) {
            this.mDuration = 0L;
            this.mRepeatCount = 0;
            return;
        }
        if (this.mRepeatCount < 0 || (long)this.mRepeatCount > durationMillis || dur * (long)this.mRepeatCount > durationMillis) {
            this.mRepeatCount = (int)(durationMillis / dur) - 1;
            if (this.mRepeatCount < 0) {
                this.mRepeatCount = 0;
            }
        }
    }

    public void scaleCurrentDuration(float scale) {
        this.mDuration = (long)((float)this.mDuration * scale);
        this.mStartOffset = (long)((float)this.mStartOffset * scale);
    }

    public void setStartTime(long startTimeMillis) {
        this.mStartTime = startTimeMillis;
        this.mEnded = false;
        this.mStarted = false;
        this.mCycleFlip = false;
        this.mRepeated = 0;
        this.mMore = true;
    }

    public void start() {
        this.setStartTime(-1L);
    }

    public void startNow() {
        this.setStartTime(AnimationUtils.currentAnimationTimeMillis());
    }

    public void setRepeatMode(int repeatMode) {
        this.mRepeatMode = repeatMode;
    }

    public void setRepeatCount(int repeatCount) {
        if (repeatCount < 0) {
            repeatCount = -1;
        }
        this.mRepeatCount = repeatCount;
    }

    public boolean isFillEnabled() {
        return this.mFillEnabled;
    }

    public void setFillEnabled(boolean fillEnabled) {
        this.mFillEnabled = fillEnabled;
    }

    public void setFillBefore(boolean fillBefore) {
        this.mFillBefore = fillBefore;
    }

    public void setFillAfter(boolean fillAfter) {
        this.mFillAfter = fillAfter;
    }

    public void setZAdjustment(int zAdjustment) {
        this.mZAdjustment = zAdjustment;
    }

    @Deprecated
    public void setBackgroundColor(int bg) {
    }

    protected float getScaleFactor() {
        return this.mScaleFactor;
    }

    @Deprecated
    public void setDetachWallpaper(boolean detachWallpaper) {
    }

    public void setShowWallpaper(boolean showWallpaper) {
        this.mShowWallpaper = showWallpaper;
    }

    public void setHasRoundedCorners(boolean hasRoundedCorners) {
        this.mHasRoundedCorners = hasRoundedCorners;
    }

    public void setShowBackdrop(boolean showBackdrop) {
        this.mShowBackdrop = showBackdrop;
    }

    public void setBackdropColor(int backdropColor) {
        this.mBackdropColor = backdropColor;
    }

    public Interpolator getInterpolator() {
        return this.mInterpolator;
    }

    public long getStartTime() {
        return this.mStartTime;
    }

    public long getDuration() {
        return this.mDuration;
    }

    public long getStartOffset() {
        return this.mStartOffset;
    }

    public int getRepeatMode() {
        return this.mRepeatMode;
    }

    public int getRepeatCount() {
        return this.mRepeatCount;
    }

    public boolean getFillBefore() {
        return this.mFillBefore;
    }

    public boolean getFillAfter() {
        return this.mFillAfter;
    }

    public int getZAdjustment() {
        return this.mZAdjustment;
    }

    @Deprecated
    public int getBackgroundColor() {
        return 0;
    }

    @Deprecated
    public boolean getDetachWallpaper() {
        return true;
    }

    public boolean getShowWallpaper() {
        return this.mShowWallpaper;
    }

    public boolean hasRoundedCorners() {
        return this.mHasRoundedCorners;
    }

    public boolean hasExtension() {
        return false;
    }

    public boolean getShowBackdrop() {
        return this.mShowBackdrop;
    }

    public int getBackdropColor() {
        return this.mBackdropColor;
    }

    public boolean willChangeTransformationMatrix() {
        return true;
    }

    public boolean willChangeBounds() {
        return true;
    }

    private boolean hasAnimationListener() {
        return this.mListener != null;
    }

    public void setAnimationListener(AnimationListener listener2) {
        this.mListener = listener2;
    }

    protected void ensureInterpolator() {
        if (this.mInterpolator == null) {
            this.mInterpolator = new AccelerateDecelerateInterpolator();
        }
    }

    public long computeDurationHint() {
        return (this.getStartOffset() + this.getDuration()) * (long)(this.getRepeatCount() + 1);
    }

    public void getTransformationAt(float normalizedTime, Transformation outTransformation) {
        float interpolatedTime = this.mInterpolator.getInterpolation(normalizedTime);
        this.applyTransformation(interpolatedTime, outTransformation);
    }

    public boolean getTransformation(long currentTime, Transformation outTransformation) {
        if (this.mStartTime == -1L) {
            this.mStartTime = currentTime;
        }
        long startOffset = this.getStartOffset();
        long duration = this.mDuration;
        float normalizedTime = duration != 0L ? (float)(currentTime - (this.mStartTime + startOffset)) / (float)duration : (currentTime < this.mStartTime ? 0.0f : 1.0f);
        boolean expired = normalizedTime >= 1.0f || this.isCanceled();
        boolean bl = this.mMore = !expired;
        if (!this.mFillEnabled) {
            normalizedTime = Math.max(Math.min(normalizedTime, 1.0f), 0.0f);
        }
        if ((normalizedTime >= 0.0f || this.mFillBefore) && (normalizedTime <= 1.0f || this.mFillAfter)) {
            if (!this.mStarted) {
                this.fireAnimationStart();
                this.mStarted = true;
                if (NoImagePreloadHolder.USE_CLOSEGUARD) {
                    this.guard.open("cancel or detach or getTransformation");
                }
            }
            if (this.mFillEnabled) {
                normalizedTime = Math.max(Math.min(normalizedTime, 1.0f), 0.0f);
            }
            if (this.mCycleFlip) {
                normalizedTime = 1.0f - normalizedTime;
            }
            this.getTransformationAt(normalizedTime, outTransformation);
        }
        if (expired) {
            if (this.mRepeatCount == this.mRepeated || this.isCanceled()) {
                if (!this.mEnded) {
                    this.mEnded = true;
                    this.guard.close();
                    this.fireAnimationEnd();
                }
            } else {
                if (this.mRepeatCount > 0) {
                    ++this.mRepeated;
                }
                if (this.mRepeatMode == 2) {
                    this.mCycleFlip = !this.mCycleFlip;
                }
                this.mStartTime = -1L;
                this.mMore = true;
                this.fireAnimationRepeat();
            }
        }
        if (!this.mMore && this.mOneMoreTime) {
            this.mOneMoreTime = false;
            return true;
        }
        return this.mMore;
    }

    private boolean isCanceled() {
        return this.mStartTime == Long.MIN_VALUE;
    }

    private void fireAnimationStart() {
        if (this.hasAnimationListener()) {
            if (this.mListenerHandler == null) {
                this.dispatchAnimationStart();
            } else {
                this.mListenerHandler.postAtFrontOfQueue(this.mOnStart);
            }
        }
    }

    private void fireAnimationRepeat() {
        if (this.hasAnimationListener()) {
            if (this.mListenerHandler == null) {
                this.dispatchAnimationRepeat();
            } else {
                this.mListenerHandler.postAtFrontOfQueue(this.mOnRepeat);
            }
        }
    }

    private void fireAnimationEnd() {
        if (this.hasAnimationListener()) {
            if (this.mListenerHandler == null) {
                this.dispatchAnimationEnd();
            } else {
                this.mListenerHandler.postAtFrontOfQueue(this.mOnEnd);
            }
        }
    }

    void dispatchAnimationStart() {
        if (this.mListener != null) {
            this.mListener.onAnimationStart(this);
        }
    }

    void dispatchAnimationRepeat() {
        if (this.mListener != null) {
            this.mListener.onAnimationRepeat(this);
        }
    }

    void dispatchAnimationEnd() {
        if (this.mListener != null) {
            this.mListener.onAnimationEnd(this);
        }
    }

    public boolean getTransformation(long currentTime, Transformation outTransformation, float scale) {
        this.mScaleFactor = scale;
        return this.getTransformation(currentTime, outTransformation);
    }

    public boolean hasStarted() {
        return this.mStarted;
    }

    public boolean hasEnded() {
        return this.mEnded;
    }

    protected void applyTransformation(float interpolatedTime, Transformation t) {
    }

    protected float resolveSize(int type, float value2, int size, int parentSize) {
        switch (type) {
            case 0: {
                return value2;
            }
            case 1: {
                return (float)size * value2;
            }
            case 2: {
                return (float)parentSize * value2;
            }
        }
        return value2;
    }

    @UnsupportedAppUsage
    public void getInvalidateRegion(int left, int top, int right2, int bottom2, RectF invalidate, Transformation transformation) {
        RectF tempRegion = this.mRegion;
        RectF previousRegion = this.mPreviousRegion;
        invalidate.set(left, top, right2, bottom2);
        transformation.getMatrix().mapRect(invalidate);
        invalidate.inset(-1.0f, -1.0f);
        tempRegion.set(invalidate);
        invalidate.union(previousRegion);
        previousRegion.set(tempRegion);
        Transformation tempTransformation = this.mTransformation;
        Transformation previousTransformation = this.mPreviousTransformation;
        tempTransformation.set(transformation);
        transformation.set(previousTransformation);
        previousTransformation.set(tempTransformation);
    }

    @UnsupportedAppUsage
    public void initializeInvalidateRegion(int left, int top, int right2, int bottom2) {
        RectF region = this.mPreviousRegion;
        region.set(left, top, right2, bottom2);
        region.inset(-1.0f, -1.0f);
        if (this.mFillBefore) {
            Transformation previousTransformation = this.mPreviousTransformation;
            this.applyTransformation(this.mInterpolator.getInterpolation(0.0f), previousTransformation);
        }
    }

    protected void finalize() throws Throwable {
        try {
            if (this.guard != null) {
                this.guard.warnIfOpen();
            }
        }
        finally {
            super.finalize();
        }
    }

    public boolean hasAlpha() {
        return false;
    }

    public static interface AnimationListener {
        public void onAnimationStart(Animation var1);

        public void onAnimationEnd(Animation var1);

        public void onAnimationRepeat(Animation var1);
    }

    protected static class Description {
        public int type;
        public float value;

        protected Description() {
        }

        static Description parseValue(TypedValue value2, Context context) {
            Description d = new Description();
            if (value2 == null) {
                d.type = 0;
                d.value = 0.0f;
            } else {
                if (value2.type == 6) {
                    d.type = (value2.data & 0xF) == 1 ? 2 : 1;
                    d.value = TypedValue.complexToFloat(value2.data);
                    return d;
                }
                if (value2.type == 4) {
                    d.type = 0;
                    d.value = value2.getFloat();
                    return d;
                }
                if (value2.type >= 16 && value2.type <= 31) {
                    d.type = 0;
                    d.value = value2.data;
                    return d;
                }
                if (value2.type == 5) {
                    d.type = 0;
                    d.value = TypedValue.complexToDimension(value2.data, context.getResources().getDisplayMetrics());
                    return d;
                }
            }
            d.type = 0;
            d.value = 0.0f;
            return d;
        }
    }

    private static class NoImagePreloadHolder {
        public static final boolean USE_CLOSEGUARD = SystemProperties.getBoolean("log.closeguard.Animation", false);

        private NoImagePreloadHolder() {
        }
    }
}

