/*
 * Decompiled with CFR 0.152.
 */
package android.view.animation;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.animation.HasNativeInterpolator;
import android.graphics.animation.NativeInterpolator;
import android.graphics.animation.NativeInterpolatorFactory;
import android.util.AttributeSet;
import android.view.animation.BaseInterpolator;
import com.android.internal.R;

@HasNativeInterpolator
public class AnticipateInterpolator
extends BaseInterpolator
implements NativeInterpolator {
    private final float mTension;

    public AnticipateInterpolator() {
        this.mTension = 2.0f;
    }

    public AnticipateInterpolator(float tension) {
        this.mTension = tension;
    }

    public AnticipateInterpolator(Context context, AttributeSet attrs) {
        this(context.getResources(), context.getTheme(), attrs);
    }

    public AnticipateInterpolator(Resources res, Resources.Theme theme, AttributeSet attrs) {
        TypedArray a = theme != null ? theme.obtainStyledAttributes(attrs, R.styleable.AnticipateInterpolator, 0, 0) : res.obtainAttributes(attrs, R.styleable.AnticipateInterpolator);
        this.mTension = a.getFloat(0, 2.0f);
        this.setChangingConfiguration(a.getChangingConfigurations());
        a.recycle();
    }

    @Override
    public float getInterpolation(float t) {
        return t * t * ((this.mTension + 1.0f) * t - this.mTension);
    }

    @Override
    public long createNativeInterpolator() {
        return NativeInterpolatorFactory.createAnticipateInterpolator(this.mTension);
    }
}

