/*
 * Decompiled with CFR 0.152.
 */
package android.view.animation;

import android.compat.annotation.UnsupportedAppUsage;
import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.animation.Animation;
import android.view.animation.Transformation;
import com.android.internal.R;

public class TranslateAnimation
extends Animation {
    private int mFromXType = 0;
    private int mToXType = 0;
    private int mFromYType = 0;
    private int mToYType = 0;
    @UnsupportedAppUsage
    protected float mFromXValue = 0.0f;
    @UnsupportedAppUsage
    protected float mToXValue = 0.0f;
    @UnsupportedAppUsage
    protected float mFromYValue = 0.0f;
    @UnsupportedAppUsage
    protected float mToYValue = 0.0f;
    protected float mFromXDelta;
    protected float mToXDelta;
    protected float mFromYDelta;
    protected float mToYDelta;
    private int mWidth;
    private int mParentWidth;

    public TranslateAnimation(Context context, AttributeSet attrs) {
        super(context, attrs);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.TranslateAnimation);
        Animation.Description d = Animation.Description.parseValue(a.peekValue(0), context);
        this.mFromXType = d.type;
        this.mFromXValue = d.value;
        d = Animation.Description.parseValue(a.peekValue(1), context);
        this.mToXType = d.type;
        this.mToXValue = d.value;
        d = Animation.Description.parseValue(a.peekValue(2), context);
        this.mFromYType = d.type;
        this.mFromYValue = d.value;
        d = Animation.Description.parseValue(a.peekValue(3), context);
        this.mToYType = d.type;
        this.mToYValue = d.value;
        a.recycle();
    }

    public TranslateAnimation(float fromXDelta, float toXDelta, float fromYDelta, float toYDelta) {
        this.mFromXValue = fromXDelta;
        this.mToXValue = toXDelta;
        this.mFromYValue = fromYDelta;
        this.mToYValue = toYDelta;
        this.mFromXType = 0;
        this.mToXType = 0;
        this.mFromYType = 0;
        this.mToYType = 0;
    }

    public TranslateAnimation(int fromXType, float fromXValue, int toXType, float toXValue, int fromYType, float fromYValue, int toYType, float toYValue) {
        this.mFromXValue = fromXValue;
        this.mToXValue = toXValue;
        this.mFromYValue = fromYValue;
        this.mToYValue = toYValue;
        this.mFromXType = fromXType;
        this.mToXType = toXType;
        this.mFromYType = fromYType;
        this.mToYType = toYType;
    }

    @Override
    protected void applyTransformation(float interpolatedTime, Transformation t) {
        float dx = this.mFromXDelta;
        float dy = this.mFromYDelta;
        if (this.mFromXDelta != this.mToXDelta) {
            dx = this.mFromXDelta + (this.mToXDelta - this.mFromXDelta) * interpolatedTime;
        }
        if (this.mFromYDelta != this.mToYDelta) {
            dy = this.mFromYDelta + (this.mToYDelta - this.mFromYDelta) * interpolatedTime;
        }
        t.getMatrix().setTranslate(dx, dy);
    }

    @Override
    public void initialize(int width2, int height2, int parentWidth, int parentHeight) {
        super.initialize(width2, height2, parentWidth, parentHeight);
        this.mFromXDelta = this.resolveSize(this.mFromXType, this.mFromXValue, width2, parentWidth);
        this.mToXDelta = this.resolveSize(this.mToXType, this.mToXValue, width2, parentWidth);
        this.mFromYDelta = this.resolveSize(this.mFromYType, this.mFromYValue, height2, parentHeight);
        this.mToYDelta = this.resolveSize(this.mToYType, this.mToYValue, height2, parentHeight);
        this.mWidth = width2;
        this.mParentWidth = parentWidth;
    }

    public boolean isXAxisTransition() {
        return this.mFromXDelta - this.mToXDelta != 0.0f && this.mFromYDelta - this.mToYDelta == 0.0f;
    }

    public boolean isFullWidthTranslate() {
        boolean isXAxisSlideTransition = this.isSlideInLeft() || this.isSlideOutRight() || this.isSlideInRight() || this.isSlideOutLeft();
        return this.mWidth == this.mParentWidth && isXAxisSlideTransition;
    }

    private boolean isSlideInLeft() {
        boolean startsOutOfParentOnLeft = this.mFromXDelta <= (float)(-this.mWidth);
        return startsOutOfParentOnLeft && this.endsXEnclosedWithinParent();
    }

    private boolean isSlideOutRight() {
        boolean endOutOfParentOnRight = this.mToXDelta >= (float)this.mParentWidth;
        return this.startsXEnclosedWithinParent() && endOutOfParentOnRight;
    }

    private boolean isSlideInRight() {
        boolean startsOutOfParentOnRight = this.mFromXDelta >= (float)this.mParentWidth;
        return startsOutOfParentOnRight && this.endsXEnclosedWithinParent();
    }

    private boolean isSlideOutLeft() {
        boolean endOutOfParentOnLeft = this.mToXDelta <= (float)(-this.mWidth);
        return this.startsXEnclosedWithinParent() && endOutOfParentOnLeft;
    }

    private boolean endsXEnclosedWithinParent() {
        return this.mWidth <= this.mParentWidth && this.mToXDelta + (float)this.mWidth <= (float)this.mParentWidth && this.mToXDelta >= 0.0f;
    }

    private boolean startsXEnclosedWithinParent() {
        return this.mWidth <= this.mParentWidth && this.mFromXDelta + (float)this.mWidth <= (float)this.mParentWidth && this.mFromXDelta >= 0.0f;
    }
}

