/*
 * Decompiled with CFR 0.152.
 */
package android.view.contentcapture;

import android.annotation.RequiresPermission;
import android.annotation.SystemApi;
import android.app.Activity;
import android.content.ComponentName;
import android.content.ContentCaptureOptions;
import android.content.Context;
import android.os.Binder;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.ParcelFileDescriptor;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.util.Dumpable;
import android.util.Log;
import android.util.Slog;
import android.view.WindowManager;
import android.view.contentcapture.ContentCaptureCondition;
import android.view.contentcapture.ContentCaptureHelper;
import android.view.contentcapture.DataRemovalRequest;
import android.view.contentcapture.DataShareRequest;
import android.view.contentcapture.DataShareWriteAdapter;
import android.view.contentcapture.IContentCaptureManager;
import android.view.contentcapture.IDataShareWriteAdapter;
import android.view.contentcapture.MainContentCaptureSession;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.util.SyncResultReceiver;
import java.io.PrintWriter;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.function.Consumer;

public class ContentCaptureManager {
    private static final String TAG = ContentCaptureManager.class.getSimpleName();
    public static final boolean DEBUG = false;
    public static final String DUMPABLE_NAME = "ContentCaptureManager";
    public static final int DATA_SHARE_ERROR_UNKNOWN = 1;
    public static final int DATA_SHARE_ERROR_CONCURRENT_REQUEST = 2;
    public static final int DATA_SHARE_ERROR_TIMEOUT_INTERRUPTED = 3;
    public static final int RESULT_CODE_OK = 0;
    public static final int RESULT_CODE_TRUE = 1;
    public static final int RESULT_CODE_FALSE = 2;
    public static final int RESULT_CODE_SECURITY_EXCEPTION = -1;
    @SystemApi
    public static final int NO_SESSION_ID = 0;
    private static final int SYNC_CALLS_TIMEOUT_MS = 5000;
    public static final String DEVICE_CONFIG_PROPERTY_SERVICE_EXPLICITLY_ENABLED = "service_explicitly_enabled";
    public static final String DEVICE_CONFIG_PROPERTY_MAX_BUFFER_SIZE = "max_buffer_size";
    public static final String DEVICE_CONFIG_PROPERTY_IDLE_FLUSH_FREQUENCY = "idle_flush_frequency";
    public static final String DEVICE_CONFIG_PROPERTY_TEXT_CHANGE_FLUSH_FREQUENCY = "text_change_flush_frequency";
    public static final String DEVICE_CONFIG_PROPERTY_LOG_HISTORY_SIZE = "log_history_size";
    public static final String DEVICE_CONFIG_PROPERTY_LOGGING_LEVEL = "logging_level";
    public static final String DEVICE_CONFIG_PROPERTY_IDLE_UNBIND_TIMEOUT = "idle_unbind_timeout";
    public static final int LOGGING_LEVEL_OFF = 0;
    public static final int LOGGING_LEVEL_DEBUG = 1;
    public static final int LOGGING_LEVEL_VERBOSE = 2;
    public static final int DEFAULT_MAX_BUFFER_SIZE = 500;
    public static final int DEFAULT_IDLE_FLUSHING_FREQUENCY_MS = 5000;
    public static final int DEFAULT_TEXT_CHANGE_FLUSHING_FREQUENCY_MS = 1000;
    public static final int DEFAULT_LOG_HISTORY_SIZE = 10;
    private final Object mLock = new Object();
    private final Context mContext;
    private final IContentCaptureManager mService;
    @GuardedBy(value={"mLock"})
    private final LocalDataShareAdapterResourceManager mDataShareAdapterResourceManager;
    final ContentCaptureOptions mOptions;
    @GuardedBy(value={"mLock"})
    private int mFlags;
    private final Handler mHandler;
    @GuardedBy(value={"mLock"})
    private MainContentCaptureSession mMainSession;
    private Dumper mDumpable;

    public ContentCaptureManager(Context context, IContentCaptureManager service, ContentCaptureOptions options) {
        this.mContext = Objects.requireNonNull(context, "context cannot be null");
        this.mService = Objects.requireNonNull(service, "service cannot be null");
        this.mOptions = Objects.requireNonNull(options, "options cannot be null");
        ContentCaptureHelper.setLoggingLevel(this.mOptions.loggingLevel);
        if (ContentCaptureHelper.sVerbose) {
            Log.v(TAG, "Constructor for " + context.getPackageName());
        }
        this.mHandler = Handler.createAsync(Looper.getMainLooper());
        this.mDataShareAdapterResourceManager = new LocalDataShareAdapterResourceManager();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MainContentCaptureSession getMainContentCaptureSession() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mMainSession == null) {
                this.mMainSession = new MainContentCaptureSession(this.mContext, this, this.mHandler, this.mService);
                if (ContentCaptureHelper.sVerbose) {
                    Log.v(TAG, "getMainContentCaptureSession(): created " + this.mMainSession);
                }
            }
            return this.mMainSession;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onActivityCreated(IBinder applicationToken, IBinder shareableActivityToken, ComponentName activityComponent) {
        if (this.mOptions.lite) {
            return;
        }
        Object object = this.mLock;
        synchronized (object) {
            this.getMainContentCaptureSession().start(applicationToken, shareableActivityToken, activityComponent, this.mFlags);
        }
    }

    public void onActivityResumed() {
        if (this.mOptions.lite) {
            return;
        }
        this.getMainContentCaptureSession().notifySessionResumed();
    }

    public void onActivityPaused() {
        if (this.mOptions.lite) {
            return;
        }
        this.getMainContentCaptureSession().notifySessionPaused();
    }

    public void onActivityDestroyed() {
        if (this.mOptions.lite) {
            return;
        }
        this.getMainContentCaptureSession().destroy();
    }

    public void flush(int reason) {
        if (this.mOptions.lite) {
            return;
        }
        this.getMainContentCaptureSession().flush(reason);
    }

    public ComponentName getServiceComponentName() {
        if (!this.isContentCaptureEnabled() && !this.mOptions.lite) {
            return null;
        }
        SyncResultReceiver resultReceiver = new SyncResultReceiver(5000);
        try {
            this.mService.getServiceComponentName(resultReceiver);
            return (ComponentName)resultReceiver.getParcelableResult();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        catch (SyncResultReceiver.TimeoutException e) {
            throw new RuntimeException("Fail to get service componentName.");
        }
    }

    public static ComponentName getServiceSettingsComponentName() {
        IBinder binder = ServiceManager.checkService("content_capture");
        if (binder == null) {
            return null;
        }
        IContentCaptureManager service = IContentCaptureManager.Stub.asInterface(binder);
        SyncResultReceiver resultReceiver = new SyncResultReceiver(5000);
        try {
            service.getServiceSettingsActivity(resultReceiver);
            int resultCode = resultReceiver.getIntResult();
            if (resultCode == -1) {
                throw new SecurityException(resultReceiver.getStringResult());
            }
            return (ComponentName)resultReceiver.getParcelableResult();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        catch (SyncResultReceiver.TimeoutException e) {
            Log.e(TAG, "Fail to get service settings componentName: " + e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isContentCaptureEnabled() {
        MainContentCaptureSession mainSession;
        if (this.mOptions.lite) {
            return false;
        }
        Object object = this.mLock;
        synchronized (object) {
            mainSession = this.mMainSession;
        }
        return mainSession == null || !mainSession.isDisabled();
    }

    public Set<ContentCaptureCondition> getContentCaptureConditions() {
        if (!this.isContentCaptureEnabled() && !this.mOptions.lite) {
            return null;
        }
        SyncResultReceiver resultReceiver = this.syncRun(r -> this.mService.getContentCaptureConditions(this.mContext.getPackageName(), r));
        try {
            ArrayList result = resultReceiver.getParcelableListResult();
            return ContentCaptureHelper.toSet(result);
        }
        catch (SyncResultReceiver.TimeoutException e) {
            throw new RuntimeException("Fail to get content capture conditions.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setContentCaptureEnabled(boolean enabled) {
        MainContentCaptureSession mainSession;
        if (ContentCaptureHelper.sDebug) {
            Log.d(TAG, "setContentCaptureEnabled(): setting to " + enabled + " for " + this.mContext);
        }
        Object object = this.mLock;
        synchronized (object) {
            this.mFlags = enabled ? (this.mFlags &= 0xFFFFFFFE) : (this.mFlags |= 1);
            mainSession = this.mMainSession;
        }
        if (mainSession != null) {
            mainSession.setDisabled(!enabled);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateWindowAttributes(WindowManager.LayoutParams params) {
        MainContentCaptureSession mainSession;
        if (ContentCaptureHelper.sDebug) {
            Log.d(TAG, "updateWindowAttributes(): window flags=" + params.flags);
        }
        boolean flagSecureEnabled = (params.flags & 0x2000) != 0;
        Object object = this.mLock;
        synchronized (object) {
            this.mFlags = flagSecureEnabled ? (this.mFlags |= 2) : (this.mFlags &= 0xFFFFFFFD);
            mainSession = this.mMainSession;
        }
        if (mainSession != null) {
            mainSession.setDisabled(flagSecureEnabled);
        }
    }

    @SystemApi
    public boolean isContentCaptureFeatureEnabled() {
        SyncResultReceiver resultReceiver = this.syncRun(r -> this.mService.isContentCaptureFeatureEnabled(r));
        try {
            int resultCode = resultReceiver.getIntResult();
            switch (resultCode) {
                case 1: {
                    return true;
                }
                case 2: {
                    return false;
                }
            }
            Log.wtf(TAG, "received invalid result: " + resultCode);
            return false;
        }
        catch (SyncResultReceiver.TimeoutException e) {
            Log.e(TAG, "Fail to get content capture feature enable status: " + e);
            return false;
        }
    }

    public void removeData(DataRemovalRequest request) {
        Objects.requireNonNull(request);
        try {
            this.mService.removeData(request);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void shareData(DataShareRequest request, Executor executor, DataShareWriteAdapter dataShareWriteAdapter) {
        Objects.requireNonNull(request);
        Objects.requireNonNull(dataShareWriteAdapter);
        Objects.requireNonNull(executor);
        try {
            this.mService.shareData(request, new DataShareAdapterDelegate(executor, dataShareWriteAdapter, this.mDataShareAdapterResourceManager));
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private SyncResultReceiver syncRun(MyRunnable r) {
        SyncResultReceiver resultReceiver = new SyncResultReceiver(5000);
        try {
            r.run(resultReceiver);
            int resultCode = resultReceiver.getIntResult();
            if (resultCode == -1) {
                throw new SecurityException(resultReceiver.getStringResult());
            }
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        catch (SyncResultReceiver.TimeoutException e) {
            throw new RuntimeException("Fail to get syn run result from SyncResultReceiver.");
        }
        return resultReceiver;
    }

    public void addDumpable(Activity activity) {
        if (this.mDumpable == null) {
            this.mDumpable = new Dumper();
        }
        activity.addDumpable(this.mDumpable);
    }

    @RequiresPermission(value="android.permission.MANAGE_CONTENT_CAPTURE")
    public static void resetTemporaryService(int userId) {
        IContentCaptureManager service = ContentCaptureManager.getService();
        if (service == null) {
            Log.e(TAG, "IContentCaptureManager is null");
        }
        try {
            service.resetTemporaryService(userId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.MANAGE_CONTENT_CAPTURE")
    public static void setTemporaryService(int userId, String serviceName, int duration) {
        IContentCaptureManager service = ContentCaptureManager.getService();
        if (service == null) {
            Log.e(TAG, "IContentCaptureManager is null");
        }
        try {
            service.setTemporaryService(userId, serviceName, duration);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.MANAGE_CONTENT_CAPTURE")
    public static void setDefaultServiceEnabled(int userId, boolean enabled) {
        IContentCaptureManager service = ContentCaptureManager.getService();
        if (service == null) {
            Log.e(TAG, "IContentCaptureManager is null");
        }
        try {
            service.setDefaultServiceEnabled(userId, enabled);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private static IContentCaptureManager getService() {
        return IContentCaptureManager.Stub.asInterface(ServiceManager.getService("content_capture"));
    }

    private static class LocalDataShareAdapterResourceManager {
        private Map<DataShareAdapterDelegate, DataShareWriteAdapter> mWriteAdapterHardReferences = new HashMap<DataShareAdapterDelegate, DataShareWriteAdapter>();
        private Map<DataShareAdapterDelegate, Executor> mExecutorHardReferences = new HashMap<DataShareAdapterDelegate, Executor>();

        private LocalDataShareAdapterResourceManager() {
        }

        void initializeForDelegate(DataShareAdapterDelegate delegate, DataShareWriteAdapter adapter, Executor executor) {
            this.mWriteAdapterHardReferences.put(delegate, adapter);
            this.mExecutorHardReferences.put(delegate, executor);
        }

        Executor getExecutor(DataShareAdapterDelegate delegate) {
            return this.mExecutorHardReferences.get(delegate);
        }

        DataShareWriteAdapter getAdapter(DataShareAdapterDelegate delegate) {
            return this.mWriteAdapterHardReferences.get(delegate);
        }

        void clearHardReferences(DataShareAdapterDelegate delegate) {
            this.mWriteAdapterHardReferences.remove(delegate);
            this.mExecutorHardReferences.remove(delegate);
        }
    }

    private static class DataShareAdapterDelegate
    extends IDataShareWriteAdapter.Stub {
        private final WeakReference<LocalDataShareAdapterResourceManager> mResourceManagerReference;

        private DataShareAdapterDelegate(Executor executor, DataShareWriteAdapter adapter, LocalDataShareAdapterResourceManager resourceManager) {
            Objects.requireNonNull(executor);
            Objects.requireNonNull(adapter);
            Objects.requireNonNull(resourceManager);
            resourceManager.initializeForDelegate(this, adapter, executor);
            this.mResourceManagerReference = new WeakReference<LocalDataShareAdapterResourceManager>(resourceManager);
        }

        @Override
        public void write(ParcelFileDescriptor destination) throws RemoteException {
            this.executeAdapterMethodLocked(adapter -> adapter.onWrite(destination), "onWrite");
        }

        @Override
        public void error(int errorCode) throws RemoteException {
            this.executeAdapterMethodLocked(adapter -> adapter.onError(errorCode), "onError");
            this.clearHardReferences();
        }

        @Override
        public void rejected() throws RemoteException {
            this.executeAdapterMethodLocked(DataShareWriteAdapter::onRejected, "onRejected");
            this.clearHardReferences();
        }

        @Override
        public void finish() throws RemoteException {
            this.clearHardReferences();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void executeAdapterMethodLocked(Consumer<DataShareWriteAdapter> adapterFn, String methodName) {
            LocalDataShareAdapterResourceManager resourceManager = (LocalDataShareAdapterResourceManager)this.mResourceManagerReference.get();
            if (resourceManager == null) {
                Slog.w(TAG, "Can't execute " + methodName + "(), resource manager has been GC'ed");
                return;
            }
            DataShareWriteAdapter adapter = resourceManager.getAdapter(this);
            Executor executor = resourceManager.getExecutor(this);
            if (adapter == null || executor == null) {
                Slog.w(TAG, "Can't execute " + methodName + "(), references are null");
                return;
            }
            long identity = Binder.clearCallingIdentity();
            try {
                executor.execute(() -> adapterFn.accept(adapter));
            }
            finally {
                Binder.restoreCallingIdentity(identity);
            }
        }

        private void clearHardReferences() {
            LocalDataShareAdapterResourceManager resourceManager = (LocalDataShareAdapterResourceManager)this.mResourceManagerReference.get();
            if (resourceManager == null) {
                Slog.w(TAG, "Can't clear references, resource manager has been GC'ed");
                return;
            }
            resourceManager.clearHardReferences(this);
        }
    }

    private static interface MyRunnable {
        public void run(SyncResultReceiver var1) throws RemoteException;
    }

    private class Dumper
    implements Dumpable {
        private Dumper() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void dump(PrintWriter pw, String[] args) {
            String prefix = "";
            pw.print(prefix);
            pw.println(ContentCaptureManager.DUMPABLE_NAME);
            String prefix2 = prefix + "  ";
            Object object = ContentCaptureManager.this.mLock;
            synchronized (object) {
                pw.print(prefix2);
                pw.print("isContentCaptureEnabled(): ");
                pw.println(ContentCaptureManager.this.isContentCaptureEnabled());
                pw.print(prefix2);
                pw.print("Debug: ");
                pw.print(ContentCaptureHelper.sDebug);
                pw.print(" Verbose: ");
                pw.println(ContentCaptureHelper.sVerbose);
                pw.print(prefix2);
                pw.print("Context: ");
                pw.println(ContentCaptureManager.this.mContext);
                pw.print(prefix2);
                pw.print("User: ");
                pw.println(ContentCaptureManager.this.mContext.getUserId());
                pw.print(prefix2);
                pw.print("Service: ");
                pw.println(ContentCaptureManager.this.mService);
                pw.print(prefix2);
                pw.print("Flags: ");
                pw.println(ContentCaptureManager.this.mFlags);
                pw.print(prefix2);
                pw.print("Options: ");
                ContentCaptureManager.this.mOptions.dumpShort(pw);
                pw.println();
                if (ContentCaptureManager.this.mMainSession != null) {
                    String prefix3 = prefix2 + "  ";
                    pw.print(prefix2);
                    pw.println("Main session:");
                    ContentCaptureManager.this.mMainSession.dump(prefix3, pw);
                } else {
                    pw.print(prefix2);
                    pw.println("No sessions");
                }
            }
        }

        @Override
        public String getDumpableName() {
            return ContentCaptureManager.DUMPABLE_NAME;
        }
    }

    public static interface ContentCaptureClient {
        public ComponentName contentCaptureClientGetComponentName();
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface LoggingLevel {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface DataShareError {
    }
}

