/*
 * Decompiled with CFR 0.152.
 */
package android.view.inputmethod;

import android.os.IBinder;
import android.os.RemoteException;
import android.os.ResultReceiver;
import android.util.Log;
import android.view.InputChannel;
import android.view.MotionEvent;
import android.view.inputmethod.EditorInfo;
import android.view.inputmethod.InputBinding;
import android.view.inputmethod.InputConnection;
import android.view.inputmethod.InputMethodSession;
import android.view.inputmethod.InputMethodSubtype;
import android.window.ImeOnBackInvokedDispatcher;
import com.android.internal.inputmethod.IInputMethodPrivilegedOperations;
import com.android.internal.view.IInlineSuggestionsRequestCallback;
import com.android.internal.view.InlineSuggestionsRequestInfo;
import java.util.List;

public interface InputMethod {
    public static final String TAG = "InputMethod";
    public static final String SERVICE_INTERFACE = "android.view.InputMethod";
    public static final String SERVICE_META_DATA = "android.view.im";
    public static final int SHOW_EXPLICIT = 1;
    public static final int SHOW_FORCED = 2;

    default public void initializeInternal(IBinder token, IInputMethodPrivilegedOperations privilegedOperations, int configChanges, boolean stylusHwSupported, int navButtonFlags) {
        this.attachToken(token);
    }

    default public void onCreateInlineSuggestionsRequest(InlineSuggestionsRequestInfo requestInfo, IInlineSuggestionsRequestCallback cb) {
        try {
            cb.onInlineSuggestionsUnsupported();
        }
        catch (RemoteException e) {
            Log.w(TAG, "Failed to call onInlineSuggestionsUnsupported.", e);
        }
    }

    public void attachToken(IBinder var1);

    public void bindInput(InputBinding var1);

    public void unbindInput();

    public void startInput(InputConnection var1, EditorInfo var2);

    public void restartInput(InputConnection var1, EditorInfo var2);

    default public void dispatchStartInputWithToken(InputConnection inputConnection, EditorInfo editorInfo, boolean restarting, IBinder startInputToken, int navButtonFlags, ImeOnBackInvokedDispatcher imeDispatcher) {
        if (restarting) {
            this.restartInput(inputConnection, editorInfo);
        } else {
            this.startInput(inputConnection, editorInfo);
        }
    }

    default public void onNavButtonFlagsChanged(int navButtonFlags) {
    }

    public void createSession(SessionCallback var1);

    public void setSessionEnabled(InputMethodSession var1, boolean var2);

    public void revokeSession(InputMethodSession var1);

    default public void showSoftInputWithToken(int flags, ResultReceiver resultReceiver, IBinder showInputToken) {
        this.showSoftInput(flags, resultReceiver);
    }

    public void showSoftInput(int var1, ResultReceiver var2);

    public void hideSoftInputWithToken(int var1, ResultReceiver var2, IBinder var3);

    public void hideSoftInput(int var1, ResultReceiver var2);

    public void changeInputMethodSubtype(InputMethodSubtype var1);

    default public void canStartStylusHandwriting(int requestId) {
    }

    default public void startStylusHandwriting(int requestId, InputChannel channel, List<MotionEvent> events) {
    }

    default public void initInkWindow() {
    }

    default public void finishStylusHandwriting() {
    }

    public static interface SessionCallback {
        public void sessionCreated(InputMethodSession var1);
    }
}

