/*
 * Decompiled with CFR 0.152.
 */
package android.view.inputmethod;

import android.compat.annotation.UnsupportedAppUsage;
import android.content.ComponentName;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.pm.ServiceInfo;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.content.res.XmlResourceParser;
import android.graphics.drawable.Drawable;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.util.Printer;
import android.util.Slog;
import android.util.Xml;
import android.view.inputmethod.InputMethodSubtype;
import android.view.inputmethod.InputMethodSubtypeArray;
import com.android.internal.R;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.xmlpull.v1.XmlPullParserException;

public class InputMethodInfo
implements Parcelable {
    static final String TAG = "InputMethodInfo";
    final ResolveInfo mService;
    final boolean mIsVrOnly;
    final String mId;
    final String mSettingsActivityName;
    final int mIsDefaultResId;
    @UnsupportedAppUsage
    private final InputMethodSubtypeArray mSubtypes;
    private final boolean mIsAuxIme;
    private final boolean mForceDefault;
    private final boolean mSupportsSwitchingToNextInputMethod;
    private final boolean mInlineSuggestionsEnabled;
    private final boolean mSupportsInlineSuggestionsWithTouchExploration;
    private final boolean mSuppressesSpellChecker;
    private final boolean mShowInInputMethodPicker;
    private final int mHandledConfigChanges;
    private final boolean mSupportsStylusHandwriting;
    public static final Parcelable.Creator<InputMethodInfo> CREATOR = new Parcelable.Creator<InputMethodInfo>(){

        @Override
        public InputMethodInfo createFromParcel(Parcel source) {
            return new InputMethodInfo(source);
        }

        public InputMethodInfo[] newArray(int size) {
            return new InputMethodInfo[size];
        }
    };

    public static String computeId(ResolveInfo service) {
        ServiceInfo si = service.serviceInfo;
        return new ComponentName(si.packageName, si.name).flattenToShortString();
    }

    public InputMethodInfo(Context context, ResolveInfo service) throws XmlPullParserException, IOException {
        this(context, service, null);
    }

    public InputMethodInfo(Context context, ResolveInfo service, List<InputMethodSubtype> additionalSubtypes) throws XmlPullParserException, IOException {
        boolean isVrOnly;
        this.mService = service;
        ServiceInfo si = service.serviceInfo;
        this.mId = InputMethodInfo.computeId(service);
        boolean isAuxIme = true;
        boolean supportsSwitchingToNextInputMethod = false;
        boolean inlineSuggestionsEnabled = false;
        boolean supportsInlineSuggestionsWithTouchExploration = false;
        boolean suppressesSpellChecker = false;
        boolean showInInputMethodPicker = true;
        this.mForceDefault = false;
        PackageManager pm = context.getPackageManager();
        String settingsActivityComponent = null;
        int isDefaultResId = 0;
        ArrayList<InputMethodSubtype> subtypes = new ArrayList<InputMethodSubtype>();
        try (XmlResourceParser parser = null;){
            int type;
            parser = si.loadXmlMetaData(pm, "android.view.im");
            if (parser == null) {
                throw new XmlPullParserException("No android.view.im meta-data");
            }
            Resources res = pm.getResourcesForApplication(si.applicationInfo);
            AttributeSet attrs = Xml.asAttributeSet(parser);
            while ((type = parser.next()) != 1 && type != 2) {
            }
            String nodeName = parser.getName();
            if (!"input-method".equals(nodeName)) {
                throw new XmlPullParserException("Meta-data does not start with input-method tag");
            }
            TypedArray sa = res.obtainAttributes(attrs, R.styleable.InputMethod);
            settingsActivityComponent = sa.getString(2);
            isVrOnly = sa.getBoolean(4, false);
            isDefaultResId = sa.getResourceId(1, 0);
            supportsSwitchingToNextInputMethod = sa.getBoolean(3, false);
            inlineSuggestionsEnabled = sa.getBoolean(5, false);
            supportsInlineSuggestionsWithTouchExploration = sa.getBoolean(9, false);
            suppressesSpellChecker = sa.getBoolean(6, false);
            showInInputMethodPicker = sa.getBoolean(7, true);
            this.mHandledConfigChanges = sa.getInt(0, 0);
            this.mSupportsStylusHandwriting = sa.getBoolean(8, false);
            sa.recycle();
            int depth = parser.getDepth();
            while (((type = parser.next()) != 3 || parser.getDepth() > depth) && type != 1) {
                if (type != 2) continue;
                nodeName = parser.getName();
                if (!"subtype".equals(nodeName)) {
                    throw new XmlPullParserException("Meta-data in input-method does not start with subtype tag");
                }
                TypedArray a = res.obtainAttributes(attrs, R.styleable.InputMethod_Subtype);
                InputMethodSubtype subtype = new InputMethodSubtype.InputMethodSubtypeBuilder().setSubtypeNameResId(a.getResourceId(0, 0)).setSubtypeIconResId(a.getResourceId(1, 0)).setLanguageTag(a.getString(9)).setSubtypeLocale(a.getString(2)).setSubtypeMode(a.getString(3)).setSubtypeExtraValue(a.getString(4)).setIsAuxiliary(a.getBoolean(5, false)).setOverridesImplicitlyEnabledSubtype(a.getBoolean(6, false)).setSubtypeId(a.getInt(7, 0)).setIsAsciiCapable(a.getBoolean(8, false)).build();
                a.recycle();
                if (!subtype.isAuxiliary()) {
                    isAuxIme = false;
                }
                subtypes.add(subtype);
            }
        }
        if (subtypes.size() == 0) {
            isAuxIme = false;
        }
        if (additionalSubtypes != null) {
            int N = additionalSubtypes.size();
            for (int i = 0; i < N; ++i) {
                InputMethodSubtype subtype = additionalSubtypes.get(i);
                if (!subtypes.contains(subtype)) {
                    subtypes.add(subtype);
                    continue;
                }
                Slog.w(TAG, "Duplicated subtype definition found: " + subtype.getLocale() + ", " + subtype.getMode());
            }
        }
        this.mSubtypes = new InputMethodSubtypeArray(subtypes);
        this.mSettingsActivityName = settingsActivityComponent;
        this.mIsDefaultResId = isDefaultResId;
        this.mIsAuxIme = isAuxIme;
        this.mSupportsSwitchingToNextInputMethod = supportsSwitchingToNextInputMethod;
        this.mInlineSuggestionsEnabled = inlineSuggestionsEnabled;
        this.mSupportsInlineSuggestionsWithTouchExploration = supportsInlineSuggestionsWithTouchExploration;
        this.mSuppressesSpellChecker = suppressesSpellChecker;
        this.mShowInInputMethodPicker = showInInputMethodPicker;
        this.mIsVrOnly = isVrOnly;
    }

    InputMethodInfo(Parcel source) {
        this.mId = source.readString();
        this.mSettingsActivityName = source.readString();
        this.mIsDefaultResId = source.readInt();
        this.mIsAuxIme = source.readInt() == 1;
        this.mSupportsSwitchingToNextInputMethod = source.readInt() == 1;
        this.mInlineSuggestionsEnabled = source.readInt() == 1;
        this.mSupportsInlineSuggestionsWithTouchExploration = source.readInt() == 1;
        this.mSuppressesSpellChecker = source.readBoolean();
        this.mShowInInputMethodPicker = source.readBoolean();
        this.mIsVrOnly = source.readBoolean();
        this.mService = ResolveInfo.CREATOR.createFromParcel(source);
        this.mSubtypes = new InputMethodSubtypeArray(source);
        this.mHandledConfigChanges = source.readInt();
        this.mSupportsStylusHandwriting = source.readBoolean();
        this.mForceDefault = false;
    }

    public InputMethodInfo(String packageName, String className, CharSequence label, String settingsActivity) {
        this(InputMethodInfo.buildFakeResolveInfo(packageName, className, label), false, settingsActivity, null, 0, false, true, false, false, 0, false, false);
    }

    public InputMethodInfo(String packageName, String className, CharSequence label, String settingsActivity, int handledConfigChanges) {
        this(InputMethodInfo.buildFakeResolveInfo(packageName, className, label), false, settingsActivity, null, 0, false, true, false, false, handledConfigChanges, false, false);
    }

    public InputMethodInfo(ResolveInfo ri, boolean isAuxIme, String settingsActivity, List<InputMethodSubtype> subtypes, int isDefaultResId, boolean forceDefault) {
        this(ri, isAuxIme, settingsActivity, subtypes, isDefaultResId, forceDefault, true, false, false, 0, false, false);
    }

    public InputMethodInfo(ResolveInfo ri, boolean isAuxIme, String settingsActivity, List<InputMethodSubtype> subtypes, int isDefaultResId, boolean forceDefault, boolean supportsSwitchingToNextInputMethod, boolean isVrOnly) {
        this(ri, isAuxIme, settingsActivity, subtypes, isDefaultResId, forceDefault, supportsSwitchingToNextInputMethod, false, isVrOnly, 0, false, false);
    }

    public InputMethodInfo(ResolveInfo ri, boolean isAuxIme, String settingsActivity, List<InputMethodSubtype> subtypes, int isDefaultResId, boolean forceDefault, boolean supportsSwitchingToNextInputMethod, boolean inlineSuggestionsEnabled, boolean isVrOnly, int handledConfigChanges, boolean supportsStylusHandwriting, boolean supportsInlineSuggestionsWithTouchExploration) {
        ServiceInfo si = ri.serviceInfo;
        this.mService = ri;
        this.mId = new ComponentName(si.packageName, si.name).flattenToShortString();
        this.mSettingsActivityName = settingsActivity;
        this.mIsDefaultResId = isDefaultResId;
        this.mIsAuxIme = isAuxIme;
        this.mSubtypes = new InputMethodSubtypeArray(subtypes);
        this.mForceDefault = forceDefault;
        this.mSupportsSwitchingToNextInputMethod = supportsSwitchingToNextInputMethod;
        this.mInlineSuggestionsEnabled = inlineSuggestionsEnabled;
        this.mSupportsInlineSuggestionsWithTouchExploration = supportsInlineSuggestionsWithTouchExploration;
        this.mSuppressesSpellChecker = false;
        this.mShowInInputMethodPicker = true;
        this.mIsVrOnly = isVrOnly;
        this.mHandledConfigChanges = handledConfigChanges;
        this.mSupportsStylusHandwriting = supportsStylusHandwriting;
    }

    private static ResolveInfo buildFakeResolveInfo(String packageName, String className, CharSequence label) {
        ResolveInfo ri = new ResolveInfo();
        ServiceInfo si = new ServiceInfo();
        ApplicationInfo ai = new ApplicationInfo();
        ai.packageName = packageName;
        ai.enabled = true;
        si.applicationInfo = ai;
        si.enabled = true;
        si.packageName = packageName;
        si.name = className;
        si.exported = true;
        si.nonLocalizedLabel = label;
        ri.serviceInfo = si;
        return ri;
    }

    public String getId() {
        return this.mId;
    }

    public String getPackageName() {
        return this.mService.serviceInfo.packageName;
    }

    public String getServiceName() {
        return this.mService.serviceInfo.name;
    }

    public ServiceInfo getServiceInfo() {
        return this.mService.serviceInfo;
    }

    public ComponentName getComponent() {
        return new ComponentName(this.mService.serviceInfo.packageName, this.mService.serviceInfo.name);
    }

    public CharSequence loadLabel(PackageManager pm) {
        return this.mService.loadLabel(pm);
    }

    public Drawable loadIcon(PackageManager pm) {
        return this.mService.loadIcon(pm);
    }

    public String getSettingsActivity() {
        return this.mSettingsActivityName;
    }

    public boolean isVrOnly() {
        return this.mIsVrOnly;
    }

    public int getSubtypeCount() {
        return this.mSubtypes.getCount();
    }

    public InputMethodSubtype getSubtypeAt(int index) {
        return this.mSubtypes.get(index);
    }

    public int getIsDefaultResourceId() {
        return this.mIsDefaultResId;
    }

    @UnsupportedAppUsage
    public boolean isDefault(Context context) {
        if (this.mForceDefault) {
            return true;
        }
        try {
            if (this.getIsDefaultResourceId() == 0) {
                return false;
            }
            Resources res = context.createPackageContext(this.getPackageName(), 0).getResources();
            return res.getBoolean(this.getIsDefaultResourceId());
        }
        catch (PackageManager.NameNotFoundException | Resources.NotFoundException e) {
            return false;
        }
    }

    public int getConfigChanges() {
        return this.mHandledConfigChanges;
    }

    public boolean supportsStylusHandwriting() {
        return this.mSupportsStylusHandwriting;
    }

    public void dump(Printer pw, String prefix) {
        pw.println(prefix + "mId=" + this.mId + " mSettingsActivityName=" + this.mSettingsActivityName + " mIsVrOnly=" + this.mIsVrOnly + " mSupportsSwitchingToNextInputMethod=" + this.mSupportsSwitchingToNextInputMethod + " mInlineSuggestionsEnabled=" + this.mInlineSuggestionsEnabled + " mSupportsInlineSuggestionsWithTouchExploration=" + this.mSupportsInlineSuggestionsWithTouchExploration + " mSuppressesSpellChecker=" + this.mSuppressesSpellChecker + " mShowInInputMethodPicker=" + this.mShowInInputMethodPicker + " mSupportsStylusHandwriting=" + this.mSupportsStylusHandwriting);
        pw.println(prefix + "mIsDefaultResId=0x" + Integer.toHexString(this.mIsDefaultResId));
        pw.println(prefix + "Service:");
        this.mService.dump(pw, prefix + "  ");
    }

    public String toString() {
        return "InputMethodInfo{" + this.mId + ", settings: " + this.mSettingsActivityName + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (!(o instanceof InputMethodInfo)) {
            return false;
        }
        InputMethodInfo obj = (InputMethodInfo)o;
        return this.mId.equals(obj.mId);
    }

    public int hashCode() {
        return this.mId.hashCode();
    }

    public boolean isSystem() {
        return (this.mService.serviceInfo.applicationInfo.flags & 1) != 0;
    }

    public boolean isAuxiliaryIme() {
        return this.mIsAuxIme;
    }

    public boolean supportsSwitchingToNextInputMethod() {
        return this.mSupportsSwitchingToNextInputMethod;
    }

    public boolean isInlineSuggestionsEnabled() {
        return this.mInlineSuggestionsEnabled;
    }

    public boolean supportsInlineSuggestionsWithTouchExploration() {
        return this.mSupportsInlineSuggestionsWithTouchExploration;
    }

    public boolean suppressesSpellChecker() {
        return this.mSuppressesSpellChecker;
    }

    public boolean shouldShowInInputMethodPicker() {
        return this.mShowInInputMethodPicker;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.mId);
        dest.writeString(this.mSettingsActivityName);
        dest.writeInt(this.mIsDefaultResId);
        dest.writeInt(this.mIsAuxIme ? 1 : 0);
        dest.writeInt(this.mSupportsSwitchingToNextInputMethod ? 1 : 0);
        dest.writeInt(this.mInlineSuggestionsEnabled ? 1 : 0);
        dest.writeInt(this.mSupportsInlineSuggestionsWithTouchExploration ? 1 : 0);
        dest.writeBoolean(this.mSuppressesSpellChecker);
        dest.writeBoolean(this.mShowInInputMethodPicker);
        dest.writeBoolean(this.mIsVrOnly);
        this.mService.writeToParcel(dest, flags);
        this.mSubtypes.writeToParcel(dest);
        dest.writeInt(this.mHandledConfigChanges);
        dest.writeBoolean(this.mSupportsStylusHandwriting);
    }

    @Override
    public int describeContents() {
        return 0;
    }
}

