/*
 * Decompiled with CFR 0.152.
 */
package android.view.inputmethod;

import android.graphics.RectF;
import android.os.Parcel;
import android.os.Parcelable;
import java.util.Arrays;

public class SparseRectFArray
implements Parcelable {
    private final int[] mKeys;
    private final float[] mCoordinates;
    private final int[] mFlagsArray;
    public static final Parcelable.Creator<SparseRectFArray> CREATOR = new Parcelable.Creator<SparseRectFArray>(){

        @Override
        public SparseRectFArray createFromParcel(Parcel source) {
            return new SparseRectFArray(source);
        }

        public SparseRectFArray[] newArray(int size) {
            return new SparseRectFArray[size];
        }
    };

    public SparseRectFArray(Parcel source) {
        this.mKeys = source.createIntArray();
        this.mCoordinates = source.createFloatArray();
        this.mFlagsArray = source.createIntArray();
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeIntArray(this.mKeys);
        dest.writeFloatArray(this.mCoordinates);
        dest.writeIntArray(this.mFlagsArray);
    }

    public int hashCode() {
        if (this.mKeys == null || this.mKeys.length == 0) {
            return 0;
        }
        int hash2 = this.mKeys.length;
        for (int i = 0; i < 4; ++i) {
            hash2 *= 31;
            hash2 = (int)((float)hash2 + this.mCoordinates[i]);
        }
        hash2 *= 31;
        return hash2 += this.mFlagsArray[0];
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof SparseRectFArray)) {
            return false;
        }
        SparseRectFArray that = (SparseRectFArray)obj;
        return Arrays.equals(this.mKeys, that.mKeys) && Arrays.equals(this.mCoordinates, that.mCoordinates) && Arrays.equals(this.mFlagsArray, that.mFlagsArray);
    }

    public String toString() {
        if (this.mKeys == null || this.mCoordinates == null || this.mFlagsArray == null) {
            return "SparseRectFArray{}";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("SparseRectFArray{");
        for (int i = 0; i < this.mKeys.length; ++i) {
            if (i != 0) {
                sb.append(", ");
            }
            int baseIndex = i * 4;
            sb.append(this.mKeys[i]);
            sb.append(":[");
            sb.append(this.mCoordinates[baseIndex + 0]);
            sb.append(",");
            sb.append(this.mCoordinates[baseIndex + 1]);
            sb.append("],[");
            sb.append(this.mCoordinates[baseIndex + 2]);
            sb.append(",");
            sb.append(this.mCoordinates[baseIndex + 3]);
            sb.append("]:flagsArray=");
            sb.append(this.mFlagsArray[i]);
        }
        sb.append("}");
        return sb.toString();
    }

    private SparseRectFArray(SparseRectFArrayBuilder builder2) {
        if (builder2.mCount == 0) {
            this.mKeys = null;
            this.mCoordinates = null;
            this.mFlagsArray = null;
        } else {
            this.mKeys = new int[builder2.mCount];
            this.mCoordinates = new float[builder2.mCount * 4];
            this.mFlagsArray = new int[builder2.mCount];
            System.arraycopy(builder2.mKeys, 0, this.mKeys, 0, builder2.mCount);
            System.arraycopy(builder2.mCoordinates, 0, this.mCoordinates, 0, builder2.mCount * 4);
            System.arraycopy(builder2.mFlagsArray, 0, this.mFlagsArray, 0, builder2.mCount);
        }
    }

    public RectF get(int index) {
        if (this.mKeys == null) {
            return null;
        }
        if (index < 0) {
            return null;
        }
        int arrayIndex = Arrays.binarySearch(this.mKeys, index);
        if (arrayIndex < 0) {
            return null;
        }
        int baseCoordIndex = arrayIndex * 4;
        return new RectF(this.mCoordinates[baseCoordIndex], this.mCoordinates[baseCoordIndex + 1], this.mCoordinates[baseCoordIndex + 2], this.mCoordinates[baseCoordIndex + 3]);
    }

    public int getFlags(int index, int valueIfKeyNotFound) {
        if (this.mKeys == null) {
            return valueIfKeyNotFound;
        }
        if (index < 0) {
            return valueIfKeyNotFound;
        }
        int arrayIndex = Arrays.binarySearch(this.mKeys, index);
        if (arrayIndex < 0) {
            return valueIfKeyNotFound;
        }
        return this.mFlagsArray[arrayIndex];
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public static class SparseRectFArrayBuilder {
        private int mCount = 0;
        private int[] mKeys = null;
        private float[] mCoordinates = null;
        private int[] mFlagsArray = null;
        private static int INITIAL_SIZE = 16;

        private void checkIndex(int key) {
            if (this.mCount == 0) {
                return;
            }
            if (this.mKeys[this.mCount - 1] >= key) {
                throw new IllegalArgumentException("key must be greater than all existing keys.");
            }
        }

        private void ensureBufferSize() {
            int requiredFlagsArraySize;
            int requiredCoordinatesArraySize;
            int requiredIndexArraySize;
            if (this.mKeys == null) {
                this.mKeys = new int[INITIAL_SIZE];
            }
            if (this.mCoordinates == null) {
                this.mCoordinates = new float[INITIAL_SIZE * 4];
            }
            if (this.mFlagsArray == null) {
                this.mFlagsArray = new int[INITIAL_SIZE];
            }
            if (this.mKeys.length <= (requiredIndexArraySize = this.mCount + 1)) {
                int[] newArray = new int[requiredIndexArraySize * 2];
                System.arraycopy(this.mKeys, 0, newArray, 0, this.mCount);
                this.mKeys = newArray;
            }
            if (this.mCoordinates.length <= (requiredCoordinatesArraySize = (this.mCount + 1) * 4)) {
                float[] newArray = new float[requiredCoordinatesArraySize * 2];
                System.arraycopy(this.mCoordinates, 0, newArray, 0, this.mCount * 4);
                this.mCoordinates = newArray;
            }
            if (this.mFlagsArray.length <= (requiredFlagsArraySize = requiredIndexArraySize)) {
                int[] newArray = new int[requiredFlagsArraySize * 2];
                System.arraycopy(this.mFlagsArray, 0, newArray, 0, this.mCount);
                this.mFlagsArray = newArray;
            }
        }

        public SparseRectFArrayBuilder append(int key, float left, float top, float right2, float bottom2, int flags) {
            this.checkIndex(key);
            this.ensureBufferSize();
            int baseCoordinatesIndex = this.mCount * 4;
            this.mCoordinates[baseCoordinatesIndex + 0] = left;
            this.mCoordinates[baseCoordinatesIndex + 1] = top;
            this.mCoordinates[baseCoordinatesIndex + 2] = right2;
            this.mCoordinates[baseCoordinatesIndex + 3] = bottom2;
            int flagsIndex = this.mCount;
            this.mFlagsArray[flagsIndex] = flags;
            this.mKeys[this.mCount] = key;
            ++this.mCount;
            return this;
        }

        public boolean isEmpty() {
            return this.mCount <= 0;
        }

        public SparseRectFArray build() {
            return new SparseRectFArray(this);
        }

        public void reset() {
            if (this.mCount == 0) {
                this.mKeys = null;
                this.mCoordinates = null;
                this.mFlagsArray = null;
            }
            this.mCount = 0;
        }
    }
}

