/*
 * Decompiled with CFR 0.152.
 */
package android.view.textclassifier;

import android.provider.DeviceConfig;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.util.IndentingPrintWriter;

public class TextClassificationConstants {
    private static final String SMART_LINKIFY_ENABLED = "smart_linkify_enabled";
    static final String SYSTEM_TEXT_CLASSIFIER_ENABLED = "system_textclassifier_enabled";
    @VisibleForTesting
    static final String LOCAL_TEXT_CLASSIFIER_ENABLED = "local_textclassifier_enabled";
    private static final String MODEL_DARK_LAUNCH_ENABLED = "model_dark_launch_enabled";
    private static final String SMART_SELECTION_ENABLED = "smart_selection_enabled";
    private static final String SMART_TEXT_SHARE_ENABLED = "smart_text_share_enabled";
    private static final String SMART_SELECT_ANIMATION_ENABLED = "smart_select_animation_enabled";
    @VisibleForTesting
    static final String GENERATE_LINKS_MAX_TEXT_LENGTH = "generate_links_max_text_length";
    @VisibleForTesting
    static final String TEXT_CLASSIFIER_SERVICE_PACKAGE_OVERRIDE = "textclassifier_service_package_override";
    @VisibleForTesting
    static final String SYSTEM_TEXT_CLASSIFIER_API_TIMEOUT_IN_SECOND = "system_textclassifier_api_timeout_in_second";
    private static final String SMART_SELECTION_TRIM_DELTA = "smart_selection_trim_delta";
    private static final String DEFAULT_TEXT_CLASSIFIER_SERVICE_PACKAGE_OVERRIDE = null;
    private static final boolean LOCAL_TEXT_CLASSIFIER_ENABLED_DEFAULT = true;
    private static final boolean SYSTEM_TEXT_CLASSIFIER_ENABLED_DEFAULT = true;
    private static final boolean MODEL_DARK_LAUNCH_ENABLED_DEFAULT = false;
    private static final boolean SMART_SELECTION_ENABLED_DEFAULT = true;
    private static final boolean SMART_TEXT_SHARE_ENABLED_DEFAULT = true;
    private static final boolean SMART_LINKIFY_ENABLED_DEFAULT = true;
    private static final boolean SMART_SELECT_ANIMATION_ENABLED_DEFAULT = true;
    private static final int GENERATE_LINKS_MAX_TEXT_LENGTH_DEFAULT = 100000;
    private static final long SYSTEM_TEXT_CLASSIFIER_API_TIMEOUT_IN_SECOND_DEFAULT = 60L;
    private static final int SMART_SELECTION_TRIM_DELTA_DEFAULT = 120;

    public String getTextClassifierServicePackageOverride() {
        return DeviceConfig.getString("textclassifier", TEXT_CLASSIFIER_SERVICE_PACKAGE_OVERRIDE, DEFAULT_TEXT_CLASSIFIER_SERVICE_PACKAGE_OVERRIDE);
    }

    public boolean isLocalTextClassifierEnabled() {
        return DeviceConfig.getBoolean("textclassifier", LOCAL_TEXT_CLASSIFIER_ENABLED, true);
    }

    public boolean isSystemTextClassifierEnabled() {
        return DeviceConfig.getBoolean("textclassifier", SYSTEM_TEXT_CLASSIFIER_ENABLED, true);
    }

    public boolean isModelDarkLaunchEnabled() {
        return DeviceConfig.getBoolean("textclassifier", MODEL_DARK_LAUNCH_ENABLED, false);
    }

    public boolean isSmartSelectionEnabled() {
        return DeviceConfig.getBoolean("textclassifier", SMART_SELECTION_ENABLED, true);
    }

    public boolean isSmartTextShareEnabled() {
        return DeviceConfig.getBoolean("textclassifier", SMART_TEXT_SHARE_ENABLED, true);
    }

    public boolean isSmartLinkifyEnabled() {
        return DeviceConfig.getBoolean("textclassifier", SMART_LINKIFY_ENABLED, true);
    }

    public boolean isSmartSelectionAnimationEnabled() {
        return DeviceConfig.getBoolean("textclassifier", SMART_SELECT_ANIMATION_ENABLED, true);
    }

    public int getGenerateLinksMaxTextLength() {
        return DeviceConfig.getInt("textclassifier", GENERATE_LINKS_MAX_TEXT_LENGTH, 100000);
    }

    public long getSystemTextClassifierApiTimeoutInSecond() {
        return DeviceConfig.getLong("textclassifier", SYSTEM_TEXT_CLASSIFIER_API_TIMEOUT_IN_SECOND, 60L);
    }

    public int getSmartSelectionTrimDelta() {
        return DeviceConfig.getInt("textclassifier", SMART_SELECTION_TRIM_DELTA, 120);
    }

    void dump(IndentingPrintWriter pw) {
        pw.println("TextClassificationConstants:");
        pw.increaseIndent();
        pw.print(GENERATE_LINKS_MAX_TEXT_LENGTH, this.getGenerateLinksMaxTextLength()).println();
        pw.print(LOCAL_TEXT_CLASSIFIER_ENABLED, this.isLocalTextClassifierEnabled()).println();
        pw.print(MODEL_DARK_LAUNCH_ENABLED, this.isModelDarkLaunchEnabled()).println();
        pw.print(SMART_LINKIFY_ENABLED, this.isSmartLinkifyEnabled()).println();
        pw.print(SMART_SELECT_ANIMATION_ENABLED, this.isSmartSelectionAnimationEnabled()).println();
        pw.print(SMART_SELECTION_ENABLED, this.isSmartSelectionEnabled()).println();
        pw.print(SMART_TEXT_SHARE_ENABLED, this.isSmartTextShareEnabled()).println();
        pw.print(SYSTEM_TEXT_CLASSIFIER_ENABLED, this.isSystemTextClassifierEnabled()).println();
        pw.print(TEXT_CLASSIFIER_SERVICE_PACKAGE_OVERRIDE, this.getTextClassifierServicePackageOverride()).println();
        pw.print(SYSTEM_TEXT_CLASSIFIER_API_TIMEOUT_IN_SECOND, this.getSystemTextClassifierApiTimeoutInSecond()).println();
        pw.print(SMART_SELECTION_TRIM_DELTA, this.getSmartSelectionTrimDelta()).println();
        pw.decreaseIndent();
    }
}

