/*
 * Decompiled with CFR 0.152.
 */
package android.view.textclassifier;

import android.icu.util.ULocale;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.view.textclassifier.SelectionEvent;
import android.view.textclassifier.TextClassificationContext;
import android.view.textclassifier.TextClassificationSessionId;
import com.android.internal.annotations.VisibleForTesting;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Arrays;
import java.util.Objects;

public abstract class TextClassifierEvent
implements Parcelable {
    private static final int PARCEL_TOKEN_TEXT_SELECTION_EVENT = 1;
    private static final int PARCEL_TOKEN_TEXT_LINKIFY_EVENT = 2;
    private static final int PARCEL_TOKEN_CONVERSATION_ACTION_EVENT = 3;
    private static final int PARCEL_TOKEN_LANGUAGE_DETECTION_EVENT = 4;
    public static final int CATEGORY_SELECTION = 1;
    public static final int CATEGORY_LINKIFY = 2;
    public static final int CATEGORY_CONVERSATION_ACTIONS = 3;
    public static final int CATEGORY_LANGUAGE_DETECTION = 4;
    public static final int TYPE_SELECTION_STARTED = 1;
    public static final int TYPE_SELECTION_MODIFIED = 2;
    public static final int TYPE_SMART_SELECTION_SINGLE = 3;
    public static final int TYPE_SMART_SELECTION_MULTI = 4;
    public static final int TYPE_AUTO_SELECTION = 5;
    public static final int TYPE_ACTIONS_SHOWN = 6;
    public static final int TYPE_LINK_CLICKED = 7;
    public static final int TYPE_OVERTYPE = 8;
    public static final int TYPE_COPY_ACTION = 9;
    public static final int TYPE_PASTE_ACTION = 10;
    public static final int TYPE_CUT_ACTION = 11;
    public static final int TYPE_SHARE_ACTION = 12;
    public static final int TYPE_SMART_ACTION = 13;
    public static final int TYPE_SELECTION_DRAG = 14;
    public static final int TYPE_SELECTION_DESTROYED = 15;
    public static final int TYPE_OTHER_ACTION = 16;
    public static final int TYPE_SELECT_ALL = 17;
    public static final int TYPE_SELECTION_RESET = 18;
    public static final int TYPE_MANUAL_REPLY = 19;
    public static final int TYPE_ACTIONS_GENERATED = 20;
    public static final int TYPE_LINKS_GENERATED = 21;
    public static final int TYPE_READ_CLIPBOARD = 22;
    private final int mEventCategory;
    private final int mEventType;
    private final String[] mEntityTypes;
    private TextClassificationContext mEventContext;
    private final String mResultId;
    private final int mEventIndex;
    private final float[] mScores;
    private final String mModelName;
    private final int[] mActionIndices;
    private final ULocale mLocale;
    private final Bundle mExtras;
    @VisibleForTesting(visibility=VisibleForTesting.Visibility.PACKAGE)
    public TextClassificationSessionId mHiddenTempSessionId;
    public static final Parcelable.Creator<TextClassifierEvent> CREATOR = new Parcelable.Creator<TextClassifierEvent>(){

        @Override
        public TextClassifierEvent createFromParcel(Parcel in) {
            int token = in.readInt();
            if (token == 1) {
                return new TextSelectionEvent(in);
            }
            if (token == 2) {
                return new TextLinkifyEvent(in);
            }
            if (token == 4) {
                return new LanguageDetectionEvent(in);
            }
            if (token == 3) {
                return new ConversationActionsEvent(in);
            }
            throw new IllegalStateException("Unexpected input event type token in parcel.");
        }

        public TextClassifierEvent[] newArray(int size) {
            return new TextClassifierEvent[size];
        }
    };

    private TextClassifierEvent(Builder builder2) {
        this.mEventCategory = builder2.mEventCategory;
        this.mEventType = builder2.mEventType;
        this.mEntityTypes = builder2.mEntityTypes;
        this.mEventContext = builder2.mEventContext;
        this.mResultId = builder2.mResultId;
        this.mEventIndex = builder2.mEventIndex;
        this.mScores = builder2.mScores;
        this.mModelName = builder2.mModelName;
        this.mActionIndices = builder2.mActionIndices;
        this.mLocale = builder2.mLocale;
        this.mExtras = builder2.mExtras == null ? Bundle.EMPTY : builder2.mExtras;
    }

    private TextClassifierEvent(Parcel in) {
        this.mEventCategory = in.readInt();
        this.mEventType = in.readInt();
        this.mEntityTypes = in.readStringArray();
        this.mEventContext = in.readParcelable(null, TextClassificationContext.class);
        this.mResultId = in.readString();
        this.mEventIndex = in.readInt();
        int scoresLength = in.readInt();
        this.mScores = new float[scoresLength];
        in.readFloatArray(this.mScores);
        this.mModelName = in.readString();
        this.mActionIndices = in.createIntArray();
        String languageTag = in.readString();
        this.mLocale = languageTag == null ? null : ULocale.forLanguageTag(languageTag);
        this.mExtras = in.readBundle();
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.getParcelToken());
        dest.writeInt(this.mEventCategory);
        dest.writeInt(this.mEventType);
        dest.writeStringArray(this.mEntityTypes);
        dest.writeParcelable(this.mEventContext, flags);
        dest.writeString(this.mResultId);
        dest.writeInt(this.mEventIndex);
        dest.writeInt(this.mScores.length);
        dest.writeFloatArray(this.mScores);
        dest.writeString(this.mModelName);
        dest.writeIntArray(this.mActionIndices);
        dest.writeString(this.mLocale == null ? null : this.mLocale.toLanguageTag());
        dest.writeBundle(this.mExtras);
    }

    private int getParcelToken() {
        if (this instanceof TextSelectionEvent) {
            return 1;
        }
        if (this instanceof TextLinkifyEvent) {
            return 2;
        }
        if (this instanceof LanguageDetectionEvent) {
            return 4;
        }
        if (this instanceof ConversationActionsEvent) {
            return 3;
        }
        throw new IllegalArgumentException("Unexpected type: " + this.getClass().getSimpleName());
    }

    public int getEventCategory() {
        return this.mEventCategory;
    }

    public int getEventType() {
        return this.mEventType;
    }

    public String[] getEntityTypes() {
        return this.mEntityTypes;
    }

    public TextClassificationContext getEventContext() {
        return this.mEventContext;
    }

    void setEventContext(TextClassificationContext eventContext) {
        this.mEventContext = eventContext;
    }

    public String getResultId() {
        return this.mResultId;
    }

    public int getEventIndex() {
        return this.mEventIndex;
    }

    public float[] getScores() {
        return this.mScores;
    }

    public String getModelName() {
        return this.mModelName;
    }

    public int[] getActionIndices() {
        return this.mActionIndices;
    }

    public ULocale getLocale() {
        return this.mLocale;
    }

    public Bundle getExtras() {
        return this.mExtras;
    }

    public String toString() {
        StringBuilder out = new StringBuilder(128);
        out.append(this.getClass().getSimpleName());
        out.append("{");
        out.append("mEventCategory=").append(this.mEventCategory);
        out.append(", mEventType=").append(this.mEventType);
        out.append(", mEntityTypes=").append(Arrays.toString(this.mEntityTypes));
        out.append(", mEventContext=").append(this.mEventContext);
        out.append(", mResultId=").append(this.mResultId);
        out.append(", mEventIndex=").append(this.mEventIndex);
        out.append(", mExtras=").append(this.mExtras);
        out.append(", mScores=").append(Arrays.toString(this.mScores));
        out.append(", mModelName=").append(this.mModelName);
        out.append(", mActionIndices=").append(Arrays.toString(this.mActionIndices));
        this.toString(out);
        out.append("}");
        return out.toString();
    }

    void toString(StringBuilder out) {
    }

    @VisibleForTesting(visibility=VisibleForTesting.Visibility.PACKAGE)
    public SelectionEvent toSelectionEvent() {
        int eventType;
        int invocationMethod;
        switch (this.getEventCategory()) {
            case 1: {
                invocationMethod = 1;
                break;
            }
            case 2: {
                invocationMethod = 2;
                break;
            }
            default: {
                return null;
            }
        }
        String entityType = this.getEntityTypes().length > 0 ? this.getEntityTypes()[0] : "";
        SelectionEvent out = new SelectionEvent(0, 0, 0, entityType, 0, "");
        out.setInvocationMethod(invocationMethod);
        TextClassificationContext eventContext = this.getEventContext();
        if (eventContext != null) {
            out.setTextClassificationSessionContext(this.getEventContext());
        }
        out.setSessionId(this.mHiddenTempSessionId);
        String resultId = this.getResultId();
        out.setResultId(resultId == null ? "" : resultId);
        out.setEventIndex(this.getEventIndex());
        switch (this.getEventType()) {
            case 1: {
                eventType = 1;
                break;
            }
            case 2: {
                eventType = 2;
                break;
            }
            case 3: {
                eventType = 3;
                break;
            }
            case 4: {
                eventType = 4;
                break;
            }
            case 5: {
                eventType = 5;
                break;
            }
            case 8: {
                eventType = 100;
                break;
            }
            case 9: {
                eventType = 101;
                break;
            }
            case 10: {
                eventType = 102;
                break;
            }
            case 11: {
                eventType = 103;
                break;
            }
            case 12: {
                eventType = 104;
                break;
            }
            case 13: {
                eventType = 105;
                break;
            }
            case 14: {
                eventType = 106;
                break;
            }
            case 15: {
                eventType = 107;
                break;
            }
            case 16: {
                eventType = 108;
                break;
            }
            case 17: {
                eventType = 200;
                break;
            }
            case 18: {
                eventType = 201;
                break;
            }
            default: {
                eventType = 0;
            }
        }
        out.setEventType(eventType);
        if (this instanceof TextSelectionEvent) {
            TextSelectionEvent selEvent = (TextSelectionEvent)this;
            out.setStart(selEvent.getRelativeWordStartIndex());
            out.setEnd(selEvent.getRelativeWordEndIndex());
            out.setSmartStart(selEvent.getRelativeSuggestedWordStartIndex());
            out.setSmartEnd(selEvent.getRelativeSuggestedWordEndIndex());
        }
        return out;
    }

    public static class ConversationActionsEvent
    extends TextClassifierEvent
    implements Parcelable {
        public static final Parcelable.Creator<ConversationActionsEvent> CREATOR = new Parcelable.Creator<ConversationActionsEvent>(){

            @Override
            public ConversationActionsEvent createFromParcel(Parcel in) {
                in.readInt();
                return new ConversationActionsEvent(in);
            }

            public ConversationActionsEvent[] newArray(int size) {
                return new ConversationActionsEvent[size];
            }
        };

        private ConversationActionsEvent(Parcel in) {
            super(in);
        }

        private ConversationActionsEvent(Builder builder2) {
            super(builder2);
        }

        public static class Builder
        extends android.view.textclassifier.TextClassifierEvent$Builder<Builder> {
            public Builder(int eventType) {
                super(3, eventType);
            }

            @Override
            Builder self() {
                return this;
            }

            public ConversationActionsEvent build() {
                return new ConversationActionsEvent(this);
            }
        }
    }

    public static class LanguageDetectionEvent
    extends TextClassifierEvent
    implements Parcelable {
        public static final Parcelable.Creator<LanguageDetectionEvent> CREATOR = new Parcelable.Creator<LanguageDetectionEvent>(){

            @Override
            public LanguageDetectionEvent createFromParcel(Parcel in) {
                in.readInt();
                return new LanguageDetectionEvent(in);
            }

            public LanguageDetectionEvent[] newArray(int size) {
                return new LanguageDetectionEvent[size];
            }
        };

        private LanguageDetectionEvent(Parcel in) {
            super(in);
        }

        private LanguageDetectionEvent(Builder builder2) {
            super(builder2);
        }

        public static class Builder
        extends android.view.textclassifier.TextClassifierEvent$Builder<Builder> {
            public Builder(int eventType) {
                super(4, eventType);
            }

            @Override
            Builder self() {
                return this;
            }

            public LanguageDetectionEvent build() {
                return new LanguageDetectionEvent(this);
            }
        }
    }

    public static class TextLinkifyEvent
    extends TextClassifierEvent
    implements Parcelable {
        public static final Parcelable.Creator<TextLinkifyEvent> CREATOR = new Parcelable.Creator<TextLinkifyEvent>(){

            @Override
            public TextLinkifyEvent createFromParcel(Parcel in) {
                in.readInt();
                return new TextLinkifyEvent(in);
            }

            public TextLinkifyEvent[] newArray(int size) {
                return new TextLinkifyEvent[size];
            }
        };

        private TextLinkifyEvent(Parcel in) {
            super(in);
        }

        private TextLinkifyEvent(Builder builder2) {
            super(builder2);
        }

        public static class Builder
        extends android.view.textclassifier.TextClassifierEvent$Builder<Builder> {
            public Builder(int eventType) {
                super(2, eventType);
            }

            @Override
            Builder self() {
                return this;
            }

            public TextLinkifyEvent build() {
                return new TextLinkifyEvent(this);
            }
        }
    }

    public static class TextSelectionEvent
    extends TextClassifierEvent
    implements Parcelable {
        public static final Parcelable.Creator<TextSelectionEvent> CREATOR = new Parcelable.Creator<TextSelectionEvent>(){

            @Override
            public TextSelectionEvent createFromParcel(Parcel in) {
                in.readInt();
                return new TextSelectionEvent(in);
            }

            public TextSelectionEvent[] newArray(int size) {
                return new TextSelectionEvent[size];
            }
        };
        final int mRelativeWordStartIndex;
        final int mRelativeWordEndIndex;
        final int mRelativeSuggestedWordStartIndex;
        final int mRelativeSuggestedWordEndIndex;

        private TextSelectionEvent(Builder builder2) {
            super(builder2);
            this.mRelativeWordStartIndex = builder2.mRelativeWordStartIndex;
            this.mRelativeWordEndIndex = builder2.mRelativeWordEndIndex;
            this.mRelativeSuggestedWordStartIndex = builder2.mRelativeSuggestedWordStartIndex;
            this.mRelativeSuggestedWordEndIndex = builder2.mRelativeSuggestedWordEndIndex;
        }

        private TextSelectionEvent(Parcel in) {
            super(in);
            this.mRelativeWordStartIndex = in.readInt();
            this.mRelativeWordEndIndex = in.readInt();
            this.mRelativeSuggestedWordStartIndex = in.readInt();
            this.mRelativeSuggestedWordEndIndex = in.readInt();
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            super.writeToParcel(dest, flags);
            dest.writeInt(this.mRelativeWordStartIndex);
            dest.writeInt(this.mRelativeWordEndIndex);
            dest.writeInt(this.mRelativeSuggestedWordStartIndex);
            dest.writeInt(this.mRelativeSuggestedWordEndIndex);
        }

        public int getRelativeWordStartIndex() {
            return this.mRelativeWordStartIndex;
        }

        public int getRelativeWordEndIndex() {
            return this.mRelativeWordEndIndex;
        }

        public int getRelativeSuggestedWordStartIndex() {
            return this.mRelativeSuggestedWordStartIndex;
        }

        public int getRelativeSuggestedWordEndIndex() {
            return this.mRelativeSuggestedWordEndIndex;
        }

        @Override
        void toString(StringBuilder out) {
            out.append(", getRelativeWordStartIndex=").append(this.mRelativeWordStartIndex);
            out.append(", getRelativeWordEndIndex=").append(this.mRelativeWordEndIndex);
            out.append(", getRelativeSuggestedWordStartIndex=").append(this.mRelativeSuggestedWordStartIndex);
            out.append(", getRelativeSuggestedWordEndIndex=").append(this.mRelativeSuggestedWordEndIndex);
        }

        public static class Builder
        extends android.view.textclassifier.TextClassifierEvent$Builder<Builder> {
            int mRelativeWordStartIndex;
            int mRelativeWordEndIndex;
            int mRelativeSuggestedWordStartIndex;
            int mRelativeSuggestedWordEndIndex;

            public Builder(int eventType) {
                super(1, eventType);
            }

            public Builder setRelativeWordStartIndex(int relativeWordStartIndex) {
                this.mRelativeWordStartIndex = relativeWordStartIndex;
                return this;
            }

            public Builder setRelativeWordEndIndex(int relativeWordEndIndex) {
                this.mRelativeWordEndIndex = relativeWordEndIndex;
                return this;
            }

            public Builder setRelativeSuggestedWordStartIndex(int relativeSuggestedWordStartIndex) {
                this.mRelativeSuggestedWordStartIndex = relativeSuggestedWordStartIndex;
                return this;
            }

            public Builder setRelativeSuggestedWordEndIndex(int relativeSuggestedWordEndIndex) {
                this.mRelativeSuggestedWordEndIndex = relativeSuggestedWordEndIndex;
                return this;
            }

            @Override
            Builder self() {
                return this;
            }

            public TextSelectionEvent build() {
                return new TextSelectionEvent(this);
            }
        }
    }

    public static abstract class Builder<T extends Builder<T>> {
        private final int mEventCategory;
        private final int mEventType;
        private String[] mEntityTypes = new String[0];
        private TextClassificationContext mEventContext;
        private String mResultId;
        private int mEventIndex;
        private float[] mScores = new float[0];
        private String mModelName;
        private int[] mActionIndices = new int[0];
        private ULocale mLocale;
        private Bundle mExtras;

        private Builder(int eventCategory, int eventType) {
            this.mEventCategory = eventCategory;
            this.mEventType = eventType;
        }

        public T setEntityTypes(String ... entityTypes) {
            Objects.requireNonNull(entityTypes);
            this.mEntityTypes = new String[entityTypes.length];
            System.arraycopy(entityTypes, 0, this.mEntityTypes, 0, entityTypes.length);
            return this.self();
        }

        public T setEventContext(TextClassificationContext eventContext) {
            this.mEventContext = eventContext;
            return this.self();
        }

        public T setResultId(String resultId) {
            this.mResultId = resultId;
            return this.self();
        }

        public T setEventIndex(int eventIndex) {
            this.mEventIndex = eventIndex;
            return this.self();
        }

        public T setScores(float ... scores) {
            Objects.requireNonNull(scores);
            this.mScores = new float[scores.length];
            System.arraycopy(scores, 0, this.mScores, 0, scores.length);
            return this.self();
        }

        public T setModelName(String modelVersion) {
            this.mModelName = modelVersion;
            return this.self();
        }

        public T setActionIndices(int ... actionIndices) {
            this.mActionIndices = new int[actionIndices.length];
            System.arraycopy(actionIndices, 0, this.mActionIndices, 0, actionIndices.length);
            return this.self();
        }

        public T setLocale(ULocale locale) {
            this.mLocale = locale;
            return this.self();
        }

        public T setExtras(Bundle extras) {
            this.mExtras = Objects.requireNonNull(extras);
            return this.self();
        }

        abstract T self();
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Type {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Category {
    }
}

