/*
 * Decompiled with CFR 0.152.
 */
package android.view.translation;

import android.annotation.NonNull;
import android.annotation.SystemApi;
import android.os.Parcel;
import android.os.Parcelable;
import android.view.translation.TranslationContext;
import android.view.translation.TranslationSpec;
import com.android.internal.util.AnnotationValidations;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Objects;

public class TranslationCapability
implements Parcelable {
    public static final int STATE_AVAILABLE_TO_DOWNLOAD = 1;
    public static final int STATE_DOWNLOADING = 2;
    public static final int STATE_ON_DEVICE = 3;
    public static final int STATE_NOT_AVAILABLE = 4;
    public static final int STATE_REMOVED_AND_AVAILABLE = 1000;
    private final int mState;
    private final TranslationSpec mSourceSpec;
    private final TranslationSpec mTargetSpec;
    private final boolean mUiTranslationEnabled;
    private final int mSupportedTranslationFlags;
    public static final Parcelable.Creator<TranslationCapability> CREATOR = new Parcelable.Creator<TranslationCapability>(){

        public TranslationCapability[] newArray(int size) {
            return new TranslationCapability[size];
        }

        @Override
        public TranslationCapability createFromParcel(Parcel in) {
            return new TranslationCapability(in);
        }
    };

    @SystemApi
    public TranslationCapability(int state, TranslationSpec sourceSpec, TranslationSpec targetSpec, boolean uiTranslationEnabled, int supportedTranslationFlags) {
        Objects.requireNonNull(sourceSpec, "sourceSpec should not be null");
        Objects.requireNonNull(targetSpec, "targetSpec should not be null");
        this.mState = state;
        this.mSourceSpec = sourceSpec;
        this.mTargetSpec = targetSpec;
        this.mUiTranslationEnabled = uiTranslationEnabled;
        this.mSupportedTranslationFlags = supportedTranslationFlags;
    }

    public static String modelStateToString(int value2) {
        switch (value2) {
            case 1: {
                return "STATE_AVAILABLE_TO_DOWNLOAD";
            }
            case 2: {
                return "STATE_DOWNLOADING";
            }
            case 3: {
                return "STATE_ON_DEVICE";
            }
            case 4: {
                return "STATE_NOT_AVAILABLE";
            }
            case 1000: {
                return "STATE_REMOVED_AND_AVAILABLE";
            }
        }
        return Integer.toHexString(value2);
    }

    public int getState() {
        return this.mState;
    }

    public TranslationSpec getSourceSpec() {
        return this.mSourceSpec;
    }

    public TranslationSpec getTargetSpec() {
        return this.mTargetSpec;
    }

    public boolean isUiTranslationEnabled() {
        return this.mUiTranslationEnabled;
    }

    public int getSupportedTranslationFlags() {
        return this.mSupportedTranslationFlags;
    }

    public String toString() {
        return "TranslationCapability { state = " + TranslationCapability.modelStateToString(this.mState) + ", sourceSpec = " + this.mSourceSpec + ", targetSpec = " + this.mTargetSpec + ", uiTranslationEnabled = " + this.mUiTranslationEnabled + ", supportedTranslationFlags = " + this.mSupportedTranslationFlags + " }";
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        byte flg = 0;
        if (this.mUiTranslationEnabled) {
            flg = (byte)(flg | 8);
        }
        dest.writeByte(flg);
        dest.writeInt(this.mState);
        dest.writeTypedObject(this.mSourceSpec, flags);
        dest.writeTypedObject(this.mTargetSpec, flags);
        dest.writeInt(this.mSupportedTranslationFlags);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    TranslationCapability(Parcel in) {
        byte flg = in.readByte();
        boolean uiTranslationEnabled = (flg & 8) != 0;
        int state = in.readInt();
        TranslationSpec sourceSpec = in.readTypedObject(TranslationSpec.CREATOR);
        TranslationSpec targetSpec = in.readTypedObject(TranslationSpec.CREATOR);
        int supportedTranslationFlags = in.readInt();
        this.mState = state;
        if (this.mState != 1 && this.mState != 2 && this.mState != 3 && this.mState != 4 && this.mState != 1000) {
            throw new IllegalArgumentException("state was " + this.mState + " but must be one of: STATE_AVAILABLE_TO_DOWNLOAD(" + 1 + "), STATE_DOWNLOADING(" + 2 + "), STATE_ON_DEVICE(" + 3 + "), STATE_NOT_AVAILABLE(" + 4 + "), STATE_REMOVED_AND_AVAILABLE(" + 1000 + ")");
        }
        this.mSourceSpec = sourceSpec;
        AnnotationValidations.validate(NonNull.class, null, (Object)this.mSourceSpec);
        this.mTargetSpec = targetSpec;
        AnnotationValidations.validate(NonNull.class, null, (Object)this.mTargetSpec);
        this.mUiTranslationEnabled = uiTranslationEnabled;
        this.mSupportedTranslationFlags = supportedTranslationFlags;
        AnnotationValidations.validate(TranslationContext.TranslationFlag.class, null, this.mSupportedTranslationFlags);
    }

    @Deprecated
    private void __metadata() {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ModelState {
    }
}

