/*
 * Decompiled with CFR 0.152.
 */
package android.view.translation;

import android.annotation.NonNull;
import android.annotation.SystemApi;
import android.app.assist.ActivityId;
import android.os.Parcel;
import android.os.Parcelable;
import android.view.translation.TranslationSpec;
import com.android.internal.util.AnnotationValidations;
import com.android.internal.util.BitUtils;
import com.android.internal.util.Preconditions;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public class TranslationContext
implements Parcelable {
    public static final int FLAG_LOW_LATENCY = 1;
    public static final int FLAG_TRANSLITERATION = 2;
    public static final int FLAG_DEFINITIONS = 4;
    private final TranslationSpec mSourceSpec;
    private final TranslationSpec mTargetSpec;
    private final int mTranslationFlags;
    private final ActivityId mActivityId;
    public static final Parcelable.Creator<TranslationContext> CREATOR = new Parcelable.Creator<TranslationContext>(){

        public TranslationContext[] newArray(int size) {
            return new TranslationContext[size];
        }

        @Override
        public TranslationContext createFromParcel(Parcel in) {
            return new TranslationContext(in);
        }
    };

    private static int defaultTranslationFlags() {
        return 0;
    }

    private static ActivityId defaultActivityId() {
        return null;
    }

    private void parcelActivityId(Parcel dest, int flags) {
        dest.writeBoolean(this.mActivityId != null);
        if (this.mActivityId != null) {
            this.mActivityId.writeToParcel(dest, flags);
        }
    }

    private ActivityId unparcelActivityId(Parcel in) {
        boolean hasActivityId = in.readBoolean();
        return hasActivityId ? new ActivityId(in) : null;
    }

    @SystemApi
    public ActivityId getActivityId() {
        return this.mActivityId;
    }

    public static String translationFlagToString(int value2) {
        return BitUtils.flagsToString(value2, TranslationContext::singleTranslationFlagToString);
    }

    static String singleTranslationFlagToString(int value2) {
        switch (value2) {
            case 1: {
                return "FLAG_LOW_LATENCY";
            }
            case 2: {
                return "FLAG_TRANSLITERATION";
            }
            case 4: {
                return "FLAG_DEFINITIONS";
            }
        }
        return Integer.toHexString(value2);
    }

    TranslationContext(TranslationSpec sourceSpec, TranslationSpec targetSpec, int translationFlags, ActivityId activityId) {
        this.mSourceSpec = sourceSpec;
        AnnotationValidations.validate(NonNull.class, null, (Object)this.mSourceSpec);
        this.mTargetSpec = targetSpec;
        AnnotationValidations.validate(NonNull.class, null, (Object)this.mTargetSpec);
        this.mTranslationFlags = translationFlags;
        Preconditions.checkFlagsArgument(this.mTranslationFlags, 7);
        this.mActivityId = activityId;
    }

    public TranslationSpec getSourceSpec() {
        return this.mSourceSpec;
    }

    public TranslationSpec getTargetSpec() {
        return this.mTargetSpec;
    }

    public int getTranslationFlags() {
        return this.mTranslationFlags;
    }

    public String toString() {
        return "TranslationContext { sourceSpec = " + this.mSourceSpec + ", targetSpec = " + this.mTargetSpec + ", translationFlags = " + TranslationContext.translationFlagToString(this.mTranslationFlags) + ", activityId = " + this.mActivityId + " }";
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        byte flg = 0;
        if (this.mActivityId != null) {
            flg = (byte)(flg | 8);
        }
        dest.writeByte(flg);
        dest.writeTypedObject(this.mSourceSpec, flags);
        dest.writeTypedObject(this.mTargetSpec, flags);
        dest.writeInt(this.mTranslationFlags);
        this.parcelActivityId(dest, flags);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    TranslationContext(Parcel in) {
        byte flg = in.readByte();
        TranslationSpec sourceSpec = in.readTypedObject(TranslationSpec.CREATOR);
        TranslationSpec targetSpec = in.readTypedObject(TranslationSpec.CREATOR);
        int translationFlags = in.readInt();
        ActivityId activityId = this.unparcelActivityId(in);
        this.mSourceSpec = sourceSpec;
        AnnotationValidations.validate(NonNull.class, null, (Object)this.mSourceSpec);
        this.mTargetSpec = targetSpec;
        AnnotationValidations.validate(NonNull.class, null, (Object)this.mTargetSpec);
        this.mTranslationFlags = translationFlags;
        Preconditions.checkFlagsArgument(this.mTranslationFlags, 7);
        this.mActivityId = activityId;
    }

    @Deprecated
    private void __metadata() {
    }

    public static class Builder
    extends BaseBuilder {
        private TranslationSpec mSourceSpec;
        private TranslationSpec mTargetSpec;
        private int mTranslationFlags;
        private ActivityId mActivityId;
        private long mBuilderFieldsSet = 0L;

        public Builder(TranslationSpec sourceSpec, TranslationSpec targetSpec) {
            this.mSourceSpec = sourceSpec;
            AnnotationValidations.validate(NonNull.class, null, (Object)this.mSourceSpec);
            this.mTargetSpec = targetSpec;
            AnnotationValidations.validate(NonNull.class, null, (Object)this.mTargetSpec);
        }

        public Builder setTranslationFlags(int value2) {
            this.checkNotUsed();
            this.mBuilderFieldsSet |= 4L;
            this.mTranslationFlags = value2;
            return this;
        }

        public Builder setActivityId(ActivityId value2) {
            this.checkNotUsed();
            this.mBuilderFieldsSet |= 8L;
            this.mActivityId = value2;
            return this;
        }

        public TranslationContext build() {
            this.checkNotUsed();
            this.mBuilderFieldsSet |= 0x10L;
            if ((this.mBuilderFieldsSet & 4L) == 0L) {
                this.mTranslationFlags = TranslationContext.defaultTranslationFlags();
            }
            if ((this.mBuilderFieldsSet & 8L) == 0L) {
                this.mActivityId = TranslationContext.defaultActivityId();
            }
            TranslationContext o = new TranslationContext(this.mSourceSpec, this.mTargetSpec, this.mTranslationFlags, this.mActivityId);
            return o;
        }

        private void checkNotUsed() {
            if ((this.mBuilderFieldsSet & 0x10L) != 0L) {
                throw new IllegalStateException("This Builder should not be reused. Use a new Builder instance instead");
            }
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface TranslationFlag {
    }

    static abstract class BaseBuilder {
        BaseBuilder() {
        }
    }
}

