/*
 * Decompiled with CFR 0.152.
 */
package android.view.translation;

import android.annotation.NonNull;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.SparseArray;
import android.view.translation.TranslationResponseValue;
import android.view.translation.ViewTranslationResponse;
import com.android.internal.util.AnnotationValidations;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Objects;

public class TranslationResponse
implements Parcelable {
    public static final int TRANSLATION_STATUS_SUCCESS = 0;
    public static final int TRANSLATION_STATUS_UNKNOWN_ERROR = 1;
    public static final int TRANSLATION_STATUS_CONTEXT_UNSUPPORTED = 2;
    private final int mTranslationStatus;
    private final SparseArray<TranslationResponseValue> mTranslationResponseValues;
    private final SparseArray<ViewTranslationResponse> mViewTranslationResponses;
    private final boolean mFinalResponse;
    public static final Parcelable.Creator<TranslationResponse> CREATOR = new Parcelable.Creator<TranslationResponse>(){

        public TranslationResponse[] newArray(int size) {
            return new TranslationResponse[size];
        }

        @Override
        public TranslationResponse createFromParcel(Parcel in) {
            return new TranslationResponse(in);
        }
    };

    private static SparseArray<TranslationResponseValue> defaultTranslationResponseValues() {
        return new SparseArray<TranslationResponseValue>();
    }

    private static SparseArray<ViewTranslationResponse> defaultViewTranslationResponses() {
        return new SparseArray<ViewTranslationResponse>();
    }

    private static boolean defaultFinalResponse() {
        return true;
    }

    public static String translationStatusToString(int value2) {
        switch (value2) {
            case 0: {
                return "TRANSLATION_STATUS_SUCCESS";
            }
            case 1: {
                return "TRANSLATION_STATUS_UNKNOWN_ERROR";
            }
            case 2: {
                return "TRANSLATION_STATUS_CONTEXT_UNSUPPORTED";
            }
        }
        return Integer.toHexString(value2);
    }

    TranslationResponse(int translationStatus, SparseArray<TranslationResponseValue> translationResponseValues, SparseArray<ViewTranslationResponse> viewTranslationResponses, boolean finalResponse) {
        this.mTranslationStatus = translationStatus;
        if (this.mTranslationStatus != 0 && this.mTranslationStatus != 1 && this.mTranslationStatus != 2) {
            throw new IllegalArgumentException("translationStatus was " + this.mTranslationStatus + " but must be one of: TRANSLATION_STATUS_SUCCESS(" + 0 + "), TRANSLATION_STATUS_UNKNOWN_ERROR(" + 1 + "), TRANSLATION_STATUS_CONTEXT_UNSUPPORTED(" + 2 + ")");
        }
        this.mTranslationResponseValues = translationResponseValues;
        AnnotationValidations.validate(NonNull.class, null, this.mTranslationResponseValues);
        this.mViewTranslationResponses = viewTranslationResponses;
        AnnotationValidations.validate(NonNull.class, null, this.mViewTranslationResponses);
        this.mFinalResponse = finalResponse;
    }

    public int getTranslationStatus() {
        return this.mTranslationStatus;
    }

    public SparseArray<TranslationResponseValue> getTranslationResponseValues() {
        return this.mTranslationResponseValues;
    }

    public SparseArray<ViewTranslationResponse> getViewTranslationResponses() {
        return this.mViewTranslationResponses;
    }

    public boolean isFinalResponse() {
        return this.mFinalResponse;
    }

    public String toString() {
        return "TranslationResponse { translationStatus = " + TranslationResponse.translationStatusToString(this.mTranslationStatus) + ", translationResponseValues = " + this.mTranslationResponseValues + ", viewTranslationResponses = " + this.mViewTranslationResponses + ", finalResponse = " + this.mFinalResponse + " }";
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        byte flg = 0;
        if (this.mFinalResponse) {
            flg = (byte)(flg | 8);
        }
        dest.writeByte(flg);
        dest.writeInt(this.mTranslationStatus);
        dest.writeSparseArray(this.mTranslationResponseValues);
        dest.writeSparseArray(this.mViewTranslationResponses);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    TranslationResponse(Parcel in) {
        byte flg = in.readByte();
        boolean finalResponse = (flg & 8) != 0;
        int translationStatus = in.readInt();
        SparseArray translationResponseValues = in.readSparseArray(TranslationResponseValue.class.getClassLoader());
        SparseArray viewTranslationResponses = in.readSparseArray(ViewTranslationResponse.class.getClassLoader());
        this.mTranslationStatus = translationStatus;
        if (this.mTranslationStatus != 0 && this.mTranslationStatus != 1 && this.mTranslationStatus != 2) {
            throw new IllegalArgumentException("translationStatus was " + this.mTranslationStatus + " but must be one of: TRANSLATION_STATUS_SUCCESS(" + 0 + "), TRANSLATION_STATUS_UNKNOWN_ERROR(" + 1 + "), TRANSLATION_STATUS_CONTEXT_UNSUPPORTED(" + 2 + ")");
        }
        this.mTranslationResponseValues = translationResponseValues;
        AnnotationValidations.validate(NonNull.class, null, this.mTranslationResponseValues);
        this.mViewTranslationResponses = viewTranslationResponses;
        AnnotationValidations.validate(NonNull.class, null, this.mViewTranslationResponses);
        this.mFinalResponse = finalResponse;
    }

    @Deprecated
    private void __metadata() {
    }

    public static class Builder
    extends BaseBuilder {
        private int mTranslationStatus;
        private SparseArray<TranslationResponseValue> mTranslationResponseValues;
        private SparseArray<ViewTranslationResponse> mViewTranslationResponses;
        private boolean mFinalResponse;
        private long mBuilderFieldsSet = 0L;

        public Builder(int translationStatus) {
            this.mTranslationStatus = translationStatus;
            if (this.mTranslationStatus != 0 && this.mTranslationStatus != 1 && this.mTranslationStatus != 2) {
                throw new IllegalArgumentException("translationStatus was " + this.mTranslationStatus + " but must be one of: TRANSLATION_STATUS_SUCCESS(" + 0 + "), TRANSLATION_STATUS_UNKNOWN_ERROR(" + 1 + "), TRANSLATION_STATUS_CONTEXT_UNSUPPORTED(" + 2 + ")");
            }
        }

        @Override
        @Deprecated
        public Builder setTranslationStatus(int value2) {
            this.checkNotUsed();
            this.mBuilderFieldsSet |= 1L;
            this.mTranslationStatus = value2;
            return this;
        }

        public Builder setTranslationResponseValues(SparseArray<TranslationResponseValue> value2) {
            this.checkNotUsed();
            this.mBuilderFieldsSet |= 2L;
            this.mTranslationResponseValues = value2;
            return this;
        }

        public Builder setViewTranslationResponses(SparseArray<ViewTranslationResponse> value2) {
            this.checkNotUsed();
            this.mBuilderFieldsSet |= 4L;
            this.mViewTranslationResponses = value2;
            return this;
        }

        public Builder setFinalResponse(boolean value2) {
            this.checkNotUsed();
            this.mBuilderFieldsSet |= 8L;
            this.mFinalResponse = value2;
            return this;
        }

        public TranslationResponse build() {
            this.checkNotUsed();
            this.mBuilderFieldsSet |= 0x10L;
            if ((this.mBuilderFieldsSet & 2L) == 0L) {
                this.mTranslationResponseValues = TranslationResponse.defaultTranslationResponseValues();
            }
            if ((this.mBuilderFieldsSet & 4L) == 0L) {
                this.mViewTranslationResponses = TranslationResponse.defaultViewTranslationResponses();
            }
            if ((this.mBuilderFieldsSet & 8L) == 0L) {
                this.mFinalResponse = TranslationResponse.defaultFinalResponse();
            }
            TranslationResponse o = new TranslationResponse(this.mTranslationStatus, this.mTranslationResponseValues, this.mViewTranslationResponses, this.mFinalResponse);
            return o;
        }

        private void checkNotUsed() {
            if ((this.mBuilderFieldsSet & 0x10L) != 0L) {
                throw new IllegalStateException("This Builder should not be reused. Use a new Builder instance instead");
            }
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface TranslationStatus {
    }

    static abstract class BaseBuilder {
        BaseBuilder() {
        }

        @Deprecated
        public abstract Builder setTranslationStatus(int var1);

        public Builder setTranslationResponseValue(int index, TranslationResponseValue value2) {
            Objects.requireNonNull(value2, "value should not be null");
            Builder builder2 = (Builder)this;
            if (builder2.mTranslationResponseValues == null) {
                builder2.setTranslationResponseValues(new SparseArray<TranslationResponseValue>());
            }
            builder2.mTranslationResponseValues.put(index, value2);
            return builder2;
        }

        public Builder setViewTranslationResponse(int index, ViewTranslationResponse response) {
            Objects.requireNonNull(response, "value should not be null");
            Builder builder2 = (Builder)this;
            if (builder2.mViewTranslationResponses == null) {
                builder2.setViewTranslationResponses(new SparseArray<ViewTranslationResponse>());
            }
            builder2.mViewTranslationResponses.put(index, response);
            return builder2;
        }
    }
}

