/*
 * Decompiled with CFR 0.152.
 */
package android.view.translation;

import android.app.Activity;
import android.app.assist.ActivityId;
import android.content.Context;
import android.os.Bundle;
import android.os.Handler;
import android.os.HandlerThread;
import android.util.ArrayMap;
import android.util.ArraySet;
import android.util.Dumpable;
import android.util.IntArray;
import android.util.Log;
import android.util.LongSparseArray;
import android.util.Pair;
import android.util.SparseArray;
import android.util.SparseIntArray;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewRootImpl;
import android.view.WindowManagerGlobal;
import android.view.autofill.AutofillId;
import android.view.translation.TranslationCapability;
import android.view.translation.TranslationContext;
import android.view.translation.TranslationManager;
import android.view.translation.TranslationRequest;
import android.view.translation.TranslationRequestValue;
import android.view.translation.TranslationResponse;
import android.view.translation.TranslationResponseValue;
import android.view.translation.TranslationSpec;
import android.view.translation.Translator;
import android.view.translation.UiTranslationManager;
import android.view.translation.UiTranslationSpec;
import android.view.translation.ViewTranslationCallback;
import android.view.translation.ViewTranslationRequest;
import android.view.translation.ViewTranslationResponse;
import android.widget.TextView;
import android.widget.TextViewTranslationCallback;
import com.android.internal.util.function.pooled.PooledLambda;
import java.io.PrintWriter;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;

public class UiTranslationController
implements Dumpable {
    public static final boolean DEBUG = Log.isLoggable("UiTranslation", 3);
    public static final String DUMPABLE_NAME = "UiTranslationController";
    private static final String TAG = "UiTranslationController";
    private final Activity mActivity;
    private final Context mContext;
    private final Object mLock = new Object();
    private final ArrayMap<Pair<TranslationSpec, TranslationSpec>, Translator> mTranslators;
    private final ArrayMap<AutofillId, WeakReference<View>> mViews;
    private final ArraySet<AutofillId> mViewsToPadContent;
    private final HandlerThread mWorkerThread;
    private final Handler mWorkerHandler;
    private int mCurrentState;
    private ArraySet<AutofillId> mLastRequestAutofillIds;

    public UiTranslationController(Activity activity, Context context) {
        this.mActivity = activity;
        this.mContext = context;
        this.mViews = new ArrayMap();
        this.mTranslators = new ArrayMap();
        this.mViewsToPadContent = new ArraySet();
        this.mWorkerThread = new HandlerThread("UiTranslationController_" + this.mActivity.getComponentName(), -2);
        this.mWorkerThread.start();
        this.mWorkerHandler = this.mWorkerThread.getThreadHandler();
        activity.addDumpable(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateUiTranslationState(int state, TranslationSpec sourceSpec, TranslationSpec targetSpec, List<AutofillId> views, UiTranslationSpec uiTranslationSpec) {
        if (this.mActivity.isDestroyed()) {
            Log.i("UiTranslationController", "Cannot update " + UiTranslationController.stateToString(state) + " for destroyed " + this.mActivity);
            return;
        }
        Log.i("UiTranslationController", "updateUiTranslationState state: " + UiTranslationController.stateToString(state) + (DEBUG ? ", views: " + views + ", spec: " + uiTranslationSpec : ""));
        Object object = this.mLock;
        synchronized (object) {
            this.mCurrentState = state;
            if (views != null) {
                this.setLastRequestAutofillIdsLocked(views);
            }
        }
        switch (state) {
            case 0: {
                Pair<TranslationSpec, TranslationSpec> specs;
                if (uiTranslationSpec != null && uiTranslationSpec.shouldPadContentForCompat()) {
                    object = this.mLock;
                    synchronized (object) {
                        this.mViewsToPadContent.addAll(views);
                    }
                }
                if (!this.mTranslators.containsKey(specs = new Pair<TranslationSpec, TranslationSpec>(sourceSpec, targetSpec))) {
                    this.mWorkerHandler.sendMessage(PooledLambda.obtainMessage(UiTranslationController::createTranslatorAndStart, this, sourceSpec, targetSpec, views));
                    break;
                }
                this.onUiTranslationStarted(this.mTranslators.get(specs), views);
                break;
            }
            case 1: {
                this.runForEachView((view2, callback2) -> callback2.onHideTranslation((View)view2));
                break;
            }
            case 2: {
                this.runForEachView((view2, callback2) -> callback2.onShowTranslation((View)view2));
                break;
            }
            case 3: {
                this.destroyTranslators();
                this.runForEachView((view2, callback2) -> view2.clearTranslationState());
                this.notifyTranslationFinished(false);
                Object object2 = this.mLock;
                synchronized (object2) {
                    this.mViews.clear();
                    break;
                }
            }
            default: {
                Log.w("UiTranslationController", "onAutoTranslationStateChange(): unknown state: " + state);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onActivityDestroyed() {
        Object object = this.mLock;
        synchronized (object) {
            if (DEBUG) {
                Log.i("UiTranslationController", "onActivityDestroyed(): mCurrentState is " + UiTranslationController.stateToString(this.mCurrentState));
            }
            if (this.mCurrentState != 3) {
                this.notifyTranslationFinished(true);
            }
            this.mViews.clear();
            this.destroyTranslators();
            this.mWorkerThread.quitSafely();
        }
    }

    private void notifyTranslationFinished(boolean activityDestroyed) {
        UiTranslationManager manager = this.mContext.getSystemService(UiTranslationManager.class);
        if (manager != null) {
            manager.onTranslationFinished(activityDestroyed, new ActivityId(this.mActivity.getTaskId(), this.mActivity.getShareableActivityToken()), this.mActivity.getComponentName());
        }
    }

    private void setLastRequestAutofillIdsLocked(List<AutofillId> views) {
        if (this.mLastRequestAutofillIds == null) {
            this.mLastRequestAutofillIds = new ArraySet();
        }
        if (this.mLastRequestAutofillIds.size() > 0) {
            this.mLastRequestAutofillIds.clear();
        }
        this.mLastRequestAutofillIds.addAll(views);
    }

    @Override
    public String getDumpableName() {
        return "UiTranslationController";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dump(PrintWriter pw, String[] args) {
        String outerPrefix = "";
        pw.print(outerPrefix);
        pw.println("UiTranslationController:");
        String pfx = outerPrefix + "  ";
        pw.print(pfx);
        pw.print("activity: ");
        pw.print(this.mActivity);
        pw.print(pfx);
        pw.print("resumed: ");
        pw.println(this.mActivity.isResumed());
        pw.print(pfx);
        pw.print("current state: ");
        pw.println(this.mCurrentState);
        int translatorSize = this.mTranslators.size();
        pw.print(outerPrefix);
        pw.print("number translator: ");
        pw.println(translatorSize);
        for (int i = 0; i < translatorSize; ++i) {
            pw.print(outerPrefix);
            pw.print("#");
            pw.println(i);
            Translator translator = this.mTranslators.valueAt(i);
            translator.dump(outerPrefix, pw);
            pw.println();
        }
        Object object = this.mLock;
        synchronized (object) {
            int viewSize = this.mViews.size();
            pw.print(outerPrefix);
            pw.print("number views: ");
            pw.println(viewSize);
            for (int i = 0; i < viewSize; ++i) {
                pw.print(outerPrefix);
                pw.print("#");
                pw.println(i);
                AutofillId autofillId = this.mViews.keyAt(i);
                View view2 = (View)this.mViews.valueAt(i).get();
                pw.print(pfx);
                pw.print("autofillId: ");
                pw.println(autofillId);
                pw.print(pfx);
                pw.print("view:");
                pw.println(view2);
            }
            pw.print(outerPrefix);
            pw.print("padded views: ");
            pw.println(this.mViewsToPadContent);
        }
        if (DEBUG) {
            this.dumpViewByTraversal(outerPrefix, pw);
        }
    }

    private void dumpViewByTraversal(String outerPrefix, PrintWriter pw) {
        ArrayList<ViewRootImpl> roots = WindowManagerGlobal.getInstance().getRootViews(this.mActivity.getActivityToken());
        pw.print(outerPrefix);
        pw.println("Dump views:");
        for (int rootNum = 0; rootNum < roots.size(); ++rootNum) {
            View rootView = roots.get(rootNum).getView();
            if (rootView instanceof ViewGroup) {
                this.dumpChildren((ViewGroup)rootView, outerPrefix, pw);
                continue;
            }
            this.dumpViewInfo(rootView, outerPrefix, pw);
        }
    }

    private void dumpChildren(ViewGroup viewGroup, String outerPrefix, PrintWriter pw) {
        int childCount = viewGroup.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            View child = viewGroup.getChildAt(i);
            if (child instanceof ViewGroup) {
                pw.print(outerPrefix);
                pw.println("Children: ");
                pw.print(outerPrefix);
                pw.print(outerPrefix);
                pw.println(child);
                this.dumpChildren((ViewGroup)child, outerPrefix, pw);
                continue;
            }
            pw.print(outerPrefix);
            pw.println("End Children: ");
            pw.print(outerPrefix);
            pw.print(outerPrefix);
            pw.print(child);
            this.dumpViewInfo(child, outerPrefix, pw);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dumpViewInfo(View view2, String outerPrefix, PrintWriter pw) {
        AutofillId autofillId = view2.getAutofillId();
        pw.print(outerPrefix);
        pw.print("autofillId: ");
        pw.print(autofillId);
        boolean isContainsView = false;
        boolean isRequestedView = false;
        Object object = this.mLock;
        synchronized (object) {
            WeakReference<View> viewRef;
            if (this.mLastRequestAutofillIds.contains(autofillId)) {
                isRequestedView = true;
            }
            if ((viewRef = this.mViews.get(autofillId)) != null && viewRef.get() != null) {
                isContainsView = true;
            }
        }
        pw.print(outerPrefix);
        pw.print("isContainsView: ");
        pw.print(isContainsView);
        pw.print(outerPrefix);
        pw.print("isRequestedView: ");
        pw.println(isRequestedView);
    }

    public void onTranslationCompleted(TranslationResponse response) {
        if (response == null || response.getTranslationStatus() != 0) {
            Log.w("UiTranslationController", "Fail result from TranslationService, status=" + (response == null ? "null" : Integer.valueOf(response.getTranslationStatus())));
            return;
        }
        SparseArray<ViewTranslationResponse> translatedResult = response.getViewTranslationResponses();
        SparseArray<ViewTranslationResponse> viewsResult = new SparseArray<ViewTranslationResponse>();
        SparseArray<LongSparseArray<ViewTranslationResponse>> virtualViewsResult = new SparseArray<LongSparseArray<ViewTranslationResponse>>();
        IntArray viewIds = new IntArray(1);
        for (int i = 0; i < translatedResult.size(); ++i) {
            ViewTranslationResponse result = translatedResult.valueAt(i);
            AutofillId autofillId = result.getAutofillId();
            if (viewIds.indexOf(autofillId.getViewId()) < 0) {
                viewIds.add(autofillId.getViewId());
            }
            if (autofillId.isNonVirtual()) {
                viewsResult.put(translatedResult.keyAt(i), result);
                continue;
            }
            boolean isVirtualViewAdded = virtualViewsResult.indexOfKey(autofillId.getViewId()) >= 0;
            LongSparseArray<ViewTranslationResponse> childIds = isVirtualViewAdded ? virtualViewsResult.get(autofillId.getViewId()) : new LongSparseArray<ViewTranslationResponse>();
            childIds.put(autofillId.getVirtualChildLongId(), result);
            if (isVirtualViewAdded) continue;
            virtualViewsResult.put(autofillId.getViewId(), childIds);
        }
        this.findViewsTraversalByAutofillIds(viewIds);
        if (viewsResult.size() > 0) {
            this.onTranslationCompleted(viewsResult);
        }
        if (virtualViewsResult.size() > 0) {
            this.onVirtualViewTranslationCompleted(virtualViewsResult);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onVirtualViewTranslationCompleted(SparseArray<LongSparseArray<ViewTranslationResponse>> translatedResult) {
        if (this.mActivity.isDestroyed()) {
            Log.v("UiTranslationController", "onTranslationCompleted:" + this.mActivity + "is destroyed.");
            return;
        }
        Object object = this.mLock;
        synchronized (object) {
            if (this.mCurrentState == 3) {
                Log.w("UiTranslationController", "onTranslationCompleted: the translation state is finished now. Skip to show the translated text.");
                return;
            }
            for (int i = 0; i < translatedResult.size(); ++i) {
                AutofillId autofillId = new AutofillId(translatedResult.keyAt(i));
                WeakReference<View> viewRef = this.mViews.get(autofillId);
                if (viewRef == null) continue;
                View view2 = (View)viewRef.get();
                if (view2 == null) {
                    Log.w("UiTranslationController", "onTranslationCompleted: the view for autofill id " + autofillId + " may be gone.");
                    continue;
                }
                LongSparseArray<ViewTranslationResponse> virtualChildResponse = translatedResult.valueAt(i);
                if (DEBUG) {
                    Log.v("UiTranslationController", "onVirtualViewTranslationCompleted: received response for AutofillId " + autofillId);
                }
                view2.onVirtualViewTranslationResponses(virtualChildResponse);
                if (this.mCurrentState == 1) {
                    return;
                }
                this.mActivity.runOnUiThread(() -> {
                    if (view2.getViewTranslationCallback() == null) {
                        if (DEBUG) {
                            Log.d("UiTranslationController", view2 + " doesn't support showing translation because of null ViewTranslationCallback.");
                        }
                        return;
                    }
                    if (view2.getViewTranslationCallback() != null) {
                        view2.getViewTranslationCallback().onShowTranslation(view2);
                    }
                });
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onTranslationCompleted(SparseArray<ViewTranslationResponse> translatedResult) {
        if (this.mActivity.isDestroyed()) {
            Log.v("UiTranslationController", "onTranslationCompleted:" + this.mActivity + "is destroyed.");
            return;
        }
        int resultCount = translatedResult.size();
        if (DEBUG) {
            Log.v("UiTranslationController", "onTranslationCompleted: receive " + resultCount + " responses.");
        }
        Object object = this.mLock;
        synchronized (object) {
            if (this.mCurrentState == 3) {
                Log.w("UiTranslationController", "onTranslationCompleted: the translation state is finished now. Skip to show the translated text.");
                return;
            }
            for (int i = 0; i < resultCount; ++i) {
                AutofillId autofillId;
                ViewTranslationResponse response = translatedResult.valueAt(i);
                if (DEBUG) {
                    Log.v("UiTranslationController", "onTranslationCompleted: " + UiTranslationController.sanitizedViewTranslationResponse(response));
                }
                if ((autofillId = response.getAutofillId()) == null) {
                    Log.w("UiTranslationController", "No AutofillId is set in ViewTranslationResponse");
                    continue;
                }
                WeakReference<View> viewRef = this.mViews.get(autofillId);
                if (viewRef == null) continue;
                View view2 = (View)viewRef.get();
                if (view2 == null) {
                    Log.w("UiTranslationController", "onTranslationCompleted: the view for autofill id " + autofillId + " may be gone.");
                    continue;
                }
                int currentState = this.mCurrentState;
                this.mActivity.runOnUiThread(() -> {
                    TextViewTranslationCallback textViewCallback;
                    ViewTranslationCallback callback2 = view2.getViewTranslationCallback();
                    if (view2.getViewTranslationResponse() != null && view2.getViewTranslationResponse().equals(response) && callback2 instanceof TextViewTranslationCallback && ((textViewCallback = (TextViewTranslationCallback)callback2).isShowingTranslation() || textViewCallback.isAnimationRunning())) {
                        if (DEBUG) {
                            Log.d("UiTranslationController", "Duplicate ViewTranslationResponse for " + autofillId + ". Ignoring.");
                        }
                        return;
                    }
                    if (callback2 == null) {
                        if (view2 instanceof TextView) {
                            callback2 = new TextViewTranslationCallback();
                            view2.setViewTranslationCallback(callback2);
                        } else {
                            if (DEBUG) {
                                Log.d("UiTranslationController", view2 + " doesn't support showing translation because of null ViewTranslationCallback.");
                            }
                            return;
                        }
                    }
                    callback2.setAnimationDurationMillis(250);
                    if (this.mViewsToPadContent.contains(autofillId)) {
                        callback2.enableContentPadding();
                    }
                    view2.onViewTranslationResponse(response);
                    if (currentState == 1) {
                        return;
                    }
                    callback2.onShowTranslation(view2);
                });
            }
        }
    }

    private void createTranslatorAndStart(TranslationSpec sourceSpec, TranslationSpec targetSpec, List<AutofillId> views) {
        Translator translator = this.createTranslatorIfNeeded(sourceSpec, targetSpec);
        if (translator == null) {
            Log.w("UiTranslationController", "Can not create Translator for sourceSpec:" + sourceSpec + " targetSpec:" + targetSpec);
            return;
        }
        this.onUiTranslationStarted(translator, views);
    }

    private void sendTranslationRequest(Translator translator, List<ViewTranslationRequest> requests) {
        if (requests.size() == 0) {
            Log.w("UiTranslationController", "No ViewTranslationRequest was collected.");
            return;
        }
        TranslationRequest request = new TranslationRequest.Builder().setViewTranslationRequests(requests).build();
        if (DEBUG) {
            StringBuilder msg = new StringBuilder("sendTranslationRequest:{requests=[");
            for (ViewTranslationRequest viewRequest : requests) {
                msg.append("{request=").append(UiTranslationController.sanitizedViewTranslationRequest(viewRequest)).append("}, ");
            }
            Log.d("UiTranslationController", "sendTranslationRequest: " + msg.toString());
        }
        translator.requestUiTranslate(request, r -> r.run(), this::onTranslationCompleted);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onUiTranslationStarted(Translator translator, List<AutofillId> views) {
        Object object = this.mLock;
        synchronized (object) {
            SparseIntArray virtualViewChildCount = this.getRequestVirtualViewChildCount(views);
            ArrayMap<AutofillId, long[]> viewIds = new ArrayMap<AutofillId, long[]>();
            ArrayMap<AutofillId, Integer> unusedIndices = null;
            for (int i = 0; i < views.size(); ++i) {
                long[] childs;
                AutofillId autofillId = views.get(i);
                if (autofillId.isNonVirtual()) {
                    viewIds.put(autofillId, null);
                    continue;
                }
                if (unusedIndices == null) {
                    unusedIndices = new ArrayMap<AutofillId, Integer>();
                }
                AutofillId virtualViewAutofillId = new AutofillId(autofillId.getViewId());
                int end = 0;
                if (viewIds.containsKey(virtualViewAutofillId)) {
                    childs = (long[])viewIds.get(virtualViewAutofillId);
                    end = (Integer)unusedIndices.get(virtualViewAutofillId);
                } else {
                    int childCount = virtualViewChildCount.get(autofillId.getViewId());
                    childs = new long[childCount];
                    viewIds.put(virtualViewAutofillId, childs);
                }
                unusedIndices.put(virtualViewAutofillId, end + 1);
                childs[end] = autofillId.getVirtualChildLongId();
            }
            ArrayList requests = new ArrayList();
            int[] supportedFormats = this.getSupportedFormatsLocked();
            ArrayList<ViewRootImpl> roots = WindowManagerGlobal.getInstance().getRootViews(this.mActivity.getActivityToken());
            TranslationCapability capability = this.getTranslationCapability(translator.getTranslationContext());
            this.mActivity.runOnUiThread(() -> {
                for (int rootNum = 0; rootNum < roots.size(); ++rootNum) {
                    View rootView = ((ViewRootImpl)roots.get(rootNum)).getView();
                    rootView.dispatchCreateViewTranslationRequest(viewIds, supportedFormats, capability, requests);
                }
                this.mWorkerHandler.sendMessage(PooledLambda.obtainMessage(UiTranslationController::sendTranslationRequest, this, translator, requests));
            });
        }
    }

    private SparseIntArray getRequestVirtualViewChildCount(List<AutofillId> views) {
        SparseIntArray virtualViewCount = new SparseIntArray();
        for (int i = 0; i < views.size(); ++i) {
            AutofillId autofillId = views.get(i);
            if (autofillId.isNonVirtual()) continue;
            int virtualViewId = autofillId.getViewId();
            if (virtualViewCount.indexOfKey(virtualViewId) < 0) {
                virtualViewCount.put(virtualViewId, 1);
                continue;
            }
            virtualViewCount.put(virtualViewId, virtualViewCount.get(virtualViewId) + 1);
        }
        return virtualViewCount;
    }

    private int[] getSupportedFormatsLocked() {
        return new int[]{1};
    }

    private TranslationCapability getTranslationCapability(TranslationContext translationContext) {
        return new TranslationCapability(3, translationContext.getSourceSpec(), translationContext.getTargetSpec(), true, 0);
    }

    private void findViewsTraversalByAutofillIds(IntArray sourceViewIds) {
        ArrayList<ViewRootImpl> roots = WindowManagerGlobal.getInstance().getRootViews(this.mActivity.getActivityToken());
        for (int rootNum = 0; rootNum < roots.size(); ++rootNum) {
            View rootView = roots.get(rootNum).getView();
            if (rootView instanceof ViewGroup) {
                this.findViewsTraversalByAutofillIds((ViewGroup)rootView, sourceViewIds);
            }
            this.addViewIfNeeded(sourceViewIds, rootView);
        }
    }

    private void findViewsTraversalByAutofillIds(ViewGroup viewGroup, IntArray sourceViewIds) {
        int childCount = viewGroup.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            View child = viewGroup.getChildAt(i);
            if (child instanceof ViewGroup) {
                this.findViewsTraversalByAutofillIds((ViewGroup)child, sourceViewIds);
            }
            this.addViewIfNeeded(sourceViewIds, child);
        }
    }

    private void addViewIfNeeded(IntArray sourceViewIds, View view2) {
        AutofillId autofillId = view2.getAutofillId();
        if (autofillId != null && sourceViewIds.indexOf(autofillId.getViewId()) >= 0 && !this.mViews.containsKey(autofillId)) {
            this.mViews.put(autofillId, new WeakReference<View>(view2));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runForEachView(BiConsumer<View, ViewTranslationCallback> action2) {
        Object object = this.mLock;
        synchronized (object) {
            ArrayMap<AutofillId, WeakReference<View>> views = new ArrayMap<AutofillId, WeakReference<View>>(this.mViews);
            if (views.size() == 0) {
                Log.w("UiTranslationController", "No views can be excuted for runForEachView.");
            }
            this.mActivity.runOnUiThread(() -> {
                int viewCounts = views.size();
                for (int i = 0; i < viewCounts; ++i) {
                    View view2 = (View)((WeakReference)views.valueAt(i)).get();
                    if (DEBUG) {
                        Log.d("UiTranslationController", "runForEachView for autofillId = " + (view2 != null ? view2.getAutofillId() : " null"));
                    }
                    if (view2 == null || view2.getViewTranslationCallback() == null) {
                        if (!DEBUG) continue;
                        Log.d("UiTranslationController", "View was gone or ViewTranslationCallback for autofillId = " + views.keyAt(i));
                        continue;
                    }
                    action2.accept(view2, view2.getViewTranslationCallback());
                }
            });
        }
    }

    private Translator createTranslatorIfNeeded(TranslationSpec sourceSpec, TranslationSpec targetSpec) {
        TranslationManager tm = this.mContext.getSystemService(TranslationManager.class);
        if (tm == null) {
            Log.e("UiTranslationController", "Can not find TranslationManager when trying to create translator.");
            return null;
        }
        TranslationContext translationContext = new TranslationContext.Builder(sourceSpec, targetSpec).setActivityId(new ActivityId(this.mActivity.getTaskId(), this.mActivity.getShareableActivityToken())).build();
        Translator translator = tm.createTranslator(translationContext);
        if (translator != null) {
            Pair<TranslationSpec, TranslationSpec> specs = new Pair<TranslationSpec, TranslationSpec>(sourceSpec, targetSpec);
            this.mTranslators.put(specs, translator);
        }
        return translator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void destroyTranslators() {
        Object object = this.mLock;
        synchronized (object) {
            int count = this.mTranslators.size();
            for (int i = 0; i < count; ++i) {
                Translator translator = this.mTranslators.valueAt(i);
                translator.destroy();
            }
            this.mTranslators.clear();
        }
    }

    public static String stateToString(int state) {
        switch (state) {
            case 0: {
                return "UI_TRANSLATION_STARTED";
            }
            case 1: {
                return "UI_TRANSLATION_PAUSED";
            }
            case 2: {
                return "UI_TRANSLATION_RESUMED";
            }
            case 3: {
                return "UI_TRANSLATION_FINISHED";
            }
        }
        return "Unknown state (" + state + ")";
    }

    private static String sanitizedViewTranslationRequest(ViewTranslationRequest request) {
        StringBuilder msg = new StringBuilder("ViewTranslationRequest:{values=[");
        for (String key : request.getKeys()) {
            TranslationRequestValue value2 = request.getValue(key);
            msg.append("{text=").append(value2.getText() == null ? "null" : "string[" + value2.getText().length() + "]}, ");
        }
        return msg.toString();
    }

    private static String sanitizedViewTranslationResponse(ViewTranslationResponse response) {
        StringBuilder msg = new StringBuilder("ViewTranslationResponse:{values=[");
        for (String key : response.getKeys()) {
            TranslationResponseValue value2 = response.getValue(key);
            msg.append("{status=").append(value2.getStatusCode()).append(", ");
            msg.append("text=").append(value2.getText() == null ? "null" : "string[" + value2.getText().length() + "], ");
            Bundle definitions = (Bundle)value2.getExtras().get("android.view.translation.extra.DEFINITIONS");
            if (definitions != null) {
                msg.append("definitions={");
                for (String partOfSpeech : definitions.keySet()) {
                    msg.append(partOfSpeech).append(":[");
                    for (CharSequence definition : definitions.getCharSequenceArray(partOfSpeech)) {
                        msg.append(definition == null ? "null, " : "string[" + definition.length() + "], ");
                    }
                    msg.append("], ");
                }
                msg.append("}");
            }
            msg.append("transliteration=").append(value2.getTransliteration() == null ? "null" : "string[" + value2.getTransliteration().length() + "]}, ");
        }
        return msg.toString();
    }
}

