/*
 * Decompiled with CFR 0.152.
 */
package android.view.translation;

import android.annotation.RequiresPermission;
import android.annotation.SystemApi;
import android.app.assist.ActivityId;
import android.content.ComponentName;
import android.content.Context;
import android.icu.util.ULocale;
import android.os.Binder;
import android.os.Bundle;
import android.os.IRemoteCallback;
import android.os.RemoteException;
import android.util.ArrayMap;
import android.util.Log;
import android.view.autofill.AutofillId;
import android.view.translation.ITranslationManager;
import android.view.translation.TranslationSpec;
import android.view.translation.UiTranslationSpec;
import android.view.translation.UiTranslationStateCallback;
import com.android.internal.annotations.GuardedBy;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Executor;

public class UiTranslationManager {
    private static final String TAG = "UiTranslationManager";
    public static final String LOG_TAG = "UiTranslation";
    public static final int STATE_UI_TRANSLATION_STARTED = 0;
    public static final int STATE_UI_TRANSLATION_PAUSED = 1;
    public static final int STATE_UI_TRANSLATION_RESUMED = 2;
    public static final int STATE_UI_TRANSLATION_FINISHED = 3;
    public static final String EXTRA_STATE = "state";
    public static final String EXTRA_SOURCE_LOCALE = "source_locale";
    public static final String EXTRA_TARGET_LOCALE = "target_locale";
    public static final String EXTRA_PACKAGE_NAME = "package_name";
    private final Context mContext;
    private final ITranslationManager mService;
    @GuardedBy(value={"mCallbacks"})
    private final Map<UiTranslationStateCallback, IRemoteCallback> mCallbacks = new ArrayMap<UiTranslationStateCallback, IRemoteCallback>();

    public UiTranslationManager(Context context, ITranslationManager service) {
        this.mContext = Objects.requireNonNull(context);
        this.mService = service;
    }

    @Deprecated
    @SystemApi
    @RequiresPermission(value="android.permission.MANAGE_UI_TRANSLATION")
    public void startTranslation(TranslationSpec sourceSpec, TranslationSpec targetSpec, List<AutofillId> viewIds, ActivityId activityId) {
        this.startTranslation(sourceSpec, targetSpec, viewIds, activityId, new UiTranslationSpec.Builder().setShouldPadContentForCompat(true).build());
    }

    @SystemApi
    @RequiresPermission(value="android.permission.MANAGE_UI_TRANSLATION")
    public void startTranslation(TranslationSpec sourceSpec, TranslationSpec targetSpec, List<AutofillId> viewIds, ActivityId activityId, UiTranslationSpec uiTranslationSpec) {
        Objects.requireNonNull(sourceSpec);
        Objects.requireNonNull(targetSpec);
        Objects.requireNonNull(viewIds);
        Objects.requireNonNull(activityId);
        Objects.requireNonNull(activityId.getToken());
        Objects.requireNonNull(uiTranslationSpec);
        if (viewIds.size() == 0) {
            throw new IllegalArgumentException("Invalid empty views: " + viewIds);
        }
        try {
            this.mService.updateUiTranslationState(0, sourceSpec, targetSpec, viewIds, activityId.getToken(), activityId.getTaskId(), uiTranslationSpec, this.mContext.getUserId());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.MANAGE_UI_TRANSLATION")
    public void finishTranslation(ActivityId activityId) {
        try {
            Objects.requireNonNull(activityId);
            Objects.requireNonNull(activityId.getToken());
            this.mService.updateUiTranslationState(3, null, null, null, activityId.getToken(), activityId.getTaskId(), null, this.mContext.getUserId());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.MANAGE_UI_TRANSLATION")
    public void pauseTranslation(ActivityId activityId) {
        try {
            Objects.requireNonNull(activityId);
            Objects.requireNonNull(activityId.getToken());
            this.mService.updateUiTranslationState(1, null, null, null, activityId.getToken(), activityId.getTaskId(), null, this.mContext.getUserId());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.MANAGE_UI_TRANSLATION")
    public void resumeTranslation(ActivityId activityId) {
        try {
            Objects.requireNonNull(activityId);
            Objects.requireNonNull(activityId.getToken());
            this.mService.updateUiTranslationState(2, null, null, null, activityId.getToken(), activityId.getTaskId(), null, this.mContext.getUserId());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerUiTranslationStateCallback(Executor executor, UiTranslationStateCallback callback2) {
        Objects.requireNonNull(executor);
        Objects.requireNonNull(callback2);
        Map<UiTranslationStateCallback, IRemoteCallback> map2 = this.mCallbacks;
        synchronized (map2) {
            if (this.mCallbacks.containsKey(callback2)) {
                Log.w(TAG, "registerUiTranslationStateCallback: callback already registered; ignoring.");
                return;
            }
            UiTranslationStateRemoteCallback remoteCallback = new UiTranslationStateRemoteCallback(executor, callback2);
            try {
                this.mService.registerUiTranslationStateCallback(remoteCallback, this.mContext.getUserId());
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
            this.mCallbacks.put(callback2, remoteCallback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterUiTranslationStateCallback(UiTranslationStateCallback callback2) {
        Objects.requireNonNull(callback2);
        Map<UiTranslationStateCallback, IRemoteCallback> map2 = this.mCallbacks;
        synchronized (map2) {
            IRemoteCallback remoteCallback = this.mCallbacks.get(callback2);
            if (remoteCallback == null) {
                Log.w(TAG, "unregisterUiTranslationStateCallback: callback not found; ignoring.");
                return;
            }
            try {
                this.mService.unregisterUiTranslationStateCallback(remoteCallback, this.mContext.getUserId());
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
            this.mCallbacks.remove(callback2);
        }
    }

    public void onTranslationFinished(boolean activityDestroyed, ActivityId activityId, ComponentName componentName) {
        try {
            this.mService.onTranslationFinished(activityDestroyed, activityId.getToken(), componentName, this.mContext.getUserId());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private static class UiTranslationStateRemoteCallback
    extends IRemoteCallback.Stub {
        private final Executor mExecutor;
        private final UiTranslationStateCallback mCallback;
        private ULocale mSourceLocale;
        private ULocale mTargetLocale;

        UiTranslationStateRemoteCallback(Executor executor, UiTranslationStateCallback callback2) {
            this.mExecutor = executor;
            this.mCallback = callback2;
        }

        @Override
        public void sendResult(Bundle bundle) {
            Binder.withCleanCallingIdentity(() -> this.mExecutor.execute(() -> this.onStateChange(bundle)));
        }

        private void onStateChange(Bundle bundle) {
            int state = bundle.getInt(UiTranslationManager.EXTRA_STATE);
            String packageName = bundle.getString(UiTranslationManager.EXTRA_PACKAGE_NAME);
            switch (state) {
                case 0: {
                    this.mSourceLocale = bundle.getSerializable(UiTranslationManager.EXTRA_SOURCE_LOCALE, ULocale.class);
                    this.mTargetLocale = bundle.getSerializable(UiTranslationManager.EXTRA_TARGET_LOCALE, ULocale.class);
                    this.mCallback.onStarted(this.mSourceLocale, this.mTargetLocale, packageName);
                    break;
                }
                case 2: {
                    this.mCallback.onResumed(this.mSourceLocale, this.mTargetLocale, packageName);
                    break;
                }
                case 1: {
                    this.mCallback.onPaused(packageName);
                    break;
                }
                case 3: {
                    this.mCallback.onFinished(packageName);
                    break;
                }
                default: {
                    Log.wtf(UiTranslationManager.TAG, "Unexpected translation state:" + state);
                }
            }
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface UiTranslationState {
    }
}

