/*
 * Decompiled with CFR 0.152.
 */
package android.webkit;

import android.content.pm.PackageInfo;
import android.os.ChildZygoteProcess;
import android.os.Process;
import android.os.ZygoteProcess;
import android.os._Original_Build;
import android.text.TextUtils;
import android.util.Log;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.os.Zygote;

public class WebViewZygote {
    private static final String LOGTAG = "WebViewZygote";
    private static final Object sLock = new Object();
    @GuardedBy(value={"sLock"})
    private static ChildZygoteProcess sZygote;
    @GuardedBy(value={"sLock"})
    private static PackageInfo sPackage;
    @GuardedBy(value={"sLock"})
    private static boolean sMultiprocessEnabled;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ZygoteProcess getProcess() {
        Object object = sLock;
        synchronized (object) {
            if (sZygote != null) {
                return sZygote;
            }
            WebViewZygote.connectToZygoteIfNeededLocked();
            return sZygote;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getPackageName() {
        Object object = sLock;
        synchronized (object) {
            return WebViewZygote.sPackage.packageName;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isMultiprocessEnabled() {
        Object object = sLock;
        synchronized (object) {
            return sMultiprocessEnabled && sPackage != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setMultiprocessEnabled(boolean enabled) {
        Object object = sLock;
        synchronized (object) {
            sMultiprocessEnabled = enabled;
            if (!enabled) {
                WebViewZygote.stopZygoteLocked();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void onWebViewProviderChanged(PackageInfo packageInfo) {
        Object object = sLock;
        synchronized (object) {
            sPackage = packageInfo;
            if (!sMultiprocessEnabled) {
                return;
            }
            WebViewZygote.stopZygoteLocked();
        }
    }

    @GuardedBy(value={"sLock"})
    private static void stopZygoteLocked() {
        if (sZygote != null) {
            sZygote.close();
            Process.killProcess(sZygote.getPid());
            sZygote = null;
        }
    }

    @GuardedBy(value={"sLock"})
    private static void connectToZygoteIfNeededLocked() {
        if (sZygote != null) {
            return;
        }
        if (sPackage == null) {
            Log.e(LOGTAG, "Cannot connect to zygote, no package specified");
            return;
        }
        try {
            String abi = WebViewZygote.sPackage.applicationInfo.primaryCpuAbi;
            int runtimeFlags = Zygote.getMemorySafetyRuntimeFlagsForSecondaryZygote(WebViewZygote.sPackage.applicationInfo, null);
            sZygote = Process.ZYGOTE_PROCESS.startChildZygote("com.android.internal.os.WebViewZygoteInit", "webview_zygote", 1053, 1053, null, runtimeFlags, "webview_zygote", abi, TextUtils.join((CharSequence)",", _Original_Build.SUPPORTED_ABIS), null, 99000, Integer.MAX_VALUE);
            ZygoteProcess.waitForConnectionToZygote(sZygote.getPrimarySocketAddress());
            sZygote.preloadApp(WebViewZygote.sPackage.applicationInfo, abi);
        }
        catch (Exception e) {
            Log.e(LOGTAG, "Error connecting to webview zygote", e);
            WebViewZygote.stopZygoteLocked();
        }
    }

    static {
        sMultiprocessEnabled = false;
    }
}

