/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.res.TypedArray;
import android.os.Process;
import android.util.AttributeSet;
import android.view.RemotableViewMethod;
import android.widget.Adapter;
import android.widget.AdapterViewAnimator;
import android.widget.RemoteViews;
import com.android.internal.R;

@RemoteViews.RemoteView
public class AdapterViewFlipper
extends AdapterViewAnimator {
    private static final String TAG = "ViewFlipper";
    private static final boolean LOGD = false;
    private static final int DEFAULT_INTERVAL = 10000;
    private int mFlipInterval = 10000;
    private boolean mAutoStart = false;
    private boolean mRunning = false;
    private boolean mStarted = false;
    private boolean mVisible = false;
    private boolean mUserPresent = true;
    private boolean mAdvancedByHost = false;
    private final BroadcastReceiver mReceiver = new BroadcastReceiver(){

        @Override
        public void onReceive(Context context, Intent intent) {
            String action2 = intent.getAction();
            if ("android.intent.action.SCREEN_OFF".equals(action2)) {
                AdapterViewFlipper.this.mUserPresent = false;
                AdapterViewFlipper.this.updateRunning();
            } else if ("android.intent.action.USER_PRESENT".equals(action2)) {
                AdapterViewFlipper.this.mUserPresent = true;
                AdapterViewFlipper.this.updateRunning(false);
            }
        }
    };
    private final Runnable mFlipRunnable = new Runnable(){

        @Override
        public void run() {
            if (AdapterViewFlipper.this.mRunning) {
                AdapterViewFlipper.this.showNext();
            }
        }
    };

    public AdapterViewFlipper(Context context) {
        super(context);
    }

    public AdapterViewFlipper(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public AdapterViewFlipper(Context context, AttributeSet attrs, int defStyleAttr) {
        this(context, attrs, defStyleAttr, 0);
    }

    public AdapterViewFlipper(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.AdapterViewFlipper, defStyleAttr, defStyleRes);
        this.saveAttributeDataForStyleable(context, R.styleable.AdapterViewFlipper, attrs, a, defStyleAttr, defStyleRes);
        this.mFlipInterval = a.getInt(0, 10000);
        this.mAutoStart = a.getBoolean(1, false);
        this.mLoopViews = true;
        a.recycle();
    }

    @Override
    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        IntentFilter filter2 = new IntentFilter();
        filter2.addAction("android.intent.action.SCREEN_OFF");
        filter2.addAction("android.intent.action.USER_PRESENT");
        this.getContext().registerReceiverAsUser(this.mReceiver, Process.myUserHandle(), filter2, null, this.getHandler());
        if (this.mAutoStart) {
            this.startFlipping();
        }
    }

    @Override
    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.mVisible = false;
        this.getContext().unregisterReceiver(this.mReceiver);
        this.updateRunning();
    }

    @Override
    protected void onWindowVisibilityChanged(int visibility) {
        super.onWindowVisibilityChanged(visibility);
        this.mVisible = visibility == 0;
        this.updateRunning(false);
    }

    @Override
    public void setAdapter(Adapter adapter) {
        super.setAdapter(adapter);
        this.updateRunning();
    }

    public int getFlipInterval() {
        return this.mFlipInterval;
    }

    public void setFlipInterval(int flipInterval) {
        this.mFlipInterval = flipInterval;
    }

    public void startFlipping() {
        this.mStarted = true;
        this.updateRunning();
    }

    public void stopFlipping() {
        this.mStarted = false;
        this.updateRunning();
    }

    @Override
    @RemotableViewMethod
    public void showNext() {
        if (this.mRunning) {
            this.removeCallbacks(this.mFlipRunnable);
            this.postDelayed(this.mFlipRunnable, this.mFlipInterval);
        }
        super.showNext();
    }

    @Override
    @RemotableViewMethod
    public void showPrevious() {
        if (this.mRunning) {
            this.removeCallbacks(this.mFlipRunnable);
            this.postDelayed(this.mFlipRunnable, this.mFlipInterval);
        }
        super.showPrevious();
    }

    private void updateRunning() {
        this.updateRunning(true);
    }

    private void updateRunning(boolean flipNow) {
        boolean running;
        boolean bl = running = !this.mAdvancedByHost && this.mVisible && this.mStarted && this.mUserPresent && this.mAdapter != null;
        if (running != this.mRunning) {
            if (running) {
                this.showOnly(this.mWhichChild, flipNow);
                this.postDelayed(this.mFlipRunnable, this.mFlipInterval);
            } else {
                this.removeCallbacks(this.mFlipRunnable);
            }
            this.mRunning = running;
        }
    }

    public boolean isFlipping() {
        return this.mStarted;
    }

    public void setAutoStart(boolean autoStart) {
        this.mAutoStart = autoStart;
    }

    public boolean isAutoStart() {
        return this.mAutoStart;
    }

    @Override
    public void fyiWillBeAdvancedByHostKThx() {
        this.mAdvancedByHost = true;
        this.updateRunning(false);
    }

    @Override
    public CharSequence getAccessibilityClassName() {
        return AdapterViewFlipper.class.getName();
    }
}

