/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.app.AppGlobals;
import android.compat.annotation.UnsupportedAppUsage;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.BlendMode;
import android.graphics.Canvas;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.Icon;
import android.os.Process;
import android.text.format.DateUtils;
import android.util.AttributeSet;
import android.util.Log;
import android.view.RemotableViewMethod;
import android.view.View;
import android.widget.RemoteViews;
import com.android.internal.R;
import com.android.layoutlib.bridge.android.AndroidLocale;
import java.time.Clock;
import java.time.DateTimeException;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Formatter;

@RemoteViews.RemoteView
@Deprecated
public class AnalogClock
extends View {
    private static final String LOG_TAG = "AnalogClock";
    private final int mSecondsHandFps;
    private Clock mClock;
    private ZoneId mTimeZone;
    @UnsupportedAppUsage
    private Drawable mHourHand;
    private final TintInfo mHourHandTintInfo = new TintInfo();
    @UnsupportedAppUsage
    private Drawable mMinuteHand;
    private final TintInfo mMinuteHandTintInfo = new TintInfo();
    private Drawable mSecondHand;
    private final TintInfo mSecondHandTintInfo = new TintInfo();
    @UnsupportedAppUsage
    private Drawable mDial;
    private final TintInfo mDialTintInfo = new TintInfo();
    private int mDialWidth;
    private int mDialHeight;
    private boolean mVisible;
    private float mSeconds;
    private float mMinutes;
    private float mHour;
    private boolean mChanged;
    private final BroadcastReceiver mIntentReceiver = new BroadcastReceiver(){

        @Override
        public void onReceive(Context context, Intent intent) {
            if ("android.intent.action.TIMEZONE_CHANGED".equals(intent.getAction())) {
                AnalogClock.this.createClock();
            }
            AnalogClock.this.mTick.run();
        }
    };
    private boolean mReceiverAttached;
    private final Runnable mTick = new Runnable(){

        @Override
        public void run() {
            long millisUntilNextTick;
            AnalogClock.this.removeCallbacks(this);
            if (!AnalogClock.this.mVisible) {
                return;
            }
            Instant now = AnalogClock.this.now();
            ZonedDateTime zonedDateTime = now.atZone(AnalogClock.this.mClock.getZone());
            LocalTime localTime = zonedDateTime.toLocalTime();
            if (AnalogClock.this.mSecondHand == null || AnalogClock.this.mSecondsHandFps <= 0) {
                Instant startOfNextMinute = zonedDateTime.plusMinutes(1L).withSecond(0).toInstant();
                millisUntilNextTick = Duration.between(now, startOfNextMinute).toMillis();
                if (millisUntilNextTick <= 0L) {
                    millisUntilNextTick = Duration.ofMinutes(1L).toMillis();
                }
            } else {
                double millisPerTick = 1000.0 / (double)AnalogClock.this.mSecondsHandFps;
                long millisOfSecond = Duration.ofNanos(localTime.getNano()).toMillis();
                long millisPastLastTick = Math.round((double)millisOfSecond % millisPerTick);
                millisUntilNextTick = Math.round(millisPerTick - (double)millisPastLastTick);
                if (millisUntilNextTick <= 0L) {
                    millisUntilNextTick = Math.round(millisPerTick);
                }
            }
            AnalogClock.this.postDelayed(this, millisUntilNextTick);
            AnalogClock.this.onTimeChanged(localTime, now.toEpochMilli());
            AnalogClock.this.invalidate();
        }
    };

    public AnalogClock(Context context) {
        this(context, null);
    }

    public AnalogClock(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public AnalogClock(Context context, AttributeSet attrs, int defStyleAttr) {
        this(context, attrs, defStyleAttr, 0);
    }

    public AnalogClock(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        BlendMode secondHandTintMode;
        BlendMode minuteHandTintMode;
        ColorStateList minuteHandTintList;
        BlendMode hourHandTintMode;
        ColorStateList hourHandTintList;
        BlendMode dialTintMode;
        ColorStateList dialTintList;
        this.mSecondsHandFps = AppGlobals.getIntCoreSetting("widget__analog_clock_seconds_hand_fps", context.getResources().getInteger(17694781));
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.AnalogClock, defStyleAttr, defStyleRes);
        this.saveAttributeDataForStyleable(context, R.styleable.AnalogClock, attrs, a, defStyleAttr, defStyleRes);
        this.mDial = a.getDrawable(0);
        if (this.mDial == null) {
            this.mDial = context.getDrawable(17302122);
        }
        if ((dialTintList = a.getColorStateList(5)) != null) {
            this.mDialTintInfo.mTintList = dialTintList;
            this.mDialTintInfo.mHasTintList = true;
        }
        if ((dialTintMode = Drawable.parseBlendMode(a.getInt(6, -1), null)) != null) {
            this.mDialTintInfo.mTintBlendMode = dialTintMode;
            this.mDialTintInfo.mHasTintBlendMode = true;
        }
        if (this.mDialTintInfo.mHasTintList || this.mDialTintInfo.mHasTintBlendMode) {
            this.mDial = this.mDialTintInfo.apply(this.mDial);
        }
        this.mHourHand = a.getDrawable(1);
        if (this.mHourHand == null) {
            this.mHourHand = context.getDrawable(17302123);
        }
        if ((hourHandTintList = a.getColorStateList(7)) != null) {
            this.mHourHandTintInfo.mTintList = hourHandTintList;
            this.mHourHandTintInfo.mHasTintList = true;
        }
        if ((hourHandTintMode = Drawable.parseBlendMode(a.getInt(8, -1), null)) != null) {
            this.mHourHandTintInfo.mTintBlendMode = hourHandTintMode;
            this.mHourHandTintInfo.mHasTintBlendMode = true;
        }
        if (this.mHourHandTintInfo.mHasTintList || this.mHourHandTintInfo.mHasTintBlendMode) {
            this.mHourHand = this.mHourHandTintInfo.apply(this.mHourHand);
        }
        this.mMinuteHand = a.getDrawable(2);
        if (this.mMinuteHand == null) {
            this.mMinuteHand = context.getDrawable(17302124);
        }
        if ((minuteHandTintList = a.getColorStateList(9)) != null) {
            this.mMinuteHandTintInfo.mTintList = minuteHandTintList;
            this.mMinuteHandTintInfo.mHasTintList = true;
        }
        if ((minuteHandTintMode = Drawable.parseBlendMode(a.getInt(10, -1), null)) != null) {
            this.mMinuteHandTintInfo.mTintBlendMode = minuteHandTintMode;
            this.mMinuteHandTintInfo.mHasTintBlendMode = true;
        }
        if (this.mMinuteHandTintInfo.mHasTintList || this.mMinuteHandTintInfo.mHasTintBlendMode) {
            this.mMinuteHand = this.mMinuteHandTintInfo.apply(this.mMinuteHand);
        }
        this.mSecondHand = a.getDrawable(4);
        ColorStateList secondHandTintList = a.getColorStateList(11);
        if (secondHandTintList != null) {
            this.mSecondHandTintInfo.mTintList = secondHandTintList;
            this.mSecondHandTintInfo.mHasTintList = true;
        }
        if ((secondHandTintMode = Drawable.parseBlendMode(a.getInt(12, -1), null)) != null) {
            this.mSecondHandTintInfo.mTintBlendMode = secondHandTintMode;
            this.mSecondHandTintInfo.mHasTintBlendMode = true;
        }
        if (this.mSecondHandTintInfo.mHasTintList || this.mSecondHandTintInfo.mHasTintBlendMode) {
            this.mSecondHand = this.mSecondHandTintInfo.apply(this.mSecondHand);
        }
        this.mTimeZone = AnalogClock.toZoneId(a.getString(3));
        this.createClock();
        a.recycle();
        this.mDialWidth = this.mDial.getIntrinsicWidth();
        this.mDialHeight = this.mDial.getIntrinsicHeight();
    }

    @RemotableViewMethod
    public void setDial(Icon icon2) {
        this.mDial = icon2.loadDrawable(this.getContext());
        this.mDialWidth = this.mDial.getIntrinsicWidth();
        this.mDialHeight = this.mDial.getIntrinsicHeight();
        if (this.mDialTintInfo.mHasTintList || this.mDialTintInfo.mHasTintBlendMode) {
            this.mDial = this.mDialTintInfo.apply(this.mDial);
        }
        this.mChanged = true;
        this.invalidate();
    }

    @RemotableViewMethod
    public void setDialTintList(ColorStateList tint) {
        this.mDialTintInfo.mTintList = tint;
        this.mDialTintInfo.mHasTintList = true;
        this.mDial = this.mDialTintInfo.apply(this.mDial);
    }

    public ColorStateList getDialTintList() {
        return this.mDialTintInfo.mTintList;
    }

    @RemotableViewMethod
    public void setDialTintBlendMode(BlendMode blendMode) {
        this.mDialTintInfo.mTintBlendMode = blendMode;
        this.mDialTintInfo.mHasTintBlendMode = true;
        this.mDial = this.mDialTintInfo.apply(this.mDial);
    }

    public BlendMode getDialTintBlendMode() {
        return this.mDialTintInfo.mTintBlendMode;
    }

    @RemotableViewMethod
    public void setHourHand(Icon icon2) {
        this.mHourHand = icon2.loadDrawable(this.getContext());
        if (this.mHourHandTintInfo.mHasTintList || this.mHourHandTintInfo.mHasTintBlendMode) {
            this.mHourHand = this.mHourHandTintInfo.apply(this.mHourHand);
        }
        this.mChanged = true;
        this.invalidate();
    }

    @RemotableViewMethod
    public void setHourHandTintList(ColorStateList tint) {
        this.mHourHandTintInfo.mTintList = tint;
        this.mHourHandTintInfo.mHasTintList = true;
        this.mHourHand = this.mHourHandTintInfo.apply(this.mHourHand);
    }

    public ColorStateList getHourHandTintList() {
        return this.mHourHandTintInfo.mTintList;
    }

    @RemotableViewMethod
    public void setHourHandTintBlendMode(BlendMode blendMode) {
        this.mHourHandTintInfo.mTintBlendMode = blendMode;
        this.mHourHandTintInfo.mHasTintBlendMode = true;
        this.mHourHand = this.mHourHandTintInfo.apply(this.mHourHand);
    }

    public BlendMode getHourHandTintBlendMode() {
        return this.mHourHandTintInfo.mTintBlendMode;
    }

    @RemotableViewMethod
    public void setMinuteHand(Icon icon2) {
        this.mMinuteHand = icon2.loadDrawable(this.getContext());
        if (this.mMinuteHandTintInfo.mHasTintList || this.mMinuteHandTintInfo.mHasTintBlendMode) {
            this.mMinuteHand = this.mMinuteHandTintInfo.apply(this.mMinuteHand);
        }
        this.mChanged = true;
        this.invalidate();
    }

    @RemotableViewMethod
    public void setMinuteHandTintList(ColorStateList tint) {
        this.mMinuteHandTintInfo.mTintList = tint;
        this.mMinuteHandTintInfo.mHasTintList = true;
        this.mMinuteHand = this.mMinuteHandTintInfo.apply(this.mMinuteHand);
    }

    public ColorStateList getMinuteHandTintList() {
        return this.mMinuteHandTintInfo.mTintList;
    }

    @RemotableViewMethod
    public void setMinuteHandTintBlendMode(BlendMode blendMode) {
        this.mMinuteHandTintInfo.mTintBlendMode = blendMode;
        this.mMinuteHandTintInfo.mHasTintBlendMode = true;
        this.mMinuteHand = this.mMinuteHandTintInfo.apply(this.mMinuteHand);
    }

    public BlendMode getMinuteHandTintBlendMode() {
        return this.mMinuteHandTintInfo.mTintBlendMode;
    }

    @RemotableViewMethod
    public void setSecondHand(Icon icon2) {
        Drawable drawable2 = this.mSecondHand = icon2 == null ? null : icon2.loadDrawable(this.getContext());
        if (this.mSecondHandTintInfo.mHasTintList || this.mSecondHandTintInfo.mHasTintBlendMode) {
            this.mSecondHand = this.mSecondHandTintInfo.apply(this.mSecondHand);
        }
        this.mTick.run();
        this.mChanged = true;
        this.invalidate();
    }

    @RemotableViewMethod
    public void setSecondHandTintList(ColorStateList tint) {
        this.mSecondHandTintInfo.mTintList = tint;
        this.mSecondHandTintInfo.mHasTintList = true;
        this.mSecondHand = this.mSecondHandTintInfo.apply(this.mSecondHand);
    }

    public ColorStateList getSecondHandTintList() {
        return this.mSecondHandTintInfo.mTintList;
    }

    @RemotableViewMethod
    public void setSecondHandTintBlendMode(BlendMode blendMode) {
        this.mSecondHandTintInfo.mTintBlendMode = blendMode;
        this.mSecondHandTintInfo.mHasTintBlendMode = true;
        this.mSecondHand = this.mSecondHandTintInfo.apply(this.mSecondHand);
    }

    public BlendMode getSecondHandTintBlendMode() {
        return this.mSecondHandTintInfo.mTintBlendMode;
    }

    public String getTimeZone() {
        ZoneId zoneId = this.mTimeZone;
        return zoneId == null ? null : zoneId.getId();
    }

    @RemotableViewMethod
    public void setTimeZone(String timeZone) {
        this.mTimeZone = AnalogClock.toZoneId(timeZone);
        this.createClock();
        this.onTimeChanged();
    }

    @Override
    public void onVisibilityAggregated(boolean isVisible) {
        super.onVisibilityAggregated(isVisible);
        if (isVisible) {
            this.onVisible();
        } else {
            this.onInvisible();
        }
    }

    @Override
    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        IntentFilter filter2 = new IntentFilter();
        if (!this.mReceiverAttached) {
            filter2.addAction("android.intent.action.TIME_SET");
            filter2.addAction("android.intent.action.TIMEZONE_CHANGED");
            this.getContext().registerReceiverAsUser(this.mIntentReceiver, Process.myUserHandle(), filter2, null, this.getHandler());
            this.mReceiverAttached = true;
        }
        this.createClock();
        this.onTimeChanged();
    }

    @Override
    protected void onDetachedFromWindow() {
        if (this.mReceiverAttached) {
            this.getContext().unregisterReceiver(this.mIntentReceiver);
            this.mReceiverAttached = false;
        }
        super.onDetachedFromWindow();
    }

    private void onVisible() {
        if (!this.mVisible) {
            this.mVisible = true;
            this.mTick.run();
        }
    }

    private void onInvisible() {
        if (this.mVisible) {
            this.removeCallbacks(this.mTick);
            this.mVisible = false;
        }
    }

    @Override
    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int widthMode = View.MeasureSpec.getMode(widthMeasureSpec);
        int widthSize = View.MeasureSpec.getSize(widthMeasureSpec);
        int heightMode = View.MeasureSpec.getMode(heightMeasureSpec);
        int heightSize = View.MeasureSpec.getSize(heightMeasureSpec);
        float hScale = 1.0f;
        float vScale = 1.0f;
        if (widthMode != 0 && widthSize < this.mDialWidth) {
            hScale = (float)widthSize / (float)this.mDialWidth;
        }
        if (heightMode != 0 && heightSize < this.mDialHeight) {
            vScale = (float)heightSize / (float)this.mDialHeight;
        }
        float scale = Math.min(hScale, vScale);
        this.setMeasuredDimension(AnalogClock.resolveSizeAndState((int)((float)this.mDialWidth * scale), widthMeasureSpec, 0), AnalogClock.resolveSizeAndState((int)((float)this.mDialHeight * scale), heightMeasureSpec, 0));
    }

    @Override
    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.mChanged = true;
    }

    @Override
    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        boolean changed = this.mChanged;
        if (changed) {
            this.mChanged = false;
        }
        int availableWidth = this.mRight - this.mLeft;
        int availableHeight = this.mBottom - this.mTop;
        int x = availableWidth / 2;
        int y = availableHeight / 2;
        Drawable dial = this.mDial;
        int w = dial.getIntrinsicWidth();
        int h = dial.getIntrinsicHeight();
        boolean scaled = false;
        if (availableWidth < w || availableHeight < h) {
            scaled = true;
            float scale = Math.min((float)availableWidth / (float)w, (float)availableHeight / (float)h);
            canvas.save();
            canvas.scale(scale, scale, x, y);
        }
        if (changed) {
            dial.setBounds(x - w / 2, y - h / 2, x + w / 2, y + h / 2);
        }
        dial.draw(canvas);
        canvas.save();
        canvas.rotate(this.mHour / 12.0f * 360.0f, x, y);
        Drawable hourHand = this.mHourHand;
        if (changed) {
            w = hourHand.getIntrinsicWidth();
            h = hourHand.getIntrinsicHeight();
            hourHand.setBounds(x - w / 2, y - h / 2, x + w / 2, y + h / 2);
        }
        hourHand.draw(canvas);
        canvas.restore();
        canvas.save();
        canvas.rotate(this.mMinutes / 60.0f * 360.0f, x, y);
        Drawable minuteHand = this.mMinuteHand;
        if (changed) {
            w = minuteHand.getIntrinsicWidth();
            h = minuteHand.getIntrinsicHeight();
            minuteHand.setBounds(x - w / 2, y - h / 2, x + w / 2, y + h / 2);
        }
        minuteHand.draw(canvas);
        canvas.restore();
        Drawable secondHand = this.mSecondHand;
        if (secondHand != null && this.mSecondsHandFps > 0) {
            canvas.save();
            canvas.rotate(this.mSeconds / 60.0f * 360.0f, x, y);
            if (changed) {
                w = secondHand.getIntrinsicWidth();
                h = secondHand.getIntrinsicHeight();
                secondHand.setBounds(x - w / 2, y - h / 2, x + w / 2, y + h / 2);
            }
            secondHand.draw(canvas);
            canvas.restore();
        }
        if (scaled) {
            canvas.restore();
        }
    }

    protected Instant now() {
        return this.mClock.instant();
    }

    protected void onTimeChanged() {
        Instant now = this.now();
        this.onTimeChanged(now.atZone(this.mClock.getZone()).toLocalTime(), now.toEpochMilli());
    }

    private void onTimeChanged(LocalTime localTime, long nowMillis) {
        float previousHour = this.mHour;
        float previousMinutes = this.mMinutes;
        float rawSeconds = (float)localTime.getSecond() + (float)localTime.getNano() / 1.0E9f;
        this.mSeconds = this.mSecondsHandFps <= 0 ? rawSeconds : (float)Math.round(rawSeconds * (float)this.mSecondsHandFps) / (float)this.mSecondsHandFps;
        this.mMinutes = (float)localTime.getMinute() + this.mSeconds / 60.0f;
        this.mHour = (float)localTime.getHour() + this.mMinutes / 60.0f;
        this.mChanged = true;
        if ((int)previousHour != (int)this.mHour || (int)previousMinutes != (int)this.mMinutes) {
            this.updateContentDescription(nowMillis);
        }
    }

    private void createClock() {
        ZoneId zoneId = this.mTimeZone;
        this.mClock = zoneId == null ? Clock.systemDefaultZone() : Clock.system(zoneId);
    }

    private void updateContentDescription(long timeMillis) {
        int flags = 129;
        String contentDescription = DateUtils.formatDateRange(this.mContext, new Formatter(new StringBuilder(50), AndroidLocale.getDefault()), timeMillis, timeMillis, 129, this.getTimeZone()).toString();
        this.setContentDescription(contentDescription);
    }

    private static ZoneId toZoneId(String timeZone) {
        if (timeZone == null) {
            return null;
        }
        try {
            return ZoneId.of(timeZone);
        }
        catch (DateTimeException e) {
            Log.w(LOG_TAG, "Failed to parse time zone from " + timeZone, e);
            return null;
        }
    }

    private class TintInfo {
        boolean mHasTintList;
        ColorStateList mTintList;
        boolean mHasTintBlendMode;
        BlendMode mTintBlendMode;

        private TintInfo() {
        }

        Drawable apply(Drawable drawable2) {
            if (drawable2 == null) {
                return null;
            }
            Drawable newDrawable = drawable2.mutate();
            if (this.mHasTintList) {
                newDrawable.setTintList(this.mTintList);
            }
            if (this.mHasTintBlendMode) {
                newDrawable.setTintBlendMode(this.mTintBlendMode);
            }
            if (drawable2.isStateful()) {
                newDrawable.setState(AnalogClock.this.getDrawableState());
            }
            return newDrawable;
        }
    }
}

