/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

class RtlSpacingHelper {
    public static final int UNDEFINED = Integer.MIN_VALUE;
    private int mLeft = 0;
    private int mRight = 0;
    private int mStart = Integer.MIN_VALUE;
    private int mEnd = Integer.MIN_VALUE;
    private int mExplicitLeft = 0;
    private int mExplicitRight = 0;
    private boolean mIsRtl = false;
    private boolean mIsRelative = false;

    RtlSpacingHelper() {
    }

    public int getLeft() {
        return this.mLeft;
    }

    public int getRight() {
        return this.mRight;
    }

    public int getStart() {
        return this.mIsRtl ? this.mRight : this.mLeft;
    }

    public int getEnd() {
        return this.mIsRtl ? this.mLeft : this.mRight;
    }

    public void setRelative(int start, int end) {
        this.mStart = start;
        this.mEnd = end;
        this.mIsRelative = true;
        if (this.mIsRtl) {
            if (end != Integer.MIN_VALUE) {
                this.mLeft = end;
            }
            if (start != Integer.MIN_VALUE) {
                this.mRight = start;
            }
        } else {
            if (start != Integer.MIN_VALUE) {
                this.mLeft = start;
            }
            if (end != Integer.MIN_VALUE) {
                this.mRight = end;
            }
        }
    }

    public void setAbsolute(int left, int right2) {
        this.mIsRelative = false;
        if (left != Integer.MIN_VALUE) {
            this.mLeft = this.mExplicitLeft = left;
        }
        if (right2 != Integer.MIN_VALUE) {
            this.mRight = this.mExplicitRight = right2;
        }
    }

    public void setDirection(boolean isRtl) {
        if (isRtl == this.mIsRtl) {
            return;
        }
        this.mIsRtl = isRtl;
        if (this.mIsRelative) {
            if (isRtl) {
                this.mLeft = this.mEnd != Integer.MIN_VALUE ? this.mEnd : this.mExplicitLeft;
                this.mRight = this.mStart != Integer.MIN_VALUE ? this.mStart : this.mExplicitRight;
            } else {
                this.mLeft = this.mStart != Integer.MIN_VALUE ? this.mStart : this.mExplicitLeft;
                this.mRight = this.mEnd != Integer.MIN_VALUE ? this.mEnd : this.mExplicitRight;
            }
        } else {
            this.mLeft = this.mExplicitLeft;
            this.mRight = this.mExplicitRight;
        }
    }
}

