/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.text.Editable;
import android.text.Selection;
import android.text.SpannedString;
import android.text.method.WordIterator;
import android.text.style.SpellCheckSpan;
import android.text.style.SuggestionSpan;
import android.util.Log;
import android.util.Range;
import android.view.textservice.SentenceSuggestionsInfo;
import android.view.textservice.SpellCheckerSession;
import android.view.textservice.SuggestionsInfo;
import android.view.textservice.TextInfo;
import android.view.textservice.TextServicesManager;
import android.widget.TextView;
import com.android.internal.util.ArrayUtils;
import com.android.internal.util.GrowingArrayUtils;
import java.text.BreakIterator;
import java.util.Locale;

public class SpellChecker
implements SpellCheckerSession.SpellCheckerSessionListener {
    private static final String TAG = SpellChecker.class.getSimpleName();
    private static final boolean DBG = false;
    public static final int MAX_NUMBER_OF_WORDS = 50;
    public static final int AVERAGE_WORD_LENGTH = 7;
    public static final int WORD_ITERATOR_INTERVAL = 350;
    private static final int SPELL_PAUSE_DURATION = 400;
    private static final int MAX_SENTENCE_LENGTH = 350;
    private static final int USE_SPAN_RANGE = -1;
    private final TextView mTextView;
    SpellCheckerSession mSpellCheckerSession;
    final int mCookie;
    private int[] mIds;
    private SpellCheckSpan[] mSpellCheckSpans;
    private int mLength;
    private SpellParser[] mSpellParsers = new SpellParser[0];
    private int mSpanSequenceCounter = 0;
    private Locale mCurrentLocale;
    private SentenceIteratorWrapper mSentenceIterator;
    private TextServicesManager mTextServicesManager;
    private Runnable mSpellRunnable;

    public SpellChecker(TextView textView) {
        this.mTextView = textView;
        boolean size = true;
        this.mIds = ArrayUtils.newUnpaddedIntArray(1);
        this.mSpellCheckSpans = new SpellCheckSpan[this.mIds.length];
        this.setLocale(this.mTextView.getSpellCheckerLocale());
        this.mCookie = this.hashCode();
    }

    void resetSession() {
        this.closeSession();
        this.mTextServicesManager = this.mTextView.getTextServicesManagerForUser();
        if (this.mCurrentLocale == null || this.mTextServicesManager == null || this.mTextView.length() == 0 || !this.mTextServicesManager.isSpellCheckerEnabled() || this.mTextServicesManager.getCurrentSpellCheckerSubtype(true) == null) {
            this.mSpellCheckerSession = null;
        } else {
            int supportedAttributes = 27;
            SpellCheckerSession.SpellCheckerSessionParams params = new SpellCheckerSession.SpellCheckerSessionParams.Builder().setLocale(this.mCurrentLocale).setSupportedAttributes(supportedAttributes).build();
            this.mSpellCheckerSession = this.mTextServicesManager.newSpellCheckerSession(params, this.mTextView.getContext().getMainExecutor(), this);
        }
        for (int i = 0; i < this.mLength; ++i) {
            this.mIds[i] = -1;
        }
        this.mLength = 0;
        this.mTextView.removeMisspelledSpans((Editable)this.mTextView.getText());
    }

    private void setLocale(Locale locale) {
        this.mCurrentLocale = locale;
        this.resetSession();
        if (locale != null) {
            this.mSentenceIterator = new SentenceIteratorWrapper(BreakIterator.getSentenceInstance(locale));
        }
        this.mTextView.onLocaleChanged();
    }

    private boolean isSessionActive() {
        return this.mSpellCheckerSession != null;
    }

    public void closeSession() {
        if (this.mSpellCheckerSession != null) {
            this.mSpellCheckerSession.close();
        }
        int length = this.mSpellParsers.length;
        for (int i = 0; i < length; ++i) {
            this.mSpellParsers[i].stop();
        }
        if (this.mSpellRunnable != null) {
            this.mTextView.removeCallbacks(this.mSpellRunnable);
        }
    }

    private int nextSpellCheckSpanIndex() {
        for (int i = 0; i < this.mLength; ++i) {
            if (this.mIds[i] >= 0) continue;
            return i;
        }
        this.mIds = GrowingArrayUtils.append(this.mIds, this.mLength, 0);
        this.mSpellCheckSpans = GrowingArrayUtils.append(this.mSpellCheckSpans, this.mLength, new SpellCheckSpan());
        ++this.mLength;
        return this.mLength - 1;
    }

    private void addSpellCheckSpan(Editable editable, int start, int end) {
        int index = this.nextSpellCheckSpanIndex();
        SpellCheckSpan spellCheckSpan = this.mSpellCheckSpans[index];
        editable.setSpan(spellCheckSpan, start, end, 33);
        spellCheckSpan.setSpellCheckInProgress(false);
        ++this.mSpanSequenceCounter;
    }

    public void onSpellCheckSpanRemoved(SpellCheckSpan spellCheckSpan) {
        for (int i = 0; i < this.mLength; ++i) {
            if (this.mSpellCheckSpans[i] != spellCheckSpan) continue;
            this.mIds[i] = -1;
            return;
        }
    }

    public void onSelectionChanged() {
        this.spellCheck();
    }

    void onPerformSpellCheck() {
        boolean start = false;
        int end = this.mTextView.length();
        this.spellCheck(0, end, true);
    }

    public void spellCheck(int start, int end) {
        this.spellCheck(start, end, false);
    }

    public void spellCheck(int start, int end, boolean forceCheckWhenEditingWord) {
        SpellParser spellParser;
        Locale locale = this.mTextView.getSpellCheckerLocale();
        boolean isSessionActive = this.isSessionActive();
        if (locale == null || this.mCurrentLocale == null || !this.mCurrentLocale.equals(locale)) {
            this.setLocale(locale);
            start = 0;
            end = this.mTextView.getText().length();
        } else {
            boolean spellCheckerActivated;
            boolean bl = spellCheckerActivated = this.mTextServicesManager != null && this.mTextServicesManager.isSpellCheckerEnabled();
            if (isSessionActive != spellCheckerActivated) {
                this.resetSession();
            }
        }
        if (!isSessionActive) {
            return;
        }
        int length = this.mSpellParsers.length;
        for (int i = 0; i < length; ++i) {
            spellParser = this.mSpellParsers[i];
            if (!spellParser.isFinished()) continue;
            spellParser.parse(start, end, forceCheckWhenEditingWord);
            return;
        }
        SpellParser[] newSpellParsers = new SpellParser[length + 1];
        System.arraycopy(this.mSpellParsers, 0, newSpellParsers, 0, length);
        this.mSpellParsers = newSpellParsers;
        this.mSpellParsers[length] = spellParser = new SpellParser();
        spellParser.parse(start, end, forceCheckWhenEditingWord);
    }

    private void spellCheck() {
        this.spellCheck(false);
    }

    private void spellCheck(boolean forceCheckWhenEditingWord) {
        if (this.mSpellCheckerSession == null) {
            return;
        }
        Editable editable = (Editable)this.mTextView.getText();
        int selectionStart = Selection.getSelectionStart(editable);
        int selectionEnd = Selection.getSelectionEnd(editable);
        TextInfo[] textInfos = new TextInfo[this.mLength];
        int textInfosCount = 0;
        for (int i = 0; i < this.mLength; ++i) {
            boolean isNotEditing;
            SpellCheckSpan spellCheckSpan = this.mSpellCheckSpans[i];
            if (this.mIds[i] < 0 || spellCheckSpan.isSpellCheckInProgress()) continue;
            int start = editable.getSpanStart(spellCheckSpan);
            int end = editable.getSpanEnd(spellCheckSpan);
            if (selectionStart == end + 1 && WordIterator.isMidWordPunctuation(this.mCurrentLocale, Character.codePointBefore(editable, end + 1))) {
                isNotEditing = false;
            } else if (selectionEnd <= start || selectionStart > end) {
                isNotEditing = true;
            } else {
                boolean bl = isNotEditing = selectionStart == end && selectionStart > 0 && SpellChecker.isSeparator(Character.codePointBefore(editable, selectionStart));
            }
            if (start < 0 || end <= start || !forceCheckWhenEditingWord && !isNotEditing) continue;
            spellCheckSpan.setSpellCheckInProgress(true);
            TextInfo textInfo = new TextInfo(editable, start, end, this.mCookie, this.mIds[i]);
            textInfos[textInfosCount++] = textInfo;
        }
        if (textInfosCount > 0) {
            if (textInfosCount < textInfos.length) {
                TextInfo[] textInfosCopy = new TextInfo[textInfosCount];
                System.arraycopy(textInfos, 0, textInfosCopy, 0, textInfosCount);
                textInfos = textInfosCopy;
            }
            this.mSpellCheckerSession.getSentenceSuggestions(textInfos, 5);
        }
    }

    private static boolean isSeparator(int codepoint) {
        int type = Character.getType(codepoint);
        return (1 << type & 0x61707000) != 0;
    }

    private SpellCheckSpan onGetSuggestionsInternal(SuggestionsInfo suggestionsInfo, int offset2, int length) {
        if (suggestionsInfo == null || suggestionsInfo.getCookie() != this.mCookie) {
            return null;
        }
        Editable editable = (Editable)this.mTextView.getText();
        int sequenceNumber = suggestionsInfo.getSequence();
        for (int k = 0; k < this.mLength; ++k) {
            boolean looksLikeGrammarError;
            if (sequenceNumber != this.mIds[k]) continue;
            SpellCheckSpan spellCheckSpan = this.mSpellCheckSpans[k];
            int spellCheckSpanStart = editable.getSpanStart(spellCheckSpan);
            if (spellCheckSpanStart < 0) {
                return null;
            }
            int attributes = suggestionsInfo.getSuggestionsAttributes();
            boolean isInDictionary = (attributes & 1) > 0;
            boolean looksLikeTypo = (attributes & 2) > 0;
            boolean bl = looksLikeGrammarError = (attributes & 8) > 0;
            if (spellCheckSpanStart + offset2 + length > editable.length()) {
                return spellCheckSpan;
            }
            if (!isInDictionary && (looksLikeTypo || looksLikeGrammarError)) {
                this.createMisspelledSuggestionSpan(editable, suggestionsInfo, spellCheckSpan, offset2, length);
            } else {
                int end;
                int start;
                int spellCheckSpanEnd = editable.getSpanEnd(spellCheckSpan);
                if (offset2 != -1 && length != -1) {
                    start = spellCheckSpanStart + offset2;
                    end = start + length;
                } else {
                    start = spellCheckSpanStart;
                    end = spellCheckSpanEnd;
                }
                if (spellCheckSpanStart >= 0 && spellCheckSpanEnd > spellCheckSpanStart && end > start) {
                    boolean visibleToAccessibility = this.mTextView.isVisibleToAccessibility();
                    SpannedString beforeText = visibleToAccessibility ? new SpannedString(editable) : null;
                    boolean spanRemoved = SpellChecker.removeErrorSuggestionSpan(editable, start, end, RemoveReason.OBSOLETE);
                    if (visibleToAccessibility && spanRemoved) {
                        this.mTextView.sendAccessibilityEventTypeViewTextChanged(beforeText, start, end);
                    }
                }
            }
            return spellCheckSpan;
        }
        return null;
    }

    private static boolean removeErrorSuggestionSpan(Editable editable, int start, int end, RemoveReason reason) {
        SuggestionSpan[] spans;
        boolean spanRemoved = false;
        for (SuggestionSpan span : spans = editable.getSpans(start, end, SuggestionSpan.class)) {
            if (editable.getSpanStart(span) != start || editable.getSpanEnd(span) != end || (span.getFlags() & 0xA) == 0) continue;
            editable.removeSpan(span);
            spanRemoved = true;
        }
        return spanRemoved;
    }

    @Override
    public void onGetSuggestions(SuggestionsInfo[] results) {
        Editable editable = (Editable)this.mTextView.getText();
        for (int i = 0; i < results.length; ++i) {
            SpellCheckSpan spellCheckSpan = this.onGetSuggestionsInternal(results[i], -1, -1);
            if (spellCheckSpan == null) continue;
            editable.removeSpan(spellCheckSpan);
        }
        this.scheduleNewSpellCheck();
    }

    @Override
    public void onGetSentenceSuggestions(SentenceSuggestionsInfo[] results) {
        Editable editable = (Editable)this.mTextView.getText();
        for (int i = 0; i < results.length; ++i) {
            SentenceSuggestionsInfo ssi = results[i];
            if (ssi == null) continue;
            SpellCheckSpan spellCheckSpan = null;
            for (int j = 0; j < ssi.getSuggestionsCount(); ++j) {
                SuggestionsInfo suggestionsInfo = ssi.getSuggestionsInfoAt(j);
                if (suggestionsInfo == null) continue;
                int offset2 = ssi.getOffsetAt(j);
                int length = ssi.getLengthAt(j);
                SpellCheckSpan scs = this.onGetSuggestionsInternal(suggestionsInfo, offset2, length);
                if (spellCheckSpan != null || scs == null) continue;
                spellCheckSpan = scs;
            }
            if (spellCheckSpan == null) continue;
            editable.removeSpan(spellCheckSpan);
        }
        this.scheduleNewSpellCheck();
    }

    private void scheduleNewSpellCheck() {
        if (this.mSpellRunnable == null) {
            this.mSpellRunnable = new Runnable(){

                @Override
                public void run() {
                    for (SpellParser spellParser : SpellChecker.this.mSpellParsers) {
                        if (spellParser.isFinished()) continue;
                        spellParser.parse();
                        break;
                    }
                }
            };
        } else {
            this.mTextView.removeCallbacks(this.mSpellRunnable);
        }
        this.mTextView.postDelayed(this.mSpellRunnable, 400L);
    }

    private void createMisspelledSuggestionSpan(Editable editable, SuggestionsInfo suggestionsInfo, SpellCheckSpan spellCheckSpan, int offset2, int length) {
        String[] suggestions;
        int end;
        int start;
        int spellCheckSpanStart = editable.getSpanStart(spellCheckSpan);
        int spellCheckSpanEnd = editable.getSpanEnd(spellCheckSpan);
        if (spellCheckSpanStart < 0 || spellCheckSpanEnd <= spellCheckSpanStart) {
            return;
        }
        if (offset2 != -1 && length != -1) {
            start = spellCheckSpanStart + offset2;
            end = start + length;
        } else {
            start = spellCheckSpanStart;
            end = spellCheckSpanEnd;
        }
        int suggestionsCount = suggestionsInfo.getSuggestionsCount();
        if (suggestionsCount > 0) {
            suggestions = new String[suggestionsCount];
            for (int i = 0; i < suggestionsCount; ++i) {
                suggestions[i] = suggestionsInfo.getSuggestionAt(i);
            }
        } else {
            suggestions = ArrayUtils.emptyArray(String.class);
        }
        int suggestionsAttrs = suggestionsInfo.getSuggestionsAttributes();
        int flags = 0;
        if ((suggestionsAttrs & 0x10) == 0) {
            flags |= 1;
        }
        if ((suggestionsAttrs & 2) != 0) {
            flags |= 2;
        }
        if ((suggestionsAttrs & 8) != 0) {
            flags |= 8;
        }
        SuggestionSpan suggestionSpan = new SuggestionSpan(this.mTextView.getContext(), suggestions, flags);
        boolean spanRemoved = SpellChecker.removeErrorSuggestionSpan(editable, start, end, RemoveReason.REPLACE);
        boolean sendAccessibilityEvent = !spanRemoved && this.mTextView.isVisibleToAccessibility();
        SpannedString beforeText = sendAccessibilityEvent ? new SpannedString(editable) : null;
        editable.setSpan(suggestionSpan, start, end, 33);
        if (sendAccessibilityEvent) {
            this.mTextView.sendAccessibilityEventTypeViewTextChanged(beforeText, start, end);
        }
        this.mTextView.invalidateRegion(start, end, false);
    }

    private Range<Integer> detectSentenceBoundary(CharSequence sequence, int textChangeStart, int textChangeEnd) {
        int iteratorWindowStart = SpellChecker.findSeparator(sequence, Math.max(0, textChangeStart - 350), Math.max(0, textChangeStart - 700));
        int iteratorWindowEnd = SpellChecker.findSeparator(sequence, Math.min(textChangeStart + 700, textChangeEnd), Math.min(textChangeStart + 1050, sequence.length()));
        this.mSentenceIterator.setCharSequence(sequence, iteratorWindowStart, iteratorWindowEnd);
        int sentenceStart = this.mSentenceIterator.isBoundary(textChangeStart) ? textChangeStart : this.mSentenceIterator.preceding(textChangeStart);
        int sentenceEnd = this.mSentenceIterator.following(sentenceStart);
        if (sentenceEnd == -1) {
            sentenceEnd = iteratorWindowEnd;
        }
        if (sentenceEnd - sentenceStart <= 350) {
            int nextEnd;
            while (sentenceEnd < textChangeEnd && (nextEnd = this.mSentenceIterator.following(sentenceEnd)) != -1 && nextEnd - sentenceStart <= 350) {
                sentenceEnd = nextEnd;
            }
        } else {
            int uncheckedLength = sentenceEnd - textChangeStart;
            if (uncheckedLength > 350) {
                sentenceEnd = SpellChecker.findSeparator(sequence, textChangeStart + 350, sentenceEnd);
                sentenceStart = this.roundUpToWordStart(sequence, textChangeStart, sentenceStart);
            } else {
                sentenceStart = this.roundUpToWordStart(sequence, sentenceEnd - 350, sentenceStart);
            }
        }
        return new Range<Integer>(sentenceStart, Math.max(sentenceStart, sentenceEnd));
    }

    private int roundUpToWordStart(CharSequence sequence, int position, int frontBoundary) {
        if (SpellChecker.isSeparator(sequence.charAt(position))) {
            return position;
        }
        int separator = SpellChecker.findSeparator(sequence, position, frontBoundary);
        return separator != frontBoundary ? separator + 1 : frontBoundary;
    }

    private static int findSeparator(CharSequence sequence, int start, int end) {
        int step = start < end ? 1 : -1;
        for (int i = start; i != end; i += step) {
            if (!SpellChecker.isSeparator(sequence.charAt(i))) continue;
            return i;
        }
        return end;
    }

    public static boolean haveWordBoundariesChanged(Editable editable, int start, int end, int spanStart, int spanEnd) {
        boolean haveWordBoundariesChanged;
        if (spanEnd != start && spanStart != end) {
            haveWordBoundariesChanged = true;
        } else if (spanEnd == start && start < editable.length()) {
            int codePoint = Character.codePointAt(editable, start);
            haveWordBoundariesChanged = Character.isLetterOrDigit(codePoint);
        } else if (spanStart == end && end > 0) {
            int codePoint = Character.codePointBefore(editable, end);
            haveWordBoundariesChanged = Character.isLetterOrDigit(codePoint);
        } else {
            haveWordBoundariesChanged = false;
        }
        return haveWordBoundariesChanged;
    }

    private class SpellParser {
        private Object mRange = new Object();
        private boolean mForceCheckWhenEditingWord;

        private SpellParser() {
        }

        public void parse(int start, int end, boolean forceCheckWhenEditingWord) {
            int parseEnd;
            this.mForceCheckWhenEditingWord = forceCheckWhenEditingWord;
            int max = SpellChecker.this.mTextView.length();
            if (end > max) {
                Log.w(TAG, "Parse invalid region, from " + start + " to " + end);
                parseEnd = max;
            } else {
                parseEnd = end;
            }
            if (parseEnd > start) {
                this.setRangeSpan((Editable)SpellChecker.this.mTextView.getText(), start, parseEnd);
                this.parse();
            }
        }

        public boolean isFinished() {
            return ((Editable)SpellChecker.this.mTextView.getText()).getSpanStart(this.mRange) < 0;
        }

        public void stop() {
            this.removeRangeSpan((Editable)SpellChecker.this.mTextView.getText());
            this.mForceCheckWhenEditingWord = false;
        }

        private void setRangeSpan(Editable editable, int start, int end) {
            editable.setSpan(this.mRange, start, end, 33);
        }

        private void removeRangeSpan(Editable editable) {
            editable.removeSpan(this.mRange);
        }

        public void parse() {
            int sentenceEnd;
            int textChangeEnd;
            int textChangeStart;
            Editable editable = (Editable)SpellChecker.this.mTextView.getText();
            Range<Integer> sentenceBoundary = SpellChecker.this.detectSentenceBoundary(editable, textChangeStart = editable.getSpanStart(this.mRange), textChangeEnd = editable.getSpanEnd(this.mRange));
            int sentenceStart = sentenceBoundary.getLower();
            if (sentenceStart == (sentenceEnd = sentenceBoundary.getUpper().intValue())) {
                this.stop();
                return;
            }
            boolean scheduleOtherSpellCheck = false;
            if (sentenceEnd < textChangeEnd) {
                scheduleOtherSpellCheck = true;
            }
            int spellCheckEnd = sentenceEnd;
            int spellCheckStart = sentenceStart;
            boolean createSpellCheckSpan = true;
            for (int i = 0; i < SpellChecker.this.mLength; ++i) {
                SpellCheckSpan spellCheckSpan = SpellChecker.this.mSpellCheckSpans[i];
                if (SpellChecker.this.mIds[i] < 0 || spellCheckSpan.isSpellCheckInProgress()) continue;
                int spanStart = editable.getSpanStart(spellCheckSpan);
                int spanEnd = editable.getSpanEnd(spellCheckSpan);
                if (spanEnd < spellCheckStart || spellCheckEnd < spanStart) continue;
                if (spanStart <= spellCheckStart && spellCheckEnd <= spanEnd) {
                    createSpellCheckSpan = false;
                    break;
                }
                editable.removeSpan(spellCheckSpan);
                spellCheckStart = Math.min(spanStart, spellCheckStart);
                spellCheckEnd = Math.max(spanEnd, spellCheckEnd);
            }
            if (spellCheckEnd <= spellCheckStart) {
                Log.w(TAG, "Trying to spellcheck invalid region, from " + sentenceStart + " to " + spellCheckEnd);
            } else if (createSpellCheckSpan) {
                SpellChecker.this.addSpellCheckSpan(editable, spellCheckStart, spellCheckEnd);
            }
            sentenceStart = spellCheckEnd;
            if (scheduleOtherSpellCheck && sentenceStart != -1 && sentenceStart <= textChangeEnd) {
                this.setRangeSpan(editable, sentenceStart, textChangeEnd);
            } else {
                this.removeRangeSpan(editable);
            }
            SpellChecker.this.spellCheck(this.mForceCheckWhenEditingWord);
        }

        private <T> void removeSpansAt(Editable editable, int offset2, T[] spans) {
            for (T span : spans) {
                int end;
                int start = editable.getSpanStart(span);
                if (start > offset2 || (end = editable.getSpanEnd(span)) < offset2) continue;
                editable.removeSpan(span);
            }
        }
    }

    private static class SentenceIteratorWrapper {
        private BreakIterator mSentenceIterator;
        private int mStartOffset;
        private int mEndOffset;

        SentenceIteratorWrapper(BreakIterator sentenceIterator) {
            this.mSentenceIterator = sentenceIterator;
        }

        public void setCharSequence(CharSequence sequence, int start, int end) {
            this.mStartOffset = Math.max(0, start);
            this.mEndOffset = Math.min(end, sequence.length());
            this.mSentenceIterator.setText(sequence.subSequence(this.mStartOffset, this.mEndOffset).toString());
        }

        public int preceding(int offset2) {
            if (offset2 < this.mStartOffset) {
                return -1;
            }
            int result = this.mSentenceIterator.preceding(offset2 - this.mStartOffset);
            return result == -1 ? -1 : result + this.mStartOffset;
        }

        public int following(int offset2) {
            if (offset2 > this.mEndOffset) {
                return -1;
            }
            int result = this.mSentenceIterator.following(offset2 - this.mStartOffset);
            return result == -1 ? -1 : result + this.mStartOffset;
        }

        public boolean isBoundary(int offset2) {
            if (offset2 < this.mStartOffset || offset2 > this.mEndOffset) {
                return false;
            }
            return this.mSentenceIterator.isBoundary(offset2 - this.mStartOffset);
        }
    }

    private static enum RemoveReason {
        REPLACE,
        OBSOLETE;

    }
}

