/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.app.AlertDialog;
import android.compat.annotation.UnsupportedAppUsage;
import android.content.Context;
import android.content.DialogInterface;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.database.DataSetObserver;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.util.Log;
import android.view.ContextThemeWrapper;
import android.view.Gravity;
import android.view.MotionEvent;
import android.view.PointerIcon;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.view.accessibility.AccessibilityNodeInfo;
import android.widget.AbsSpinner;
import android.widget.AdapterView;
import android.widget.ForwardingListener;
import android.widget.ListAdapter;
import android.widget.ListPopupWindow;
import android.widget.ListView;
import android.widget.PopupWindow;
import android.widget.SpinnerAdapter;
import android.widget.ThemedSpinnerAdapter;
import com.android.internal.R;
import com.android.internal.view.menu.ShowableListMenu;

public class Spinner
extends AbsSpinner
implements DialogInterface.OnClickListener {
    private static final String TAG = "Spinner";
    private static final int MAX_ITEMS_MEASURED = 15;
    public static final int MODE_DIALOG = 0;
    public static final int MODE_DROPDOWN = 1;
    private static final int MODE_THEME = -1;
    private final Rect mTempRect = new Rect();
    private final Context mPopupContext;
    @UnsupportedAppUsage
    private ForwardingListener mForwardingListener;
    private SpinnerAdapter mTempAdapter;
    @UnsupportedAppUsage
    private SpinnerPopup mPopup;
    int mDropDownWidth;
    private int mGravity;
    private boolean mDisableChildrenWhenDisabled;

    public Spinner(Context context) {
        this(context, null);
    }

    public Spinner(Context context, int mode) {
        this(context, null, 0x1010081, mode);
    }

    public Spinner(Context context, AttributeSet attrs) {
        this(context, attrs, 0x1010081);
    }

    public Spinner(Context context, AttributeSet attrs, int defStyleAttr) {
        this(context, attrs, defStyleAttr, 0, -1);
    }

    public Spinner(Context context, AttributeSet attrs, int defStyleAttr, int mode) {
        this(context, attrs, defStyleAttr, 0, mode);
    }

    public Spinner(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes, int mode) {
        this(context, attrs, defStyleAttr, defStyleRes, mode, null);
    }

    public Spinner(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes, int mode, Resources.Theme popupTheme) {
        super(context, attrs, defStyleAttr, defStyleRes);
        int popupThemeResId;
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.Spinner, defStyleAttr, defStyleRes);
        this.saveAttributeDataForStyleable(context, R.styleable.Spinner, attrs, a, defStyleAttr, defStyleRes);
        this.mPopupContext = popupTheme != null ? new ContextThemeWrapper(context, popupTheme) : ((popupThemeResId = a.getResourceId(7, 0)) != 0 ? new ContextThemeWrapper(context, popupThemeResId) : context);
        if (mode == -1) {
            mode = a.getInt(5, 0);
        }
        switch (mode) {
            case 0: {
                this.mPopup = new DialogPopup();
                this.mPopup.setPromptText(a.getString(3));
                break;
            }
            case 1: {
                final DropdownPopup popup2 = new DropdownPopup(this.mPopupContext, attrs, defStyleAttr, defStyleRes);
                TypedArray pa = this.mPopupContext.obtainStyledAttributes(attrs, R.styleable.Spinner, defStyleAttr, defStyleRes);
                this.mDropDownWidth = pa.getLayoutDimension(4, -2);
                if (pa.hasValueOrEmpty(1)) {
                    popup2.setListSelector(pa.getDrawable(1));
                }
                popup2.setBackgroundDrawable(pa.getDrawable(2));
                popup2.setPromptText(a.getString(3));
                pa.recycle();
                this.mPopup = popup2;
                this.mForwardingListener = new ForwardingListener(this){

                    @Override
                    public ShowableListMenu getPopup() {
                        return popup2;
                    }

                    @Override
                    public boolean onForwardingStarted() {
                        if (!Spinner.this.mPopup.isShowing()) {
                            Spinner.this.mPopup.show(Spinner.this.getTextDirection(), Spinner.this.getTextAlignment());
                        }
                        return true;
                    }
                };
                break;
            }
        }
        this.mGravity = a.getInt(0, 17);
        this.mDisableChildrenWhenDisabled = a.getBoolean(8, false);
        a.recycle();
        if (this.mTempAdapter != null) {
            this.setAdapter(this.mTempAdapter);
            this.mTempAdapter = null;
        }
    }

    public Context getPopupContext() {
        return this.mPopupContext;
    }

    public void setPopupBackgroundDrawable(Drawable background) {
        if (!(this.mPopup instanceof DropdownPopup)) {
            Log.e(TAG, "setPopupBackgroundDrawable: incompatible spinner mode; ignoring...");
            return;
        }
        this.mPopup.setBackgroundDrawable(background);
    }

    public void setPopupBackgroundResource(int resId) {
        this.setPopupBackgroundDrawable(this.getPopupContext().getDrawable(resId));
    }

    public Drawable getPopupBackground() {
        return this.mPopup.getBackground();
    }

    public boolean isPopupShowing() {
        return this.mPopup != null && this.mPopup.isShowing();
    }

    public void setDropDownVerticalOffset(int pixels) {
        this.mPopup.setVerticalOffset(pixels);
    }

    public int getDropDownVerticalOffset() {
        return this.mPopup.getVerticalOffset();
    }

    public void setDropDownHorizontalOffset(int pixels) {
        this.mPopup.setHorizontalOffset(pixels);
    }

    public int getDropDownHorizontalOffset() {
        return this.mPopup.getHorizontalOffset();
    }

    public void setDropDownWidth(int pixels) {
        if (!(this.mPopup instanceof DropdownPopup)) {
            Log.e(TAG, "Cannot set dropdown width for MODE_DIALOG, ignoring");
            return;
        }
        this.mDropDownWidth = pixels;
    }

    public int getDropDownWidth() {
        return this.mDropDownWidth;
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (this.mDisableChildrenWhenDisabled) {
            int count = this.getChildCount();
            for (int i = 0; i < count; ++i) {
                this.getChildAt(i).setEnabled(enabled);
            }
        }
    }

    public void setGravity(int gravity) {
        if (this.mGravity != gravity) {
            if ((gravity & 7) == 0) {
                gravity |= 0x800003;
            }
            this.mGravity = gravity;
            this.requestLayout();
        }
    }

    public int getGravity() {
        return this.mGravity;
    }

    @Override
    public void setAdapter(SpinnerAdapter adapter) {
        if (this.mPopup == null) {
            this.mTempAdapter = adapter;
            return;
        }
        super.setAdapter(adapter);
        this.mRecycler.clear();
        int targetSdkVersion = this.mContext.getApplicationInfo().targetSdkVersion;
        if (targetSdkVersion >= 21 && adapter != null && adapter.getViewTypeCount() != 1) {
            throw new IllegalArgumentException("Spinner adapter view type count must be 1");
        }
        Context popupContext = this.mPopupContext == null ? this.mContext : this.mPopupContext;
        this.mPopup.setAdapter(new DropDownAdapter(adapter, popupContext.getTheme()));
    }

    @Override
    public int getBaseline() {
        View child = null;
        if (this.getChildCount() > 0) {
            child = this.getChildAt(0);
        } else if (this.mAdapter != null && this.mAdapter.getCount() > 0) {
            child = this.makeView(0, false);
            this.mRecycler.put(0, child);
        }
        if (child != null) {
            int childBaseline = child.getBaseline();
            return childBaseline >= 0 ? child.getTop() + childBaseline : -1;
        }
        return -1;
    }

    @Override
    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (this.mPopup != null && this.mPopup.isShowing()) {
            this.mPopup.dismiss();
        }
    }

    @Override
    public void setOnItemClickListener(AdapterView.OnItemClickListener l) {
        throw new RuntimeException("setOnItemClickListener cannot be used with a spinner.");
    }

    @UnsupportedAppUsage
    public void setOnItemClickListenerInt(AdapterView.OnItemClickListener l) {
        super.setOnItemClickListener(l);
    }

    @Override
    public boolean onTouchEvent(MotionEvent event) {
        if (this.mForwardingListener != null && this.mForwardingListener.onTouch(this, event)) {
            return true;
        }
        return super.onTouchEvent(event);
    }

    @Override
    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        if (this.mPopup != null && View.MeasureSpec.getMode(widthMeasureSpec) == Integer.MIN_VALUE) {
            int measuredWidth = this.getMeasuredWidth();
            this.setMeasuredDimension(Math.min(Math.max(measuredWidth, this.measureContentWidth(this.getAdapter(), this.getBackground())), View.MeasureSpec.getSize(widthMeasureSpec)), this.getMeasuredHeight());
        }
    }

    @Override
    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        super.onLayout(changed, l, t, r, b);
        this.mInLayout = true;
        this.layout(0, false);
        this.mInLayout = false;
    }

    @Override
    void layout(int delta, boolean animate) {
        int childrenLeft = this.mSpinnerPadding.left;
        int childrenWidth = this.mRight - this.mLeft - this.mSpinnerPadding.left - this.mSpinnerPadding.right;
        if (this.mDataChanged) {
            this.handleDataChanged();
        }
        if (this.mItemCount == 0) {
            this.resetList();
            return;
        }
        if (this.mNextSelectedPosition >= 0) {
            this.setSelectedPositionInt(this.mNextSelectedPosition);
        }
        this.recycleAllViews();
        this.removeAllViewsInLayout();
        this.mFirstPosition = this.mSelectedPosition;
        if (this.mAdapter != null) {
            View sel = this.makeView(this.mSelectedPosition, true);
            int width2 = sel.getMeasuredWidth();
            int selectedOffset = childrenLeft;
            int layoutDirection = this.getLayoutDirection();
            int absoluteGravity = Gravity.getAbsoluteGravity(this.mGravity, layoutDirection);
            switch (absoluteGravity & 7) {
                case 1: {
                    selectedOffset = childrenLeft + childrenWidth / 2 - width2 / 2;
                    break;
                }
                case 5: {
                    selectedOffset = childrenLeft + childrenWidth - width2;
                }
            }
            sel.offsetLeftAndRight(selectedOffset);
        }
        this.mRecycler.clear();
        this.invalidate();
        this.checkSelectionChanged();
        this.mDataChanged = false;
        this.mNeedSync = false;
        this.setNextSelectedPositionInt(this.mSelectedPosition);
    }

    private View makeView(int position, boolean addChild) {
        View child;
        if (!this.mDataChanged && (child = this.mRecycler.get(position)) != null) {
            this.setUpChild(child, addChild);
            return child;
        }
        child = this.mAdapter.getView(position, null, this);
        this.setUpChild(child, addChild);
        return child;
    }

    private void setUpChild(View child, boolean addChild) {
        ViewGroup.LayoutParams lp = child.getLayoutParams();
        if (lp == null) {
            lp = this.generateDefaultLayoutParams();
        }
        this.addViewInLayout(child, 0, lp);
        child.setSelected(this.hasFocus());
        if (this.mDisableChildrenWhenDisabled) {
            child.setEnabled(this.isEnabled());
        }
        int childHeightSpec = ViewGroup.getChildMeasureSpec(this.mHeightMeasureSpec, this.mSpinnerPadding.top + this.mSpinnerPadding.bottom, lp.height);
        int childWidthSpec = ViewGroup.getChildMeasureSpec(this.mWidthMeasureSpec, this.mSpinnerPadding.left + this.mSpinnerPadding.right, lp.width);
        child.measure(childWidthSpec, childHeightSpec);
        int childTop = this.mSpinnerPadding.top + (this.getMeasuredHeight() - this.mSpinnerPadding.bottom - this.mSpinnerPadding.top - child.getMeasuredHeight()) / 2;
        int childBottom = childTop + child.getMeasuredHeight();
        int width2 = child.getMeasuredWidth();
        int childLeft = 0;
        int childRight = childLeft + width2;
        child.layout(childLeft, childTop, childRight, childBottom);
        if (!addChild) {
            this.removeViewInLayout(child);
        }
    }

    @Override
    public boolean performClick() {
        boolean handled = super.performClick();
        if (!handled) {
            handled = true;
            if (!this.mPopup.isShowing()) {
                this.mPopup.show(this.getTextDirection(), this.getTextAlignment());
            }
        }
        return handled;
    }

    @Override
    public void onClick(DialogInterface dialog, int which) {
        this.setSelection(which);
        dialog.dismiss();
    }

    @Override
    public CharSequence getAccessibilityClassName() {
        return Spinner.class.getName();
    }

    @Override
    public void onInitializeAccessibilityNodeInfoInternal(AccessibilityNodeInfo info) {
        super.onInitializeAccessibilityNodeInfoInternal(info);
        if (this.mAdapter != null) {
            info.setCanOpenPopup(true);
        }
    }

    public void setPrompt(CharSequence prompt) {
        this.mPopup.setPromptText(prompt);
    }

    public void setPromptId(int promptId) {
        this.setPrompt(this.getContext().getText(promptId));
    }

    public CharSequence getPrompt() {
        return this.mPopup.getHintText();
    }

    int measureContentWidth(SpinnerAdapter adapter, Drawable background) {
        if (adapter == null) {
            return 0;
        }
        int width2 = 0;
        View itemView = null;
        int itemType = 0;
        int widthMeasureSpec = View.MeasureSpec.makeSafeMeasureSpec(this.getMeasuredWidth(), 0);
        int heightMeasureSpec = View.MeasureSpec.makeSafeMeasureSpec(this.getMeasuredHeight(), 0);
        int start = Math.max(0, this.getSelectedItemPosition());
        int end = Math.min(adapter.getCount(), start + 15);
        int count = end - start;
        for (int i = start = Math.max(0, start - (15 - count)); i < end; ++i) {
            int positionType = adapter.getItemViewType(i);
            if (positionType != itemType) {
                itemType = positionType;
                itemView = null;
            }
            if ((itemView = adapter.getView(i, itemView, this)).getLayoutParams() == null) {
                itemView.setLayoutParams(new ViewGroup.LayoutParams(-2, -2));
            }
            itemView.measure(widthMeasureSpec, heightMeasureSpec);
            width2 = Math.max(width2, itemView.getMeasuredWidth());
        }
        if (background != null) {
            background.getPadding(this.mTempRect);
            width2 += this.mTempRect.left + this.mTempRect.right;
        }
        return width2;
    }

    @Override
    public Parcelable onSaveInstanceState() {
        SavedState ss = new SavedState(super.onSaveInstanceState());
        ss.showDropdown = this.mPopup != null && this.mPopup.isShowing();
        return ss;
    }

    @Override
    public void onRestoreInstanceState(Parcelable state) {
        ViewTreeObserver vto;
        SavedState ss = (SavedState)state;
        super.onRestoreInstanceState(ss.getSuperState());
        if (ss.showDropdown && (vto = this.getViewTreeObserver()) != null) {
            ViewTreeObserver.OnGlobalLayoutListener listener2 = new ViewTreeObserver.OnGlobalLayoutListener(){

                @Override
                public void onGlobalLayout() {
                    ViewTreeObserver vto;
                    if (!Spinner.this.mPopup.isShowing()) {
                        Spinner.this.mPopup.show(Spinner.this.getTextDirection(), Spinner.this.getTextAlignment());
                    }
                    if ((vto = Spinner.this.getViewTreeObserver()) != null) {
                        vto.removeOnGlobalLayoutListener(this);
                    }
                }
            };
            vto.addOnGlobalLayoutListener(listener2);
        }
    }

    @Override
    public PointerIcon onResolvePointerIcon(MotionEvent event, int pointerIndex) {
        if (this.getPointerIcon() == null && this.isClickable() && this.isEnabled()) {
            return PointerIcon.getSystemIcon(this.getContext(), 1002);
        }
        return super.onResolvePointerIcon(event, pointerIndex);
    }

    private class DropdownPopup
    extends ListPopupWindow
    implements SpinnerPopup {
        private CharSequence mHintText;
        private ListAdapter mAdapter;

        public DropdownPopup(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
            super(context, attrs, defStyleAttr, defStyleRes);
            this.setAnchorView(Spinner.this);
            this.setModal(true);
            this.setPromptPosition(0);
            this.setOnItemClickListener(new AdapterView.OnItemClickListener(){

                public void onItemClick(AdapterView parent, View v, int position, long id2) {
                    Spinner.this.setSelection(position);
                    if (Spinner.this.mOnItemClickListener != null) {
                        Spinner.this.performItemClick(v, position, DropdownPopup.this.mAdapter.getItemId(position));
                    }
                    DropdownPopup.this.dismiss();
                }
            });
        }

        @Override
        public void setAdapter(ListAdapter adapter) {
            super.setAdapter(adapter);
            this.mAdapter = adapter;
        }

        @Override
        public CharSequence getHintText() {
            return this.mHintText;
        }

        @Override
        public void setPromptText(CharSequence hintText) {
            this.mHintText = hintText;
        }

        void computeContentWidth() {
            Drawable background = this.getBackground();
            int hOffset = 0;
            if (background != null) {
                background.getPadding(Spinner.this.mTempRect);
                hOffset = Spinner.this.isLayoutRtl() ? Spinner.this.mTempRect.right : -Spinner.this.mTempRect.left;
            } else {
                Spinner.this.mTempRect.right = 0;
                Spinner.this.mTempRect.left = 0;
            }
            int spinnerPaddingLeft = Spinner.this.getPaddingLeft();
            int spinnerPaddingRight = Spinner.this.getPaddingRight();
            int spinnerWidth = Spinner.this.getWidth();
            if (Spinner.this.mDropDownWidth == -2) {
                int contentWidthLimit;
                int contentWidth = Spinner.this.measureContentWidth((SpinnerAdapter)((Object)this.mAdapter), this.getBackground());
                if (contentWidth > (contentWidthLimit = ((Spinner)Spinner.this).mContext.getResources().getDisplayMetrics().widthPixels - Spinner.this.mTempRect.left - Spinner.this.mTempRect.right)) {
                    contentWidth = contentWidthLimit;
                }
                this.setContentWidth(Math.max(contentWidth, spinnerWidth - spinnerPaddingLeft - spinnerPaddingRight));
            } else if (Spinner.this.mDropDownWidth == -1) {
                this.setContentWidth(spinnerWidth - spinnerPaddingLeft - spinnerPaddingRight);
            } else {
                this.setContentWidth(Spinner.this.mDropDownWidth);
            }
            hOffset = Spinner.this.isLayoutRtl() ? (hOffset += spinnerWidth - spinnerPaddingRight - this.getWidth()) : (hOffset += spinnerPaddingLeft);
            this.setHorizontalOffset(hOffset);
        }

        @Override
        public void show(int textDirection, int textAlignment) {
            boolean wasShowing = this.isShowing();
            this.computeContentWidth();
            this.setInputMethodMode(2);
            super.show();
            ListView listView = this.getListView();
            listView.setChoiceMode(1);
            listView.setTextDirection(textDirection);
            listView.setTextAlignment(textAlignment);
            this.setSelection(Spinner.this.getSelectedItemPosition());
            if (wasShowing) {
                return;
            }
            ViewTreeObserver vto = Spinner.this.getViewTreeObserver();
            if (vto != null) {
                final ViewTreeObserver.OnGlobalLayoutListener layoutListener = new ViewTreeObserver.OnGlobalLayoutListener(){

                    @Override
                    public void onGlobalLayout() {
                        if (!Spinner.this.isVisibleToUser()) {
                            DropdownPopup.this.dismiss();
                        } else {
                            DropdownPopup.this.computeContentWidth();
                            DropdownPopup.super.show();
                        }
                    }
                };
                vto.addOnGlobalLayoutListener(layoutListener);
                this.setOnDismissListener(new PopupWindow.OnDismissListener(){

                    @Override
                    public void onDismiss() {
                        ViewTreeObserver vto = Spinner.this.getViewTreeObserver();
                        if (vto != null) {
                            vto.removeOnGlobalLayoutListener(layoutListener);
                        }
                    }
                });
            }
        }
    }

    private class DialogPopup
    implements SpinnerPopup,
    DialogInterface.OnClickListener {
        private AlertDialog mPopup;
        private ListAdapter mListAdapter;
        private CharSequence mPrompt;

        private DialogPopup() {
        }

        @Override
        public void dismiss() {
            if (this.mPopup != null) {
                this.mPopup.dismiss();
                this.mPopup = null;
            }
        }

        @Override
        @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
        public boolean isShowing() {
            return this.mPopup != null ? this.mPopup.isShowing() : false;
        }

        @Override
        public void setAdapter(ListAdapter adapter) {
            this.mListAdapter = adapter;
        }

        @Override
        public void setPromptText(CharSequence hintText) {
            this.mPrompt = hintText;
        }

        @Override
        public CharSequence getHintText() {
            return this.mPrompt;
        }

        @Override
        public void show(int textDirection, int textAlignment) {
            if (this.mListAdapter == null) {
                return;
            }
            AlertDialog.Builder builder2 = new AlertDialog.Builder(Spinner.this.getPopupContext());
            if (this.mPrompt != null) {
                builder2.setTitle(this.mPrompt);
            }
            this.mPopup = builder2.setSingleChoiceItems(this.mListAdapter, Spinner.this.getSelectedItemPosition(), (DialogInterface.OnClickListener)this).create();
            ListView listView = this.mPopup.getListView();
            listView.setTextDirection(textDirection);
            listView.setTextAlignment(textAlignment);
            this.mPopup.show();
        }

        @Override
        public void onClick(DialogInterface dialog, int which) {
            Spinner.this.setSelection(which);
            if (Spinner.this.mOnItemClickListener != null) {
                Spinner.this.performItemClick(null, which, this.mListAdapter.getItemId(which));
            }
            this.dismiss();
        }

        @Override
        public void setBackgroundDrawable(Drawable bg) {
            Log.e(Spinner.TAG, "Cannot set popup background for MODE_DIALOG, ignoring");
        }

        @Override
        public void setVerticalOffset(int px) {
            Log.e(Spinner.TAG, "Cannot set vertical offset for MODE_DIALOG, ignoring");
        }

        @Override
        public void setHorizontalOffset(int px) {
            Log.e(Spinner.TAG, "Cannot set horizontal offset for MODE_DIALOG, ignoring");
        }

        @Override
        public Drawable getBackground() {
            return null;
        }

        @Override
        public int getVerticalOffset() {
            return 0;
        }

        @Override
        public int getHorizontalOffset() {
            return 0;
        }
    }

    private static interface SpinnerPopup {
        public void setAdapter(ListAdapter var1);

        public void show(int var1, int var2);

        public void dismiss();

        @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
        public boolean isShowing();

        public void setPromptText(CharSequence var1);

        public CharSequence getHintText();

        public void setBackgroundDrawable(Drawable var1);

        public void setVerticalOffset(int var1);

        public void setHorizontalOffset(int var1);

        public Drawable getBackground();

        public int getVerticalOffset();

        public int getHorizontalOffset();
    }

    private static class DropDownAdapter
    implements ListAdapter,
    SpinnerAdapter {
        private SpinnerAdapter mAdapter;
        private ListAdapter mListAdapter;

        public DropDownAdapter(SpinnerAdapter adapter, Resources.Theme dropDownTheme) {
            ThemedSpinnerAdapter themedAdapter;
            this.mAdapter = adapter;
            if (adapter instanceof ListAdapter) {
                this.mListAdapter = (ListAdapter)((Object)adapter);
            }
            if (dropDownTheme != null && adapter instanceof ThemedSpinnerAdapter && (themedAdapter = (ThemedSpinnerAdapter)adapter).getDropDownViewTheme() == null) {
                themedAdapter.setDropDownViewTheme(dropDownTheme);
            }
        }

        @Override
        public int getCount() {
            return this.mAdapter == null ? 0 : this.mAdapter.getCount();
        }

        @Override
        public Object getItem(int position) {
            return this.mAdapter == null ? null : this.mAdapter.getItem(position);
        }

        @Override
        public long getItemId(int position) {
            return this.mAdapter == null ? -1L : this.mAdapter.getItemId(position);
        }

        @Override
        public View getView(int position, View convertView, ViewGroup parent) {
            return this.getDropDownView(position, convertView, parent);
        }

        @Override
        public View getDropDownView(int position, View convertView, ViewGroup parent) {
            return this.mAdapter == null ? null : this.mAdapter.getDropDownView(position, convertView, parent);
        }

        @Override
        public boolean hasStableIds() {
            return this.mAdapter != null && this.mAdapter.hasStableIds();
        }

        @Override
        public void registerDataSetObserver(DataSetObserver observer) {
            if (this.mAdapter != null) {
                this.mAdapter.registerDataSetObserver(observer);
            }
        }

        @Override
        public void unregisterDataSetObserver(DataSetObserver observer) {
            if (this.mAdapter != null) {
                this.mAdapter.unregisterDataSetObserver(observer);
            }
        }

        @Override
        public boolean areAllItemsEnabled() {
            ListAdapter adapter = this.mListAdapter;
            if (adapter != null) {
                return adapter.areAllItemsEnabled();
            }
            return true;
        }

        @Override
        public boolean isEnabled(int position) {
            ListAdapter adapter = this.mListAdapter;
            if (adapter != null) {
                return adapter.isEnabled(position);
            }
            return true;
        }

        @Override
        public int getItemViewType(int position) {
            return 0;
        }

        @Override
        public int getViewTypeCount() {
            return 1;
        }

        @Override
        public boolean isEmpty() {
            return this.getCount() == 0;
        }
    }

    static class SavedState
    extends AbsSpinner.SavedState {
        boolean showDropdown;
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            @Override
            public SavedState createFromParcel(Parcel in) {
                return new SavedState(in);
            }

            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        };

        SavedState(Parcelable superState) {
            super(superState);
        }

        private SavedState(Parcel in) {
            super(in);
            this.showDropdown = in.readByte() != 0;
        }

        @Override
        public void writeToParcel(Parcel out, int flags) {
            super.writeToParcel(out, flags);
            out.writeByte((byte)(this.showDropdown ? 1 : 0));
        }
    }
}

