/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.animation.Animator;
import android.animation.ValueAnimator;
import android.content.res.ColorStateList;
import android.graphics.Color;
import android.text.TextUtils;
import android.text.method.TransformationMethod;
import android.text.method.TranslationTransformationMethod;
import android.util.Log;
import android.view.View;
import android.view.translation.ViewTranslationCallback;
import android.view.translation.ViewTranslationResponse;
import android.widget.TextView;
import java.lang.ref.WeakReference;

public class TextViewTranslationCallback
implements ViewTranslationCallback {
    private static final String TAG = "TextViewTranslationCb";
    private static final boolean DEBUG = Log.isLoggable("UiTranslation", 3);
    private TranslationTransformationMethod mTranslationTransformation;
    private boolean mIsShowingTranslation = false;
    private boolean mAnimationRunning = false;
    private boolean mIsTextPaddingEnabled = false;
    private boolean mOriginalIsTextSelectable = false;
    private int mOriginalFocusable = 0;
    private boolean mOriginalFocusableInTouchMode = false;
    private boolean mOriginalClickable = false;
    private boolean mOriginalLongClickable = false;
    private CharSequence mPaddedText;
    private int mAnimationDurationMillis = 250;
    private CharSequence mContentDescription;
    private static final char COMPAT_PAD_CHARACTER = '\u2002';
    private ValueAnimator mAnimator;

    private void clearTranslationTransformation() {
        if (DEBUG) {
            Log.v(TAG, "clearTranslationTransformation: " + this.mTranslationTransformation);
        }
        this.mTranslationTransformation = null;
    }

    @Override
    public boolean onShowTranslation(View view2) {
        CharSequence translatedContentDescription;
        if (this.mIsShowingTranslation) {
            if (DEBUG) {
                Log.d(TAG, view2 + " is already showing translated text.");
            }
            return false;
        }
        ViewTranslationResponse response = view2.getViewTranslationResponse();
        if (response == null) {
            Log.e(TAG, "onShowTranslation() shouldn't be called before onViewTranslationResponse().");
            return false;
        }
        TextView theTextView = (TextView)view2;
        if (this.mTranslationTransformation == null || !response.equals(this.mTranslationTransformation.getViewTranslationResponse())) {
            TransformationMethod originalTranslationMethod = theTextView.getTransformationMethod();
            this.mTranslationTransformation = new TranslationTransformationMethod(response, originalTranslationMethod);
        }
        TranslationTransformationMethod transformation = this.mTranslationTransformation;
        WeakReference<TextView> textViewRef = new WeakReference<TextView>(theTextView);
        this.runChangeTextWithAnimationIfNeeded(theTextView, () -> {
            this.mIsShowingTranslation = true;
            this.mAnimationRunning = false;
            TextView textView = (TextView)textViewRef.get();
            if (textView == null) {
                return;
            }
            this.mOriginalIsTextSelectable = textView.isTextSelectable();
            if (this.mOriginalIsTextSelectable) {
                this.mOriginalFocusableInTouchMode = textView.isFocusableInTouchMode();
                this.mOriginalFocusable = textView.getFocusable();
                this.mOriginalClickable = textView.isClickable();
                this.mOriginalLongClickable = textView.isLongClickable();
                textView.setTextIsSelectable(false);
            }
            textView.setTransformationMethod(transformation);
        });
        if (response.getKeys().contains("android:content_description") && !TextUtils.isEmpty(translatedContentDescription = response.getValue("android:content_description").getText())) {
            this.mContentDescription = view2.getContentDescription();
            view2.setContentDescription(translatedContentDescription);
        }
        return true;
    }

    @Override
    public boolean onHideTranslation(View view2) {
        if (view2.getViewTranslationResponse() == null) {
            Log.e(TAG, "onHideTranslation() shouldn't be called before onViewTranslationResponse().");
            return false;
        }
        if (this.mTranslationTransformation != null) {
            TransformationMethod transformation = this.mTranslationTransformation.getOriginalTransformationMethod();
            TextView theTextView = (TextView)view2;
            WeakReference<TextView> textViewRef = new WeakReference<TextView>(theTextView);
            this.runChangeTextWithAnimationIfNeeded(theTextView, () -> {
                this.mIsShowingTranslation = false;
                this.mAnimationRunning = false;
                TextView textView = (TextView)textViewRef.get();
                if (textView == null) {
                    return;
                }
                textView.setTransformationMethod(transformation);
                if (this.mOriginalIsTextSelectable && !textView.isTextSelectable()) {
                    textView.setTextIsSelectable(true);
                    textView.setFocusableInTouchMode(this.mOriginalFocusableInTouchMode);
                    textView.setFocusable(this.mOriginalFocusable);
                    textView.setClickable(this.mOriginalClickable);
                    textView.setLongClickable(this.mOriginalLongClickable);
                }
            });
            if (!TextUtils.isEmpty(this.mContentDescription)) {
                view2.setContentDescription(this.mContentDescription);
            }
        } else {
            if (DEBUG) {
                Log.w(TAG, "onHideTranslation(): no translated text.");
            }
            return false;
        }
        return true;
    }

    @Override
    public boolean onClearTranslation(View view2) {
        if (this.mTranslationTransformation == null) {
            if (DEBUG) {
                Log.w(TAG, "onClearTranslation(): no translated text.");
            }
            return false;
        }
        this.onHideTranslation(view2);
        this.clearTranslationTransformation();
        this.mPaddedText = null;
        this.mContentDescription = null;
        return true;
    }

    public boolean isShowingTranslation() {
        return this.mIsShowingTranslation;
    }

    public boolean isAnimationRunning() {
        return this.mAnimationRunning;
    }

    @Override
    public void enableContentPadding() {
        this.mIsTextPaddingEnabled = true;
    }

    boolean isTextPaddingEnabled() {
        return this.mIsTextPaddingEnabled;
    }

    CharSequence getPaddedText(CharSequence text, CharSequence translatedText) {
        if (text == null) {
            return null;
        }
        if (this.mPaddedText == null) {
            this.mPaddedText = this.computePaddedText(text, translatedText);
        }
        return this.mPaddedText;
    }

    private CharSequence computePaddedText(CharSequence text, CharSequence translatedText) {
        if (translatedText == null) {
            return text;
        }
        int newLength = translatedText.length();
        if (newLength <= text.length()) {
            return text;
        }
        StringBuilder sb = new StringBuilder(newLength);
        sb.append(text);
        for (int i = text.length(); i < newLength; ++i) {
            sb.append('\u2002');
        }
        return sb;
    }

    @Override
    public void setAnimationDurationMillis(int durationMillis) {
        this.mAnimationDurationMillis = durationMillis;
    }

    private void runChangeTextWithAnimationIfNeeded(TextView view2, final Runnable changeTextRunnable) {
        boolean areAnimatorsEnabled = ValueAnimator.areAnimatorsEnabled();
        if (!areAnimatorsEnabled) {
            changeTextRunnable.run();
            return;
        }
        if (this.mAnimator != null) {
            this.mAnimator.end();
        }
        this.mAnimationRunning = true;
        int fadedOutColor = TextViewTranslationCallback.colorWithAlpha(view2.getCurrentTextColor(), 0);
        this.mAnimator = ValueAnimator.ofArgb(view2.getCurrentTextColor(), fadedOutColor);
        this.mAnimator.addUpdateListener(valueAnimator -> view2.setTextColor((Integer)valueAnimator.getAnimatedValue()));
        this.mAnimator.setRepeatMode(2);
        this.mAnimator.setRepeatCount(1);
        this.mAnimator.setDuration(this.mAnimationDurationMillis);
        final ColorStateList originalColors = view2.getTextColors();
        final WeakReference<TextView> viewRef = new WeakReference<TextView>(view2);
        this.mAnimator.addListener(new Animator.AnimatorListener(){

            @Override
            public void onAnimationStart(Animator animation) {
            }

            @Override
            public void onAnimationEnd(Animator animation) {
                TextView view2 = (TextView)viewRef.get();
                if (view2 != null) {
                    view2.setTextColor(originalColors);
                }
                TextViewTranslationCallback.this.mAnimator = null;
            }

            @Override
            public void onAnimationCancel(Animator animation) {
            }

            @Override
            public void onAnimationRepeat(Animator animation) {
                changeTextRunnable.run();
            }
        });
        this.mAnimator.start();
    }

    private static int colorWithAlpha(int color2, int newAlpha) {
        return Color.argb(newAlpha, Color.red(color2), Color.green(color2), Color.blue(color2));
    }
}

