/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.app.INotificationManager;
import android.app.ITransientNotificationCallback;
import android.content.Context;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.os.IBinder;
import android.os.RemoteException;
import android.util.Log;
import android.view.Gravity;
import android.view.LayoutInflater;
import android.view.View;
import android.view.WindowManager;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityManager;
import android.view.accessibility.IAccessibilityManager;
import android.widget.TextView;
import android.widget.Toast;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.util.ArrayUtils;
import com.android.internal.util.Preconditions;

public class ToastPresenter {
    private static final String TAG = "ToastPresenter";
    private static final String WINDOW_TITLE = "Toast";
    private static final long SHORT_DURATION_TIMEOUT = 4000L;
    private static final long LONG_DURATION_TIMEOUT = 7000L;
    @VisibleForTesting
    public static final int TEXT_TOAST_LAYOUT = 17367363;
    private final Context mContext;
    private final Resources mResources;
    private final WindowManager mWindowManager;
    private final IAccessibilityManager mAccessibilityManager;
    private final INotificationManager mNotificationManager;
    private final String mPackageName;
    private final WindowManager.LayoutParams mParams;
    private View mView;
    private IBinder mToken;

    public static View getTextToastView(Context context, CharSequence text) {
        View view2 = LayoutInflater.from(context).inflate(17367363, null);
        TextView textView = (TextView)view2.findViewById(16908299);
        textView.setText(text);
        return view2;
    }

    public ToastPresenter(Context context, IAccessibilityManager accessibilityManager, INotificationManager notificationManager, String packageName) {
        this.mContext = context;
        this.mResources = context.getResources();
        this.mWindowManager = context.getSystemService(WindowManager.class);
        this.mNotificationManager = notificationManager;
        this.mPackageName = packageName;
        this.mAccessibilityManager = accessibilityManager;
        this.mParams = this.createLayoutParams();
    }

    public String getPackageName() {
        return this.mPackageName;
    }

    public WindowManager.LayoutParams getLayoutParams() {
        return this.mParams;
    }

    public View getView() {
        return this.mView;
    }

    public IBinder getToken() {
        return this.mToken;
    }

    private WindowManager.LayoutParams createLayoutParams() {
        WindowManager.LayoutParams params = new WindowManager.LayoutParams();
        params.height = -2;
        params.width = -2;
        params.format = -3;
        params.windowAnimations = 16973828;
        params.type = 2005;
        params.setFitInsetsIgnoringVisibility(true);
        params.setTitle(WINDOW_TITLE);
        params.flags = 152;
        this.setShowForAllUsersIfApplicable(params, this.mPackageName);
        return params;
    }

    private void adjustLayoutParams(WindowManager.LayoutParams params, IBinder windowToken, int duration, int gravity, int xOffset, int yOffset, float horizontalMargin, float verticalMargin, boolean removeWindowAnimations) {
        int absGravity;
        Configuration config = this.mResources.getConfiguration();
        params.gravity = absGravity = Gravity.getAbsoluteGravity(gravity, config.getLayoutDirection());
        if ((absGravity & 7) == 7) {
            params.horizontalWeight = 1.0f;
        }
        if ((absGravity & 0x70) == 112) {
            params.verticalWeight = 1.0f;
        }
        params.x = xOffset;
        params.y = yOffset;
        params.horizontalMargin = horizontalMargin;
        params.verticalMargin = verticalMargin;
        params.packageName = this.mContext.getPackageName();
        params.hideTimeoutMilliseconds = duration == 1 ? 7000L : 4000L;
        params.token = windowToken;
        if (removeWindowAnimations && params.windowAnimations == 16973828) {
            params.windowAnimations = 0;
        }
    }

    public void updateLayoutParams(int xOffset, int yOffset, float horizontalMargin, float verticalMargin, int gravity) {
        Preconditions.checkState(this.mView != null, "Toast must be showing to update its layout parameters.");
        Configuration config = this.mResources.getConfiguration();
        this.mParams.gravity = Gravity.getAbsoluteGravity(gravity, config.getLayoutDirection());
        this.mParams.x = xOffset;
        this.mParams.y = yOffset;
        this.mParams.horizontalMargin = horizontalMargin;
        this.mParams.verticalMargin = verticalMargin;
        this.mView.setLayoutParams(this.mParams);
    }

    private void setShowForAllUsersIfApplicable(WindowManager.LayoutParams params, String packageName) {
        if (this.isCrossUserPackage(packageName)) {
            params.privateFlags = 16;
        }
    }

    private boolean isCrossUserPackage(String packageName) {
        String[] packages = this.mResources.getStringArray(17236143);
        return ArrayUtils.contains(packages, packageName);
    }

    public void show(View view2, IBinder token, IBinder windowToken, int duration, int gravity, int xOffset, int yOffset, float horizontalMargin, float verticalMargin, ITransientNotificationCallback callback2) {
        this.show(view2, token, windowToken, duration, gravity, xOffset, yOffset, horizontalMargin, verticalMargin, callback2, false);
    }

    public void show(View view2, IBinder token, IBinder windowToken, int duration, int gravity, int xOffset, int yOffset, float horizontalMargin, float verticalMargin, ITransientNotificationCallback callback2, boolean removeWindowAnimations) {
        Preconditions.checkState(this.mView == null, "Only one toast at a time is allowed, call hide() first.");
        this.mView = view2;
        this.mToken = token;
        this.adjustLayoutParams(this.mParams, windowToken, duration, gravity, xOffset, yOffset, horizontalMargin, verticalMargin, removeWindowAnimations);
        this.addToastView();
        this.trySendAccessibilityEvent(this.mView, this.mPackageName);
        if (callback2 != null) {
            try {
                callback2.onToastShown();
            }
            catch (RemoteException e) {
                Log.w(TAG, "Error calling back " + this.mPackageName + " to notify onToastShow()", e);
            }
        }
    }

    public void hide(ITransientNotificationCallback callback2) {
        Preconditions.checkState(this.mView != null, "No toast to hide.");
        if (this.mView.getParent() != null) {
            this.mWindowManager.removeViewImmediate(this.mView);
        }
        try {
            this.mNotificationManager.finishToken(this.mPackageName, this.mToken);
        }
        catch (RemoteException e) {
            Log.w(TAG, "Error finishing toast window token from package " + this.mPackageName, e);
        }
        if (callback2 != null) {
            try {
                callback2.onToastHidden();
            }
            catch (RemoteException e) {
                Log.w(TAG, "Error calling back " + this.mPackageName + " to notify onToastHide()", e);
            }
        }
        this.mView = null;
        this.mToken = null;
    }

    public void trySendAccessibilityEvent(View view2, String packageName) {
        AccessibilityManager accessibilityManager = new AccessibilityManager(this.mContext, this.mAccessibilityManager, this.mContext.getUserId());
        if (!accessibilityManager.isEnabled()) {
            accessibilityManager.removeClient();
            return;
        }
        AccessibilityEvent event = AccessibilityEvent.obtain(64);
        event.setClassName(Toast.class.getName());
        event.setPackageName(packageName);
        view2.dispatchPopulateAccessibilityEvent(event);
        accessibilityManager.sendAccessibilityEvent(event);
        accessibilityManager.removeClient();
    }

    private void addToastView() {
        if (this.mView.getParent() != null) {
            this.mWindowManager.removeView(this.mView);
        }
        try {
            this.mWindowManager.addView(this.mView, this.mParams);
        }
        catch (WindowManager.BadTokenException e) {
            Log.w(TAG, "Error while attempting to show toast from " + this.mPackageName, e);
            return;
        }
    }
}

