/*
 * Decompiled with CFR 0.152.
 */
package android.window;

import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import android.view.RemoteAnimationDefinition;
import android.window.ITaskFragmentOrganizer;

public interface ITaskFragmentOrganizerController
extends IInterface {
    public static final String DESCRIPTOR = "android.window.ITaskFragmentOrganizerController";

    public void registerOrganizer(ITaskFragmentOrganizer var1) throws RemoteException;

    public void unregisterOrganizer(ITaskFragmentOrganizer var1) throws RemoteException;

    public void registerRemoteAnimations(ITaskFragmentOrganizer var1, int var2, RemoteAnimationDefinition var3) throws RemoteException;

    public void unregisterRemoteAnimations(ITaskFragmentOrganizer var1, int var2) throws RemoteException;

    public boolean isActivityEmbedded(IBinder var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements ITaskFragmentOrganizerController {
        static final int TRANSACTION_registerOrganizer = 1;
        static final int TRANSACTION_unregisterOrganizer = 2;
        static final int TRANSACTION_registerRemoteAnimations = 3;
        static final int TRANSACTION_unregisterRemoteAnimations = 4;
        static final int TRANSACTION_isActivityEmbedded = 5;

        public Stub() {
            this.attachInterface(this, ITaskFragmentOrganizerController.DESCRIPTOR);
        }

        public static ITaskFragmentOrganizerController asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(ITaskFragmentOrganizerController.DESCRIPTOR);
            if (iin != null && iin instanceof ITaskFragmentOrganizerController) {
                return (ITaskFragmentOrganizerController)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "registerOrganizer";
                }
                case 2: {
                    return "unregisterOrganizer";
                }
                case 3: {
                    return "registerRemoteAnimations";
                }
                case 4: {
                    return "unregisterRemoteAnimations";
                }
                case 5: {
                    return "isActivityEmbedded";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = ITaskFragmentOrganizerController.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    ITaskFragmentOrganizer _arg0 = ITaskFragmentOrganizer.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.registerOrganizer(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 2: {
                    ITaskFragmentOrganizer _arg0 = ITaskFragmentOrganizer.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.unregisterOrganizer(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 3: {
                    ITaskFragmentOrganizer _arg0 = ITaskFragmentOrganizer.Stub.asInterface(data.readStrongBinder());
                    int _arg1 = data.readInt();
                    RemoteAnimationDefinition _arg2 = data.readTypedObject(RemoteAnimationDefinition.CREATOR);
                    data.enforceNoDataAvail();
                    this.registerRemoteAnimations(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 4: {
                    ITaskFragmentOrganizer _arg0 = ITaskFragmentOrganizer.Stub.asInterface(data.readStrongBinder());
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.unregisterRemoteAnimations(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 5: {
                    IBinder _arg0 = data.readStrongBinder();
                    data.enforceNoDataAvail();
                    boolean _result = this.isActivityEmbedded(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 4;
        }

        private static class Proxy
        implements ITaskFragmentOrganizerController {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return ITaskFragmentOrganizerController.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerOrganizer(ITaskFragmentOrganizer organizer) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITaskFragmentOrganizerController.DESCRIPTOR);
                    _data.writeStrongInterface(organizer);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unregisterOrganizer(ITaskFragmentOrganizer organizer) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITaskFragmentOrganizerController.DESCRIPTOR);
                    _data.writeStrongInterface(organizer);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerRemoteAnimations(ITaskFragmentOrganizer organizer, int taskId, RemoteAnimationDefinition definition) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITaskFragmentOrganizerController.DESCRIPTOR);
                    _data.writeStrongInterface(organizer);
                    _data.writeInt(taskId);
                    _data.writeTypedObject(definition, 0);
                    boolean _status = this.mRemote.transact(3, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unregisterRemoteAnimations(ITaskFragmentOrganizer organizer, int taskId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITaskFragmentOrganizerController.DESCRIPTOR);
                    _data.writeStrongInterface(organizer);
                    _data.writeInt(taskId);
                    boolean _status = this.mRemote.transact(4, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isActivityEmbedded(IBinder activityToken) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITaskFragmentOrganizerController.DESCRIPTOR);
                    _data.writeStrongBinder(activityToken);
                    boolean _status = this.mRemote.transact(5, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }
        }
    }

    public static class Default
    implements ITaskFragmentOrganizerController {
        @Override
        public void registerOrganizer(ITaskFragmentOrganizer organizer) throws RemoteException {
        }

        @Override
        public void unregisterOrganizer(ITaskFragmentOrganizer organizer) throws RemoteException {
        }

        @Override
        public void registerRemoteAnimations(ITaskFragmentOrganizer organizer, int taskId, RemoteAnimationDefinition definition) throws RemoteException {
        }

        @Override
        public void unregisterRemoteAnimations(ITaskFragmentOrganizer organizer, int taskId) throws RemoteException {
        }

        @Override
        public boolean isActivityEmbedded(IBinder activityToken) throws RemoteException {
            return false;
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

