/*
 * Decompiled with CFR 0.152.
 */
package android.window;

import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import android.view.RemoteAnimationAdapter;
import android.window.IDisplayAreaOrganizerController;
import android.window.ITaskFragmentOrganizerController;
import android.window.ITaskOrganizerController;
import android.window.ITransitionMetricsReporter;
import android.window.ITransitionPlayer;
import android.window.IWindowContainerTransactionCallback;
import android.window.WindowContainerTransaction;

public interface IWindowOrganizerController
extends IInterface {
    public static final String DESCRIPTOR = "android.window.IWindowOrganizerController";

    public void applyTransaction(WindowContainerTransaction var1) throws RemoteException;

    public int applySyncTransaction(WindowContainerTransaction var1, IWindowContainerTransactionCallback var2) throws RemoteException;

    public IBinder startTransition(int var1, IBinder var2, WindowContainerTransaction var3) throws RemoteException;

    public int startLegacyTransition(int var1, RemoteAnimationAdapter var2, IWindowContainerTransactionCallback var3, WindowContainerTransaction var4) throws RemoteException;

    public int finishTransition(IBinder var1, WindowContainerTransaction var2, IWindowContainerTransactionCallback var3) throws RemoteException;

    public ITaskOrganizerController getTaskOrganizerController() throws RemoteException;

    public IDisplayAreaOrganizerController getDisplayAreaOrganizerController() throws RemoteException;

    public ITaskFragmentOrganizerController getTaskFragmentOrganizerController() throws RemoteException;

    public void registerTransitionPlayer(ITransitionPlayer var1) throws RemoteException;

    public ITransitionMetricsReporter getTransitionMetricsReporter() throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IWindowOrganizerController {
        static final int TRANSACTION_applyTransaction = 1;
        static final int TRANSACTION_applySyncTransaction = 2;
        static final int TRANSACTION_startTransition = 3;
        static final int TRANSACTION_startLegacyTransition = 4;
        static final int TRANSACTION_finishTransition = 5;
        static final int TRANSACTION_getTaskOrganizerController = 6;
        static final int TRANSACTION_getDisplayAreaOrganizerController = 7;
        static final int TRANSACTION_getTaskFragmentOrganizerController = 8;
        static final int TRANSACTION_registerTransitionPlayer = 9;
        static final int TRANSACTION_getTransitionMetricsReporter = 10;

        public Stub() {
            this.attachInterface(this, IWindowOrganizerController.DESCRIPTOR);
        }

        public static IWindowOrganizerController asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IWindowOrganizerController.DESCRIPTOR);
            if (iin != null && iin instanceof IWindowOrganizerController) {
                return (IWindowOrganizerController)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "applyTransaction";
                }
                case 2: {
                    return "applySyncTransaction";
                }
                case 3: {
                    return "startTransition";
                }
                case 4: {
                    return "startLegacyTransition";
                }
                case 5: {
                    return "finishTransition";
                }
                case 6: {
                    return "getTaskOrganizerController";
                }
                case 7: {
                    return "getDisplayAreaOrganizerController";
                }
                case 8: {
                    return "getTaskFragmentOrganizerController";
                }
                case 9: {
                    return "registerTransitionPlayer";
                }
                case 10: {
                    return "getTransitionMetricsReporter";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IWindowOrganizerController.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    WindowContainerTransaction _arg0 = data.readTypedObject(WindowContainerTransaction.CREATOR);
                    data.enforceNoDataAvail();
                    this.applyTransaction(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 2: {
                    WindowContainerTransaction _arg0 = data.readTypedObject(WindowContainerTransaction.CREATOR);
                    IWindowContainerTransactionCallback _arg1 = IWindowContainerTransactionCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    int _result = this.applySyncTransaction(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 3: {
                    int _arg0 = data.readInt();
                    IBinder _arg1 = data.readStrongBinder();
                    WindowContainerTransaction _arg2 = data.readTypedObject(WindowContainerTransaction.CREATOR);
                    data.enforceNoDataAvail();
                    IBinder _result = this.startTransition(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeStrongBinder(_result);
                    break;
                }
                case 4: {
                    int _arg0 = data.readInt();
                    RemoteAnimationAdapter _arg1 = data.readTypedObject(RemoteAnimationAdapter.CREATOR);
                    IWindowContainerTransactionCallback _arg2 = IWindowContainerTransactionCallback.Stub.asInterface(data.readStrongBinder());
                    WindowContainerTransaction _arg3 = data.readTypedObject(WindowContainerTransaction.CREATOR);
                    data.enforceNoDataAvail();
                    int _result = this.startLegacyTransition(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 5: {
                    IBinder _arg0 = data.readStrongBinder();
                    WindowContainerTransaction _arg1 = data.readTypedObject(WindowContainerTransaction.CREATOR);
                    IWindowContainerTransactionCallback _arg2 = IWindowContainerTransactionCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    int _result = this.finishTransition(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 6: {
                    ITaskOrganizerController _result = this.getTaskOrganizerController();
                    reply.writeNoException();
                    reply.writeStrongInterface(_result);
                    break;
                }
                case 7: {
                    IDisplayAreaOrganizerController _result = this.getDisplayAreaOrganizerController();
                    reply.writeNoException();
                    reply.writeStrongInterface(_result);
                    break;
                }
                case 8: {
                    ITaskFragmentOrganizerController _result = this.getTaskFragmentOrganizerController();
                    reply.writeNoException();
                    reply.writeStrongInterface(_result);
                    break;
                }
                case 9: {
                    ITransitionPlayer _arg0 = ITransitionPlayer.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.registerTransitionPlayer(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 10: {
                    ITransitionMetricsReporter _result = this.getTransitionMetricsReporter();
                    reply.writeNoException();
                    reply.writeStrongInterface(_result);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 9;
        }

        private static class Proxy
        implements IWindowOrganizerController {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IWindowOrganizerController.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void applyTransaction(WindowContainerTransaction t) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IWindowOrganizerController.DESCRIPTOR);
                    _data.writeTypedObject(t, 0);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int applySyncTransaction(WindowContainerTransaction t, IWindowContainerTransactionCallback callback2) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IWindowOrganizerController.DESCRIPTOR);
                    _data.writeTypedObject(t, 0);
                    _data.writeStrongInterface(callback2);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public IBinder startTransition(int type, IBinder transitionToken, WindowContainerTransaction t) throws RemoteException {
                IBinder _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IWindowOrganizerController.DESCRIPTOR);
                    _data.writeInt(type);
                    _data.writeStrongBinder(transitionToken);
                    _data.writeTypedObject(t, 0);
                    boolean _status = this.mRemote.transact(3, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readStrongBinder();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int startLegacyTransition(int type, RemoteAnimationAdapter adapter, IWindowContainerTransactionCallback syncCallback, WindowContainerTransaction t) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IWindowOrganizerController.DESCRIPTOR);
                    _data.writeInt(type);
                    _data.writeTypedObject(adapter, 0);
                    _data.writeStrongInterface(syncCallback);
                    _data.writeTypedObject(t, 0);
                    boolean _status = this.mRemote.transact(4, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int finishTransition(IBinder transitionToken, WindowContainerTransaction t, IWindowContainerTransactionCallback callback2) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IWindowOrganizerController.DESCRIPTOR);
                    _data.writeStrongBinder(transitionToken);
                    _data.writeTypedObject(t, 0);
                    _data.writeStrongInterface(callback2);
                    boolean _status = this.mRemote.transact(5, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ITaskOrganizerController getTaskOrganizerController() throws RemoteException {
                ITaskOrganizerController _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IWindowOrganizerController.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(6, _data, _reply, 0);
                    _reply.readException();
                    _result = ITaskOrganizerController.Stub.asInterface(_reply.readStrongBinder());
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public IDisplayAreaOrganizerController getDisplayAreaOrganizerController() throws RemoteException {
                IDisplayAreaOrganizerController _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IWindowOrganizerController.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(7, _data, _reply, 0);
                    _reply.readException();
                    _result = IDisplayAreaOrganizerController.Stub.asInterface(_reply.readStrongBinder());
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ITaskFragmentOrganizerController getTaskFragmentOrganizerController() throws RemoteException {
                ITaskFragmentOrganizerController _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IWindowOrganizerController.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(8, _data, _reply, 0);
                    _reply.readException();
                    _result = ITaskFragmentOrganizerController.Stub.asInterface(_reply.readStrongBinder());
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerTransitionPlayer(ITransitionPlayer player) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IWindowOrganizerController.DESCRIPTOR);
                    _data.writeStrongInterface(player);
                    boolean _status = this.mRemote.transact(9, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ITransitionMetricsReporter getTransitionMetricsReporter() throws RemoteException {
                ITransitionMetricsReporter _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IWindowOrganizerController.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(10, _data, _reply, 0);
                    _reply.readException();
                    _result = ITransitionMetricsReporter.Stub.asInterface(_reply.readStrongBinder());
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }
        }
    }

    public static class Default
    implements IWindowOrganizerController {
        @Override
        public void applyTransaction(WindowContainerTransaction t) throws RemoteException {
        }

        @Override
        public int applySyncTransaction(WindowContainerTransaction t, IWindowContainerTransactionCallback callback2) throws RemoteException {
            return 0;
        }

        @Override
        public IBinder startTransition(int type, IBinder transitionToken, WindowContainerTransaction t) throws RemoteException {
            return null;
        }

        @Override
        public int startLegacyTransition(int type, RemoteAnimationAdapter adapter, IWindowContainerTransactionCallback syncCallback, WindowContainerTransaction t) throws RemoteException {
            return 0;
        }

        @Override
        public int finishTransition(IBinder transitionToken, WindowContainerTransaction t, IWindowContainerTransactionCallback callback2) throws RemoteException {
            return 0;
        }

        @Override
        public ITaskOrganizerController getTaskOrganizerController() throws RemoteException {
            return null;
        }

        @Override
        public IDisplayAreaOrganizerController getDisplayAreaOrganizerController() throws RemoteException {
            return null;
        }

        @Override
        public ITaskFragmentOrganizerController getTaskFragmentOrganizerController() throws RemoteException {
            return null;
        }

        @Override
        public void registerTransitionPlayer(ITransitionPlayer player) throws RemoteException {
        }

        @Override
        public ITransitionMetricsReporter getTransitionMetricsReporter() throws RemoteException {
            return null;
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

