/*
 * Decompiled with CFR 0.152.
 */
package android.window;

import android.graphics.Matrix;
import android.graphics.PointF;
import android.graphics.Rect;
import android.os.Parcel;
import android.os.Parcelable;
import android.view.SurfaceControl;
import java.util.Arrays;
import java.util.Objects;

public class PictureInPictureSurfaceTransaction
implements Parcelable {
    private static final float NOT_SET = -1.0f;
    public final float mAlpha;
    public final PointF mPosition;
    public final float[] mFloat9;
    public final float mRotation;
    public final float mCornerRadius;
    public final float mShadowRadius;
    private final Rect mWindowCrop;
    public static final Parcelable.Creator<PictureInPictureSurfaceTransaction> CREATOR = new Parcelable.Creator<PictureInPictureSurfaceTransaction>(){

        @Override
        public PictureInPictureSurfaceTransaction createFromParcel(Parcel in) {
            return new PictureInPictureSurfaceTransaction(in);
        }

        public PictureInPictureSurfaceTransaction[] newArray(int size) {
            return new PictureInPictureSurfaceTransaction[size];
        }
    };

    private PictureInPictureSurfaceTransaction(Parcel in) {
        this.mAlpha = in.readFloat();
        this.mPosition = in.readTypedObject(PointF.CREATOR);
        this.mFloat9 = new float[9];
        in.readFloatArray(this.mFloat9);
        this.mRotation = in.readFloat();
        this.mCornerRadius = in.readFloat();
        this.mShadowRadius = in.readFloat();
        this.mWindowCrop = in.readTypedObject(Rect.CREATOR);
    }

    private PictureInPictureSurfaceTransaction(float alpha, PointF position, float[] float9, float rotation, float cornerRadius, float shadowRadius, Rect windowCrop) {
        this.mAlpha = alpha;
        this.mPosition = position;
        if (float9 == null) {
            this.mFloat9 = new float[9];
            Matrix.IDENTITY_MATRIX.getValues(this.mFloat9);
            this.mRotation = 0.0f;
        } else {
            this.mFloat9 = Arrays.copyOf(float9, 9);
            this.mRotation = rotation;
        }
        this.mCornerRadius = cornerRadius;
        this.mShadowRadius = shadowRadius;
        this.mWindowCrop = windowCrop == null ? null : new Rect(windowCrop);
    }

    public PictureInPictureSurfaceTransaction(PictureInPictureSurfaceTransaction other) {
        this(other.mAlpha, other.mPosition, other.mFloat9, other.mRotation, other.mCornerRadius, other.mShadowRadius, other.mWindowCrop);
    }

    public Matrix getMatrix() {
        Matrix matrix = new Matrix();
        matrix.setValues(this.mFloat9);
        return matrix;
    }

    public boolean hasCornerRadiusSet() {
        return this.mCornerRadius > 0.0f;
    }

    public boolean hasShadowRadiusSet() {
        return this.mShadowRadius > 0.0f;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PictureInPictureSurfaceTransaction)) {
            return false;
        }
        PictureInPictureSurfaceTransaction that = (PictureInPictureSurfaceTransaction)o;
        return Objects.equals(Float.valueOf(this.mAlpha), Float.valueOf(that.mAlpha)) && Objects.equals(this.mPosition, that.mPosition) && Arrays.equals(this.mFloat9, that.mFloat9) && Objects.equals(Float.valueOf(this.mRotation), Float.valueOf(that.mRotation)) && Objects.equals(Float.valueOf(this.mCornerRadius), Float.valueOf(that.mCornerRadius)) && Objects.equals(Float.valueOf(this.mShadowRadius), Float.valueOf(that.mShadowRadius)) && Objects.equals(this.mWindowCrop, that.mWindowCrop);
    }

    public int hashCode() {
        return Objects.hash(Float.valueOf(this.mAlpha), this.mPosition, Arrays.hashCode(this.mFloat9), Float.valueOf(this.mRotation), Float.valueOf(this.mCornerRadius), Float.valueOf(this.mShadowRadius), this.mWindowCrop);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel out, int flags) {
        out.writeFloat(this.mAlpha);
        out.writeTypedObject(this.mPosition, 0);
        out.writeFloatArray(this.mFloat9);
        out.writeFloat(this.mRotation);
        out.writeFloat(this.mCornerRadius);
        out.writeFloat(this.mShadowRadius);
        out.writeTypedObject(this.mWindowCrop, 0);
    }

    public String toString() {
        Matrix matrix = this.getMatrix();
        return "PictureInPictureSurfaceTransaction( alpha=" + this.mAlpha + " position=" + this.mPosition + " matrix=" + matrix.toShortString() + " rotation=" + this.mRotation + " cornerRadius=" + this.mCornerRadius + " shadowRadius=" + this.mShadowRadius + " crop=" + this.mWindowCrop + ")";
    }

    public static void apply(PictureInPictureSurfaceTransaction surfaceTransaction, SurfaceControl surfaceControl, SurfaceControl.Transaction tx) {
        Matrix matrix = surfaceTransaction.getMatrix();
        tx.setMatrix(surfaceControl, matrix, new float[9]);
        if (surfaceTransaction.mPosition != null) {
            tx.setPosition(surfaceControl, surfaceTransaction.mPosition.x, surfaceTransaction.mPosition.y);
        }
        if (surfaceTransaction.mWindowCrop != null) {
            tx.setWindowCrop(surfaceControl, surfaceTransaction.mWindowCrop);
        }
        if (surfaceTransaction.hasCornerRadiusSet()) {
            tx.setCornerRadius(surfaceControl, surfaceTransaction.mCornerRadius);
        }
        if (surfaceTransaction.hasShadowRadiusSet()) {
            tx.setShadowRadius(surfaceControl, surfaceTransaction.mShadowRadius);
        }
        if (surfaceTransaction.mAlpha != -1.0f) {
            tx.setAlpha(surfaceControl, surfaceTransaction.mAlpha);
        }
    }

    public static class Builder {
        private float mAlpha = -1.0f;
        private PointF mPosition;
        private float[] mFloat9;
        private float mRotation;
        private float mCornerRadius = -1.0f;
        private float mShadowRadius = -1.0f;
        private Rect mWindowCrop;

        public Builder setAlpha(float alpha) {
            this.mAlpha = alpha;
            return this;
        }

        public Builder setPosition(float x, float y) {
            this.mPosition = new PointF(x, y);
            return this;
        }

        public Builder setTransform(float[] float9, float rotation) {
            this.mFloat9 = Arrays.copyOf(float9, 9);
            this.mRotation = rotation;
            return this;
        }

        public Builder setCornerRadius(float cornerRadius) {
            this.mCornerRadius = cornerRadius;
            return this;
        }

        public Builder setShadowRadius(float shadowRadius) {
            this.mShadowRadius = shadowRadius;
            return this;
        }

        public Builder setWindowCrop(Rect windowCrop) {
            this.mWindowCrop = new Rect(windowCrop);
            return this;
        }

        public PictureInPictureSurfaceTransaction build() {
            return new PictureInPictureSurfaceTransaction(this.mAlpha, this.mPosition, this.mFloat9, this.mRotation, this.mCornerRadius, this.mShadowRadius, this.mWindowCrop);
        }
    }
}

