/*
 * Decompiled with CFR 0.152.
 */
package android.window;

import android.app.ActivityManager;
import android.content.pm.ActivityInfo;
import android.os.Parcel;
import android.os.Parcelable;
import android.view.InsetsState;
import android.view.InsetsVisibilities;
import android.view.WindowManager;
import android.window.TaskSnapshot;

public class StartingWindowInfo
implements Parcelable {
    public static final int STARTING_WINDOW_TYPE_NONE = 0;
    public static final int STARTING_WINDOW_TYPE_SPLASH_SCREEN = 1;
    public static final int STARTING_WINDOW_TYPE_SNAPSHOT = 2;
    public static final int STARTING_WINDOW_TYPE_SOLID_COLOR_SPLASH_SCREEN = 3;
    public static final int STARTING_WINDOW_TYPE_LEGACY_SPLASH_SCREEN = 4;
    public ActivityManager.RunningTaskInfo taskInfo;
    public ActivityInfo targetActivityInfo;
    public InsetsState topOpaqueWindowInsetsState;
    public WindowManager.LayoutParams topOpaqueWindowLayoutParams;
    public WindowManager.LayoutParams mainWindowLayoutParams;
    public static final int TYPE_PARAMETER_NEW_TASK = 1;
    public static final int TYPE_PARAMETER_TASK_SWITCH = 2;
    public static final int TYPE_PARAMETER_PROCESS_RUNNING = 4;
    public static final int TYPE_PARAMETER_ALLOW_TASK_SNAPSHOT = 8;
    public static final int TYPE_PARAMETER_ACTIVITY_CREATED = 16;
    public static final int TYPE_PARAMETER_USE_SOLID_COLOR_SPLASH_SCREEN = 32;
    public static final int TYPE_PARAMETER_ACTIVITY_DRAWN = 64;
    public static final int TYPE_PARAMETER_ALLOW_HANDLE_SOLID_COLOR_SCREEN = 128;
    public static final int TYPE_PARAMETER_LEGACY_SPLASH_SCREEN = Integer.MIN_VALUE;
    public int startingWindowTypeParameter;
    public int splashScreenThemeResId;
    public boolean isKeyguardOccluded = false;
    public TaskSnapshot taskSnapshot;
    public final InsetsVisibilities requestedVisibilities = new InsetsVisibilities();
    public static final Parcelable.Creator<StartingWindowInfo> CREATOR = new Parcelable.Creator<StartingWindowInfo>(){

        @Override
        public StartingWindowInfo createFromParcel(Parcel source) {
            return new StartingWindowInfo(source);
        }

        public StartingWindowInfo[] newArray(int size) {
            return new StartingWindowInfo[size];
        }
    };

    public StartingWindowInfo() {
    }

    private StartingWindowInfo(Parcel source) {
        this.readFromParcel(source);
    }

    public boolean allowHandleSolidColorSplashScreen() {
        return (this.startingWindowTypeParameter & 0x80) != 0;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeTypedObject(this.taskInfo, flags);
        dest.writeTypedObject(this.targetActivityInfo, flags);
        dest.writeInt(this.startingWindowTypeParameter);
        dest.writeTypedObject(this.topOpaqueWindowInsetsState, flags);
        dest.writeTypedObject(this.topOpaqueWindowLayoutParams, flags);
        dest.writeTypedObject(this.mainWindowLayoutParams, flags);
        dest.writeInt(this.splashScreenThemeResId);
        dest.writeBoolean(this.isKeyguardOccluded);
        dest.writeTypedObject(this.taskSnapshot, flags);
        this.requestedVisibilities.writeToParcel(dest, flags);
    }

    void readFromParcel(Parcel source) {
        this.taskInfo = source.readTypedObject(ActivityManager.RunningTaskInfo.CREATOR);
        this.targetActivityInfo = source.readTypedObject(ActivityInfo.CREATOR);
        this.startingWindowTypeParameter = source.readInt();
        this.topOpaqueWindowInsetsState = source.readTypedObject(InsetsState.CREATOR);
        this.topOpaqueWindowLayoutParams = source.readTypedObject(WindowManager.LayoutParams.CREATOR);
        this.mainWindowLayoutParams = source.readTypedObject(WindowManager.LayoutParams.CREATOR);
        this.splashScreenThemeResId = source.readInt();
        this.isKeyguardOccluded = source.readBoolean();
        this.taskSnapshot = source.readTypedObject(TaskSnapshot.CREATOR);
        this.requestedVisibilities.readFromParcel(source);
    }

    public String toString() {
        return "StartingWindowInfo{taskId=" + this.taskInfo.taskId + " targetActivityInfo=" + this.targetActivityInfo + " displayId=" + this.taskInfo.displayId + " topActivityType=" + this.taskInfo.topActivityType + " preferredStartingWindowType=" + Integer.toHexString(this.startingWindowTypeParameter) + " insetsState=" + this.topOpaqueWindowInsetsState + " topWindowLayoutParams=" + this.topOpaqueWindowLayoutParams + " mainWindowLayoutParams=" + this.mainWindowLayoutParams + " splashScreenThemeResId " + Integer.toHexString(this.splashScreenThemeResId);
    }

    public static @interface StartingTypeParams {
    }

    public static @interface StartingWindowType {
    }
}

