/*
 * Decompiled with CFR 0.152.
 */
package android.window;

import android.app.WindowConfiguration;
import android.graphics.Rect;
import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import android.window.TaskFragmentOrganizerToken;

public class TaskFragmentCreationParams
implements Parcelable {
    private final TaskFragmentOrganizerToken mOrganizer;
    private final IBinder mFragmentToken;
    private final IBinder mOwnerToken;
    private final Rect mInitialBounds = new Rect();
    @WindowConfiguration.WindowingMode
    private int mWindowingMode = 0;
    public static final Parcelable.Creator<TaskFragmentCreationParams> CREATOR = new Parcelable.Creator<TaskFragmentCreationParams>(){

        @Override
        public TaskFragmentCreationParams createFromParcel(Parcel in) {
            return new TaskFragmentCreationParams(in);
        }

        public TaskFragmentCreationParams[] newArray(int size) {
            return new TaskFragmentCreationParams[size];
        }
    };

    private TaskFragmentCreationParams(TaskFragmentOrganizerToken organizer, IBinder fragmentToken, IBinder ownerToken) {
        this.mOrganizer = organizer;
        this.mFragmentToken = fragmentToken;
        this.mOwnerToken = ownerToken;
    }

    public TaskFragmentOrganizerToken getOrganizer() {
        return this.mOrganizer;
    }

    public IBinder getFragmentToken() {
        return this.mFragmentToken;
    }

    public IBinder getOwnerToken() {
        return this.mOwnerToken;
    }

    public Rect getInitialBounds() {
        return this.mInitialBounds;
    }

    @WindowConfiguration.WindowingMode
    public int getWindowingMode() {
        return this.mWindowingMode;
    }

    private TaskFragmentCreationParams(Parcel in) {
        this.mOrganizer = TaskFragmentOrganizerToken.CREATOR.createFromParcel(in);
        this.mFragmentToken = in.readStrongBinder();
        this.mOwnerToken = in.readStrongBinder();
        this.mInitialBounds.readFromParcel(in);
        this.mWindowingMode = in.readInt();
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        this.mOrganizer.writeToParcel(dest, flags);
        dest.writeStrongBinder(this.mFragmentToken);
        dest.writeStrongBinder(this.mOwnerToken);
        this.mInitialBounds.writeToParcel(dest, flags);
        dest.writeInt(this.mWindowingMode);
    }

    public String toString() {
        return "TaskFragmentCreationParams{ organizer=" + this.mOrganizer + " fragmentToken=" + this.mFragmentToken + " ownerToken=" + this.mOwnerToken + " initialBounds=" + this.mInitialBounds + " windowingMode=" + this.mWindowingMode + "}";
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public static class Builder {
        private final TaskFragmentOrganizerToken mOrganizer;
        private final IBinder mFragmentToken;
        private final IBinder mOwnerToken;
        private final Rect mInitialBounds = new Rect();
        @WindowConfiguration.WindowingMode
        private int mWindowingMode = 0;

        public Builder(TaskFragmentOrganizerToken organizer, IBinder fragmentToken, IBinder ownerToken) {
            this.mOrganizer = organizer;
            this.mFragmentToken = fragmentToken;
            this.mOwnerToken = ownerToken;
        }

        public Builder setInitialBounds(Rect bounds2) {
            this.mInitialBounds.set(bounds2);
            return this;
        }

        public Builder setWindowingMode(@WindowConfiguration.WindowingMode int windowingMode) {
            this.mWindowingMode = windowingMode;
            return this;
        }

        public TaskFragmentCreationParams build() {
            TaskFragmentCreationParams result = new TaskFragmentCreationParams(this.mOrganizer, this.mFragmentToken, this.mOwnerToken);
            result.mInitialBounds.set(this.mInitialBounds);
            result.mWindowingMode = this.mWindowingMode;
            return result;
        }
    }
}

