/*
 * Decompiled with CFR 0.152.
 */
package com.android.framework.protobuf.nano;

import com.android.framework.protobuf.nano.CodedInputByteBufferNano;
import com.android.framework.protobuf.nano.CodedOutputByteBufferNano;
import com.android.framework.protobuf.nano.Extension;
import com.android.framework.protobuf.nano.FieldArray;
import com.android.framework.protobuf.nano.FieldData;
import com.android.framework.protobuf.nano.InternalNano;
import com.android.framework.protobuf.nano.MessageNano;
import com.android.framework.protobuf.nano.UnknownFieldData;
import com.android.framework.protobuf.nano.WireFormatNano;
import java.io.IOException;

public abstract class ExtendableMessageNano<M extends ExtendableMessageNano<M>>
extends MessageNano {
    protected FieldArray unknownFieldData;

    @Override
    protected int computeSerializedSize() {
        int size = 0;
        if (this.unknownFieldData != null) {
            for (int i = 0; i < this.unknownFieldData.size(); ++i) {
                FieldData field = this.unknownFieldData.dataAt(i);
                size += field.computeSerializedSize();
            }
        }
        return size;
    }

    @Override
    public void writeTo(CodedOutputByteBufferNano output) throws IOException {
        if (this.unknownFieldData == null) {
            return;
        }
        for (int i = 0; i < this.unknownFieldData.size(); ++i) {
            FieldData field = this.unknownFieldData.dataAt(i);
            field.writeTo(output);
        }
    }

    public boolean hasExtension(Extension<M, ?> extension) {
        if (this.unknownFieldData == null) {
            return false;
        }
        FieldData field = this.unknownFieldData.get(WireFormatNano.getTagFieldNumber(extension.tag));
        return field != null;
    }

    public <T> T getExtension(Extension<M, T> extension) {
        if (this.unknownFieldData == null) {
            return null;
        }
        FieldData field = this.unknownFieldData.get(WireFormatNano.getTagFieldNumber(extension.tag));
        return field == null ? null : (T)field.getValue(extension);
    }

    public <T> M setExtension(Extension<M, T> extension, T value2) {
        int fieldNumber = WireFormatNano.getTagFieldNumber(extension.tag);
        if (value2 == null) {
            if (this.unknownFieldData != null) {
                this.unknownFieldData.remove(fieldNumber);
                if (this.unknownFieldData.isEmpty()) {
                    this.unknownFieldData = null;
                }
            }
        } else {
            FieldData field = null;
            if (this.unknownFieldData == null) {
                this.unknownFieldData = new FieldArray();
            } else {
                field = this.unknownFieldData.get(fieldNumber);
            }
            if (field == null) {
                this.unknownFieldData.put(fieldNumber, new FieldData(extension, value2));
            } else {
                field.setValue(extension, value2);
            }
        }
        ExtendableMessageNano typedThis = this;
        return (M)typedThis;
    }

    protected boolean storeUnknownField(CodedInputByteBufferNano input, int tag2) throws IOException {
        int startPos = input.getPosition();
        if (!input.skipField(tag2)) {
            return false;
        }
        int fieldNumber = WireFormatNano.getTagFieldNumber(tag2);
        int endPos = input.getPosition();
        byte[] bytes = input.getData(startPos, endPos - startPos);
        UnknownFieldData unknownField = new UnknownFieldData(tag2, bytes);
        FieldData field = null;
        if (this.unknownFieldData == null) {
            this.unknownFieldData = new FieldArray();
        } else {
            field = this.unknownFieldData.get(fieldNumber);
        }
        if (field == null) {
            field = new FieldData();
            this.unknownFieldData.put(fieldNumber, field);
        }
        field.addUnknownField(unknownField);
        return true;
    }

    public M clone() throws CloneNotSupportedException {
        ExtendableMessageNano cloned = (ExtendableMessageNano)super.clone();
        InternalNano.cloneUnknownFieldData(this, cloned);
        return (M)cloned;
    }
}

